/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.component.WfConditionUpd;
import kd.bos.workflow.design.condition.IConditionalRule;
import kd.bos.workflow.design.util.ConditionalRuleUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;

public abstract class AbstractConditionalRule
implements IConditionalRule {
    protected Log log = LogFactory.getLog(this.getClass());

    @Override
    public void initializePage(IDataModel model, IFormView view, BpmnModel bpmnModel) {
        this.initWfCondition(view, bpmnModel);
        this.initTitle(model, view);
        view.setVisible(Boolean.TRUE, new String[]{"clearandexit"});
        if (view.getFormShowParameter().getCustomParam("procInstId") != null) {
            view.setVisible(Boolean.FALSE, new String[]{"historybtn"});
        }
        view.setVisible(Boolean.FALSE, this.getHideFields().toArray(new String[0]));
    }

    protected void initTitle(IDataModel model, IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        String type = (String)parameter.getCustomParam("type");
        Map context = null;
        if (WfUtils.isEmpty((String)type) && (context = (Map)parameter.getCustomParam("context")) != null) {
            type = (String)context.get("type");
        }
        String title = WfUtils.isNotEmpty((String)parameter.getCaption()) ? parameter.getCaption() : ConditionalRuleType.getTypeName((String)type);
        model.setValue("title", (Object)title);
        Object validateTime = model.getValue("validtime");
        if (validateTime != null) {
            model.setValue("subtitle", validateTime);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"subtitle"});
        }
    }

    protected String getCurrentNodeName(IDataModel model, BpmnModel bpmnModel) {
        FlowElement currentNode = bpmnModel.getFlowElement(model.getValue("elementid").toString());
        return currentNode.getName();
    }

    protected void initWfCondition(IFormView view, BpmnModel bpmnModel) {
        WfConditionUpd wfConditionUpd = (WfConditionUpd)view.getControl("wfconditionupdap");
        FormShowParameter parameter = view.getFormShowParameter();
        String type = null;
        String nodeId = null;
        Map ctx = (Map)parameter.getCustomParam("context");
        if (ctx != null) {
            type = (String)ctx.get("type");
            nodeId = (String)parameter.getCustomParam("itemId");
        } else {
            type = (String)parameter.getCustomParam("type");
            nodeId = (String)parameter.getCustomParam("nodeid");
        }
        if (nodeId == null && ctx != null) {
            Map nodeProperties = (Map)ctx.get("nodeProperties");
            String string = nodeId = nodeProperties != null ? (String)nodeProperties.get("itemId") : null;
        }
        if (ConditionalRuleType.skip.toString().equals(type) || ConditionalRuleType.autoApproval.toString().equals(type)) {
            wfConditionUpd.setActivityId(nodeId);
        }
        if (bpmnModel != null) {
            Object needSourceElement = parameter.getCustomParam("needSourceElement");
            String entityNumber = ConditionalRuleUtil.getEntryBillNumber(bpmnModel.getMainProcess(), nodeId, needSourceElement);
            this.setConditionEntityInfo(view, wfConditionUpd, entityNumber);
            this.setConditionBpmnModelJson(wfConditionUpd, bpmnModel);
        } else {
            this.setConditionEntityInfo(view, wfConditionUpd, (String)parameter.getCustomParam("entityNumber"));
        }
        if (WfUtils.isNotEmpty((String)type)) {
            if (ConditionalRuleType.exeConditionRule.name().equals(type)) {
                type = "EventConfig";
            }
        } else {
            throw new KDException(ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5904\u7406\u3002", (String)"AbstractConditionalRule_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        wfConditionUpd.setRuleType(type);
        String eventNumber = (String)parameter.getCustomParam("eventnumber");
        if (WfUtils.isNotEmpty((String)eventNumber)) {
            wfConditionUpd.setEventNumber(eventNumber);
        }
    }

    protected void setConditionEntityInfo(IFormView view, WfConditionUpd wfConditionUpd, String entityNumber) {
        wfConditionUpd.setEntityNumber(entityNumber);
        try {
            String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
            view.getPageCache().put("entityId", entityId);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    protected void setConditionBpmnModelJson(WfConditionUpd wfConditionUpd, BpmnModel bpmnModel) {
        wfConditionUpd.setBpmnModelJson(new BpmnJsonConverter().convertToJson(bpmnModel).toString());
    }

    protected List<String> getHideFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("defaultcondition");
        return fields;
    }
}

