/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.condition;

import kd.bos.dataentity.TypesContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.condition.CommonConditionalRule;
import kd.bos.workflow.design.condition.IConditionalRule;
import kd.bos.workflow.design.condition.NoProcessInfoCondRule;

public class ConditionalRuleFactory {
    private static final String PATH = "kd.bos.workflow.design.condition";
    private static final String SUFFIX = "CondRule";
    private static final Log log = LogFactory.getLog(ConditionalRuleFactory.class);

    public static IConditionalRule getConditionalRule(String type) {
        if (type != null) {
            try {
                switch (type) {
                    case "eventStartUp": 
                    case "taskCloseRule": {
                        return new NoProcessInfoCondRule();
                    }
                }
                return (IConditionalRule)TypesContainer.createInstance((String)String.format("%s.%s%s", PATH, ConditionalRuleFactory.firstLetterToUpperCase(type), SUFFIX));
            }
            catch (Exception e) {
                log.info(String.format("%s \u8282\u70b9\u6ca1\u6709\u627e\u5230\u81ea\u5b9a\u4e49\u7684\u5904\u7406\u7c7b\uff0c\u4f7f\u7528\u901a\u7528\u7684\u5904\u7406\u7c7b\uff01", type));
                return new CommonConditionalRule();
            }
        }
        return null;
    }

    public static String firstLetterToUpperCase(String string) {
        char[] chars = string.toCharArray();
        char first = chars[0];
        if ('a' <= first && first <= 'z') {
            chars[0] = first = (char)(first ^ 0x20);
        }
        return String.valueOf(chars);
    }
}

