/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.event.pluign;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.util.ParticipantConfigureHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;

public class EventParticipantPlugin
extends AbstractFormPlugin {
    public static final String VALUE = "value";
    public static final String VALUESHOWTEXT = "valueshowtext";
    public static final String RECEIVER = "receiver";
    public static final String BOS_USER = "bos_user";
    public static final String EVT_SUBSCRIPTION = "evt_subscription";
    public static final String ENTITY = "entity";
    public static final String EVENT = "event";
    public static final String PERSON = "person";
    public static final String FROMENTITY = "fromentity";
    public static final String FROMEVENT = "fromevent";
    public static final String FROMF7 = "fromf7";
    public static final String ENTITYFIELD = "entityfield";
    public static final String EVENTFIELD = "eventfield";
    public static final String F7FIELD = "f7field";
    public static final String BTNOK = "btnok";
    public static final String PLUGIN = "Plugin";
    public static final String FROMCLASS = "class";
    public static final String EXPRESSION = "expression";
    private static final String ISPRESET = "ispreset";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK, FROMENTITY, FROMEVENT, FROMF7, FROMCLASS});
    }

    public void afterCreateNewData(EventObject e) {
        String participant;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String type = (String)showParameter.getCustomParam("type");
        String parent = showParameter.getParentFormId();
        if ("cosmic".equals(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FROMENTITY});
        }
        if ("custom".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FROMENTITY});
        }
        if (StringUtils.isNotEmpty((CharSequence)(participant = (String)showParameter.getCustomParam(RECEIVER)))) {
            this.loadParticipantPage(participant);
        }
        if (("evt_automsg".equals(parent) || EVT_SUBSCRIPTION.equals(parent)) && "false".equals(showParameter.getCustomParam(ISPRESET))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNOK});
        }
        if (parent.equals(EVT_SUBSCRIPTION)) {
            String fromf7 = (String)this.getModel().getValue(FROMF7);
            String fromentity = (String)this.getModel().getValue(FROMENTITY);
            String fromevent = (String)this.getModel().getValue(FROMEVENT);
            String fromclass = (String)this.getModel().getValue(FROMCLASS);
            if (!fromf7.isEmpty()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FROMEVENT, FROMENTITY, FROMCLASS});
                this.getModel().setValue(FROMEVENT, null);
                this.getModel().setValue(FROMENTITY, null);
                this.getModel().setValue(FROMCLASS, null);
            } else if (!fromentity.isEmpty()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FROMF7, FROMEVENT, FROMCLASS});
                this.getModel().setValue(FROMF7, null);
                this.getModel().setValue(FROMEVENT, null);
                this.getModel().setValue(FROMCLASS, null);
            } else if (!fromevent.isEmpty()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FROMF7, FROMENTITY, FROMCLASS});
                this.getModel().setValue(FROMF7, null);
                this.getModel().setValue(FROMENTITY, null);
                this.getModel().setValue(FROMCLASS, null);
            } else if (!fromclass.isEmpty()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FROMF7, FROMENTITY, FROMEVENT});
                this.getModel().setValue(FROMF7, null);
                this.getModel().setValue(FROMENTITY, null);
                this.getModel().setValue(FROMEVENT, null);
            }
            Long pkValue = (Long)this.getView().getParentView().getModel().getDataEntity().getPkValue();
            if (0L != pkValue) {
                this.getView().setVisible(Boolean.valueOf(!EventParticipantPlugin.judgePreinsData(EVT_SUBSCRIPTION, pkValue)), new String[]{BTNOK});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String parent = showParameter.getParentFormId();
        String propName = e.getProperty().getName();
        String propValue = (String)this.getModel().getValue(propName);
        String fromf7 = (String)this.getModel().getValue(FROMF7);
        String fromentity = (String)this.getModel().getValue(FROMENTITY);
        String fromevent = (String)this.getModel().getValue(FROMEVENT);
        String fromclass = (String)this.getModel().getValue(FROMCLASS);
        if (parent.equals(EVT_SUBSCRIPTION)) {
            if (!propValue.isEmpty() && propName.equals(F7FIELD)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FROMEVENT, FROMENTITY, FROMCLASS});
                this.getModel().setValue(FROMEVENT, null);
                this.getModel().setValue(FROMCLASS, null);
                this.getModel().setValue(FROMENTITY, null);
                this.getModel().setValue(F7FIELD, (Object)propValue);
            } else if (!propValue.isEmpty() && propName.equals(FROMENTITY)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FROMF7, FROMEVENT, FROMCLASS});
                this.getModel().setValue(FROMF7, null);
                this.getModel().setValue(FROMEVENT, null);
                this.getModel().setValue(FROMCLASS, null);
            } else if (!propValue.isEmpty() && propName.equals(FROMEVENT)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FROMF7, FROMENTITY, FROMCLASS});
                this.getModel().setValue(FROMF7, null);
                this.getModel().setValue(FROMENTITY, null);
                this.getModel().setValue(FROMCLASS, null);
            } else if (!propValue.isEmpty() && propName.equals(FROMCLASS)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FROMF7, FROMENTITY, FROMEVENT});
                this.getModel().setValue(FROMF7, null);
                this.getModel().setValue(FROMENTITY, null);
                this.getModel().setValue(FROMEVENT, null);
            } else if (fromf7.isEmpty() && fromevent.isEmpty() && fromentity.isEmpty() && fromclass.isEmpty()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{FROMF7, FROMEVENT, FROMENTITY, FROMCLASS});
                this.getModel().setValue(FROMF7, null);
                this.getModel().setValue(FROMENTITY, null);
                this.getModel().setValue(FROMEVENT, null);
                this.getModel().setValue(F7FIELD, null);
                this.getModel().setValue(FROMCLASS, null);
            }
        }
    }

    private void loadParticipantPage(String participant) {
        List participants = (List)SerializationUtils.fromJsonString((String)participant, List.class);
        for (Map part : participants) {
            String type = String.valueOf(part.get("type"));
            if (ENTITY.equals(type)) {
                this.getModel().setValue(ENTITYFIELD, (Object)SerializationUtils.toJsonString((Object)part));
                this.getModel().setValue(FROMENTITY, part.get(VALUESHOWTEXT));
                continue;
            }
            if (EVENT.equals(type)) {
                this.getModel().setValue(EVENTFIELD, (Object)SerializationUtils.toJsonString((Object)part));
                this.getModel().setValue(FROMEVENT, part.get(VALUESHOWTEXT));
                continue;
            }
            if (PERSON.equals(type)) {
                this.getModel().setValue(F7FIELD, (Object)SerializationUtils.toJsonString((Object)part));
                String[] ids = part.get(VALUE).toString().split(",");
                String showText = EventParticipantPlugin.getNamesByIds(ids);
                this.getModel().setValue(FROMF7, (Object)showText);
                continue;
            }
            if (!PLUGIN.equals(type)) continue;
            this.getModel().setValue(FROMCLASS, part.get(VALUESHOWTEXT));
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String modelJson = (String)showParameter.getCustomParam("modelJson");
        String entityNumber = (String)showParameter.getCustomParam("entityNumber");
        HashMap<String, Object> content = new HashMap<String, Object>();
        String partString = String.valueOf(this.getModel().getValue(ENTITYFIELD));
        FormShowParameter parameter = new FormShowParameter();
        switch (key) {
            case "fromentity": {
                content.put("bpmnModel", modelJson);
                content.put("entityNumber", entityNumber);
                content.put("ruleType", ConditionalRuleType.skip);
                content.put("fromSubjectModelAndApp", "fromSubjectModelAndApp");
                content.put("filter", "F7");
                if (StringUtils.isNotEmpty((CharSequence)partString)) {
                    Map map = (Map)SerializationUtils.fromJsonString((String)partString, HashMap.class);
                    content.put(EXPRESSION, map.get(VALUE));
                }
                this.showForm("fromentityclosecallback", "wf_valueexpression", content);
                break;
            }
            case "fromevent": {
                String eventNumber = (String)showParameter.getCustomParam("eventnumber");
                content.put("bpmnModel", modelJson);
                content.put("eventnumber", eventNumber);
                content.put("ruleType", "EventConfig");
                content.put("fromSubjectModelAndApp", "fromSubjectModelAndApp");
                content.put("filter", "F7");
                partString = String.valueOf(this.getModel().getValue(EVENTFIELD));
                if (StringUtils.isNotEmpty((CharSequence)partString)) {
                    Map map = (Map)SerializationUtils.fromJsonString((String)partString, HashMap.class);
                    content.put(EXPRESSION, map.get(VALUE));
                }
                this.showForm("fromeventclosecallback", "wf_valueexpression", content);
                break;
            }
            case "class": {
                parameter.setFormId("evt_pluginconfig");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam(FROMCLASS, this.getModel().getValue(FROMCLASS));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "configPluginCloseCallBack"));
                if (("evt_automsg".equals(showParameter.getParentFormId()) || EVT_SUBSCRIPTION.equals(showParameter.getParentFormId())) && "false".equals(showParameter.getCustomParam(ISPRESET))) {
                    parameter.setCustomParam(ISPRESET, showParameter.getCustomParam(ISPRESET));
                }
                this.getView().showForm(parameter);
                break;
            }
            case "fromf7": {
                parameter.setFormId("wf_participant_assist");
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fromf7closecallback"));
                parameter.setCustomParam("openpagebyformid", (Object)"bos_usertreelistf7_part");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setShowTitle(false);
                parameter.setCustomParam("externalUserType", (Object)"all");
                parameter.setHasRight(true);
                parameter.setCustomParam("selectedType", (Object)PERSON);
                partString = String.valueOf(this.getModel().getValue(F7FIELD));
                if (StringUtils.isNotEmpty((CharSequence)partString)) {
                    Map map = (Map)SerializationUtils.fromJsonString((String)partString, HashMap.class);
                    parameter.setCustomParam("part", (Object)map);
                    parameter.setCustomParam(VALUE, map.get(VALUE));
                }
                parameter.setCustomParam("type", (Object)PERSON);
                parameter.setCustomParam("required", (Object)"false");
                this.getView().showForm(parameter);
                break;
            }
            case "btnok": {
                this.confirm();
                break;
            }
        }
    }

    private void showForm(String key, String formId, Map<String, Object> params) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String expression = (String)params.get(EXPRESSION);
        if (StringUtils.isNotBlank((CharSequence)expression) && expression.endsWith(".id")) {
            expression = expression.substring(0, expression.length() - 3);
        }
        params.put(EXPRESSION, expression);
        parameter.setCustomParams(params);
        this.getView().showForm(parameter);
    }

    private void confirm() {
        if (this.getModel().getValue(FROMENTITY).equals("")) {
            this.getModel().setValue(ENTITYFIELD, null);
        }
        if (this.getModel().getValue(FROMEVENT).equals("")) {
            this.getModel().setValue(EVENTFIELD, null);
        }
        if (this.getModel().getValue(FROMF7).equals("")) {
            this.getModel().setValue(F7FIELD, null);
        }
        this.getModel().getValue(FROMENTITY);
        ArrayList<Object> returnDataList = new ArrayList<Object>();
        String participantFromEntity = String.valueOf(this.getModel().getValue(ENTITYFIELD));
        String participantFromEvent = String.valueOf(this.getModel().getValue(EVENTFIELD));
        String participantFromF7 = String.valueOf(this.getModel().getValue(F7FIELD));
        String participantFromClass = String.valueOf(this.getModel().getValue(FROMCLASS));
        if (StringUtils.isNotEmpty((CharSequence)participantFromEntity)) {
            returnDataList.add(SerializationUtils.fromJsonString((String)participantFromEntity, HashMap.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)participantFromEvent)) {
            returnDataList.add(SerializationUtils.fromJsonString((String)participantFromEvent, HashMap.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)participantFromF7)) {
            returnDataList.add(SerializationUtils.fromJsonString((String)participantFromF7, HashMap.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)participantFromClass)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(FROMCLASS, participantFromClass);
            map.put("type", PLUGIN);
            map.put(VALUESHOWTEXT, participantFromClass);
            returnDataList.add(map);
        }
        String participantValue = SerializationUtils.toJsonString(returnDataList);
        String participant = this.updateParticipant(participantValue);
        JSONObject returnData = new JSONObject();
        returnData.put("receivervalue", (Object)participantValue);
        returnData.put(RECEIVER, (Object)participant);
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map map;
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (WfUtils.isEmptyString((Object)returnData)) {
            return;
        }
        if ("fromentityclosecallback".equals(actionId)) {
            this.getParticipantFromReturnData(returnData, ENTITY);
        } else if ("fromeventclosecallback".equals(actionId)) {
            this.getParticipantFromReturnData(returnData, EVENT);
        } else if ("fromf7closecallback".equals(actionId)) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String parent = showParameter.getParentFormId();
            if (parent.equals(EVT_SUBSCRIPTION)) {
                String[] ids = ((Map)returnData).get(VALUE).toString().split(",");
                if (ids.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u4eba\u5458\u3002", (String)"EventParticipantPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getParticipantFromReturnData(returnData, PERSON);
            } else {
                this.getParticipantFromReturnData(returnData, PERSON);
            }
        } else if ("configPluginCloseCallBack".equals(actionId) && (map = (Map)event.getReturnData()) != null) {
            this.getModel().setValue(FROMCLASS, (Object)map.toString());
        }
    }

    private void getParticipantFromReturnData(Object returnData, String type) {
        if (returnData instanceof Map) {
            if (PERSON.equals(type)) {
                this.getModel().setValue(F7FIELD, (Object)SerializationUtils.toJsonString((Object)returnData));
                String[] ids = ((Map)returnData).get(VALUE).toString().split(",");
                String showText = EventParticipantPlugin.getNamesByIds(ids);
                this.getModel().setValue(FROMF7, (Object)showText);
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                JSONObject propObj = JSONObject.parseObject((String)String.valueOf(((Map)returnData).get("prop")));
                Object fullName = propObj.get((Object)"fullName");
                map.put("type", type);
                map.put(VALUE, propObj.get((Object)EXPRESSION));
                map.put(VALUESHOWTEXT, fullName);
                map.put("required", Boolean.FALSE);
                if (ENTITY.equals(type)) {
                    this.getModel().setValue(FROMENTITY, fullName);
                    this.getModel().setValue(ENTITYFIELD, (Object)SerializationUtils.toJsonString(map));
                } else if (EVENT.equals(type)) {
                    this.getModel().setValue(FROMEVENT, fullName);
                    this.getModel().setValue(EVENTFIELD, (Object)SerializationUtils.toJsonString(map));
                }
            }
        }
    }

    private static String getNamesByIds(String[] ids) {
        String name = "";
        ArrayList<Long> idsLong = new ArrayList<Long>();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null || "".equals(ids[i].trim())) continue;
            idsLong.add(Long.valueOf(ids[i]));
        }
        if (idsLong.isEmpty()) {
            return null;
        }
        ORM orm = ORM.create();
        DynamicObjectCollection dos = orm.query(BOS_USER, "id,name", new QFilter[]{new QFilter("id", "in", (Object)idsLong.toArray())});
        if (!dos.isEmpty()) {
            StringBuilder names = new StringBuilder();
            for (DynamicObject obj : dos) {
                names.append(((ILocaleString)obj.get("name")).getLocaleValue()).append('\uff0c');
            }
            name = names.substring(0, names.length() - 1);
        }
        return name;
    }

    private String updateParticipant(String returnData) {
        StringBuilder showValue = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)returnData)) {
            List participantList = (List)SerializationUtils.fromJsonString((String)returnData, List.class);
            int size = participantList.size();
            for (int i = 0; i < participantList.size(); ++i) {
                Map participant = (Map)participantList.get(i);
                String type = (String)participant.get("type");
                if (ENTITY.equals(type)) {
                    showValue.append(ResManager.loadKDString((String)"\u5b9e\u4f53\uff1a", (String)"EventParticipantPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    showValue.append(participant.get(VALUESHOWTEXT));
                } else if (PERSON.equals(type)) {
                    showValue.append(ResManager.loadKDString((String)"\u4eba\u5458\uff1a", (String)"EventParticipantPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    showValue.append(ParticipantConfigureHelper.getTextFromParams(participant));
                } else if (EVENT.equals(type)) {
                    showValue.append(ResManager.loadKDString((String)"\u4e8b\u4ef6\uff1a", (String)"EventParticipantPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    showValue.append(participant.get(VALUESHOWTEXT));
                } else if (PLUGIN.equals(type)) {
                    showValue.append(ResManager.loadKDString((String)"\u63d2\u4ef6\uff1a", (String)"EventParticipantPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    showValue.append(participant.get(VALUESHOWTEXT));
                }
                if (i == size - 1) continue;
                showValue.append(';');
            }
        }
        return showValue.toString();
    }

    public static boolean judgePreinsData(String entityName, Object id) {
        DynamicObject dyObj = QueryServiceHelper.queryOne((String)entityName, (String)"ispreinsdata,ismodified", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        return dyObj.getBoolean("ispreinsdata") && dyObj.getBoolean("ismodified");
    }
}

