/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.graph.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.bpmn.graph.model.GraphItem;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.design.paste.IPropertiesReplicator;
import kd.bos.workflow.design.paste.PropertiesPasteFactory;
import kd.bos.workflow.design.plugin.AbstractWorkflowDesignerPlugin;
import kd.bos.workflow.design.plugin.model.StencilProperty;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

@KSObject
public class GraphModel
implements Serializable {
    private static final long serialVersionUID = 3502923469244918493L;
    private final Log log = LogFactory.getLog(this.getClass());
    private String modelType;
    private GraphCell root;
    private Map<String, GraphCell> cellMap = new HashMap<String, GraphCell>();
    private Map<String, List<String>> cellChildrenMap = new HashMap<String, List<String>>();
    private Map<String, String> cellParentMap = new HashMap<String, String>();

    public GraphModel(String modelType, String modelJson) {
        this.initModel(modelType, modelJson);
    }

    private void initModel(String modelType, String modelJson) {
        this.modelType = modelType;
        this.root = (GraphCell)SerializationUtils.fromJsonString((String)modelJson, GraphCell.class);
        this.initCellMap();
    }

    public String getModeType() {
        return this.modelType;
    }

    private void initCellMap() {
        String rootId = this.root.getResourceId();
        this.cellMap.put(rootId, this.root);
        List children = this.root.getChildShapes();
        for (GraphCell cell : children) {
            this.putChildrenCell(rootId, cell);
        }
    }

    private void putChildrenCell(String parentId, GraphCell cell) {
        String refId;
        if (cell.getProperties().get("expireModel") != null) {
            this.log.debug("kd.bos.workflow.design.graph.model.GraphModel.putChildrenCelljson\u4e2d\u7684\u7ed3\u679c" + ((Map)cell.getProperties().get("expireModel")).get("expireTime"));
        }
        List children = cell.getChildShapes();
        String cellId = cell.getResourceId();
        this.cellMap.put(cellId, cell);
        this.cellParentMap.put(cellId, parentId);
        if (DesignerModelUtil.isBoundaryEvent(cell.getStencil().getId()) && WfUtils.isNotEmpty((String)(refId = (String)DesignerModelUtil.getProperty(cell.getProperties(), "attachedToRefId")))) {
            List<String> childrenIds = this.cellChildrenMap.get(refId);
            if (childrenIds == null) {
                childrenIds = new ArrayList<String>();
                this.cellChildrenMap.put(refId, childrenIds);
            }
            childrenIds.add(cellId);
        }
        if (!children.isEmpty()) {
            List<String> childrenIds = this.cellChildrenMap.get(cellId);
            if (childrenIds == null) {
                childrenIds = new ArrayList<String>(children.size());
                this.cellChildrenMap.put(cellId, childrenIds);
            }
            for (GraphCell child : children) {
                childrenIds.add(child.getResourceId());
                this.putChildrenCell(cellId, child);
            }
        }
    }

    public GraphCell getGraphCell(String itemId) {
        return this.cellMap.get(itemId);
    }

    public Map<String, Object> getCellProperties(String itemId) {
        GraphCell cell = this.getGraphCell(itemId);
        if (cell != null) {
            return cell.getProperties();
        }
        this.log.debug(String.format("GraphModel\u4e2d\u4e0d\u5b58\u5728%s\u8282\u70b9\uff01", itemId));
        return null;
    }

    public void setProperty(String itemId, String stencilType, String propName, Object value) {
        this.setProperty(itemId, stencilType, propName, value, null);
    }

    public void setProperty(String itemId, String stencilType, String propName, Object value, JSONObject properties) {
        StencilProperty property;
        if ("expiretime".equals(propName)) {
            this.log.debug("\u9700\u8981\u53d8\u66f4\u7684\u503c\u4e3a" + value);
        }
        if ((property = DesignerModelUtil.getConfigProperty(this.modelType, stencilType, propName)) == null) {
            this.log.debug(String.format("%s\u6ca1\u6709%s\u5c5e\u6027\uff0csetProperty\u5931\u8d25\uff01", stencilType, propName));
            return;
        }
        Map<String, Object> cellProperties = this.getCellProperties(itemId);
        String path = DesignerModelUtil.getPropertyPath(property.getGroupId(), property.getPropertyName());
        DesignerModelUtil.setProperty(cellProperties, path, value);
        if (properties != null) {
            DesignerModelUtil.setProperty((Map<String, Object>)properties, path, value);
        }
    }

    public void setProperties(String itemId, String stencilType, Object ... pairs) {
        this.setProperties(itemId, stencilType, null, pairs);
    }

    public void setProperties(String itemId, String stencilType, JSONObject properties, Object ... pairs) {
        int length = pairs.length;
        if (length < 1) {
            return;
        }
        String propName = null;
        Object value = null;
        StencilProperty property = null;
        Map<String, Object> cellProperties = this.getCellProperties(itemId);
        for (int i = 0; i < length; ++i) {
            propName = (String)pairs[i];
            value = pairs[++i];
            if (null == propName || (property = DesignerModelUtil.getConfigProperty(this.modelType, stencilType, propName)) == null) continue;
            String path = DesignerModelUtil.getPropertyPath(property.getGroupId(), property.getPropertyName());
            DesignerModelUtil.setProperty(cellProperties, path, value);
            if (properties == null) continue;
            DesignerModelUtil.setProperty((Map<String, Object>)properties, path, value);
        }
    }

    public void deleteProperty(String itemId, String stencilType, String propName) {
        StencilProperty property = DesignerModelUtil.getConfigProperty(this.modelType, stencilType, propName);
        Map<String, Object> properties = this.getCellProperties(itemId);
        if (property == null) {
            if (properties.get(propName) != null) {
                properties.remove(propName);
            } else {
                Object value = BpmnModelUtil.getProperty(properties, (String)propName);
                if (value != null) {
                    BpmnModelUtil.deleteProperty(properties, (String)propName);
                } else {
                    this.log.debug(String.format("%s\u6ca1\u6709%s\u5c5e\u6027\uff0cdeleteProperty\u5931\u8d25\uff01", stencilType, propName));
                }
            }
            return;
        }
        BpmnModelUtil.deleteProperty(properties, (String)DesignerModelUtil.getPropertyPath(property.getGroupId(), property.getPropertyName()));
    }

    public void deleteProperties(String itemId, String stencilType, String ... properties) {
        for (String property : properties) {
            this.deleteProperty(itemId, stencilType, property);
        }
    }

    public Object getProperty(String itemId, String stencilType, String propName) {
        StencilProperty property = DesignerModelUtil.getConfigProperty(this.modelType, stencilType, propName);
        if (property == null) {
            this.log.debug(String.format("%s\u6ca1\u6709%s\u5c5e\u6027\uff0cgetProperty\u5931\u8d25\uff01", stencilType, propName));
            return null;
        }
        Map<String, Object> properties = this.getCellProperties(itemId);
        return DesignerModelUtil.getProperty(properties, DesignerModelUtil.getPropertyPath(property.getGroupId(), property.getPropertyName()));
    }

    public void removeCells(List<GraphCell> cells) {
        List<GraphCell> children = new ArrayList();
        for (GraphCell cell : cells) {
            String id = cell.getResourceId();
            GraphCell parent = this.getGraphCell(this.cellParentMap.get(id));
            if (parent != null) {
                children = parent.getChildShapes();
            }
            if (cell.isEdge()) {
                GraphCell source = this.getEdgeSource(cell);
                this.removeOutgoing(source, id);
            } else {
                List<GraphCell> edges = this.getVertexSource(cell);
                for (GraphCell edge : edges) {
                    edge.setTarget(null);
                    this.removeOutgoing(edge, id);
                }
            }
            this.cellMap.remove(id);
            children.remove(cell);
            this.cellParentMap.remove(id);
            this.log.debug(String.format("\u5220\u9664\u8282\u70b9: %s", id));
            this.removeAttachedBoundaryEvent(cell, children);
        }
    }

    private void removeAttachedBoundaryEvent(GraphCell cell, List<GraphCell> rootChildren) {
        if ("BoundaryErrorEvent".equals(cell.getStencil().getId()) || "SequenceFlow".equals(cell.getStencil().getId())) {
            return;
        }
        String ATTACHED_TO_REFID = "attachedToRefId";
        ArrayList<GraphCell> attachedCells = new ArrayList<GraphCell>();
        ArrayList<String> attachedCellIds = new ArrayList<String>();
        for (GraphCell child : rootChildren) {
            String refId;
            if (!"BoundaryErrorEvent".equals(child.getStencil().getId()) || (refId = (String)child.getProperties().get("attachedToRefId")) == null || !refId.equals(cell.getResourceId())) continue;
            attachedCells.add(child);
            attachedCellIds.add(child.getResourceId());
        }
        if (!attachedCells.isEmpty()) {
            this.log.debug(String.format("\u5220\u9664\u8282\u70b9 %s \u5173\u8054\u7684\u8fb9\u754c\u8282\u70b9 %s !", cell.getResourceId(), attachedCellIds));
            this.removeCells(attachedCells);
        }
    }

    public String cloneAndAddCells(List<GraphCell> cells, IFormView currentView) {
        if (cells.isEmpty()) {
            return null;
        }
        int DELIMITER = 12289;
        StringBuilder result = new StringBuilder();
        HashMap<String, GraphModel> modelMap = new HashMap<String, GraphModel>();
        PropertiesPasteFactory factory = PropertiesPasteFactory.getInstance();
        boolean isSameDesigner = currentView.getPageId().equals(cells.get(0).getOriginPageId());
        IPropertiesReplicator replicator = factory.getPropertiesReplicator(isSameDesigner);
        for (GraphCell cell : cells) {
            GraphCell oriCell = this.getOriginCell(cell, modelMap, currentView);
            if (oriCell == null) {
                this.log.warn(String.format("The source %s dosen't exists! ID: %s", cell.getOriginId(), cell.getResourceId()));
                result.append(String.format(WFMultiLangConstants.getCellSourceTip(), cell.getFullName(), cell.getOriginId())).append('\u3001');
            } else {
                replicator.copyProperties(this, cell, oriCell);
            }
            this.addCell(cell);
            for (GraphCell child : cell.getChildShapes()) {
                GraphCell oriChild = this.getOriginCell(child, modelMap, currentView);
                if (oriChild == null) {
                    this.log.warn(String.format("The child source %s dosen't exists! ID: %s  ParentId: %s", child.getOriginId(), child.getResourceId(), cell.getResourceId()));
                    result.append(String.format(WFMultiLangConstants.getCellSourceTip(), child.getFullName(), child.getOriginId())).append('\u3001');
                } else {
                    replicator.copyProperties(this, child, cell, oriChild);
                }
                this.addCell(child);
            }
            cell.getChildShapes().clear();
        }
        int length = result.length();
        if (length == 0) {
            return null;
        }
        int index = -1;
        index = result.lastIndexOf(String.valueOf('\u3001'));
        if (index == length - 1) {
            result.deleteCharAt(index);
        }
        return String.format(ResManager.loadKDString((String)"\u8282\u70b9\u5c5e\u6027\u590d\u5236\u5931\u8d25\uff0c\u201c%s\u201d \u5728\u6a21\u578b\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"GraphModel_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), result);
    }

    private GraphCell getOriginCell(GraphCell cell, Map<String, GraphModel> modelMap, IFormView currentView) {
        String originPageId;
        String pageId = currentView.getPageId();
        if (pageId.equals(originPageId = cell.getOriginPageId())) {
            return this.getGraphCell(cell.getOriginId());
        }
        GraphModel model = modelMap.get(originPageId);
        if (model == null) {
            AbstractWorkflowDesignerPlugin plugin = DesignerModelUtil.getWorkflowDesignerPlugin(currentView.getView(originPageId));
            if (plugin == null) {
                return null;
            }
            model = plugin.getGraphModel();
            modelMap.put(originPageId, model);
        }
        return model.getGraphCell(cell.getOriginId());
    }

    private void removeOutgoing(GraphCell cell, String outgoingId) {
        if (cell == null) {
            this.log.debug(String.format("\u627e\u4e0d\u5230 %s \u7ebf\u7684\u524d\u4e00\u8282\u70b9\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff01", outgoingId));
            return;
        }
        List outgoings = cell.getOutgoing();
        Iterator iterator = outgoings.iterator();
        while (iterator.hasNext()) {
            if (!outgoingId.equals(((GraphItem)iterator.next()).getResourceId())) continue;
            iterator.remove();
        }
    }

    private GraphCell getEdgeSource(GraphCell edge) {
        List children = this.root.getChildShapes();
        String id = edge.getResourceId();
        for (GraphCell cell : children) {
            if (cell.isEdge()) continue;
            for (GraphItem item : cell.getOutgoing()) {
                if (!id.equals(item.getResourceId())) continue;
                return cell;
            }
        }
        return null;
    }

    private List<GraphCell> getVertexSource(GraphCell vertex) {
        ArrayList<GraphCell> edges = new ArrayList<GraphCell>();
        List children = this.root.getChildShapes();
        String id = vertex.getResourceId();
        for (GraphCell cell : children) {
            if (!cell.isEdge() || cell.getTarget() == null || !id.equals(cell.getTarget().getResourceId())) continue;
            edges.add(cell);
        }
        return edges;
    }

    public void addCell(GraphCell cell) {
        this.cellMap.put(cell.getResourceId(), cell);
        this.root.getChildShapes().add(cell);
        this.log.debug(String.format("\u6dfb\u52a0\u8282\u70b9: %s", cell.getResourceId()));
    }

    public String connectAddCell(GraphCell edge, String sourceId, GraphCell target) {
        this.connect(edge, sourceId, target.getResourceId());
        if (this.cellMap.get(target.getResourceId()) == null) {
            this.addCell(target);
            return "connect_add";
        }
        return "connect";
    }

    public void connect(GraphCell edge, String sourceId, String targetId) {
        GraphCell flow = this.cellMap.get(edge.getResourceId());
        if (flow == null) {
            this.addCell(edge);
            GraphCell source = this.cellMap.get(sourceId);
            source.getOutgoing().add(new GraphItem(edge.getResourceId()));
        } else {
            GraphCell oriSource = this.getEdgeSource(flow);
            if (oriSource != null && sourceId != null) {
                if (!sourceId.equals(oriSource.getResourceId())) {
                    this.sourceConnect(edge, sourceId);
                    this.removeOutgoing(oriSource, flow.getResourceId());
                } else {
                    this.targetConnect(flow, edge);
                }
            } else if (oriSource == null && sourceId == null) {
                this.targetConnect(flow, edge);
            } else if (oriSource == null) {
                this.sourceConnect(edge, sourceId);
            } else {
                this.removeOutgoing(oriSource, flow.getResourceId());
            }
        }
    }

    private void sourceConnect(GraphCell edge, String sourceId) {
        GraphCell source = this.cellMap.get(sourceId);
        GraphItem item = new GraphItem(edge.getResourceId());
        if (!source.getOutgoing().contains(item)) {
            source.getOutgoing().add(item);
        }
    }

    private void targetConnect(GraphCell flow, GraphCell edge) {
        flow.setOutgoing(edge.getOutgoing());
        flow.setTarget(edge.getTarget());
    }

    public void splitEdge(GraphCell edge, GraphCell newEdge) {
        GraphItem oldEdgeItem = new GraphItem(edge.getResourceId());
        GraphCell source = this.getEdgeSource(edge);
        if (source != null) {
            source.getOutgoing().remove(oldEdgeItem);
            source.getOutgoing().add(new GraphItem(newEdge.getResourceId()));
        }
        this.addCell(newEdge);
        GraphCell target = this.cellMap.get(newEdge.getTarget().getResourceId());
        target.getOutgoing().add(oldEdgeItem);
    }

    @KSMethod
    public String getBpmnModelJson() {
        return JSON.toJSONString((Object)this.root);
    }

    public BpmnModel getBpmnModel() {
        return ProcessDefinitionUtil.getBpmnModel((String)this.getBpmnModelJson());
    }

    public void updateGraphGeometry(GraphCell graphRoot) {
        this.updateCellGraphGeometry(this.root, graphRoot);
    }

    public GraphCell getRootCell() {
        return this.root;
    }

    public Object getRootCellProperty(String property) {
        return BpmnModelUtil.getProperty((Map)this.root.getProperties(), (String)property);
    }

    private void updateCellGraphGeometry(GraphCell originCell, GraphCell newCell) {
        originCell.updateGeometry(newCell);
        List children = newCell.getChildShapes();
        if (!children.isEmpty()) {
            GraphCell origin = null;
            for (GraphCell child : children) {
                origin = this.cellMap.get(child.getResourceId());
                this.updateCellGraphGeometry(origin, child);
            }
        }
    }

    public void parentChanged(String parentId, Map<String, String> changed) {
        if (WfUtils.isEmpty((String)parentId)) {
            this.log.warn("cells moved parentId is null!");
            return;
        }
        if (changed == null || changed.isEmpty()) {
            this.log.warn("no changed!");
            return;
        }
        GraphCell parent = this.getGraphCell(parentId);
        for (Map.Entry<String, String> entry : changed.entrySet()) {
            GraphCell cell = this.getGraphCell(entry.getKey());
            GraphCell oriParent = this.getGraphCell(entry.getValue());
            oriParent.getChildShapes().remove(cell);
            parent.getChildShapes().add(cell);
            this.specialHandling(cell, oriParent, parent);
        }
        System.out.println(JSON.toJSONString((Object)this.root));
    }

    private void specialHandling(GraphCell cell, GraphCell oriParent, GraphCell newParent) {
        if ("Lane".equals(cell.getStencil().getId())) {
            if ("Pool".equals(newParent.getStencil().getId())) {
                cell.getProperties().put("pool_id", newParent.getResourceId());
            } else {
                cell.getProperties().put("pool_id", null);
            }
        }
    }
}

