/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.paste;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.paste.IPropertiesReplicator;
import kd.bos.workflow.engine.WfUtils;

public class AbstractDesignerReplicator
implements IPropertiesReplicator {
    protected Log log = LogFactory.getLog(this.getClass());

    @Override
    public void copyProperties(GraphModel graphModel, GraphCell cell, GraphCell oriCell) {
        cell.setProperties(oriCell.getCopiedProperties(cell));
        this.handleSpecialProperties(cell, graphModel);
    }

    @Override
    public void copyProperties(GraphModel graphModel, GraphCell child, GraphCell parent, GraphCell oriChild) {
        child.setProperties(oriChild.getCopiedProperties(child));
        this.handleSpecialProperties(child, parent, graphModel);
    }

    protected void handleSpecialProperties(GraphCell cell, GraphModel graphModel) {
        this.handleSpecialProperties(cell, null, graphModel);
    }

    protected void handleSpecialProperties(GraphCell cell, GraphCell parent, GraphModel graphModel) {
        String type = cell.getStencil().getId();
        Set stencilTypes = ModelConfigUtil.getBuiltInStencilTypes();
        if (stencilTypes.contains(type)) {
            this.handleNodeProperties(type, cell, parent, graphModel);
        } else {
            String parentType = ModelConfigUtil.getInheritStencilType((String)type);
            this.handleNodeProperties(parentType, cell, parent, graphModel);
        }
    }

    protected void handleNodeProperties(String type, GraphCell cell, GraphCell parent, GraphModel graphModel) {
        Map properties = cell.getProperties();
        if (WfUtils.isEmpty((String)type)) {
            this.log.debug(String.format("The type is null! %s %s", cell.getResourceId(), cell.getStencil().getId()));
            return;
        }
        switch (type) {
            case "StartSignalEvent": {
                this.handleStartEventProperties(properties, graphModel);
                break;
            }
            case "UserTask": {
                this.handleUserTaskProperties(properties, graphModel);
                break;
            }
            case "AuditTask": {
                this.handleAuditTaskProperties(properties, graphModel);
                break;
            }
            case "YunzhijiaTask": {
                this.handleYunzhijiaTaskProperties(properties, graphModel);
                break;
            }
            case "BoundaryErrorEvent": {
                this.handleBoundaryEventProperties(properties, parent, graphModel);
                break;
            }
        }
    }

    protected void handleBoundaryEventProperties(Map<String, Object> properties, GraphCell parent, GraphModel graphModel) {
        properties.put("attachedToRefId", parent.getResourceId());
    }

    protected void handleStartEventProperties(Map<String, Object> properties, GraphModel graphModel) {
    }

    protected void handleUserTaskProperties(Map<String, Object> properties, GraphModel graphModel) {
        if (properties.containsKey("allowNextPersonSettingModel")) {
            this.removeAfterAssignNodes(properties);
        }
    }

    private void removeAfterAssignNodes(Map<String, Object> copiedProperties) {
        JSONObject nextPersonSetting;
        Map copiedValue = (Map)copiedProperties.get("allowNextPersonSettingModel");
        if (copiedValue.get("allowNextPersonSetting") != null && (nextPersonSetting = (JSONObject)copiedValue.get("allowNextPersonSetting")).get((Object)"sceneNextNodeAssignValue") != null) {
            nextPersonSetting.remove((Object)"sceneNextNodeAssignValue");
        }
    }

    protected void handleAuditTaskProperties(Map<String, Object> properties, GraphModel graphModel) {
        if (properties.containsKey("allowNextPersonSettingModel")) {
            this.removeAfterAssignNodes(properties);
        }
    }

    private void handleYunzhijiaTaskProperties(Map<String, Object> properties, GraphModel graphModel) {
        this.handleAuditTaskProperties(properties, graphModel);
    }
}

