/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.paste;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.paste.AbstractDesignerReplicator;
import kd.bos.workflow.design.util.DesignerPasteUtil;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class CrossingDesignerReplicator
extends AbstractDesignerReplicator {
    @Override
    protected void handleStartEventProperties(Map<String, Object> properties, GraphModel graphModel) {
        super.handleStartEventProperties(properties, graphModel);
        String processNumber = (String)graphModel.getRootCellProperty("process_id");
        properties.put("signalref", processNumber);
    }

    @Override
    protected void handleAuditTaskProperties(Map<String, Object> properties, GraphModel graphModel) {
        super.handleAuditTaskProperties(properties, graphModel);
        this.handleDecisionOption(properties, graphModel);
    }

    private void handleDecisionOption(Map<String, Object> properties, GraphModel graphModel) {
        List children = graphModel.getRootCell().getChildShapes();
        GraphCell firstUserTask = DesignerPasteUtil.getFirstUserTask(children, graphModel);
        Object decisionOptions = BpmnModelUtil.getProperty(properties, (String)"decisionOptions");
        if (decisionOptions instanceof List) {
            List decisions = (List)decisionOptions;
            for (Map decision : decisions) {
                if (!"reject".equals(decision.get("auditType")) || "rejectToPreAuditNode".equals(decision.get("decisionScene"))) continue;
                if (firstUserTask != null) {
                    decision.put("rejectOptions", DesignerPasteUtil.getFirstUserRejectOptions(firstUserTask));
                    continue;
                }
                decision.put("rejectOptions", new ArrayList());
            }
        }
        BpmnModelUtil.setProperty(properties, (String)"batchReject.batchRejectNode", null);
    }
}

