/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.UserField;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.ConditionalRuleUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.WFErrorCode;

public abstract class AbstractPartPlugin
extends AbstractWorkflowPlugin {
    private static final Set<String> USERS_NEED_IGNORE = new HashSet<String>();
    private static final String REPORT_TYPE_FORMID = "wf_cooperation_def";
    private static final String RELATION_DEF_ENTRY = "relationtypeentry";
    private static final String RELATION_ENTRY_NAME = "reltypename";
    private static final String RELATION_ENTRY_NUMBER = "reltypenum";
    protected static final String RELATION_PERSON_TYPE = "refpersontype";
    private static final String PARAM_DEF_SUBENTRY = "paramsdefsubentry";

    protected boolean checkNull(Map<String, String> fields) {
        IDataModel model = this.getModel();
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String field = entry.getKey();
            if (!WfUtils.isEmptyString((Object)model.getValue(field))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractPartPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), entry.getValue()), Integer.valueOf(1000));
            return false;
        }
        return true;
    }

    protected void setIfCheck(IDataModel model, String prop, Object value) {
        if (WfUtils.isEmpty((String)prop) || WfUtils.isEmptyString((Object)value)) {
            return;
        }
        model.setValue(prop, value);
    }

    protected Process extractProcessFromParameter(FormShowParameter formShowParameter) {
        try {
            Process process = null;
            Map extendData = (Map)formShowParameter.getCustomParam("context");
            process = extendData.get("procDefId") != null ? this.getRepositoryService().getBpmnModel((Long)extendData.get("procDefId"), null).getMainProcess() : DesignerModelUtil.getBpmnModel((String)extendData.get("model")).getMainProcess();
            return process;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, WFErrorCode.getMainProcessFromBpmnModel(), new Object[]{e.getMessage()});
        }
    }

    protected List<ComboItem> extractUserItemsFromEntity(Entity<?, ?> entity, String prefix) {
        ArrayList<ComboItem> userItems = new ArrayList<ComboItem>();
        String namePrefix = prefix;
        String valuePrefix = "ENTI_";
        if (entity instanceof EntryEntity) {
            namePrefix = entity.getName().getLocaleValue() + "-";
            valuePrefix = "ENTRY_" + entity.getKey() + ".";
        }
        for (EntityItem item : entity.getItems()) {
            String value;
            if (!(item instanceof UserField) || USERS_NEED_IGNORE.contains(value = item.getKey())) continue;
            LocaleString name = item.getName();
            String orignalName = name.getLocaleValue();
            String newName = namePrefix + (WfUtils.isNotEmpty((String)orignalName) ? orignalName : "");
            String newValue = valuePrefix + value;
            userItems.add(new ComboItem(new LocaleString(newName), newValue));
        }
        return userItems;
    }

    protected List<ComboItem> extractUserItemsFromEntityCache(DynamicObjectType entityType, String prefix) {
        ArrayList<ComboItem> userItems = new ArrayList<ComboItem>();
        String namePrefix = prefix;
        String valuePrefix = "ENTI_";
        if (entityType instanceof EntryType) {
            namePrefix = entityType.getDisplayName().getLocaleValue() + "-";
            valuePrefix = "ENTRY_" + entityType.getName() + ".";
        }
        boolean isUserProp = false;
        String refPersonType = (String)this.getModel().getValue(RELATION_PERSON_TYPE);
        if (WfUtils.isEmpty((String)refPersonType)) {
            refPersonType = "bos_user";
        }
        String baseEntityId = null;
        for (IDataEntityProperty item : entityType.getProperties()) {
            String value;
            baseEntityId = null;
            isUserProp = false;
            if (item instanceof BasedataProp) {
                baseEntityId = ((BasedataProp)item).getBaseEntityId();
            }
            if (item instanceof MulBasedataProp) {
                baseEntityId = ((MulBasedataProp)item).getBaseEntityId();
            }
            if (!(isUserProp = WfUtils.isNotEmpty((String)baseEntityId) && refPersonType.contains(baseEntityId)) || USERS_NEED_IGNORE.contains(value = item.getName())) continue;
            LocaleString name = item.getDisplayName();
            String orignalName = name.getLocaleValue();
            String newName = namePrefix + (WfUtils.isNotEmpty((String)orignalName) ? orignalName : "");
            String newValue = valuePrefix + value;
            userItems.add(new ComboItem(new LocaleString(newName), newValue));
        }
        return userItems;
    }

    protected List<ComboItem> extractOrgItemsFromEntityCacheForPartRole(DynamicObjectType entityType, String prefix) {
        DataEntityPropertyCollection properties;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (null != entityType && null != (properties = entityType.getProperties()) && properties.size() > 0) {
            String namePrefix = prefix;
            String valuePrefix = "ENTI_";
            if (entityType instanceof EntryType) {
                namePrefix = entityType.getDisplayName().getLocaleValue() + "-";
                valuePrefix = "ENTRY_" + entityType.getName() + ".";
            }
            String newName = null;
            String newValue = null;
            boolean isOrgPropExist = false;
            boolean isBasedataPropForOrg = false;
            boolean isBasedataPropForUser = false;
            BasedataProp itemProp = null;
            String itemPropValue = null;
            LocaleString itemPropNameLocal = null;
            String itemPropName = null;
            String orgPropName = null;
            String orgPropValue = null;
            MainEntityType mainEntityForUser = null;
            DataEntityPropertyCollection propertiesForUser = null;
            EntryType typeForUser = null;
            DataEntityPropertyCollection propertiesForUserEntry = null;
            OrgProp orgPropForUser = null;
            for (IDataEntityProperty item : properties) {
                isOrgPropExist = false;
                itemPropValue = item.getName();
                boolean bl = isBasedataPropForOrg = item instanceof BasedataProp && "bos_org".equals(((BasedataProp)item).getBaseEntityId());
                if (item instanceof OrgProp || isBasedataPropForOrg) {
                    isOrgPropExist = true;
                    orgPropName = item.getDisplayName().getLocaleValue();
                    orgPropValue = item.getName();
                    newName = namePrefix + (WfUtils.isNotEmpty((String)orgPropName) ? orgPropName : "");
                    newValue = valuePrefix + orgPropValue;
                } else {
                    boolean bl2 = isBasedataPropForUser = item instanceof BasedataProp && "bos_user".equals(((BasedataProp)item).getBaseEntityId());
                    if (item instanceof UserProp || isBasedataPropForUser) {
                        if (USERS_NEED_IGNORE.contains(itemPropValue)) continue;
                        itemProp = (BasedataProp)item;
                        mainEntityForUser = EntityMetadataCache.getDataEntityType((String)itemProp.getBaseEntityId());
                        if (null != mainEntityForUser && null != (propertiesForUser = mainEntityForUser.getProperties()) && propertiesForUser.size() > 0) {
                            block1: for (IDataEntityProperty prop : propertiesForUser) {
                                if (!(prop instanceof EntryProp) || !"entryentity".equals(((EntryProp)prop).getName()) || null == (typeForUser = (EntryType)((EntryProp)prop).getDynamicCollectionItemPropertyType()) || null == (propertiesForUserEntry = typeForUser.getProperties()) || propertiesForUserEntry.size() <= 0) continue;
                                for (IDataEntityProperty propForEntry : propertiesForUserEntry) {
                                    if (!(propForEntry instanceof OrgProp) || null == (orgPropForUser = (OrgProp)propForEntry) || !"dpt".equals(orgPropForUser.getName())) continue;
                                    isOrgPropExist = true;
                                    orgPropName = orgPropForUser.getDisplayName().getLocaleValue();
                                    orgPropValue = typeForUser.getName() + "." + orgPropForUser.getName();
                                    continue block1;
                                }
                            }
                        }
                        if (isOrgPropExist) {
                            itemPropNameLocal = item.getDisplayName();
                            itemPropName = itemPropNameLocal.getLocaleValue();
                            newName = namePrefix + (WfUtils.isNotEmpty((String)itemPropName) ? itemPropName : "") + '.' + (WfUtils.isNotEmpty((String)orgPropName) ? orgPropName : "");
                            newValue = valuePrefix + itemPropValue + '.' + orgPropValue;
                        }
                    }
                }
                if (!isOrgPropExist) continue;
                items.add(new ComboItem(new LocaleString(newName), newValue));
            }
        }
        return items;
    }

    protected List<ComboItem> extractUserItemsFromProcess(Process process) {
        ArrayList<ComboItem> userItems = new ArrayList<ComboItem>();
        if (WfUtils.isNullObject((Object)process)) {
            return userItems;
        }
        Object sendEvt = null;
        sendEvt = this.getView().getFormShowParameter().getCustomParam("referencePersonScene");
        if (sendEvt != null) {
            LocaleString name = new LocaleString();
            name = "taskReceived".equals(sendEvt) ? (LocaleString)WfUtils.getPromptWordLocaleString((String)"\u6d41\u7a0b-\u4efb\u52a1\u63a5\u6536\u4eba", (String)"AbstractPartPlugin_4", (String)"bos-wf-formplugin") : (LocaleString)WfUtils.getPromptWordLocaleString((String)"\u6d41\u7a0b-\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u4eba", (String)"AbstractPartPlugin_3", (String)"bos-wf-formplugin");
            userItems.add(new ComboItem(name, "PROC_currentParticipant"));
        }
        for (Macro marco : process.getMacros()) {
            if (!"user".equals(marco.getDataType())) continue;
            String name = String.format(ResManager.loadKDString((String)"\u6d41\u7a0b-%s", (String)"AbstractPartPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), marco.getDescription());
            String value = marco.getName();
            userItems.add(new ComboItem(new LocaleString(name), "PROC_" + value));
        }
        return userItems;
    }

    protected List<ComboItem> extractOrgItemsFromEntity(Entity<?, ?> entity, String prefix) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        String namePrefix = prefix;
        String valuePrefix = "ENTI_";
        if (entity instanceof EntryEntity) {
            namePrefix = entity.getName().getLocaleValue() + "-";
            valuePrefix = "ENTRY_" + entity.getKey() + ".";
        }
        for (EntityItem item : entity.getItems()) {
            if (!(item instanceof OrgField)) continue;
            String value = item.getKey();
            LocaleString name = item.getName();
            String orignalName = name.getLocaleValue();
            String newName = namePrefix + (WfUtils.isNotEmpty((String)orignalName) ? orignalName : "");
            String newValue = valuePrefix + value;
            orgItems.add(new ComboItem(new LocaleString(newName), newValue));
        }
        return orgItems;
    }

    protected List<ComboItem> extractBasedataFieldItemsFromEntityByEntityId(Entity<?, ?> entity, String prefix, String entityNum) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        String namePrefix = prefix;
        String valuePrefix = "ENTI_";
        if (entity instanceof EntryEntity) {
            namePrefix = entity.getName().getLocaleValue() + "-";
            valuePrefix = "ENTRY_" + entity.getKey() + ".";
        }
        String entityId = MetadataDao.getIdByNumber((String)entityNum, (MetaCategory)MetaCategory.Entity);
        for (EntityItem item : entity.getItems()) {
            if (!(item instanceof BasedataField) || ((BasedataField)item).getBaseEntityId() == null || !((BasedataField)item).getBaseEntityId().equals(entityId)) continue;
            String value = item.getKey();
            LocaleString name = item.getName();
            String orignalName = name.getLocaleValue();
            String newName = namePrefix + (WfUtils.isNotEmpty((String)orignalName) ? orignalName : "");
            String newValue = valuePrefix + value;
            orgItems.add(new ComboItem(new LocaleString(newName), newValue));
        }
        return orgItems;
    }

    protected List<ComboItem> extractOrgItemsFromEntityCache(DynamicObjectType entityType, String prefix) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        String namePrefix = prefix;
        String valuePrefix = "ENTI_";
        if (entityType instanceof EntryType) {
            namePrefix = entityType.getDisplayName().getLocaleValue() + "-";
            valuePrefix = "ENTRY_" + entityType.getName() + ".";
        }
        for (IDataEntityProperty item : entityType.getProperties()) {
            String value;
            if (!(item instanceof OrgProp) || USERS_NEED_IGNORE.contains(value = item.getName())) continue;
            LocaleString name = item.getDisplayName();
            String orignalName = name.getLocaleValue();
            String newName = namePrefix + (WfUtils.isNotEmpty((String)orignalName) ? orignalName : "");
            String newValue = valuePrefix + value;
            orgItems.add(new ComboItem(new LocaleString(newName), newValue));
        }
        return orgItems;
    }

    @Deprecated
    protected long getTopOrg(long subOrg) {
        if (subOrg == 0L) {
            return 0L;
        }
        long cu = OrgServiceHelper.getCuByOrgId((long)subOrg);
        return cu;
    }

    protected Map<String, ComboItem> extractReportTypesByType(String type) {
        LinkedHashMap<String, ComboItem> coItems = new LinkedHashMap<String, ComboItem>();
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)};
        Map coObjs = BusinessDataServiceHelper.loadFromCache((String)REPORT_TYPE_FORMID, (String)"number,name,id", (QFilter[])filters, (String)"createtime");
        if (coObjs != null) {
            for (DynamicObject obj : coObjs.values()) {
                ILocaleString name = obj.getLocaleString("name");
                String value = obj.getString("number");
                coItems.put(value, new ComboItem(LocaleString.fromMap((Map)name), value));
            }
        }
        return coItems;
    }

    protected Map<String, ComboItem> extractRelationsByReportType(String reportTypeNum) {
        DynamicObjectCollection cols;
        LinkedHashMap<String, ComboItem> relItems = new LinkedHashMap<String, ComboItem>();
        DynamicObject obj = this.extractCooperationByCooperationId(reportTypeNum);
        if (obj != null && (cols = obj.getDynamicObjectCollection(RELATION_DEF_ENTRY)) != null) {
            for (DynamicObject col : cols) {
                ILocaleString name = col.getLocaleString(RELATION_ENTRY_NAME);
                if (WfUtils.isEmpty((String)name.getLocaleValue())) {
                    name.setItem(Lang.get().toString(), (Object)name.getLocaleValue_zh_CN());
                }
                String value = col.getString(RELATION_ENTRY_NUMBER);
                relItems.put(value, new ComboItem(LocaleString.fromMap((Map)name), value));
            }
        }
        return relItems;
    }

    protected String extractRefPersonTypeByReportType(String reportTypeNum) {
        DynamicObjectCollection cols;
        StringBuilder refPersonType = new StringBuilder("bos_user");
        DynamicObject obj = this.extractCooperationByCooperationId(reportTypeNum);
        if (obj != null && (cols = obj.getDynamicObjectCollection(RELATION_PERSON_TYPE)) != null && cols.size() > 0) {
            refPersonType = new StringBuilder();
            for (int i = 0; i < cols.size(); ++i) {
                DynamicObject col = (DynamicObject)cols.get(i);
                String num = col.getString("fbasedataid_id");
                if (i == cols.size() - 1) {
                    refPersonType.append(num);
                    continue;
                }
                refPersonType.append(num).append(',');
            }
        }
        return refPersonType.toString();
    }

    protected DynamicObjectCollection extractParamsByRelId(String reportTypeNum, String relationNum) {
        DynamicObjectCollection cols;
        DynamicObjectCollection paramItems = null;
        DynamicObject obj = this.extractCooperationByCooperationId(reportTypeNum);
        if (obj != null && (cols = obj.getDynamicObjectCollection(RELATION_DEF_ENTRY)) != null && StringUtils.isNotBlank((CharSequence)relationNum)) {
            for (DynamicObject col : cols) {
                if (!relationNum.equals(col.getString(RELATION_ENTRY_NUMBER))) continue;
                paramItems = col.getDynamicObjectCollection(PARAM_DEF_SUBENTRY);
                break;
            }
        }
        return paramItems;
    }

    private DynamicObject extractCooperationByCooperationId(String reportTypeNum) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)reportTypeNum)};
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)REPORT_TYPE_FORMID, (QFilter[])filters);
        return obj;
    }

    protected String getEntraBill(FormShowParameter formShowParameter, Process process) {
        Map context;
        Map nodeProperties;
        if (process == null) {
            process = this.extractProcessFromParameter(formShowParameter);
        }
        if ((nodeProperties = (Map)(context = (Map)formShowParameter.getCustomParams().get("context")).get("nodeProperties")) != null) {
            String nodeId = (String)nodeProperties.get("itemId");
            Object needSourceElement = formShowParameter.getCustomParam("needSourceElement");
            return ConditionalRuleUtil.getEntryBillNumber(process, nodeId, needSourceElement);
        }
        return process.getEntraBill();
    }

    static {
        USERS_NEED_IGNORE.add("modifier");
        USERS_NEED_IGNORE.add("auditor");
    }
}

