/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public abstract class AbstractWorkflowConfigPlugin
extends AbstractWorkflowPlugin {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected static final String MODEL_JSON = "model_json";
    protected static final String SELECTION_CELL = "selection_cell";
    protected String modelType;
    protected String selectionCellType;
    protected String selectionCellId;

    @Override
    public void initialize() {
        super.initialize();
        this.modelType = (String)this.getView().getFormShowParameter().getCustomParam("model_type");
        String modelJson = this.getPageCache().get(MODEL_JSON);
        if (modelJson != null) {
            this.initGraphModel(modelJson);
        } else {
            this.log.debug("\u521d\u59cb\u5316GraphModel\u5931\u8d25\uff1aPageCache\u4e2dmodelJson\u4e3a\u7a7a\uff01");
        }
        this.initSelectionCell();
    }

    protected abstract void initGraphModel(String var1);

    protected abstract GraphModel getGraphModel();

    protected abstract String getType();

    private void initSelectionCell() {
        String cellStr = this.getPageCache().get(SELECTION_CELL);
        if (WfUtils.isNotEmpty((String)cellStr)) {
            JSONObject cell = JSON.parseObject((String)cellStr);
            this.selectionCellId = cell.getString("id");
            this.selectionCellType = cell.getString("type");
        }
    }

    public void cacheModelJson(String modelJson) {
        this.getPageCache().put(MODEL_JSON, modelJson);
        this.getPageCache().saveChanges();
    }

    public void cacheModelJson() {
        this.cacheModelJson(this.getGraphModel().getBpmnModelJson());
    }

    public void clearNodeConfigPageCache(String stencilType) {
        if (stencilType != null) {
            this.getPageCache().remove(stencilType);
        }
    }

    public void changeStyle(String itemId, IFormView view, String newStyle) {
    }

    public void shrinkConfigurePanel(IFormView view) {
    }

    public void updateCellName(String itemId, IFormView view, String value) {
    }

    public void updateBindToNodeProperty(boolean bindToPrev, String itemId, IFormView view, boolean value) {
    }

    public void updatePageCount(boolean increment, IFormView view) {
    }
}

