/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.bpmn.graph.model.IValueContext;
import kd.bos.workflow.bpmn.graph.model.JsonValueContext;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.model.StateItem;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.plugin.model.StencilCtrlState;
import kd.bos.workflow.design.plugin.model.StencilProperty;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.design.util.BillSummaryUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.util.BillSummaryType;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.msg.util.MessageUtils;

public abstract class AbstractWorkflowConfigurePlugin
extends AbstractWorkflowPlugin {
    private AbstractWorkflowConfigPlugin idePlugin;
    private IFormView ideFormView;
    private GraphModel graphModel;
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected String modelType;
    protected String stencilType;
    protected String stencilTemplate;
    protected String itemId;
    private Set<String> properties = new HashSet<String>();
    protected static final String CONTROL_SHRINK = "shrink";
    protected static final String CONTROL_SAVEVECTOR = "savevector";
    protected static final String FLOATLAYERBILLSUMMARY = "floatLayerBillSummary";
    protected static final String BIZFLOWBILLSUMMARY = "bizFlowBillSummary";
    protected static final String BUSINESSID = "businessid";
    protected static final String TEMPLATENAME = "templatename";
    private static final String SV_OUTENTRY_CONTENT = "sv_outmsg_content";
    private static final String SV_INENTRY_CONTENT = "sv_inmsg_content";
    private static final String SV_OUTENTRY_NOTIFYSUBJECT = "sv_outmsg_notifysubject";
    private static final String SV_INENTRY_NOTIFYSUBJECT = "sv_inmsg_notifysubject";
    protected static final String NODETEMPLATECOPY = "nodeTemplateCopy";
    protected static final String NODETEMPALTENUMBER = "nodeTempalteNumber";

    @Override
    public void initialize() {
        super.initialize();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.ideFormView = this.getWorkflowDesignerView(this.getView());
        if (this.ideFormView == null) {
            return;
        }
        this.idePlugin = parameter.getCustomParam("designer_formId") != null && "wf_nodeconfigview".equalsIgnoreCase((String)parameter.getCustomParam("designer_formId")) ? DesignerModelUtil.getWorkflowNodeTempaltePlugin(this.ideFormView) : DesignerModelUtil.getWorkflowDesignerPlugin(this.ideFormView);
        this.graphModel = this.idePlugin.getGraphModel();
        this.modelType = (String)parameter.getCustomParam("model_type");
        this.stencilType = (String)parameter.getCustomParam("stencil_type");
        this.stencilTemplate = (String)parameter.getCustomParam("node_template_number");
        this.itemId = (String)parameter.getCustomParam("itemId");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONTROL_SHRINK});
    }

    public void afterCreateNewData(EventObject e) {
        if (this.stencilType == null) {
            return;
        }
        JSONObject properties = this.getCellProperties();
        StencilConfig config = this.getStencilConfig();
        StencilCtrlState ctrlState = DesignerModelUtil.getStencilCtrlState(this.modelType, this.stencilType, this.idePlugin.getType());
        this.initControlsState(ctrlState);
        if (properties != null) {
            this.setCommonFieldValue(config, properties);
        }
        JSONObject props = this.getCellProperties();
        this.initNodeTemplate(props);
        this.log.debug(String.format("%s\u8282\u70b9\u5c5e\u6027\uff1a%s", this.itemId, properties));
    }

    protected StencilConfig getStencilConfig() {
        String nodeTplNumber = (String)this.getView().getFormShowParameter().getCustomParam("node_template_number");
        String nodeType = WfUtils.isNotEmpty((String)nodeTplNumber) ? nodeTplNumber : this.stencilType;
        return DesignerModelUtil.getStencilConfig(this.modelType, nodeType);
    }

    protected void initControlsState(StencilCtrlState state) {
        if (state != null) {
            this.initHiddenControls(state.getHidden());
            this.initReadOnlyControls(state.getReadonly());
        }
    }

    protected void initHiddenControls(Set<StateItem> items) {
        ArrayList<String> hiddenProps = new ArrayList<String>();
        ArrayList<String> showProps = new ArrayList<String>();
        IFormView view = this.getView();
        for (StateItem item : items) {
            if (view.getControl(item.getName()) == null) continue;
            if (Boolean.TRUE.equals(item.getValue())) {
                hiddenProps.add(item.getName());
                continue;
            }
            showProps.add(item.getName());
        }
        if (!hiddenProps.isEmpty()) {
            view.setVisible(Boolean.FALSE, hiddenProps.toArray(new String[0]));
        }
        if (!showProps.isEmpty()) {
            view.setVisible(Boolean.TRUE, showProps.toArray(new String[0]));
        }
    }

    protected void initReadOnlyControls(Set<StateItem> items) {
        ArrayList<String> disableProps = new ArrayList<String>();
        ArrayList<String> enableProps = new ArrayList<String>();
        IFormView view = this.getView();
        for (StateItem item : items) {
            if (view.getControl(item.getName()) == null) continue;
            if (Boolean.TRUE.equals(item.getValue())) {
                disableProps.add(item.getName());
                continue;
            }
            enableProps.add(item.getName());
        }
        if (!disableProps.isEmpty()) {
            view.setEnable(Boolean.FALSE, disableProps.toArray(new String[0]));
        }
        if (!enableProps.isEmpty()) {
            view.setEnable(Boolean.TRUE, enableProps.toArray(new String[0]));
        }
    }

    protected void setCommonFieldValue(StencilConfig config, JSONObject properties) {
        String name;
        IFormView view = this.getView();
        Label label = (Label)view.getControl("title");
        if (null != label) {
            name = config.getStencilName();
            label.setText(String.format(ResManager.loadKDString((String)"%s\u8bbe\u7f6e", (String)"AbstractWorkflowConfigurePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), name != null ? name : ""));
        }
        name = null;
        String group = null;
        String controlName = null;
        Control control = null;
        ArrayList<Object> updateProperties = new ArrayList<Object>();
        Map isvPropsConfig = ModelConfigUtil.getISVModelPropertiesConfig((String)config.getId());
        StencilProperty property = null;
        Map<String, StencilProperty> propertiesMap = config.getPropertiesMap();
        HashSet<String> initedProps = new HashSet<String>(propertiesMap.size());
        for (Map.Entry<String, StencilProperty> entry : propertiesMap.entrySet()) {
            String key = entry.getKey();
            if ("macros".equals(key)) continue;
            property = entry.getValue();
            name = controlName = property.getPropertyName();
            group = property.getGroupId();
            if (!this.isHandledProperty(name)) continue;
            if (WfUtils.isNotEmpty((String)group)) {
                name = String.format("%s.%s", group, name);
            }
            if ("management".equals(this.getScene()) && !BpmnModelUtil.hasProperty((Map)properties, (String)name) && !"extAttrGroup".equals(name)) {
                initedProps.add(name);
            }
            if ((control = view.getControl(controlName)) != null) {
                this.initPropertyValue(property, control, properties, name, updateProperties, isvPropsConfig);
                continue;
            }
            this.initPropertyDefaultValue(properties, name, controlName, updateProperties, isvPropsConfig, property);
        }
        if (!initedProps.isEmpty()) {
            this.recordInitedProps(initedProps);
        }
        this.setProperties(updateProperties.toArray(new Object[0]));
    }

    protected void initPropertyDefaultValue(JSONObject properties, String name, String controlName, List<Object> updateProperties, Map<String, Object> isvPropsConfig, StencilProperty property) {
        Object value = this.getInitPropValue(properties, name);
        if (value == null && property.getDefaultValue() != null) {
            updateProperties.add(controlName);
            updateProperties.add(this.getDefaultValue(properties, property, isvPropsConfig));
        }
    }

    protected void initPropertyValue(StencilProperty property, Control control, JSONObject properties, String propName, List<Object> updateProperties, Map<String, Object> isvPropsConfig) {
        Object value = this.getInitPropValue(properties, propName);
        value = value != null ? value : this.getDefaultValue(properties, property, isvPropsConfig);
        String propertyName = propName.replaceFirst("(.+\\.)?(\\w+)", "$2");
        if (control instanceof EntryGrid) {
            if (value instanceof JSONArray) {
                this.initEntryGridValue((EntryGrid)control, (JSONArray)value);
            } else {
                this.getModel().deleteEntryData(control.getKey());
            }
        } else if (control instanceof MulBasedataEdit) {
            if (value instanceof JSONArray) {
                this.getModel().setValue(control.getKey(), (Object)((JSONArray)value).toArray());
            } else if (value != null) {
                this.getModel().setValue(control.getKey(), (Object)String.valueOf(value).split("\\,"));
            }
        } else {
            if (value == null) {
                return;
            }
            if (this.getModel().getProperty(control.getKey()) == null) {
                return;
            }
            this.getModel().setValue(control.getKey(), value);
            updateProperties.add(propertyName);
            updateProperties.add(value);
        }
    }

    protected Object getInitPropValue(JSONObject properties, String propName) {
        Object value = DesignerModelUtil.getProperty((Map<String, Object>)properties, propName);
        return value;
    }

    protected Object getDefaultValue(JSONObject properties, StencilProperty property, Map<String, Object> isvPropsConfig) {
        String group = property.getGroupId();
        String propKey = group != null && !"base".equals(group) ? String.format("%s.%s", group, property.getPropertyName()) : property.getPropertyName();
        Object defaultVal = null;
        if (isvPropsConfig != null) {
            defaultVal = BpmnModelUtil.getProperty(isvPropsConfig, (String)propKey);
        }
        if (defaultVal == null) {
            defaultVal = property.getDefaultValue();
        }
        try {
            JsonValueContext valueContext = new JsonValueContext(this.getProcessProperties(), properties);
            defaultVal = GraphCodecUtils.handlSpecialValue((IValueContext)valueContext, (Object)defaultVal);
        }
        catch (Exception e) {
            this.log.error(String.format("get %s defaultValue failed! %s", property.getPropertyName(), WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return defaultVal;
    }

    protected void beginInit() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String parentFormId = parameter.getParentFormId();
        if (this.getDesignerFormId().equals(parentFormId)) {
            this.beginOpenPage(parameter.getFormId(), parameter.getPageId(), parentFormId);
        }
    }

    protected void initNodeTemplate(JSONObject props) {
        if (this.getView().getControl(TEMPLATENAME) == null) {
            return;
        }
        if ("BizFlowModel".equals(this.modelType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TEMPLATENAME});
            return;
        }
        String value = (String)this.getModel().getValue(TEMPLATENAME);
        if (WfUtils.isNotEmpty((String)value)) {
            return;
        }
        QFilter filter = null;
        Long templateId = props.getLong("templateId");
        if (WfUtils.isNotEmpty((Long)templateId)) {
            filter = new QFilter("id", "=", (Object)templateId);
        } else {
            String templateNumber = props.getString("template");
            if (WfUtils.isNotEmpty((String)templateNumber)) {
                filter = new QFilter("number", "=", (Object)templateNumber);
            }
        }
        if (filter == null) {
            return;
        }
        List templates = this.getRepositoryService().findEntitiesByFilters("wf_nodetemplate", new QFilter[]{filter}, "name", null);
        if (!templates.isEmpty()) {
            this.getModel().setValue(TEMPLATENAME, (Object)((NodeTemplateEntity)templates.get(0)).getName());
        }
    }

    protected String getDynamicPlugin(String formId) {
        Map pluginMap = (Map)this.getView().getFormShowParameter().getCustomParam("dynamic_config_plugin");
        if (pluginMap != null) {
            return (String)pluginMap.get(formId);
        }
        return null;
    }

    protected String getDesignerFormId() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("designer_formId");
        return formId != null ? formId : "ide_workflowdesigner";
    }

    protected String getScene() {
        String formId = this.getDesignerFormId();
        if ("wf_processconfig_scheme".equals(formId) || "wf_advancedprop_setting".equals(formId)) {
            return "management";
        }
        return "designer";
    }

    protected boolean propertyIsHide(String property) {
        return DesignerModelUtil.isPropertyNeedHide(this.modelType, this.stencilType, property, this.getScene());
    }

    protected void changeNodeType(String itemId, IFormView view, String newType) {
        GraphCell cell = this.graphModel.getGraphCell(itemId);
        String style = cell.getStyle();
        String newStyle = style.replaceFirst("(ierp\\.bpmn\\.)\\w+;", String.format("$1%s;", newType));
        cell.setStyle(newStyle);
        this.stencilType = newType;
        cell.getStencil().setId(this.stencilType);
        this.idePlugin.changeStyle(itemId, view, newStyle);
        this.updateModelInCache();
    }

    protected void initComplete(Class<? extends AbstractWorkflowConfigurePlugin> plugin) {
        if (plugin == null || plugin.equals(((Object)((Object)this)).getClass())) {
            this.endOpenPage(this.getView().getFormShowParameter().getFormId(), this.getView().getFormShowParameter().getPageId());
        }
    }

    public void click(EventObject evt) {
        String key;
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "shrink": {
                this.idePlugin.shrinkConfigurePanel(this.getView());
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int rowIndex = changeData[0].getRowIndex();
        this.propertyChanged(propName, newValue, oldValue, rowIndex);
    }

    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (this.isExclusiveProperty(propName) || this.isEntryShowField(propName) || !this.isHandledProperty(propName)) {
            if ("sv_outmsg_rule".equals(propName) && WfUtils.isEmpty((String)((String)newValue))) {
                this.getModel().setValue("outmsg_rule", newValue, rowIndex);
                this.getModel().endInit();
            }
            return;
        }
        if ("expiretime".equals(propName)) {
            this.log.debug("\u9700\u8981\u53d8\u66f4\u7684\u503c\u4e3a" + newValue + "\u65e7\u503c" + oldValue);
        }
        if (propName.indexOf(95) > 1) {
            this.setGridProperty(propName, newValue, rowIndex);
        } else {
            this.setProperty(propName, newValue);
        }
    }

    protected void addButtonClickListener(TextEdit ... edits) {
        for (TextEdit edit : edits) {
            if (edit == null) {
                return;
            }
            edit.addButtonClickListener((ClickListener)this);
        }
    }

    protected void setProperty(String name, Object value) {
        this.setPropertyOnly(name, value);
        IPageCache idePageCache = (IPageCache)this.ideFormView.getService(IPageCache.class);
        idePageCache.put("data_changed", "true");
        String path = this.getPropPath(name);
        this.delInitedProp(path);
    }

    protected void setPropertyOnly(String name, Object value) {
        this.graphModel.setProperty(this.itemId, this.stencilType, name, value);
        this.afterSetProperty(name, value);
        String path = this.getPropPath(name);
        this.recordInitedProp(path);
    }

    private String getPropPath(String prop) {
        StencilProperty property = DesignerModelUtil.getConfigProperty(this.modelType, this.stencilType, prop);
        String groupId = null;
        String propertyName = null;
        if (property != null) {
            groupId = property.getGroupId();
            propertyName = property.getPropertyName();
        }
        return DesignerModelUtil.getPropertyPath(groupId, propertyName);
    }

    private void recordInitedProp(String path) {
        HashSet<String> paths = new HashSet<String>();
        paths.add(path);
        this.recordInitedProps(paths);
    }

    private void recordInitedProps(Set<String> paths) {
        IPageCache idePageCache = (IPageCache)this.ideFormView.getService(IPageCache.class);
        String initedPropertiesStr = idePageCache.get("initialized_property");
        if (WfUtils.isEmpty((String)initedPropertiesStr)) {
            initedPropertiesStr = SerializationUtils.toJsonString(paths);
            idePageCache.put("initialized_property", initedPropertiesStr);
        } else {
            Set initedPropsSet = (Set)SerializationUtils.fromJsonString((String)initedPropertiesStr, Set.class);
            initedPropsSet.addAll(paths);
            initedPropertiesStr = SerializationUtils.toJsonString((Object)initedPropsSet);
            idePageCache.put("initialized_property", initedPropertiesStr);
        }
    }

    private void delInitedProp(String path) {
        IPageCache idePageCache = (IPageCache)this.ideFormView.getService(IPageCache.class);
        String initedPropertiesStr = idePageCache.get("initialized_property");
        if (WfUtils.isNotEmpty((String)initedPropertiesStr)) {
            Set initedPropsSet = (Set)SerializationUtils.fromJsonString((String)initedPropertiesStr, Set.class);
            initedPropsSet.remove(path);
            initedPropertiesStr = SerializationUtils.toJsonString((Object)initedPropsSet);
            idePageCache.put("initialized_property", initedPropertiesStr);
        }
    }

    protected void afterSetProperty(String name, Object value) {
        this.updateModelInCache();
        this.updateCellNameForPage(name, value);
    }

    protected void updateCellNameForPage(String name, Object value) {
        if ("name".equals(name)) {
            this.idePlugin.updateCellName(this.itemId, this.getCurrentView(), (String)value);
        }
    }

    protected void setProperty(JSONObject properties, String name, Object value) {
        if (this.stencilType == null) {
            return;
        }
        this.graphModel.setProperty(this.itemId, this.stencilType, name, value, properties);
        this.afterSetProperty(name, value);
        String path = this.getPropPath(name);
        this.recordInitedProp(path);
    }

    protected Object getProperty(String name) {
        if (this.stencilType == null) {
            return null;
        }
        return this.graphModel.getProperty(this.itemId, this.stencilType, name);
    }

    protected IFormView getCurrentView() {
        return this.getView();
    }

    protected void setProperties(Object ... pairs) {
        this.graphModel.setProperties(this.itemId, this.stencilType, pairs);
        this.updateModelInCache();
    }

    protected void setProperties(JSONObject properties, Object ... pairs) {
        this.graphModel.setProperties(this.itemId, this.stencilType, properties, pairs);
        this.updateModelInCache();
    }

    protected void updateModelInCache() {
        this.idePlugin.cacheModelJson(this.graphModel.getBpmnModelJson());
    }

    private void updatePageCount(boolean increment) {
        this.idePlugin.updatePageCount(increment, this.getView());
    }

    protected void deleteProperty(String property) {
        this.graphModel.deleteProperty(this.itemId, this.stencilType, property);
        this.updateModelInCache();
    }

    protected void deleteProperties(String ... properties) {
        this.graphModel.deleteProperties(this.itemId, this.stencilType, properties);
        this.updateModelInCache();
    }

    private IFormView getWorkflowDesignerView(IFormView view) {
        IFormView parentView = view;
        while ((parentView = parentView.getParentView()) != null) {
            if (!this.getDesignerFormId().equals(parentView.getFormShowParameter().getFormId())) continue;
            return parentView;
        }
        return null;
    }

    protected IFormView getRootConfigView(IFormView view) {
        IFormView parentView = view;
        do {
            if (!this.getDesignerFormId().equals(parentView.getFormShowParameter().getParentFormId())) continue;
            return parentView;
        } while ((parentView = parentView.getParentView()) != null);
        return null;
    }

    protected AbstractWorkflowConfigPlugin getWorkflowDesignerPlugin() {
        return this.idePlugin;
    }

    protected void addExclusiveProperty(String ... propNames) {
        if (propNames == null) {
            return;
        }
        HashMap<String, String> excludeNameMap = new HashMap<String, String>(propNames.length);
        for (String propName : propNames) {
            excludeNameMap.put("excludeNames_" + propName.toLowerCase(), propName);
        }
        this.getPageCache().put(excludeNameMap);
    }

    protected void addHandleProperties(String ... propNames) {
        this.properties.addAll(Arrays.asList(propNames));
    }

    protected boolean isHandledProperty(String propertyName) {
        return this.properties.isEmpty() || !this.properties.isEmpty() && this.properties.contains(propertyName);
    }

    protected boolean isExclusiveProperty(String propName) {
        String key = "excludeNames_" + propName.toLowerCase();
        return this.getPageCache().get(key) != null;
    }

    protected IFormView getIdeFormView() {
        return this.ideFormView;
    }

    protected String getIdeViewPageCacheData(String key) {
        IPageCache pageCache = (IPageCache)this.getIdeFormView().getService(IPageCache.class);
        return pageCache.get(key);
    }

    public void updateStencilAndItemId(String stencilType, String itemId) {
        this.stencilType = stencilType;
        this.itemId = itemId;
    }

    protected void beginOpenPage(String formId, String pageId, String parentFormId) {
        if (this.itemId == null) {
            return;
        }
        this.log.debug(String.format("[%s\u8282\u70b9] %s --open-> %s[%s]  [time:%s]", this.itemId, parentFormId, formId, pageId, System.currentTimeMillis()));
        this.updatePageCount(true);
    }

    private void endOpenPage(String formId, String pageId) {
        if (this.itemId == null) {
            return;
        }
        this.log.debug(String.format("[%s\u8282\u70b9] %s[%s] finished!  [time:%s]", this.itemId, formId, pageId, System.currentTimeMillis()));
        this.updatePageCount(false);
    }

    protected String getCacheKey(IFormView view, String openFormId) {
        return this.getCacheKey(view, openFormId, "");
    }

    protected String getCacheKey(IFormView view, String openFormId, String suffix) {
        return String.format("%s_%s_%s", view.getPageId(), openFormId, suffix);
    }

    protected JSONObject getCellProperties() {
        Map<String, Object> properties = this.graphModel.getCellProperties(this.itemId);
        return (JSONObject)JSON.toJSON(properties);
    }

    protected boolean isModelInitialized() {
        return this.graphModel != null;
    }

    protected GraphCell getGraphCell() {
        return this.graphModel.getGraphCell(this.itemId);
    }

    protected GraphCell getGraphCell(String itemId) {
        return this.graphModel.getGraphCell(itemId);
    }

    protected JSONObject getProcessProperties() {
        Map<String, Object> properties = this.graphModel.getCellProperties("node_1");
        return (JSONObject)JSON.toJSON(properties);
    }

    protected String getModelJsonString() {
        return this.graphModel.getBpmnModelJson();
    }

    protected void showErrorMessage(String msg, Exception ex) {
        this.getIdeFormView().showErrorNotification(msg);
        this.getView().sendFormAction(this.getIdeFormView());
        if (ex != null) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)ex));
        }
    }

    protected void showInitErrorMessage(Exception ex) {
        String msg = null;
        String number = null;
        JSONObject properties = this.getCellProperties();
        if ("SequenceFlow".equals(this.stencilType)) {
            if (properties != null) {
                number = properties.getString("number");
            }
            msg = String.format(WFMultiLangConstants.getSequenceFlowConfigInitErrorTip(), number != null ? number : this.itemId);
        } else {
            String name = "";
            if (properties != null) {
                name = properties.getString("name");
                number = properties.getString("number");
            }
            msg = String.format(WFMultiLangConstants.getNodePropConfigInitErrorTip(), name, number != null ? number : this.itemId);
        }
        this.showErrorMessage(msg, ex);
    }

    protected void showOperationPage(JSONObject properties, FormShowParameter parameter, Boolean showSelChexkbox, String selectValues, String closeCallBackKey) {
        String formKey = null;
        String entityId = null;
        formKey = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "billSetting.formKey");
        entityId = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "entityId");
        Map params = BillPagePluginUtil.getParamstersOperation((Object)formKey, (Object)entityId, (FormShowParameter)parameter, (Boolean)showSelChexkbox, (String)selectValues);
        if (!"optionalopers".equals(closeCallBackKey)) {
            params.put("optionalActions", ProcTemplatePluginUtil.getOptionalOperationNumbers((Map<String, Object>)properties));
        }
        FormShowParameter parameters = this.getShowParameter(closeCallBackKey, "wf_formoperation", "", params);
        parameter.setShowTitle(true);
        this.showForm(parameters);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.afterOperateRow(e.getEntryProp());
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.afterOperateRow(e.getEntryProp());
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        this.afterOperateRow(e.getEntryProp());
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        this.afterOperateRow(e.getEntryProp());
    }

    protected void afterOperateRow(EntryProp entryProp) {
        String propName = entryProp.getName();
        if (this.isExclusiveProperty(propName)) {
            return;
        }
        this.setGridPropertyValue(propName);
    }

    protected void setGridPropertyValue(String gridKey) {
        if (!this.isHandledProperty(gridKey)) {
            this.log.debug(String.format("\u8be5\u5c5e\u6027[%s]\u4e0d\u7531\u6b64\u63d2\u4ef6[%s]\u5904\u7406", gridKey, ((Object)((Object)this)).getClass().getName()));
            return;
        }
        EntryGrid grid = (EntryGrid)this.getControl(gridKey);
        this.setProperty(gridKey, this.getEntryGridValue(grid));
        if ("inmsg".equals(gridKey) || "outmsg".equals(gridKey)) {
            this.log.debug(String.format("setGridPropertyValue\uff0c\u8bbe\u7f6e\u5206\u5f55propertyValue\u3002gridKey[%s]\uff0cValue[%s]", gridKey, this.getEntryGridValue(grid)));
        }
    }

    protected JSONArray getEntryGridValue(EntryGrid grid) {
        String gridKey = grid.getKey();
        int rowCount = this.getModel().getEntryRowCount(gridKey);
        DynamicObject[] collection = this.getModel().getEntryEntity(gridKey, 0, rowCount);
        JSONArray rowVals = new JSONArray();
        String name = null;
        for (DynamicObject dynObj : collection) {
            JSONObject rowVal = new JSONObject();
            for (Control ctrl : grid.getItems()) {
                name = ctrl.getKey();
                if (this.isEntryShowField(name)) continue;
                rowVal.put(this.getEntryFieldJSONKey(gridKey, name, false), this.getGridCellVal(name, dynObj));
            }
            rowVals.add((Object)rowVal);
        }
        return rowVals;
    }

    protected boolean isEntryShowField(String fieldKey) {
        return fieldKey.startsWith("sv_");
    }

    protected String getEntryFieldJSONKey(String gridKey, String ctrlKey, boolean isShowValue) {
        if (!isShowValue) {
            return ctrlKey.replace(String.format("%s%s", gridKey, Character.valueOf('_')), "");
        }
        return ctrlKey.replace(String.format("%s%s%s", "sv_", gridKey, Character.valueOf('_')), "");
    }

    protected Object getGridCellVal(String name, DynamicObject dynObj) {
        return dynObj.get(name);
    }

    protected void initEntryGridValue(EntryGrid grid, JSONArray array) {
        int size = 0;
        if (array == null || (size = array.size()) < 1) {
            return;
        }
        IDataModel model = this.getModel();
        JSONObject obj = null;
        String ctrlKey = null;
        int rows = this.getModel().getEntryRowCount(grid.getKey());
        model.batchCreateNewEntryRow(grid.getKey(), size);
        for (int i = 0; i < size; ++i) {
            int index = i + rows;
            obj = array.getJSONObject(i);
            for (Control ctrl : grid.getItems()) {
                ctrlKey = ctrl.getKey();
                if (this.isEntryShowField(ctrlKey)) {
                    Object titleObj;
                    Object contentObj;
                    String key = this.getEntryFieldJSONKey(grid.getKey(), ctrlKey, true);
                    Object data = null;
                    data = SV_INENTRY_CONTENT.equals(ctrlKey) || SV_OUTENTRY_CONTENT.equals(ctrlKey) ? (WfUtils.isJSONObject((Object)(contentObj = obj.get((Object)"content"))) ? MessageUtils.handleData((JSONObject)JSONObject.parseObject((String)((String)contentObj))) : this.getEntryFieldShowValue(key, obj, grid)) : (SV_INENTRY_NOTIFYSUBJECT.equals(ctrlKey) || SV_OUTENTRY_NOTIFYSUBJECT.equals(ctrlKey) ? (WfUtils.isJSONObject((Object)(titleObj = obj.get((Object)"notifysubject"))) ? MessageUtils.handleData((JSONObject)JSONObject.parseObject((String)((String)titleObj))) : this.getEntryFieldShowValue(key, obj, grid)) : this.getEntryFieldShowValue(key, obj, grid));
                    model.setValue(ctrlKey, data, index);
                } else {
                    Object fieldValue = this.getEntryFieldValue(grid, obj, ctrlKey);
                    model.setValue(ctrlKey, fieldValue, index);
                }
                this.setEntryFieldEnableOrVisiable(grid.getKey(), ctrlKey, obj, index);
                if (!"taskGroupBy".equals(obj.getString("name")) || !"variables_type".equals(ctrlKey)) continue;
                ((ComboEdit)ctrl).setEnable("", Boolean.FALSE.booleanValue(), index);
            }
        }
    }

    protected Object getEntryFieldValue(EntryGrid grid, JSONObject obj, String ctrlKey) {
        return DesignerModelUtil.getProperty((Map<String, Object>)obj, this.getEntryFieldJSONKey(grid.getKey(), ctrlKey, false));
    }

    protected void setEntryFieldEnableOrVisiable(String key, String ctrlKey, JSONObject obj, int i) {
    }

    protected Object getEntryFieldShowValue(String property, JSONObject data, EntryGrid grid) {
        Object value = data.get((Object)property);
        return this.getEntryFieldShowValue(property, value);
    }

    protected Object getEntryFieldShowValue(String property, Object value) {
        return value;
    }

    protected void setEntryFieldShowValue(EntryGrid grid, String key, Object newValue, int rowIndex) {
        for (Control control : grid.getItems()) {
            String showField = this.getEntryShowFieldKey(grid.getKey(), key);
            if (!showField.equals(control.getKey())) continue;
            Object showValue = this.getEntryFieldShowValue(key, newValue);
            if ("sv_inmsg_rule".equals(showField) || "sv_outmsg_rule".equals(showField)) {
                this.log.debug(String.format("sv_inmsg_rule\u6216sv_outmsg_ruled\u7684key[%s],newValue[%s]", key, newValue));
                this.log.debug(String.format("sv_inmsg_rule\u6216sv_outmsg_ruled\u7684showValue[%s]", showValue));
            }
            this.getModel().setValue(showField, showValue, rowIndex);
            break;
        }
    }

    protected String getModelType() {
        return this.modelType;
    }

    protected String getEntryShowFieldKey(String gridKey, String field) {
        return String.format("%s%s%s%s", "sv_", gridKey, Character.valueOf('_'), field);
    }

    protected void setGridProperty(String propName, Object newValue, int rowIndex) {
        String[] names = propName.split(String.valueOf('_'));
        String gridKey = names[0];
        String key = names[1];
        Control control = this.getControl(gridKey);
        if (control instanceof EntryGrid) {
            EntryGrid grid = (EntryGrid)control;
            this.log.debug(String.format("setEntryFieldShowValue\uff0c\u8bbe\u7f6e\u5206\u5f55\u503c\u3002key[%s]\uff0cnewValue[%s]\uff0crowIndex[%s]", key, newValue, rowIndex));
            this.setEntryFieldShowValue(grid, key, newValue, rowIndex);
            this.setGridPropertyValue(grid.getKey());
        }
    }

    protected String getEntryFieldKey(String gridKey, String field) {
        return String.format("%s%s%s", gridKey, Character.valueOf('_'), field);
    }

    protected void clearConfigurePageCache(String stencilType) {
        this.idePlugin.clearNodeConfigPageCache(stencilType);
    }

    protected String showFormInTabContainer(String formId, String container) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("model_type", this.modelType);
        params.put("stencil_type", this.stencilType);
        params.put("itemId", this.itemId);
        params.put("designer_formId", this.getDesignerFormId());
        params.put("dynamic_config_plugin", this.getDynamicPlugin(formId));
        return this.showFormInContainer(formId, container, params);
    }

    protected int getEntryEntityFocusRow(String entryEntityName) {
        EntryGrid grid = (EntryGrid)this.getControl(entryEntityName);
        return grid.getEntryState().getFocusRow();
    }

    protected void initBizFlowProperties(String entityNumber, JSONObject properties) {
        if ("BillTask".equals(this.stencilType) || "CallActivity".equals(this.stencilType) || "UserTask".equals(this.stencilType)) {
            String processingPageValue = properties.getString(FLOATLAYERBILLSUMMARY);
            ComboEdit floatlayersummary = (ComboEdit)this.getControl(FLOATLAYERBILLSUMMARY);
            List<ComboItem> floatLayerComboItems = BillSummaryUtil.getBillSummaryComboItems(entityNumber, BillSummaryType.floatlayerSummary.name());
            floatlayersummary.setComboItems(floatLayerComboItems);
            if (CollectionUtil.isNotEmpty(floatLayerComboItems) && WfUtils.isEmpty((String)processingPageValue)) {
                this.getView().getModel().setValue(FLOATLAYERBILLSUMMARY, (Object)floatLayerComboItems.get(0).getValue());
                this.setProperty(properties, FLOATLAYERBILLSUMMARY, floatLayerComboItems.get(0).getValue());
            }
            ComboEdit bizFlowBillSummary = (ComboEdit)this.getControl(BIZFLOWBILLSUMMARY);
            List<ComboItem> comboItems = BillSummaryUtil.getBillSummaryComboItems(entityNumber, BillSummaryType.flowchartSummary.name());
            bizFlowBillSummary.setComboItems(comboItems);
        }
    }

    protected GraphCell getRootCell() {
        return this.graphModel.getRootCell();
    }

    protected Object getDefaultValueByName(JSONObject properties, String name) {
        StencilConfig config = this.getStencilConfig();
        Map<String, StencilProperty> propertiesMap = config.getPropertiesMap();
        StencilProperty property = propertiesMap.get(name);
        Map isvPropsConfig = ModelConfigUtil.getISVModelPropertiesConfig((String)config.getId());
        return this.getDefaultValue(properties, property, isvPropsConfig);
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }
}

