/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.component.WorkflowDesigner;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigPlugin;
import kd.bos.workflow.design.plugin.IWorkflowDesigner;
import kd.bos.workflow.design.plugin.event.AfterCheckDigramEvent;
import kd.bos.workflow.design.plugin.event.AfterPublishDigramEvent;
import kd.bos.workflow.design.plugin.event.AfterSaveDigramEvent;
import kd.bos.workflow.design.plugin.model.Directive;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPasteUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.validation.ValidationError;

public abstract class AbstractWorkflowDesignerPlugin
extends AbstractWorkflowConfigPlugin
implements IWorkflowDesigner {
    protected static final char SYMBOL_SPLIT = ';';
    protected static final String CONFIGURE = "configure";
    protected static final String CURRENT_NODE = "currentNode";
    protected static final String DRAW_MODE = "draw";
    protected static final String CONFIRM_CLOSE = "close";
    protected static final String PANEL_RIGHTPANEL = "rightpanel";
    protected static final String WORKFLOWDESIGNER = "workflowdesigner";
    protected static final String ALLTYPE = "allType";

    @Override
    protected void initGraphModel(String modelJson) {
        if (modelJson != null) {
            this.getDesigner().initGraphModel(this.modelType, modelJson);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    protected WorkflowDesigner getDesigner() {
        WorkflowDesigner designer = (WorkflowDesigner)this.getView().getControl(WORKFLOWDESIGNER);
        return designer;
    }

    protected void showProcessConfigure() {
        this.getDesigner().selectProcess(this.getView());
    }

    protected void showNodeConfigure(String itemId) {
        this.getDesigner().selectNode(this.getView(), itemId);
    }

    protected String showNodeConfigure(String formId, String targetKey, String itemId, String type, String nodeTplNumber) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("stencil_type", type);
        params.put("designer_formId", this.getDesignerFormId());
        params.put("model_type", this.modelType);
        params.put("node_template_number", nodeTplNumber);
        FormShowParameter parameter = this.getShowFormInContainerParameter(formId, targetKey, params);
        this.initNodeConfigureShowParameter(parameter, formId);
        this.showForm(parameter);
        String pageId = parameter.getPageId();
        this.getPageCache().put(type, String.format("%s%s%s", pageId, Character.valueOf(';'), itemId));
        return pageId;
    }

    protected void initNodeConfigureShowParameter(FormShowParameter parameter, String formId) {
    }

    @Override
    public GraphModel getGraphModel() {
        return this.getDesigner().getGraphModel();
    }

    protected abstract String getDesignerFormId();

    protected String getInitGraphXml(Long modelId, Long procDefId, Long schemeId, String modelJson, GraphCodecContext context) {
        String newModelJson = this.dynamicUpdateGraphModel(modelId, procDefId, schemeId, modelJson);
        this.cacheModelJson(newModelJson);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((String)newModelJson);
        if (context == null) {
            return GraphCodecUtils.convertBpmnModelToXML((BpmnModel)bpmnModel);
        }
        return GraphCodecUtils.convertBpmnModelToXML((BpmnModel)bpmnModel, (GraphCodecContext)context);
    }

    private String dynamicUpdateGraphModel(Long modelId, Long procDefId, Long schemeId, String modelJson) {
        QFilter filter1 = null;
        QFilter filter2 = new QFilter("type", "=", (Object)"person");
        QFilter filter3 = null;
        if (!WfUtils.isEmpty((Long)modelId)) {
            filter1 = new QFilter("modelid", "=", (Object)modelId);
        } else {
            filter1 = new QFilter("procdefId", "=", (Object)procDefId);
            if (!WfUtils.isEmpty((Long)schemeId)) {
                filter3 = new QFilter("schemeId", "=", (Object)schemeId);
            }
        }
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        List participantModels = this.getRepositoryService().findEntitiesByFilters("wf_participantmodel", filters);
        if (participantModels == null || participantModels.isEmpty()) {
            return modelJson;
        }
        GraphModel graphModel = new GraphModel(this.modelType, modelJson);
        for (ParticipantModelEntity participantModel : participantModels) {
            String property;
            String itemId = participantModel.getTaskActivityId();
            GraphCell graphCell = graphModel.getGraphCell(itemId);
            String stencilType = "";
            if (graphCell != null) {
                stencilType = graphCell.getStencil().getId();
            }
            String participantModelValue = participantModel.getValue();
            Long modelJsonPartId = participantModel.getModelJsonPartId();
            switch (property = participantModel.getProperty()) {
                case "participant": {
                    this.updateParticipants(graphModel, itemId, stencilType, "participant", participantModelValue, modelJsonPartId);
                    break;
                }
                case "allowlistor": {
                    this.updateParticipants(graphModel, itemId, stencilType, "participantAllow", participantModelValue, modelJsonPartId);
                    break;
                }
                case "blacklistor": {
                    this.updateParticipants(graphModel, itemId, stencilType, "participantBlackList", participantModelValue, modelJsonPartId);
                    break;
                }
                case "circulator": {
                    this.updateCirculatorCoordinator(graphModel, itemId, stencilType, "circulate", participantModelValue, modelJsonPartId);
                    break;
                }
                case "coordinator": {
                    this.updateCirculatorCoordinator(graphModel, itemId, stencilType, "autoCoordinate", participantModelValue, modelJsonPartId);
                    break;
                }
                case "inMsg.receiver": {
                    this.updateMsgReceiver(graphModel, itemId, stencilType, participantModelValue, "inMsg", modelJsonPartId);
                    break;
                }
                case "outMsg.receiver": {
                    this.updateMsgReceiver(graphModel, itemId, stencilType, participantModelValue, "outMsg", modelJsonPartId);
                    break;
                }
            }
        }
        return graphModel.getBpmnModelJson();
    }

    private void updateParticipants(GraphModel graphModel, String itemId, String stencilType, String propName, String participantModelValue, Long modelJsonPartId) {
        Object participantObject = graphModel.getProperty(itemId, stencilType, propName);
        if (participantObject instanceof List) {
            List<Map<String, Object>> participants = this.updateGraphModelParticipantValue(participantObject, modelJsonPartId, participantModelValue);
            graphModel.setProperty(itemId, stencilType, propName, participants);
        }
    }

    private void updateCirculatorCoordinator(GraphModel graphModel, String itemId, String stencilType, String propName, String participantModelValue, Long modelJsonPartId) {
        Object coordinateObject = graphModel.getProperty(itemId, stencilType, propName);
        if (coordinateObject instanceof Map) {
            Map coordinate = (Map)coordinateObject;
            Object coordinatorObject = coordinate.get("participant");
            if (coordinatorObject instanceof List) {
                this.updateGraphModelParticipantValue(coordinatorObject, modelJsonPartId, participantModelValue);
            }
            graphModel.setProperty(itemId, stencilType, propName, coordinate);
        }
    }

    private void updateMsgReceiver(GraphModel graphModel, String itemId, String stencilType, String participantModelValue, String propName, Long modelJsonPartId) {
        Object inMsgObject = graphModel.getProperty(itemId, stencilType, propName);
        if (inMsgObject instanceof List) {
            List inMsgs = (List)inMsgObject;
            for (Map inMsg : inMsgs) {
                Object inMsgReceiverObject = inMsg.get("receiver");
                if (!(inMsgReceiverObject instanceof List)) continue;
                this.updateGraphModelParticipantValue(inMsgReceiverObject, modelJsonPartId, participantModelValue);
            }
            graphModel.setProperty(itemId, stencilType, propName, inMsgs);
        }
    }

    private List<Map<String, Object>> updateGraphModelParticipantValue(Object participantObject, Long modelJsonPartId, String participantModelValue) {
        List participants = (List)participantObject;
        for (Map participant : participants) {
            if (!WfUtils.getLongValueFromObj(participant.get("id")).equals(modelJsonPartId) || participant.get("value").equals(participantModelValue)) continue;
            participant.put("value", participantModelValue);
        }
        return participants;
    }

    protected String getConfigurePanelId(String stencilType) {
        return String.format("%s_%s", stencilType.toLowerCase(), CONFIGURE);
    }

    @Override
    public void afterRemoveCells(List<GraphCell> cells) {
        this.cacheModelJson();
        this.setDataChanged();
    }

    @Override
    public void afterInsertCells(GraphCell cell) {
        this.setCellTemplateId(cell);
        this.cacheModelJson();
        this.setDataChanged();
    }

    protected void setCellTemplateId(GraphCell cell) {
        if (cell == null) {
            return;
        }
        Map props = cell.getProperties();
        GraphCell modelCell = this.getGraphModel().getGraphCell(cell.getResourceId());
        if (modelCell != null) {
            props = modelCell.getProperties();
        }
        String templateNumber = (String)DesignerModelUtil.getProperty(props, "template");
        Long templateId = (Long)DesignerModelUtil.getProperty(props, "templateId");
        if (WfUtils.isEmpty((Long)templateId) && WfUtils.isNotEmpty((String)templateNumber)) {
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)templateNumber)};
            List templates = this.getRepositoryService().findEntitiesByFilters("wf_nodetemplate", filters, "id", null);
            if (!templates.isEmpty()) {
                NodeTemplateEntity template = (NodeTemplateEntity)templates.get(0);
                DesignerModelUtil.setProperty(props, "templateId", template.getId());
            }
        }
    }

    @Override
    public void afterInsertCells(GraphCell edge, String sourceId, GraphCell target, String type) {
        this.setCellTemplateId(target);
        this.cacheModelJson();
        this.setDataChanged();
    }

    @Override
    public void connect(GraphCell edge, String sourceId, String targetId) {
        this.cacheModelJson();
        this.setDataChanged();
    }

    @Override
    public void afterSplitEdge(GraphCell edge, GraphCell newEdge) {
        this.cacheModelJson();
        this.setDataChanged();
    }

    @Override
    public void beforePasteCells(List<GraphCell> cells) {
        try {
            GraphModel graphModel = this.getGraphModel();
            String entraBillId = (String)graphModel.getRootCellProperty("entraBillId");
            String tip = DesignerPasteUtil.pasteValidate(cells, entraBillId, this.getView());
            if (tip == null) {
                this.getDesigner().pasteUICells(this.getView());
            } else {
                this.getView().showErrorNotification(tip);
            }
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"AbstractWorkflowDesignerPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    @Override
    public void afterPasteCells(List<GraphCell> cells) {
        GraphModel graphModel = this.getGraphModel();
        String result = graphModel.cloneAndAddCells(cells, this.getView());
        this.cacheModelJson(graphModel.getBpmnModelJson());
        if (result != null) {
            this.getView().showTipNotification(result);
        }
        this.setDataChanged();
    }

    @Override
    public void afterParentChanged(String parentId, Map<String, String> changed) {
        this.cacheModelJson(this.getGraphModel().getBpmnModelJson());
    }

    @Override
    public void change(String type, String itemId, Map<String, Object> params) {
        String drawMode = this.getPageCache().get(DRAW_MODE);
        if ("true".equals(drawMode)) {
            this.showBlock(false, this.getView());
            return;
        }
        StencilConfig config = DesignerModelUtil.getStencilConfig(this.modelType, type);
        String targetKey = this.getConfigurePanelId(type);
        this.log.debug(String.format("--designer->change--: \u4e0a\u6b21\u6253\u5f00\u7684\u8282\u70b9\u662f %s\uff0c\u672c\u6b21\u662f %s[%s]\uff0cPanel: %s", this.getPageCache().get(CURRENT_NODE), itemId, type, targetKey));
        HashSet<String> newTypes = new HashSet<String>();
        newTypes.add(type);
        this.addNodeConfigurePanelIfNecessary(newTypes);
        this.hideCurrentConfigurePanel();
        this.getView().setVisible(Boolean.TRUE, new String[]{targetKey});
        String data = this.getPageCache().get(type);
        String pageId = null;
        String nodeId = null;
        if (data != null) {
            String[] datas = data.split(String.valueOf(';'));
            pageId = datas[0];
            nodeId = datas[1];
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{PANEL_RIGHTPANEL});
        String nodeTplNumber = (String)params.get("template");
        if (pageId == null || this.getView().getView(pageId) == null) {
            this.showNodeConfigure(config.getFormId(), targetKey, itemId, type, nodeTplNumber);
            this.log.debug(String.format("--designer->change--: \u91cd\u65b0\u6253\u5f00\u9875\u9762 %s [%s]", config.getFormId(), targetKey));
        } else if (this.isNodeChanged(type, itemId, nodeId)) {
            this.showNodeConfigure(config.getFormId(), targetKey, itemId, type, nodeTplNumber);
            this.log.debug(String.format("--designer->change--: \u8282\u70b9\u6539\u53d8\uff0c\u91cd\u65b0\u6253\u5f00\u9875\u9762 %s [%s]", config.getFormId(), targetKey));
        } else {
            this.showBlock(false, this.getView());
            this.log.debug("--designer->change--: \u672a\u53d1\u751f\u53d8\u5316\uff0c\u53ea\u9690\u85cf\u963b\u585e\u5c42");
        }
        this.getPageCache().put(CURRENT_NODE, type);
        this.selectionCellId = itemId;
        this.selectionCellType = type;
        JSONObject value = new JSONObject();
        value.put("type", (Object)type);
        value.put("id", (Object)itemId);
        this.getPageCache().put("selection_cell", JSON.toJSONString((Object)value));
    }

    protected boolean isNodeChanged(String type, String itemId, String nodeId) {
        return !"Diagram".equals(type) && !itemId.equals(nodeId);
    }

    protected void addNodeConfigurePanelIfNecessary(Set<String> newTypes) {
        Set types;
        Sets.SetView ts;
        String alltype = this.getPageCache().get(ALLTYPE);
        if (WfUtils.isNotEmpty((String)alltype) && !(ts = Sets.difference(newTypes, (Set)(types = (Set)SerializationUtils.fromJsonString((String)alltype, Set.class)))).isEmpty()) {
            ArrayList<Map> controls = new ArrayList<Map>(ts.size());
            HashSet<String> panelIds = new HashSet<String>(ts.size());
            for (String type : ts) {
                FlexPanelAp panel = this.getConfigureFlexPanel(type);
                controls.add(panel.createControl());
                panelIds.add(this.getConfigurePanelId(type));
            }
            Container container = (Container)this.getControl(PANEL_RIGHTPANEL);
            container.addControls(controls);
            this.getView().setVisible(Boolean.FALSE, panelIds.toArray(new String[0]));
            newTypes.addAll(types);
            this.getPageCache().put(ALLTYPE, SerializationUtils.toJsonString(newTypes));
        }
    }

    protected FlexPanelAp getConfigureFlexPanel(String type) {
        FlexPanelAp panel = new FlexPanelAp();
        panel.setKey(this.getConfigurePanelId(type));
        panel.setAlignItems("stretch");
        panel.setAlignSelf("stretch");
        panel.setGrow(1);
        panel.setWrap(true);
        panel.setHeight(new LocaleString("100%"));
        return panel;
    }

    protected void setLocaleProperties(Map<String, Object> obj, String ... args) {
        String zhCN = null;
        String zhTW = null;
        String en = null;
        switch (args.length) {
            case 1: {
                zhTW = en = args[0];
                zhCN = en;
                break;
            }
            case 2: {
                zhCN = en = args[0];
                zhTW = args[1];
                break;
            }
            case 3: {
                zhCN = args[0];
                zhTW = args[1];
                en = args[2];
                break;
            }
        }
        obj.put(Locale.SIMPLIFIED_CHINESE.toString(), zhCN);
        obj.put(Locale.TRADITIONAL_CHINESE.toString(), zhTW);
        obj.put(Locale.ENGLISH.toString(), en);
    }

    protected JSONObject getConfigureFlexJSON(String type) {
        JSONObject panel = new JSONObject();
        panel.put("type", (Object)"flexpanel");
        panel.put("ai", (Object)"stretch");
        panel.put("as", (Object)"stretch");
        panel.put("vi", (Object)55);
        panel.put("id", (Object)this.getConfigurePanelId(type));
        panel.put("wr", (Object)Boolean.TRUE);
        panel.put("gr", (Object)1);
        JSONObject height = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)height, "100%");
        panel.put("h", (Object)height);
        return panel;
    }

    public void showBlock(boolean block, IFormView view) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("block", block);
        this.getDesigner().notify("showBlock", params, view);
    }

    @Override
    public void updatePageCount(boolean increment, IFormView view) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("increment", increment);
        this.getDesigner().notify("updatePageCount", params, view);
    }

    @Override
    public void updateCellName(String itemId, IFormView view, String value) {
        this.getDesigner().updateProperty(new Directive(itemId, null, "name", value, view));
    }

    @Override
    public void updateBindToNodeProperty(boolean bindToPrev, String itemId, IFormView view, boolean value) {
        String property = bindToPrev ? "bindToPrevNode" : "bindToNextNode";
        this.getDesigner().updateProperty(new Directive(itemId, "controlIntensity", property, value, view));
    }

    @Override
    public void changeStyle(String itemId, IFormView view, String newStyle) {
        this.getDesigner().changeStyle(itemId, view, newStyle);
    }

    @Override
    public void expandedConfigurePanel(Map<String, Object> param) {
        this.getPageCache().put(DRAW_MODE, "false");
        this.change((String)param.get("type"), (String)param.get("itemId"), param);
    }

    @Override
    public void shrinkConfigurePanel(IFormView view) {
        this.hideCurrentConfigurePanel();
        this.getDesigner().shrinkConfigurePanel(view);
        this.getPageCache().put(DRAW_MODE, "true");
    }

    protected void hideCurrentConfigurePanel() {
        String current = this.getPageCache().get(CURRENT_NODE);
        if (current != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getConfigurePanelId(current)});
        }
    }

    public void loadDesigner(Map<String, Object> params) {
        try {
            this.getDesigner().open("WorkflowModel", this.getDesignerInitData(params));
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"AbstractWorkflowDesignerPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(msg);
            this.log.error(msg);
        }
    }

    @Override
    public String getModelJson(String itemId) {
        GraphModel graphModel = this.getGraphModel();
        if (graphModel == null) {
            return null;
        }
        if (WfUtils.isNotEmpty((String)itemId)) {
            return JSON.toJSONString((Object)graphModel.getGraphCell(itemId));
        }
        return graphModel.getBpmnModelJson();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("data_changed".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getPageCache().put(CONFIRM_CLOSE, "true");
            this.getView().close();
        }
    }

    public String getSelectionCellType() {
        return this.selectionCellType;
    }

    public String getSelectionCellId() {
        return this.selectionCellId;
    }

    public void clearDataChanged() {
        this.getPageCache().remove("data_changed");
    }

    protected void setDataChanged() {
        this.getPageCache().put("data_changed", "true");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.isDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u9000\u51fa\u540e\u5c06\u4e0d\u4fdd\u5b58\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AbstractWorkflowDesignerPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("data_changed"));
            e.setCancel(true);
            return;
        }
        super.beforeClosed(e);
        this.getPageCache().remove(CURRENT_NODE);
        this.getPageCache().remove("model_json");
        this.getPageCache().remove(DRAW_MODE);
        this.getPageCache().remove(CONFIRM_CLOSE);
        this.getPageCache().remove("selection_cell");
        this.getPageCache().remove("data_changed");
        this.getPageCache().remove(ALLTYPE);
    }

    protected boolean isDataChanged() {
        return "true".equals(this.getPageCache().get("data_changed")) && !"true".equals(this.getPageCache().get(CONFIRM_CLOSE));
    }

    protected void fireAfterSaveDigram(String processNumber, String processVersion, String scene) {
        GraphModel graphModel = this.getGraphModel();
        try {
            if (graphModel != null && graphModel.getRootCell() != null) {
                AfterSaveDigramEvent evt = new AfterSaveDigramEvent(this.getView(), scene, "afterSaveDigram", null, graphModel, processNumber, processVersion, scene);
                this.fireCutomeEvent(evt);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u89e6\u53d1\u6a21\u578b\u4fdd\u5b58\u4e8b\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"AbstractWorkflowDesignerPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    protected void fireAfterPublishDigram(Map<String, Object> param, String scene) {
        Long modelId = (Long)param.get("modelId");
        String processNumber = (String)param.get("processNumber");
        String processVersion = (String)param.get("processVersion");
        GraphModel graphModel = this.getGraphModel();
        try {
            if (graphModel != null && graphModel.getRootCell() != null) {
                AfterPublishDigramEvent evt = new AfterPublishDigramEvent(this.getView(), scene, "afterPublishDigram", null, graphModel, modelId, processNumber, processVersion);
                this.fireCutomeEvent(evt);
            }
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u89e6\u53d1\u6a21\u578b\u53d1\u5e03\u4e8b\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"AbstractWorkflowDesignerPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    protected void fireAfterCheckDigram(List<ValidationError> result, String scene) {
        GraphModel graphModel = this.getGraphModel();
        try {
            if (graphModel != null && graphModel.getRootCell() != null) {
                AfterCheckDigramEvent evt = new AfterCheckDigramEvent(this.getView(), scene, "afterCheckDigram", null, graphModel, result, scene);
                this.fireCutomeEvent(evt);
            }
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u89e6\u53d1\u6a21\u578b\u6821\u9a8c\u4e8b\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"AbstractWorkflowDesignerPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    protected void fireCutomeEvent(CustomEventArgs evt) {
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent(evt);
    }
}

