/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessEventEntity;

public abstract class AbstractWorkflowEventConfigurePlugin
extends AbstractWorkflowConfigurePlugin
implements TabSelectListener {
    protected static final String KEY_ID = "id";
    protected static final String KEY_NAME = "name";
    protected static final String KEY_NUMBER = "number";
    protected static final String EVENT = "event";
    protected static final String EVENT_TYPE = "eventType";
    protected static final String EVENTNAME = "eventName";
    protected static final String EVENTID = "eventId";
    protected static final String ENTITYID = "entityId";
    protected static final String ENTITYNAME = "entityName";
    protected static final String ENTITYNUMBER = "entityNumber";
    protected static final String EVTTYPE_BECEVENT = "becevent";
    protected static final String EVTTYPE_CUSEVENT = "cusevent";
    protected static final String PROPERTY_EVENTPARAMS = "eventParams";
    protected static final String FIELD_EVENTNAME = "eventname";
    protected static final String FIELD_ENTITYNAME = "entityname";
    protected static final String FIELD_EVENTTYPE = "eventtype";
    protected static final String FIELD_EVENTNUMBER = "event";
    protected static final String FIELD_EVENTPARAMS = "evtparams";
    protected static final String FIELD_EVEVTID = "eventid";
    protected static final String TAB = "tabap";
    protected static final String TAB_MESSAGE = "msgtab";
    protected static final String PANEL_MSG = "msg_panel";
    protected static final String TAB_PLUGIN = "plugintab";
    protected static final String PANEL_PLUGIN = "plugin_panel";
    protected static final String KEY_MESSAGE_PAGEID = "message_pageId";
    protected static final String KEY_PLUGIN_PAGEID = "plugin_pageId";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FIELD_EVENTNAME, FIELD_ENTITYNAME, FIELD_EVENTPARAMS});
        Tab tab = (Tab)this.getControl(TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "entityname": {
                DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, FIELD_ENTITYNAME);
                break;
            }
            case "eventname": {
                this.openSelectEventPage();
                break;
            }
            case "evtparams": {
                this.openEventParamsPage();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void openEventParamsPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_EVENTPARAMS));
        parameter.setFormId("wf_nodeeventparams");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getCustomParams().putAll(this.getOpenEvtParamsCustomParams());
        this.getView().showForm(parameter);
    }

    protected Map<String, Object> getOpenEvtParamsCustomParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject props = this.getCellProperties();
        Object evtParams = DesignerModelUtil.getProperty((Map<String, Object>)props, PROPERTY_EVENTPARAMS);
        String entityId = (String)DesignerModelUtil.getProperty((Map<String, Object>)props, ENTITYID);
        params.put("value", evtParams);
        params.put(ENTITYID, entityId);
        params.put("modelJson", this.getModelJsonString());
        params.put(EVENTID, this.getCellProperties().get((Object)EVENTID));
        return params;
    }

    private void openSelectEventPage() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_common_f7list");
        param.setCustomParam("billFormId", (Object)"wf_evt_eventlist");
        param.setShowTitle(false);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_EVENTNAME));
        this.getView().showForm(param);
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "eventname": {
                this.eventChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "entityname": {
                this.entityChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "eventtype": {
                this.eventTypeChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "evtparams": {
                this.eventParamsChanged(newValue);
                break;
            }
            case "eventid": {
                this.eventIdChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void eventIdChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (WfUtils.isEmptyString((Object)newValue)) {
            this.setProperties("event", null, EVENTID, null, PROPERTY_EVENTPARAMS, null);
            this.getModel().setValue(FIELD_EVENTPARAMS, null);
            this.getModel().setValue(EVENTID, null);
        } else {
            Long eventId = (Long)((DynamicObject)newValue).get(KEY_ID);
            super.propertyChanged(propName, eventId, oldValue, rowIndex);
            this.getModel().setValue(FIELD_EVENTPARAMS, null);
            this.setProperty(this.getCellProperties(), "event", ((DynamicObject)newValue).get("eventnumber"));
        }
    }

    private void eventParamsChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty(PROPERTY_EVENTPARAMS, null);
        }
    }

    private void entityChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (WfUtils.isEmptyString((Object)newValue)) {
            this.setProperties(ENTITYID, null, ENTITYNAME, null);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
        this.getModel().setValue(FIELD_EVENTPARAMS, null);
    }

    private void eventTypeChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
        this.initEventControlVisible(newValue);
        this.getModel().setValue(FIELD_EVENTNAME, null);
        this.getModel().setValue("event", null);
    }

    protected void initEventControlVisible(Object eventType) {
        if (EVTTYPE_BECEVENT.equals(eventType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_EVEVTID, FIELD_EVENTPARAMS});
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_EVENTNAME});
        } else if (EVTTYPE_CUSEVENT.equals(eventType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_EVENTNAME});
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_EVEVTID, FIELD_EVENTPARAMS});
        }
    }

    private void eventChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (WfUtils.isEmptyString((Object)newValue)) {
            this.setProperties("event", null, EVENTNAME, null);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "entityname": {
                this.entityCallBack(returnData);
                break;
            }
            case "eventname": {
                this.eventCallBack(returnData);
                break;
            }
            case "evtparams": {
                this.eventParamsCallBack(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    protected void entityCallBack(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            Object id = data.get(KEY_ID);
            Object name = data.get(KEY_NAME);
            this.getModel().setValue(FIELD_ENTITYNAME, name);
            this.setProperty(ENTITYID, id);
            this.setProperty(ENTITYNUMBER, data.get(KEY_NUMBER));
        }
    }

    protected void eventCallBack(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            Object name = data.get(KEY_NAME);
            Object number = data.get(KEY_NUMBER);
            this.getModel().setValue(FIELD_EVENTNAME, name);
            this.setProperty("event", number);
        }
    }

    protected void eventParamsCallBack(Object returnData) {
        if (returnData instanceof JSONArray) {
            JSONArray params = (JSONArray)returnData;
            this.getModel().setValue(FIELD_EVENTPARAMS, (Object)DesignerPluginUtil.getNodeParamsShowText(params));
            this.setProperty(PROPERTY_EVENTPARAMS, params);
        }
    }

    protected void initEventParamsText() {
        Object value = DesignerModelUtil.getProperty((Map<String, Object>)this.getCellProperties(), PROPERTY_EVENTPARAMS);
        if (value instanceof JSONArray) {
            JSONArray params = (JSONArray)value;
            for (int i = 0; i < params.size(); ++i) {
                JSONObject objects = (JSONObject)params.get(i);
                if (objects.get((Object)"value") == null) continue;
                this.getModel().setValue(FIELD_EVENTPARAMS, (Object)DesignerPluginUtil.getNodeParamsShowText(params));
                break;
            }
        }
    }

    public void initProcessEvent(Object eventNumber) {
        Long eventId;
        if (eventNumber == null || WfUtils.isEmpty((String)((String)eventNumber))) {
            return;
        }
        JSONObject properties = this.getCellProperties();
        Long l = eventId = properties.get((Object)EVENTID) != null ? properties.getLong(EVENTID) : null;
        if (eventId == null) {
            JSONArray eventParams = properties.getJSONArray(PROPERTY_EVENTPARAMS);
            ProcessEventEntity processEventEntity = this.getRepositoryService().createProcessEvent((String)eventNumber, properties.getString(KEY_NAME), eventParams);
            eventId = processEventEntity.getId();
            this.setProperty(this.getCellProperties(), EVENTID, eventId);
        }
        this.getModel().setValue(FIELD_EVEVTID, (Object)eventId);
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        if (TAB_MESSAGE.equals(key)) {
            this.loadMessagePage();
        } else if (TAB_PLUGIN.equals(key)) {
            this.loadPluginPage();
        }
    }

    protected void loadMessagePage() {
        String pageId = this.getPageCache().get(KEY_MESSAGE_PAGEID);
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_msgnotify_configure", PANEL_MSG);
            this.getPageCache().put(KEY_MESSAGE_PAGEID, pageId);
        }
    }

    protected void loadPluginPage() {
        String pageId = this.getPageCache().get(KEY_PLUGIN_PAGEID);
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_task_plugins", PANEL_PLUGIN);
            this.getPageCache().put(KEY_PLUGIN_PAGEID, pageId);
        }
    }
}

