/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfUtils;

public abstract class AbstractWorkflowNodeParamsPlugin
extends AbstractWorkflowPlugin {
    protected static final String BTN_CONFIRM = "confirm";
    protected static final String ENTRY_PARAMS = "entryentity";
    protected static final String FIELD_ID = "id";
    protected static final String FIELD_NAME = "name";
    protected static final String FIELD_NUMBER = "number";
    protected static final String FIELD_VALUE = "value";
    protected static final String NUMBER_REGULAR_EXPRESSION = "^[A-Za-z][A-Za-z0-9_]*$";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
        TextEdit value = (TextEdit)this.getControl(FIELD_VALUE);
        value.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initParamsList();
    }

    protected void initParamsList() {
        JSONArray params = this.getRepositoryService().getProcessEventParams((Long)this.getView().getFormShowParameter().getCustomParam("eventId"));
        JSONArray value = (JSONArray)this.getView().getFormShowParameter().getCustomParam(FIELD_VALUE);
        if (params == null || params.isEmpty()) {
            return;
        }
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        if (value != null && !value.isEmpty()) {
            for (int i = 0; i < value.size(); ++i) {
                JSONObject param = value.getJSONObject(i);
                map.put(param.getString(FIELD_NUMBER), param);
            }
        }
        int size = params.size();
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(ENTRY_PARAMS, size);
        for (int i = 0; i < size; ++i) {
            JSONObject param = params.getJSONObject(i);
            if (map.get(param.get((Object)FIELD_NUMBER)) != null) {
                param = (JSONObject)map.get(param.get((Object)FIELD_NUMBER));
            }
            this.initParamRow(model, param, i);
        }
    }

    protected void initParamRow(IDataModel model, JSONObject param, int index) {
        model.setValue(FIELD_ID, param.get((Object)FIELD_ID), index);
        model.setValue(FIELD_NUMBER, param.get((Object)FIELD_NUMBER), index);
        model.setValue(FIELD_VALUE, param.get((Object)FIELD_VALUE), index);
        model.setValue(FIELD_NAME, param.get((Object)FIELD_NAME), index);
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_CONFIRM.equals(key)) {
            this.confirm();
        } else if (FIELD_VALUE.equals(key)) {
            this.openExpressionPage();
        }
    }

    protected void confirm() {
        JSONArray params = this.getEventParams();
        String tip = this.validate(params);
        if (tip != null) {
            this.getView().showTipNotification(tip);
            return;
        }
        this.getView().returnDataToParent((Object)params);
        this.getView().close();
    }

    protected void openExpressionPage() {
        String value = (String)this.getModel().getValue(FIELD_VALUE, this.getFocusRowIndex());
        DesignerPluginUtil.openExpressionPage(this.getView(), (IFormPlugin)this, value);
    }

    protected String validate(JSONArray params) {
        if (params != null) {
            int size = params.size();
            ArrayList<String> numbers = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                JSONObject param = params.getJSONObject(i);
                String number = param.getString(FIELD_NUMBER);
                int row = i + 1;
                if (WfUtils.isEmpty((String)number) || !number.matches(NUMBER_REGULAR_EXPRESSION)) {
                    return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u201c\u53c2\u6570\u7f16\u7801\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"AbstractWorkflowNodeParamsPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), row);
                }
                int index = numbers.indexOf(number);
                if (index > -1) {
                    return String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u4e0e\u7b2c\u201c%2$s\u201d\u884c\u7684\u201c\u53c2\u6570\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"AbstractWorkflowNodeParamsPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), index + 1, row);
                }
                numbers.add(number);
                String name = param.getString(FIELD_NAME);
                if (!WfUtils.isEmpty((String)name)) continue;
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u201c\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractWorkflowNodeParamsPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), row);
            }
        }
        return null;
    }

    protected JSONArray getEventParams() {
        JSONArray params = new JSONArray();
        DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRY_PARAMS);
        if (!datas.isEmpty()) {
            for (DynamicObject data : datas) {
                params.add((Object)this.getParamRowData(data));
            }
        }
        return params;
    }

    protected JSONObject getParamRowData(DynamicObject data) {
        JSONObject param = new JSONObject();
        param.put(FIELD_ID, (Object)data.getString(FIELD_ID));
        param.put(FIELD_NUMBER, (Object)data.getString(FIELD_NUMBER));
        param.put(FIELD_VALUE, (Object)data.getString(FIELD_VALUE));
        param.put(FIELD_NAME, (Object)data.getString(FIELD_NAME));
        return param;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if ("valueExpression".equals(evt.getActionId()) && returnData instanceof Map) {
            Map data = (Map)returnData;
            String expression = (String)data.get("expression");
            this.getModel().setValue(FIELD_VALUE, (Object)String.format("${%s}", expression), this.getFocusRowIndex());
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (ENTRY_PARAMS.equals(name)) {
            RowDataEntity data = e.getRowDataEntities()[0];
            String id = data.getDataEntity().getString(FIELD_ID);
            if (WfUtils.isEmpty((String)id)) {
                id = BpmnDiffUtil.getListElementId((String)this.getParamsField());
            }
            data.getDataEntity().set(FIELD_ID, (Object)id);
        }
        super.afterAddRow(e);
    }

    protected int getFocusRowIndex() {
        return ((EntryGrid)this.getControl(ENTRY_PARAMS)).getEntryState().getFocusRow();
    }

    protected abstract String getParamsField();
}

