/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public abstract class AbstractWorkflowPlugin
extends AbstractFormPlugin {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected RepositoryService getRepositoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRepositoryService();
    }

    protected TaskService getTaskService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getTaskService();
    }

    protected RuntimeService getRuntimeService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRuntimeService();
    }

    protected ManagementService getManagementService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getManagementService();
    }

    protected HistoryService getHistoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getHistoryService();
    }

    public void showForm(String key, String formId) {
        this.showForm(this.getShowParameter(key, formId));
    }

    public void showForm(String key, String formId, String caption) {
        this.showForm(this.getShowParameter(key, formId));
    }

    public void showForm(String key, String formId, Map<String, Object> params) {
        FormShowParameter parameter = this.getShowParameter(key, formId, params);
        this.showForm(parameter);
    }

    public void showForm(String key, String formId, String caption, Map<String, Object> params) {
        FormShowParameter parameter = this.getShowParameter(key, formId, caption, params);
        this.showForm(parameter);
    }

    public void showForm(FormShowParameter parameter) {
        parameter.setHasRight(true);
        parameter.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
        this.getView().showForm(parameter);
    }

    protected void showComingMessage() {
        this.getView().showMessage(ResManager.loadKDString((String)"\u6b63\u5728\u5efa\u8bbe\u4e2d\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"AbstractWorkflowPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), "", MessageTypes.ComingSoon);
    }

    protected FormShowParameter getShowParameter(String key, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        return parameter;
    }

    protected FormShowParameter getShowParameter(String key, String formId, String caption) {
        FormShowParameter parameter = this.getShowParameter(key, formId);
        parameter.setCaption(caption);
        return parameter;
    }

    protected FormShowParameter getShowParameter(String key, String formId, Map<String, Object> params) {
        FormShowParameter parameter = this.getShowParameter(key, formId);
        parameter.setCustomParams(params);
        return parameter;
    }

    protected FormShowParameter getShowParameter(String key, String formId, String caption, Map<String, Object> params) {
        FormShowParameter parameter = this.getShowParameter(key, formId, caption);
        parameter.setCustomParams(params);
        return parameter;
    }

    public String showFormInContainer(String formId, String targetKey, Map<String, Object> params) {
        FormShowParameter parameter = this.getShowFormInContainerParameter(formId, targetKey, params);
        this.showForm(parameter);
        return parameter.getPageId();
    }

    protected FormShowParameter getShowFormInContainerParameter(String formId, String targetKey, Map<String, Object> params) {
        FormShowParameter parameter = this.getShowParameter(targetKey, formId);
        parameter.setShowTitle(false);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(targetKey);
        if (params != null) {
            String dynamicPlugin = (String)params.remove("dynamic_config_plugin");
            if (WfUtils.isNotEmpty((String)dynamicPlugin)) {
                parameter.addCustPlugin(dynamicPlugin);
            }
            parameter.setCustomParams(params);
        }
        return parameter;
    }

    public void initialize() {
        super.initialize();
    }

    protected boolean canDoOperation(Long orgId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        return WfAdminUtil.canDoOperation((Long)userId, (Long)orgId);
    }
}

