/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfUtils;

public class AuditCommentGroupPlugin
extends AbstractWorkflowPlugin {
    public static final String FORM_ID = "wf_auditcommentgroup";
    public static final String NUMBERVARIABLE = "number";
    public static final String NAME = "name";
    public static final String LONGNUMBER = "longnumber";
    public static final String PARENT = "parent";
    public static final String FULLNAME = "fullname";
    public static final String FORMID = "id";

    public void afterBindData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.VIEW) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"save"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (NUMBERVARIABLE.equals(propertyName) || NAME.equals(propertyName) || PARENT.equals(propertyName)) {
            this.checkFieldLength();
        }
    }

    private void checkFieldLength() {
        DynamicObject dynamicObject;
        DynamicObject number = (DynamicObject)this.getModel().getValue(PARENT);
        if (number != null && (dynamicObject = WfUtils.findBusinessObject((String)number.getString(FORMID), (String)FORM_ID, (String)"longnumber,fullname")) != null) {
            String parentNumber = dynamicObject.getString(LONGNUMBER);
            String parentName = dynamicObject.getLocaleString(FULLNAME).getLocaleValue();
            String sonNumber = (String)this.getModel().getValue(NUMBERVARIABLE);
            Object sonName = this.getModel().getValue(NAME);
            String realNumber = parentNumber + sonNumber;
            String realName = parentName + sonName;
            if (WfUtils.isNotEmpty((String)realNumber) && realNumber.length() + 1 > 300) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u603b\u7f16\u7801\u8d85\u957f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AuditCommentGroupPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else if (WfUtils.isNotEmpty((String)realName) && realName.length() + 1 > 500) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u603b\u540d\u79f0\u8d85\u957f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AuditCommentGroupPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String number;
        if (args.getSource() instanceof Save && !PluginUtil.matchPattern("^[A-Za-z][A-Za-z0-9_]*$", number = (String)this.getModel().getValue(NUMBERVARIABLE))) {
            String result = ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"CommonAuditCommentPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(result);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getSource() instanceof Save && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().close();
        }
    }
}

