/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.component.WorkflowDesigner;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.exception.WFPreComputorException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ChangeFlowChartComponent {
    private static final Log log = LogFactory.getLog(ChangeFlowChartComponent.class);
    private static final String BAR_ERROR_MESSAGE = "barerrormessage";
    private static final String BAR_SUSPEND = "suspend";
    private static final String BAR_REVOKE_SUSPEND = "barrevokesuspend";
    private static final String DYNAMIC_UPDATE_PROCINST = "updateprocinst";
    private static final String ABANDON = "feiqi";
    private static final String CURTASK = "curtask";
    private static final String BAR_PROCESS_SALUTION = "barprocesssalution";
    private static final String TRANSFERLOG = "transferlog";
    private static final String SKIP = "skip";
    protected static final String BTNPRECOMPUTATOR = "barprecomputator";
    private static final String BTNOPERATELOG = "baroperatelog";
    private static final String WORKFLOW_DESIGNER = "workflowdesigner";
    protected static final String PROCINSTID = "procinstid";
    private static final String BACKTOPARENTPROCESS = "backtoparentprocess";
    protected static final String SHOWADMINBUTTONS = "showAdminButtons";
    private static final String BTN_ABANDONBILL = "abandonbill";
    protected static final String BTN_VIEWBILLRELATION = "viewbillrelation";
    protected static String[] BUTTONS = new String[]{"barerrormessage", "suspend", "barrevokesuspend", "updateprocinst", "feiqi", "curtask", "barprocesssalution", "transferlog", "skip", "baroperatelog"};
    private static final String PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD = "showViewApprovalRecord";
    private static final String BTN_REFRESH = "refresh";
    private static final String BTN_CLOSE = "close";
    private static final String BARITEMAP = "baritemap";
    private static final String BTNIMMEDIATE = "immediate";
    private static final String VARIABLES = "variables";
    private static final String PROCDEFID = "procDefId";
    private static final String ISPRECOMPUTATOR = "isPreComputator";
    private static final String ISIMMEDIATE = "isImmediate";
    private IFormView view;
    private Long processInstance;
    protected static final String BARVIEWAPPROVALRECORD = "barviewapprovalrecord";

    public ChangeFlowChartComponent(IFormView view, Long processInstance) {
        this.view = view;
        this.processInstance = processInstance;
    }

    public ChangeFlowChartComponent() {
    }

    public void changeFlowChart() {
        try {
            this.view.getModel().setValue(PROCINSTID, (Object)this.processInstance);
            this.refreshPage();
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(WFMultiLangConstants.getViewFlowChartErrorInfo(), e.getMessage()));
            log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private Map<String, Object> getFlowchartInitData(Long procInstId, Boolean isPreComputator, Boolean isImmediate) {
        return this.getRepositoryService().getFlowchartInitDataByProcInstId(isPreComputator, isImmediate, this.getHisProInstById(procInstId));
    }

    public void refreshPage() {
        Long procInstId = Long.valueOf((String)this.view.getModel().getValue(PROCINSTID));
        HistoricProcessInstanceEntity processInstance = this.getHisProInstById(procInstId);
        if (null == processInstance) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u4e0d\u5b58\u5728\u3002 ", (String)"WorkflowViewFlowchartPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.switchButtonVisibility(procInstId);
        this.controlVisibleAbanBtns(procInstId);
        this.getView().updateView();
        WorkflowDesigner designer = (WorkflowDesigner)this.view.getControl(WORKFLOW_DESIGNER);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("procInstId", this.view.getModel().getValue(PROCINSTID));
        try {
            String parentFormId;
            designer.cleanRecordsState();
            Map<String, Object> initData = this.getDesignerInitData(params);
            if (initData != null) {
                String variables = this.view.getPageCache().get(VARIABLES);
                if (WfUtils.isNotEmpty((String)variables)) {
                    Map data = (Map)SerializationUtils.fromJsonString((String)variables, Map.class);
                    initData.putAll(data);
                    initData.put("procInstId", this.view.getModel().getValue(PROCINSTID));
                }
                designer.open("WorkflowModel", initData);
            }
            if (!"wf_apphome_new".equals(parentFormId = this.getView().getFormShowParameter().getParentFormId()) && !"bpm_apphome_grid".equals(parentFormId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BARITEMAP});
            }
        }
        catch (Exception e) {
            log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6d41\u7a0b\u6d41\u8f6c\u4fe1\u606f\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public Map<String, Object> getDesignerInitData(Map<String, Object> params) {
        Object id = params.get("procInstId");
        Long procInstId = null;
        procInstId = id != null ? Long.valueOf(id.toString()) : this.getLatestProcInstId(params.get("billId"));
        if (WfUtils.isNotEmpty((Long)procInstId)) {
            return this.getDesignerInitDataByProcInstId(procInstId, params);
        }
        if (WfUtils.isEmpty((Long)procInstId)) {
            Long procDefId = null;
            if (params.get(PROCDEFID) != null) {
                procDefId = Long.valueOf(params.get(PROCDEFID).toString());
            }
            if (procDefId == null || procDefId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u672a\u5b9a\u4e49\u6d41\u7a0b\u6216\u4e0d\u5728\u6d41\u7a0b\u4e2d\u3002", (String)"WorkflowViewFlowchartPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return null;
            }
            return this.getDesignerInitDataByProcDefId(procDefId);
        }
        return null;
    }

    private Map<String, Object> getDesignerInitDataByProcDefId(Long procDefId) {
        Map<String, Object> data = null;
        try {
            this.getView().setVisible(Boolean.FALSE, new String[]{BACKTOPARENTPROCESS, BARVIEWAPPROVALRECORD});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String entityName = (String)parameter.getCustomParam("entityname");
            Long billNo = Long.valueOf(parameter.getCustomParam("billno").toString());
            DynamicObject billObj = null;
            if (WfUtils.isNotEmpty((Long)billNo) && WfUtils.isNotEmpty((String)entityName)) {
                billObj = WfUtils.findBusinessObject((String)String.valueOf(billNo), (String)entityName);
            } else {
                try {
                    String parentViewId = (String)parameter.getCustomParam("parentViewId");
                    IFormView parentView = this.getView().getView(parentViewId);
                    if (parentView instanceof IBillView) {
                        billObj = parentView.getModel().getDataEntity();
                    }
                }
                catch (KDException e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58", (String)"WorkflowViewFlowchartPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                }
            }
            data = this.getFlowchartInitDataByProcDefId(procDefId, billObj);
            if (data.get("tips") != null) {
                this.getView().showTipNotification(String.valueOf(data.get("tips")), Integer.valueOf(3000));
            }
        }
        catch (WFPreComputorException e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u7b97\u8fd0\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            return this.getFlowchartInitDataByProcDefId(procDefId);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return data;
    }

    private Map<String, Object> getFlowchartInitDataByProcDefId(Long procDefId, DynamicObject billObj) {
        return this.getRepositoryService().getFlowchartInitDataByProcDefId(procDefId, billObj);
    }

    private Map<String, Object> getFlowchartInitDataByProcDefId(Long procDefId) {
        return this.getRepositoryService().getFlowchartInitDataByProcDefId(procDefId);
    }

    private Long getLatestProcInstId(Object billId) {
        if (WfUtils.isNotEmptyString((Object)billId)) {
            QFilter[] hisProcInstfilters = new QFilter[]{new QFilter("businessKey", "=", (Object)billId.toString()), new QFilter("endType", "!=", (Object)"20"), new QFilter("superProcessInstanceId", "=", (Object)0)};
            String orderBy = String.format("%s desc", "createDate");
            List hisProcEntities = this.getRepositoryService().findEntitiesByFilters("wf_hiprocinst", hisProcInstfilters, null, orderBy);
            if (WfUtils.isEmptyForCollection((Collection)hisProcEntities)) {
                HistoricProcessInstanceEntity hisProcEntity = (HistoricProcessInstanceEntity)hisProcEntities.get(0);
                return hisProcEntity.getProcessInstanceId();
            }
        }
        return null;
    }

    private Map<String, Object> getDesignerInitDataByProcInstId(Long procInstId, Map<String, Object> params) {
        this.view.getModel().setValue(PROCINSTID, (Object)procInstId);
        this.setUpShowButtons(procInstId, params);
        Map<String, Object> data = null;
        try {
            HistoricProcessInstanceEntity hisProInst;
            Long superProcInstId;
            Boolean isPreComputator = this.getView().getFormShowParameter().getCustomParam(ISPRECOMPUTATOR) == null ? Boolean.FALSE : (Boolean)this.getView().getFormShowParameter().getCustomParam(ISPRECOMPUTATOR);
            Boolean isImmediate = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISIMMEDIATE);
            data = this.getFlowchartInitData(procInstId, isPreComputator, isImmediate);
            if (data == null || data.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6240\u5728\u6d41\u7a0b\u6ca1\u6709\u8282\u70b9\u6d41\u8f6c\u4fe1\u606f\u3002", (String)"WorkflowViewFlowchartPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return null;
            }
            if (data.get("tips") != null) {
                this.getView().showTipNotification((String)data.get("tips"), Integer.valueOf(3000));
            }
            if (WfUtils.isNotEmpty((Long)(superProcInstId = (hisProInst = this.getHisProInstById(procInstId)).getSuperProcessInstanceId()))) {
                data.put("superProcInstId", String.valueOf(superProcInstId));
            }
        }
        catch (WFPreComputorException e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u7b97\u8fd0\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (data != null) {
            data.put(PROCINSTID, procInstId);
            data.put("flowType", this.getWorkFlowType(procInstId));
        }
        return data;
    }

    private void setUpShowButtons(Long procInstId, Map<String, Object> params) {
        boolean terminate = false;
        if ("true".equals(params.get("showButtons")) || "true".equals(this.view.getPageCache().get(SHOWADMINBUTTONS))) {
            terminate = this.isTerminate(procInstId);
            if (terminate) {
                this.getView().setVisible(Boolean.FALSE, BUTTONS);
            } else {
                this.showAdminPermButton(procInstId);
            }
            this.view.getPageCache().put(SHOWADMINBUTTONS, "true");
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_REFRESH, BTN_CLOSE});
        this.showPrecomputatorButton(procInstId);
        this.controlVisibleBizBillBtns(procInstId);
        this.showSuspendErrorBtns();
        this.showBackToParentProcessButton();
        this.getView().setVisible(Boolean.valueOf(!terminate), new String[]{BARITEMAP});
        this.getView().setVisible(Boolean.valueOf(!"false".equals(this.view.getPageCache().get(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD))), new String[]{BARVIEWAPPROVALRECORD});
    }

    private void showBackToParentProcessButton() {
        Long procInstId = Long.valueOf((String)this.view.getModel().getValue(PROCINSTID));
        HistoricProcessInstanceEntity hisProInst = this.getHisProInstById(procInstId);
        Long superProcInstId = hisProInst.getSuperProcessInstanceId();
        if (WfUtils.isEmpty((Long)superProcInstId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BACKTOPARENTPROCESS});
            this.setPageCacheForApprovalRecord("true");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BACKTOPARENTPROCESS});
            this.setPageCacheForApprovalRecord("false");
        }
    }

    private void setPageCacheForApprovalRecord(String cacheValue) {
        boolean isBizFlow;
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        String isBizFlowObj = this.view.getPageCache().get("isBizFlow");
        boolean bl = isBizFlow = null == isBizFlowObj ? false : Boolean.parseBoolean(isBizFlowObj.toString());
        if (isBizFlow || "wf_apphome_new".equals(parentFormId) || "bpm_apphome_grid".equals(parentFormId)) {
            this.view.getPageCache().put(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD, "false");
        } else {
            this.view.getPageCache().put(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD, cacheValue);
        }
    }

    private boolean isTerminate(Long procInstId) {
        HistoricProcessInstanceEntity procInstEntity = this.getHisProInstById(procInstId);
        if (procInstEntity == null) {
            return false;
        }
        return procInstEntity.getEndTime() != null;
    }

    private void controlVisibleBizBillBtns(Long procInstId) {
        String workFlowType = this.getWorkFlowType(procInstId);
        boolean isBizFlow = ProcessType.BizFlow.name().equals(workFlowType);
        log.error(String.format("WorkflowViewFlowchartPlugin controlVisibleBizBillBtns isBizFlow is %s", workFlowType));
        if (isBizFlow) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_ABANDONBILL});
            this.getView().setEnable(Boolean.FALSE, new String[]{SKIP});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ABANDONBILL});
            this.getView().setEnable(Boolean.TRUE, new String[]{SKIP});
        }
        this.view.getPageCache().put("isBizFlow", String.valueOf(isBizFlow));
        this.getView().setVisible(Boolean.valueOf(isBizFlow), new String[]{BTN_VIEWBILLRELATION});
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (!"wf_apphome_new".equals(parentFormId) && !"bpm_apphome_grid".equals(parentFormId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BARITEMAP});
        }
    }

    private void showSuspendErrorBtns() {
        Long procInstId = Long.valueOf((String)this.view.getModel().getValue(PROCINSTID));
        ExecutionEntity entity = (ExecutionEntity)this.getRepositoryService().findEntityById(procInstId, "wf_execution", String.format("%s,%s", "suspensionState", "processtype"));
        log.debug(String.format("WorkflowViewFlowchartPlugin showSuspendErrorBtns's procInstId is %s", procInstId));
        if (entity != null && ManagementConstants.ACTIVE.getStateCode().equalsIgnoreCase(entity.getSuspensionState())) {
            log.debug(String.format("WorkflowViewFlowchartPlugin showSuspendErrorBtns's suspensionState is %s", entity.getSuspensionState()));
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_REVOKE_SUSPEND, DYNAMIC_UPDATE_PROCINST});
            this.getView().setEnable(Boolean.TRUE, new String[]{BTNIMMEDIATE, BAR_SUSPEND});
        } else {
            log.debug("WorkflowViewFlowchartPlugin showSuspendErrorBtns's suspensionState is null.else barch");
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_REVOKE_SUSPEND});
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNPRECOMPUTATOR, BTNIMMEDIATE, BAR_SUSPEND});
            this.getView().setEnable(Boolean.TRUE, new String[]{DYNAMIC_UPDATE_PROCINST});
            QFilter qFilter = new QFilter("processinstanceid", "=", (Object)procInstId);
            List durations = this.getRepositoryService().findEntitiesByFilters("wf_durationdetail", new QFilter[]{qFilter}, String.format("%s,%s,%s", "type", "undosuspendtime", "errortype"), "");
            if (durations != null) {
                for (DurationDetailEntity durationEntity : durations) {
                    if (SuspendType.MANUALSUSPEND.getCode().equals(durationEntity.getType()) && durationEntity.getUndoSuspendTime() == null) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{DYNAMIC_UPDATE_PROCINST});
                    }
                    if (!"suspendByUserId".equals(durationEntity.getErrorType())) continue;
                    this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SUSPEND, BAR_REVOKE_SUSPEND, SKIP, ABANDON});
                }
            }
        }
        this.setErrorMsgBtn(procInstId);
        if (entity != null && ProcessType.BizFlow.name().equals(entity.getProcessType())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SUSPEND});
        }
        ArrayList<Long> procInstIds = new ArrayList<Long>(1);
        procInstIds.add(procInstId);
        if (ProcessInstancePluginUtil.isSuspendParticipantAvailable(procInstIds)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{DYNAMIC_UPDATE_PROCINST});
        }
    }

    private void setErrorMsgBtn(Long procInstId) {
        QFilter qFProcInstId = new QFilter("processInstanceId", "=", (Object)procInstId);
        QFilter qTypes = new QFilter("jobHandlerType", "in", Arrays.asList(RuntimeUtil.getRunningJobStr()));
        Long deadLetterJobs = this.getRepositoryService().getEntityCountByFilter("wf_deadletterjob", new QFilter[]{qFProcInstId, qTypes});
        if (deadLetterJobs == 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_ERROR_MESSAGE});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_ERROR_MESSAGE});
        }
    }

    private String getWorkFlowType(Long procInstId) {
        HistoricProcessInstanceEntity procInstEntity = this.getHisProInstById(procInstId);
        if (procInstEntity == null) {
            return null;
        }
        return procInstEntity.getProcessType();
    }

    private RepositoryService getRepositoryService() {
        return ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
    }

    private void showAdminPermButton(Long procInstId) {
        Long userId = RequestContext.get().getCurrUserId();
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"47150e89000000ac")), new String[]{BAR_ERROR_MESSAGE});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"0YS1GTBP53D6")), new String[]{BAR_SUSPEND});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"/8M3MNJNJZE5")), new String[]{BAR_REVOKE_SUSPEND});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"018KF2ZNSR7J")), new String[]{DYNAMIC_UPDATE_PROCINST});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"/8M3RG6213GO")), new String[]{ABANDON});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"05VKOWGDW44=")), new String[]{CURTASK});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"Gap3Udfv29")), new String[]{BARITEMAP});
        boolean hasPermision = PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"/ENE0FKRAB0O");
        if (hasPermision) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_PROCESS_SALUTION});
            HistoricProcessInstanceEntity hisProInst = this.getHisProInstById(procInstId);
            Long procDefId = hisProInst.getProcessDefinitionId();
            if ("886006942529487872".equals(String.valueOf(procDefId)) || this.isAutoTestVersion(procInstId)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_PROCESS_SALUTION});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_PROCESS_SALUTION});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_PROCESS_SALUTION});
        }
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"47150e89000000ac")), new String[]{TRANSFERLOG});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"/8M3P61RNHXZ")), new String[]{SKIP});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTNOPERATELOG});
    }

    private boolean isAutoTestVersion(Long procInstId) {
        HistoricProcessInstanceEntity procInstEntity = this.getHisProInstById(procInstId);
        if (procInstEntity == null) {
            return false;
        }
        Long defId = procInstEntity.getProcessDefinitionId();
        ProcessDefinitionEntity procDefEntiy = (ProcessDefinitionEntity)((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService().findEntityById(defId, "wf_processdefinition", "enable");
        return "testing".equals(procDefEntiy.getEnable());
    }

    private String getPermissionEntity() {
        return ProcessInstancePluginUtil.getPermissionEntity(this.getView());
    }

    private HistoricProcessInstanceEntity getHisProInstById(Long procInstId) {
        return (HistoricProcessInstanceEntity)((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService().findEntityById(procInstId, "wf_hiprocinst");
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }

    protected void switchButtonVisibility(Long procInstId) {
        this.showPrecomputatorButton(procInstId);
        if ("true".equals(this.view.getPageCache().get(SHOWADMINBUTTONS))) {
            if (ViewFlowchartUtil.isTerminate((Long)procInstId)) {
                this.getView().setVisible(Boolean.FALSE, BUTTONS);
            } else {
                this.getView().setVisible(Boolean.TRUE, BUTTONS);
            }
        }
    }

    private void showPrecomputatorButton(Long procInstId) {
        if (ViewFlowchartUtil.isAutoTest((Long)procInstId) || ViewFlowchartUtil.isTerminate((Long)procInstId) || ProcessType.BizFlow.name().equals(ViewFlowchartUtil.getWorkFlowType((Long)procInstId))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNPRECOMPUTATOR});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTNPRECOMPUTATOR});
        }
    }

    private void controlVisibleAbanBtns(Long procInstId) {
        String workFlowType = ViewFlowchartUtil.getWorkFlowType((Long)procInstId);
        boolean isBizFlow = ProcessType.BizFlow.name().equals(workFlowType);
        if (isBizFlow) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_ABANDONBILL});
            this.getView().setEnable(Boolean.FALSE, new String[]{SKIP});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ABANDONBILL});
            this.getView().setEnable(Boolean.TRUE, new String[]{SKIP});
        }
        this.getView().setVisible(Boolean.valueOf(isBizFlow), new String[]{BTN_VIEWBILLRELATION});
        if (WfUtils.isEmpty((String)this.view.getPageCache().get(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD))) {
            this.view.getPageCache().put(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD, "true");
        }
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (isBizFlow || "wf_apphome_new".equals(parentFormId) || "bpm_apphome_grid".equals(parentFormId)) {
            this.view.getPageCache().put(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD, "false");
        }
    }

    public IFormView getView() {
        return this.view;
    }

    public ChangeFlowChartComponent setView(IFormView view) {
        this.view = view;
        return this;
    }

    public Long getProcessInstance() {
        return this.processInstance;
    }

    public ChangeFlowChartComponent setProcessInstance(Long processInstance) {
        this.processInstance = processInstance;
        return this;
    }
}

