/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.design.util.PluginUtil;

public class CommonAuditCommentListPlugin
extends AbstractListPlugin {
    private static final String QUERY = "query";
    private static final String COMMENT = "comment";
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    private static final String TBLENABLE = "tblenable";
    private static final String TBLDISABLE = "tbldisable";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{QUERY});
    }

    public void itemClick(ItemClickEvent evt) {
        if (QUERY.equals(evt.getItemKey())) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_commonauditcommenttree", (String)"47150e89000000ac")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseChangeLogsUtil.queryLog(this.getView(), COMMENT);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection listSelectedRowCollection = evt.getListSelectedRowCollection();
        if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
            ArrayList<Long> primaryKeyList = new ArrayList<Long>(listSelectedRowCollection.size());
            for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                Long primaryKey = (Long)listSelectedRow.getPrimaryKeyValue();
                primaryKeyList.add(primaryKey);
            }
            Long[] primaryKeyArr = new Long[primaryKeyList.size()];
            Map commonaudits = BusinessDataServiceHelper.loadFromCache((Object[])primaryKeyList.toArray(primaryKeyArr), (String)"wf_commonauditcommenttree");
            ArrayList<String> enableList = new ArrayList<String>(commonaudits.size());
            if (commonaudits != null && commonaudits.size() > 0) {
                for (Map.Entry commonaudit : commonaudits.entrySet()) {
                    DynamicObject dynamicObject = (DynamicObject)commonaudit.getValue();
                    String enableValue = dynamicObject.getString(ENABLE);
                    if ("1".equals(enableValue)) {
                        enableList.add(ENABLE);
                        continue;
                    }
                    enableList.add(DISABLE);
                }
            }
            if (enableList.size() > 0) {
                if (enableList.contains(ENABLE) && enableList.contains(DISABLE)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{TBLENABLE, TBLDISABLE});
                } else if (enableList.contains(ENABLE) && !enableList.contains(DISABLE)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{TBLDISABLE});
                    this.getView().setEnable(Boolean.FALSE, new String[]{TBLENABLE});
                } else if (enableList.contains(DISABLE) && !enableList.contains(ENABLE)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{TBLDISABLE});
                    this.getView().setEnable(Boolean.TRUE, new String[]{TBLENABLE});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{TBLENABLE, TBLDISABLE});
                }
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{TBLENABLE, TBLDISABLE});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ((args.getSource() instanceof Delete || args.getSource() instanceof StatusConvert) && args.getOperationResult().isSuccess()) {
            BaseChangeLogsUtil.addChangeLog(this.getView(), args.getSource(), COMMENT);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete || args.getSource() instanceof StatusConvert) {
            BaseChangeLogsUtil.putBaseArrayCache(this.getView(), "wf_commonauditcommenttree");
        }
    }

    public void afterCreateNewData(EventObject e) {
        PluginUtil.setControlInvisible(this.getView(), "tblclose");
    }
}

