/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.design.util.IBaseChangeLogCallBack;
import kd.bos.workflow.design.util.PluginUtil;

public class CommonAuditCommentPlugin
extends AbstractWorkflowPlugin {
    public static final String FORM_ID = "wf_commonauditcommenttree";
    private static final String COMMENT = "comment";
    private static final String TBMAIN = "tbmain";
    private static final String BAR_SAVE = "bar_save";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
    }

    public void loadData(LoadDataEventArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof Save && args.getOperationResult().isSuccess()) {
            String baseFormId = args.getOperationResult().getSuccessPkIds().get(0).toString();
            BaseChangeLogsUtil.addBaseLog(this.getView(), COMMENT, FORM_ID, baseFormId, new IBaseChangeLogCallBack(){

                @Override
                public JSONArray getModelArray() {
                    return new JSONArray();
                }
            });
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            this.getModel().setValue("name", this.getModel().getValue("name"));
            String number = (String)this.getModel().getValue("number");
            if (!PluginUtil.matchPattern("^[A-Za-z][A-Za-z0-9_]*$", number)) {
                String result = ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"CommonAuditCommentPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(result);
                args.setCancel(true);
            }
        }
    }
}

