/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.component.WfConditionUpd;
import kd.bos.workflow.design.condition.ConditionalRuleFactory;
import kd.bos.workflow.design.condition.IConditionalRule;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.validate.IValidateResult;
import kd.bos.workflow.design.util.ConditionalRuleUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.ExtItfPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;
import kd.bos.workflow.engine.management.util.ConditionalRuleConvertUtil;

public class ConditionalRulePlugin
extends AbstractWorkflowPlugin
implements IValidateResult {
    private static final String HISTORYBTN = "historybtn";
    private static final String CONFIRMBTN = "confirmbtn";
    private static final String CANCELBTN = "cancelbtn";
    private static final String CLEAR_EXIT_BTN = "clearandexit";
    public static final String SHOWTEXT = "showtext";
    private static final String TYPE = "type";
    private static final String DESCRIPTION = "description";
    private static final String PROCESSNAME = "processname";
    private static final String PROCESSVERSION = "processversion";
    private static final String VALIDTIME = "validtime";
    private static final String ELEMENTID = "elementid";
    private static final String VERSION = "version";
    private static final String EXPRESSION = "expression";
    private static final String PLUGIN = "plugin";
    private static final String PROPERTY = "property";
    public static final String DEFAULTCONDITION = "defaultcondition";
    private static final String ENTRY = "entryentity";
    private static final String LEFTBRACKET = "leftbracket";
    private static final String PARAMNUMBER = "paramnumber";
    private static final String OPERATION = "operation";
    private static final String VALUE = "value";
    private static final String RIGHTBRACKET = "rightbracket";
    private static final String VALUETYPE = "valuetype";
    private static final String LOGIC = "logic";
    private static final String SEQ = "seq";
    private static final String ISHIDEEXP = "isHideExp";
    public static final String PLUGINPANEL = "pluginpanel";
    public static final String CONDRULEPANEL = "condrulepanel";
    private static final String CONTAINER_EXT_ITF = "extitfcontainer";
    private static final String TOOLBAR = "toolbar";
    private static final String BTN_ADDLINE = "addline";
    private static final String COPYCONDITION = "copycondition";
    private static final String PASTECONDITION = "pastecondition";
    private static final String PLACEHOLDER_LEFT = "placeholderleft";
    private static final String PLACEHOLDER_RIGHT = "placeholderright";
    public static final String CONDITIONTYPE = "conditiontype";
    private static final String CONDRULEID = "condruleid";
    private static final String CONDITIONTYPE_PLUGIN = "plugin";
    private static final String CONDITIONTYPE_CONDITION = "condrule";
    private static final String CONDITION_TYPE = "type";
    private static final String EXPRESSION_REGEX = "^\\$\\{(\\s*.+\\s*)\\}$";
    private static final String NOT_EXPRESSION_REGEX = "^\\$\\{\\s*!\\((.+)\\)\\s*\\}$";
    private Log log = LogFactory.getLog(this.getClass());
    private static final String NEED_UPDATED_COND_IDS = "conditionIds";
    private static final String CALLBACK_VALIDATE_TIPS = "validate_tips";
    private static final String OPENTYPE = "openType";
    private static final String CONTEXT = "context";
    private static final String PROCDEFID = "procDefId";
    private static final String NOTEMPTY = "!empty";
    private static final String CACHE_UNIONENTRYS = "unionEntrys";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String BTN_CONDITIONRULETIPS = "btn_conditionruletips";

    @Override
    public void initialize() {
        this.addClickListeners(new String[]{CANCELBTN, HISTORYBTN, CONFIRMBTN, CLEAR_EXIT_BTN, BTN_CONDITIONRULETIPS});
        this.addItemClickListeners(new String[]{TOOLBAR, ADVCONTOOLBARAP});
        this.getWfConditionUpd().addCustomListListener((ItemClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey().toLowerCase()) {
            case "historybtn": {
                this.showHistoricCondRule(key);
                break;
            }
            case "confirmbtn": {
                this.confirm();
                break;
            }
            case "cancelbtn": {
                this.cancel();
                break;
            }
            case "clearandexit": {
                this.clearAndExit();
                break;
            }
            case "btn_conditionruletips": {
                this.showConditionRuleTips();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if ("onConditionChange".equals(evt.getOperationKey())) {
            List<Map<String, Object>> itemsValue = this.getWfConditionUpd().getValue();
            String isDefaultScheme = (String)this.getView().getFormShowParameter().getCustomParam("isDefaultScheme");
            if ("true".equals(isDefaultScheme) && evt.getParamsMap() != null) {
                this.recordSchemeCondItemIds(evt.getParamsMap());
            }
            this.setExpression(itemsValue);
            return;
        }
        switch (key = evt.getItemKey()) {
            case "addline": {
                this.addLine();
                break;
            }
            case "copycondition": {
                this.copyConditionRule();
                break;
            }
            case "pastecondition": {
                this.pasteConditionRule();
                break;
            }
        }
    }

    private void copyConditionRule() {
        String experssion = (String)this.getModel().getValue(EXPRESSION);
        if (StringUtils.isBlank((CharSequence)experssion)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"ConditionalRulePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            this.getWfConditionUpd().copyCondition();
        }
    }

    private void pasteConditionRule() {
        this.getWfConditionUpd().pasteCondition();
    }

    private void recordSchemeCondItemIds(Map<String, Object> paramsMap) {
        Map changedData = (Map)paramsMap.get("changedData");
        String type = (String)changedData.get("type");
        boolean changed = false;
        block5 : switch (type) {
            case "expression": {
                Map value = (Map)changedData.get(VALUE);
                Map oldValue = (Map)changedData.get("oldValue");
                if (value == null || oldValue == null || value.size() != oldValue.size()) break;
                for (Map.Entry entry : value.entrySet()) {
                    String key = (String)entry.getKey();
                    if (((String)entry.getValue()).equals(oldValue.get(key))) continue;
                    changed = true;
                    break block5;
                }
                break;
            }
            case "valuetype": {
                if (changedData.get(VALUE).equals(changedData.get("oldValue"))) break;
                changed = true;
                break;
            }
            case "comparetype": {
                ArrayList<String> oneOperators = new ArrayList<String>();
                oneOperators.add("empty");
                oneOperators.add("notempty");
                String val = (String)changedData.get(VALUE);
                String oldVal = (String)changedData.get("oldValue");
                if ((!oneOperators.contains(val) || oneOperators.contains(oldVal)) && (!oneOperators.contains(oldVal) || oneOperators.contains(val))) break;
                changed = true;
                break;
            }
        }
        if (changed) {
            String id = (String)changedData.get("id");
            String ids = this.getPageCache().get(NEED_UPDATED_COND_IDS);
            if (ids == null) {
                ids = "";
                this.getPageCache().put(NEED_UPDATED_COND_IDS, id);
            } else if (id != null && ids.indexOf(id) < 0) {
                this.getPageCache().put(NEED_UPDATED_COND_IDS, String.format("%s,%s", ids, id));
            }
        }
    }

    private void addLine() {
        this.getWfConditionUpd().addCondition();
    }

    private void setExpression(List<Map<String, Object>> itemsValue) {
        this.getModel().setValue(EXPRESSION, (Object)this.getExpressionFromWfCondition(itemsValue));
    }

    public void afterCreateNewData(EventObject evt) {
        try {
            FormShowParameter params = this.getView().getFormShowParameter();
            String openType = (String)params.getCustomParam(OPENTYPE);
            if (WfUtils.isEmpty((String)openType)) {
                this.initPageForWorkflowDesigner(params);
            } else if ("billRule".equals(openType)) {
                this.initPageForBillSubject(params);
            } else if ("subscription".equals(openType)) {
                this.log.debug("subscription\u8ba2\u9605\u9875\u9762\u521d\u59cb\u5316\u6761\u4ef6\u89c4\u5219");
                this.initPageForSubscription(params);
                Long pkValue = (Long)this.getView().getParentView().getModel().getDataEntity().getPkValue();
                if (0L != pkValue) {
                    this.getView().setVisible(Boolean.valueOf(!ConditionalRulePlugin.judgePreinsData("evt_subscription", pkValue)), new String[]{CONFIRMBTN});
                }
            } else {
                this.initPageForManageCenter(params);
            }
            this.initUnionEntrys();
            String express = (String)this.getModel().getValue(EXPRESSION);
            if (WfUtils.isNotEmpty((String)express)) {
                String unionRule = null;
                if (express.contains("entryAnyOne")) {
                    unionRule = "entryAnyOne";
                } else if (express.contains("entryUnion")) {
                    unionRule = "entryUnion";
                }
                if (WfUtils.isNotEmpty((String)unionRule) && unionRule != null) {
                    this.getModel().setValue("entryunion", (Object)true);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"unionrule", "actionentry"});
                    this.getModel().setValue("unionrule", (Object)unionRule);
                    int index = express.indexOf(44);
                    int length = unionRule.length() + 1;
                    String newExpression = express.substring(index + 1, express.length() - 1);
                    this.getModel().setValue(EXPRESSION, (Object)newExpression);
                    String entryKey = express.substring(length, index);
                    this.getModel().setValue("actionentry", (Object)entryKey);
                }
            }
        }
        catch (Exception e) {
            this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219\u9875\u9762\u521d\u59cb\u5316\u51fa\u9519\u3002", (String)"ConditionalRulePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]) + " " + e.getMessage());
        }
    }

    private void initUnionEntrys() {
        String entityId = this.getPageCache().get("entityId");
        String entityNumber = MetadataDao.getNumberById((String)entityId);
        if (WfUtils.isEmpty((String)entityNumber)) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Iterator iter = entityType.getAllEntities().values().iterator();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        StringBuilder entrys = new StringBuilder();
        String expression = (String)this.getModel().getValue(EXPRESSION);
        boolean enable = false;
        while (iter.hasNext()) {
            EntityType fieldProp = (EntityType)iter.next();
            if (WfUtils.isEmpty((String)fieldProp.getAlias()) || entityNumber.equals(fieldProp.getName()) || fieldProp instanceof LinkEntryType || fieldProp instanceof SubEntryType) continue;
            String entryKey = fieldProp.getName();
            if (!enable) {
                enable = WfUtils.isNotEmpty((String)expression) && expression.contains(String.format("model.%s.", entryKey));
            }
            entrys.append(entryKey).append(',');
            ComboItem item = new ComboItem();
            item.setValue(entryKey);
            item.setCaption(fieldProp.getDisplayName());
            items.add(item);
        }
        if (!items.isEmpty()) {
            ComboEdit fieldCombo = (ComboEdit)this.getControl("actionentry");
            fieldCombo.setComboItems(items);
            this.getPageCache().put(CACHE_UNIONENTRYS, entrys.toString());
        }
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"entryunion"});
    }

    private void initPageForWorkflowDesigner(FormShowParameter params) {
        Map extendData = (Map)params.getCustomParam(CONTEXT);
        String modelJson = extendData.get("model").toString();
        this.getView().setVisible(Boolean.FALSE, new String[]{HISTORYBTN, PROCESSVERSION, VALIDTIME});
        BpmnModel bpmnModel = null;
        try {
            bpmnModel = DesignerModelUtil.getBpmnModel(modelJson);
        }
        catch (Exception e) {
            this.logger.debug("get BpmnModel from json failed! " + WfUtils.getExceptionStacktrace((Throwable)e));
            return;
        }
        Object value = params.getCustomParam(VALUE);
        Map rule = null;
        if (value != null) {
            if (value instanceof String) {
                if (WfUtils.isNotEmpty((String)value.toString())) {
                    rule = (Map)SerializationUtils.fromJsonString((String)value.toString(), Map.class);
                }
            } else {
                rule = (Map)value;
            }
        }
        Map nodeProperties = (Map)extendData.get("nodeProperties");
        String elementId = nodeProperties.get("itemId").toString();
        if (ProcessType.BizFlow.name().equals(bpmnModel.getMainProcess().getProcessType())) {
            String entityNumber = ConditionalRuleUtil.getEntryBillNumber(bpmnModel.getMainProcess(), elementId, false);
            this.cacheEntityId(MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form));
        } else {
            this.cacheEntityId(bpmnModel.getMainProcess().getEntraBillId());
        }
        if (rule != null && !rule.isEmpty()) {
            this.initConditionalRule(rule, bpmnModel);
            String isDefaultScheme = (String)this.getView().getFormShowParameter().getCustomParam("isDefaultScheme");
            if ("true".equals(isDefaultScheme)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"schemetip"});
            }
        } else {
            String type = extendData.get("type").toString();
            this.init(type, bpmnModel, elementId);
        }
    }

    private void initPageForBillSubject(FormShowParameter params) {
        Map extendData = (Map)params.getCustomParam(CONTEXT);
        this.getView().setVisible(Boolean.FALSE, new String[]{HISTORYBTN, PROCESSVERSION, VALIDTIME});
        this.cacheEntityId((String)params.getCustomParam("entityId"));
        Object value = params.getCustomParam(VALUE);
        Map rule = null;
        if (value != null && WfUtils.isNotEmpty((String)((String)value))) {
            rule = (Map)SerializationUtils.fromJsonString((String)((String)value), Map.class);
        }
        if (rule != null && !rule.isEmpty()) {
            this.initConditionalRule(rule, null);
        } else {
            String type = extendData.get("type").toString();
            this.init(type, null, "");
        }
    }

    private void initPageForManageCenter(FormShowParameter params) {
        ProcessConfigEntity processConfig;
        String type = (String)params.getCustomParam("type");
        Long procDefId = (Long)params.getCustomParam(PROCDEFID);
        Long procInstId = (Long)params.getCustomParam("procInstId");
        BpmnModel bpmnModel = this.getRepositoryService().getBpmnModel(procDefId, procInstId);
        String elementId = (String)params.getCustomParam("nodeid");
        String condRuleId = (String)params.getCustomParam(CONDRULEID);
        if (ConditionalRuleType.processStartUp.toString().equals(type) && (processConfig = this.getRepositoryService().getProcessConfigByProcDefId(procDefId)) != null) {
            condRuleId = String.valueOf(processConfig.getCondRuleId());
        }
        this.getPageCache().put(CONDRULEID, condRuleId);
        String openTye = (String)this.getView().getFormShowParameter().getCustomParam(OPENTYPE);
        String rule = (String)params.getCustomParam(VALUE);
        ConditionalRuleEntity condRule = null;
        if ("managermentCenter".equals(openTye) && WfUtils.isNotEmpty((String)rule)) {
            condRule = ConditionalRuleConvertUtil.jsonToConditionalRuleModel((String)rule);
        } else if (WfUtils.isNotEmpty((String)condRuleId)) {
            condRule = this.getRepositoryService().getConditionalRuleById(Long.valueOf(condRuleId));
        }
        if (condRule != null) {
            this.initConditionalRule(condRule, bpmnModel);
            this.getPageCache().put(CONDRULEID, condRule.getId() != null ? String.valueOf(condRule.getId()) : null);
        } else {
            this.init(type, bpmnModel, elementId);
        }
        this.cacheEntityId(bpmnModel.getMainProcess().getEntraBillId());
    }

    private void initPageForSubscription(FormShowParameter params) {
        this.getModel().setValue(SHOWTEXT, (Object)ResManager.loadKDString((String)"\u6267\u884c\u6761\u4ef6", (String)"ConditionalRulePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        this.getView().setEnable(Boolean.FALSE, new String[]{SHOWTEXT, CONDITIONTYPE});
        this.cacheEventNumber((String)params.getCustomParam("eventnumber"));
        Map extendData = (Map)params.getCustomParam(CONTEXT);
        this.getView().setVisible(Boolean.FALSE, new String[]{HISTORYBTN, PROCESSVERSION, VALIDTIME});
        this.cacheEntityId((String)params.getCustomParam("entityId"));
        Object value = params.getCustomParam(VALUE);
        Map rule = null;
        if (value != null && WfUtils.isNotEmpty((String)((String)value))) {
            rule = (Map)SerializationUtils.fromJsonString((String)((String)value), Map.class);
        }
        if (rule != null && !rule.isEmpty()) {
            this.log.debug("\u521d\u59cb\u5316\u5df2\u8bbe\u7f6e\u7684\u6761\u4ef6\u89c4\u5219\uff1a%s", (Object)rule);
            this.initConditionalRule(rule, null);
        } else {
            String type = extendData.get("type").toString();
            this.init(type, null, "");
        }
    }

    private void init(String type, BpmnModel bpmnModel, String elementId) {
        this.setFieldDefaultVal(type, bpmnModel, elementId);
        this.initControl(type, bpmnModel);
    }

    private void setFieldDefaultVal(String type, BpmnModel bpmnModel, String elementId) {
        IDataModel model = this.getModel();
        model.setValue("type", (Object)type);
        if (bpmnModel != null) {
            model.setValue(PROCESSNAME, (Object)bpmnModel.getMainProcess().getName());
            model.setValue(PROCESSVERSION, (Object)bpmnModel.getMainProcess().getVersion());
        }
        model.setValue(ELEMENTID, (Object)elementId);
        this.getPageCache().put("type", type);
    }

    private void initControl(String type, BpmnModel bpmnModel) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object plugin = model.getValue("plugin");
        if (plugin != null && WfUtils.isNotEmpty((String)plugin.toString())) {
            model.setValue(CONDITIONTYPE, (Object)"plugin");
            view.setVisible(Boolean.FALSE, new String[]{CONDRULEPANEL});
            view.setVisible(Boolean.TRUE, new String[]{PLUGINPANEL, PLACEHOLDER_LEFT, PLACEHOLDER_RIGHT});
            this.openExtItfInContainer();
        } else {
            model.setValue(CONDITIONTYPE, (Object)CONDITIONTYPE_CONDITION);
            view.setVisible(Boolean.FALSE, new String[]{PLUGINPANEL});
        }
        IConditionalRule rule = ConditionalRuleFactory.getConditionalRule(type);
        rule.initializePage(model, view, bpmnModel);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (propName) {
            case "conditiontype": {
                this.switchType(newValue.toString());
                break;
            }
            case "defaultcondition": {
                this.switchDefaultCondition(Boolean.valueOf(newValue.toString()));
                break;
            }
            case "entryunion": {
                this.getView().setVisible((Boolean)newValue, new String[]{"unionrule", "actionentry"});
                break;
            }
            case "unionrule": {
                if (newValue != null && !WfUtils.isEmptyString((Object)newValue)) break;
                this.getModel().setValue("actionentry", null);
                break;
            }
            case "expression": {
                String entryKeys = this.getPageCache().get(CACHE_UNIONENTRYS);
                String expression = (String)newValue;
                if (!WfUtils.isNotEmpty((String)entryKeys)) break;
                String[] entryItems = entryKeys.split(",");
                boolean containsEntry = false;
                for (String entryItem : entryItems) {
                    if (!WfUtils.isNotEmpty((String)entryItem) || !expression.contains(String.format("%s.%s.", "model", entryItem))) continue;
                    containsEntry = true;
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(containsEntry), new String[]{"entryunion"});
                if (containsEntry) break;
                this.getModel().setValue("entryunion", (Object)false);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"unionrule", "actionentry"});
            }
        }
    }

    private void switchType(String type) {
        IFormView view = this.getView();
        if (CONDITIONTYPE_CONDITION.equals(type)) {
            this.getModel().setValue("plugin", null);
            view.setVisible(Boolean.FALSE, new String[]{PLUGINPANEL, PLACEHOLDER_LEFT, PLACEHOLDER_RIGHT});
            view.setVisible(Boolean.TRUE, new String[]{CONDRULEPANEL});
            view.setVisible(Boolean.TRUE, new String[]{BTN_CONDITIONRULETIPS});
        } else {
            this.getWfConditionUpd().deleteAll();
            this.getModel().setValue(EXPRESSION, null);
            view.setVisible(Boolean.FALSE, new String[]{CONDRULEPANEL});
            view.setVisible(Boolean.TRUE, new String[]{PLUGINPANEL, PLACEHOLDER_LEFT, PLACEHOLDER_RIGHT});
            view.setVisible(Boolean.FALSE, new String[]{BTN_CONDITIONRULETIPS});
            this.openExtItfInContainer();
        }
    }

    private void openExtItfInContainer() {
        String pageId = this.getPageCache().get("pageId");
        if (pageId == null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(VALUE, this.getModel().getValue("plugin"));
            FormShowParameter parameter = this.getShowParameter("externalInterface", "wf_external_interface");
            parameter.setShowTitle(false);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(CONTAINER_EXT_ITF);
            parameter.setCustomParam("entityId", (Object)this.getPageCache().get("entityId"));
            parameter.setCustomParam("data", data);
            parameter.setCustomParam("types", (Object)ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"}));
            this.getView().showForm(parameter);
            this.getPageCache().put("pageId", parameter.getPageId());
        } else {
            ExtItfPluginUtil.invokeResetMethod(this.getView(), pageId, null);
        }
    }

    private void switchDefaultCondition(Boolean defaultCondition) {
        if (defaultCondition.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONDRULEPANEL, PLUGINPANEL});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONDITIONTYPE, SHOWTEXT});
            this.getModel().setValue(SHOWTEXT, (Object)ResManager.loadKDString((String)"\u7f3a\u7701\u6761\u4ef6\u5206\u652f", (String)"ConditionalRulePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            String conditionType = (String)this.getModel().getValue(CONDITIONTYPE);
            if (CONDITIONTYPE_CONDITION.equals(conditionType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CONDRULEPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CONDITIONRULETIPS});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{PLUGINPANEL});
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{CONDITIONTYPE, SHOWTEXT});
            this.getModel().setValue(SHOWTEXT, null);
        }
    }

    public Object confirm() {
        IFormView view = this.getView();
        String result = this.validateRequiredField();
        if (!Boolean.TRUE.equals(this.getModel().getValue(DEFAULTCONDITION)) && WfUtils.isEmpty((String)result)) {
            if (this.isPluginCondition()) {
                String extItfResult;
                String pageId = this.getPageCache().get("pageId");
                IFormView formView = this.getView();
                if (ConditionalRuleType.participant.toString().equals(this.getPageCache().get("type"))) {
                    formView = this.getView().getParentView();
                }
                if (WfUtils.isEmpty((String)(extItfResult = ExtItfPluginUtil.invokeConfirmMethod(this.getView(), pageId, new Object[]{formView})))) {
                    return null;
                }
                this.getModel().setValue("plugin", (Object)extItfResult);
            } else {
                result = ConditionalRuleHelper.validateExpression((String)((String)this.getModel().getValue(EXPRESSION)), this.getWfConditionUpd().getValue());
            }
        }
        FormShowParameter params = this.getView().getFormShowParameter();
        String openType = (String)params.getCustomParam(OPENTYPE);
        if (result != null) {
            if (!WfUtils.isEmpty((String)openType) && ConditionalRuleType.participant.toString().equals(this.getPageCache().get("type"))) {
                return result;
            }
            view.showTipNotification(result, Integer.valueOf(3000));
            return null;
        }
        if (WfUtils.isEmpty((String)openType) || "billRule".equals(openType) || "subscription".equals(openType)) {
            this.logger.debug("openType :" + openType);
            Map<String, Object> condRule = this.getConditionalRule();
            this.logger.debug("condRule :" + condRule);
            String isDefaultScheme = (String)params.getCustomParam("isDefaultScheme");
            if ("true".equals(isDefaultScheme)) {
                String defSchemeId = (String)params.getCustomParam("schemeId");
                Map ret = this.getRepositoryService().validateChildrenSchemesConditions(Long.valueOf(defSchemeId), condRule);
                if (!ret.isEmpty()) {
                    ArrayList<String> msgs = new ArrayList<String>(ret.size());
                    for (Map.Entry entry : ret.entrySet()) {
                        msgs.add(String.format(ResManager.loadKDString((String)"[\u5b50\u65b9\u6848] %1s\uff1a%2s", (String)"ConditionalRulePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), entry.getKey(), entry.getValue()));
                    }
                    DesignerModelUtil.showValidateResult(this, msgs, ResManager.loadKDString((String)"\u5b50\u65b9\u6848\u6761\u4ef6\u89c4\u5219\u6821\u9a8c\u7ed3\u679c", (String)"ConditionalRulePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4fee\u6539\u540e\u4f1a\u5bfc\u81f4\u4ee5\u4e0b\u95ee\u9898\uff0c\u786e\u8ba4\u4fee\u6539\uff1f", (String)"ConditionalRulePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), "scheme_condition_validate");
                    return null;
                }
            } else if (!"subscription".equals(openType)) {
                boolean openedByScheme = false;
                IFormView parentView = view.getParentView();
                while (parentView != null && (parentView = parentView.getParentView()) != null && !"pc_main_console".equals(parentView.getFormShowParameter().getFormId())) {
                    if (!"wf_processconfig_scheme".equals(parentView.getFormShowParameter().getFormId())) continue;
                    openedByScheme = true;
                    break;
                }
                if (openedByScheme) {
                    BpmnDiffUtil.markAsIndependent(condRule);
                }
            }
            this.logger.debug("condRule :" + condRule);
            this.logger.debug("parentPageid :" + this.getView().getParentView().getPageId());
            return this.designerConfirm(condRule);
        }
        return this.manageCenterConfirm();
    }

    public void cancel() {
        this.getView().close();
    }

    public void clearAndExit() {
        boolean isManagerCenter = "managermentCenter".equals(this.getView().getFormShowParameter().getCustomParam(OPENTYPE));
        this.getView().returnDataToParent(isManagerCenter ? this.getPageCache().get(CONDRULEID) : new HashMap());
        this.confirmClose();
    }

    public void confirmClose() {
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private Object designerConfirm(Map<String, Object> rule) {
        Map extendData = (Map)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        rule.put(PROPERTY, extendData.get(PROPERTY).toString());
        List entrys = (List)rule.get(ENTRY);
        String expression = (String)rule.get(EXPRESSION);
        String newExPression = this.formatUnionExpression(expression, entrys, null);
        if (newExPression == null) {
            return null;
        }
        if (WfUtils.isNotEmpty((String)newExPression)) {
            this.logger.debug(expression + "--->" + newExPression);
            rule.put(EXPRESSION, newExPression);
        }
        this.getView().returnDataToParent(rule);
        this.logger.debug("PageId:" + this.getView().getParentView().getPageId());
        this.confirmClose();
        return null;
    }

    private String formatUnionExpression(String expression, List<Map<String, Object>> rules, List<ConditionalEntity> ruleEntrys) {
        boolean enableEntryUnion = (Boolean)this.getModel().getValue("entryunion");
        if (WfUtils.isNotEmpty((String)expression) && enableEntryUnion) {
            String actionEntry = (String)this.getModel().getValue("actionentry");
            if (WfUtils.isEmpty((String)actionEntry)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8054\u5408\u8fd0\u7b97\u4f5c\u7528\u5206\u5f55\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5206\u5f55\u6216\u53d6\u6d88\u52fe\u9009\u201c\u5206\u5f55\u5b57\u6bb5\u8fdb\u884c\u8054\u5408\u8fd0\u7b97\u201d\u3002", (String)"ConditionalRulePlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return null;
            }
            String unionRule = (String)this.getModel().getValue("unionrule");
            if (WfUtils.isEmpty((String)unionRule)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u5206\u5f55\u5b57\u6bb5\u8fdb\u884c\u8054\u5408\u8fd0\u7b97\uff0c\u8bf7\u9009\u62e9\u8054\u5408\u8fd0\u7b97\u89c4\u5219\u6216\u4e0d\u52fe\u9009\u3002", (String)"ConditionalRulePlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return null;
            }
            String actionEntryMark = String.format("model.%s.", actionEntry);
            if (expression.contains(actionEntryMark)) {
                String tip = ResManager.loadKDString((String)"\u8be5\u5206\u5f55\u4e2d\u4f7f\u7528\u4e86\u51fd\u6570\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u8054\u5408\u8fd0\u7b97\u3002", (String)"ConditionalRulePlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                if (rules != null && !rules.isEmpty()) {
                    for (Map<String, Object> entryItem : rules) {
                        String itemExpress = (String)entryItem.get(PARAMNUMBER);
                        if (itemExpress.indexOf(actionEntryMark) <= 1) continue;
                        this.getView().showTipNotification(tip, Integer.valueOf(3000));
                        return null;
                    }
                } else if (ruleEntrys != null && ruleEntrys.isEmpty()) {
                    for (ConditionalEntity rule : ruleEntrys) {
                        String itemExpress = rule.getParamnumber();
                        if (itemExpress.indexOf(actionEntryMark) <= 1) continue;
                        this.getView().showTipNotification(tip, Integer.valueOf(3000));
                        return null;
                    }
                }
                String newExpression = String.format("%s(%s,%s)", unionRule, actionEntry, expression);
                return newExpression;
            }
            String entityId = this.getPageCache().get("entityId");
            String entityNumber = MetadataDao.getNumberById((String)entityId);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityType fieldProp = (EntityType)entityType.getAllEntities().get(actionEntry);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u201c%s\u201d\u4e0d\u5728\u6761\u4ef6\u8868\u8fbe\u5f0f\u4e2d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8005\u5173\u95ed\u201c\u5206\u5f55\u5b57\u6bb5\u8fdb\u884c\u8054\u5408\u8fd0\u7b97\u201d\u5f00\u5173\u3002", (String)"ConditionalRulePlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), fieldProp.getDisplayName()), Integer.valueOf(3000));
            return null;
        }
        return "";
    }

    private Object manageCenterConfirm() {
        FormShowParameter params = this.getView().getFormShowParameter();
        String condRuleId = this.getPageCache().get(CONDRULEID);
        ConditionalRuleEntity condRule = this.getCondRuleModel(WfUtils.isNotEmpty((String)condRuleId) ? Long.valueOf(condRuleId) : null);
        condRule.setProcdefid((Long)params.getCustomParam(PROCDEFID));
        String type = this.getPageCache().get("type");
        String expression = condRule.getExpression();
        String newExpression = this.formatUnionExpression(expression, null, condRule.getEntryentity());
        if (newExpression == null) {
            return null;
        }
        if (WfUtils.isNotEmpty((String)newExpression)) {
            this.logger.debug(expression + "--->" + newExpression);
            condRule.setExpression(newExpression);
        }
        if (ConditionalRuleType.processStartUp.toString().equals(type)) {
            this.getManagementService().updateStartUpConditionalRule((Long)params.getCustomParam(PROCDEFID), condRule, false, "");
            String condition = WfUtils.isNotEmpty((String)condRule.getExpression()) ? condRule.getExpression() : condRule.getPlugin();
            WfUtils.addOpLog((String)"wf_conditionalrule", (String)"setStartUpConditionalRule", (MultiLangEnumBridge)new MultiLangEnumBridge("\u8bbe\u7f6e\u542f\u52a8\u6761\u4ef6", "ConditionalRulePlugin_7", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6761\u4ef6\u89c4\u5219ID: %1$s \u6d41\u7a0b\u5b9a\u4e49ID: %2$s \u8868\u8fbe\u5f0f\u6216\u63d2\u4ef6: %3$s", "ConditionalRulePlugin_8", "bos-wf-formplugin"), (Object[])new Object[]{condRule.getId(), condRule.getProcdefid(), condition});
            IFormView parentView = this.getView().getParentView();
            parentView.updateView("billlistap");
            this.getView().sendFormAction(parentView);
            this.confirmClose();
            return null;
        }
        if (WfUtils.isEmpty((String)condRuleId)) {
            condRule.setProperty((String)params.getCustomParam(PROPERTY));
        }
        if (ConditionalRuleType.participant.toString().equals(type)) {
            return condRule;
        }
        this.getView().returnDataToParent((Object)ConditionalRuleConvertUtil.conditionalRuleToJson((ConditionalRuleEntity)condRule));
        this.confirmClose();
        return null;
    }

    private void showHistoricCondRule(String key) {
        IDataModel model = this.getModel();
        String condRuleId = this.getPageCache().get(CONDRULEID);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CONDRULEID, condRuleId);
        params.put("type", ConditionalRuleType.getTypeName((String)model.getValue("type").toString()));
        params.put("processName", model.getValue(PROCESSNAME));
        params.put("processVersion", model.getValue(PROCESSVERSION));
        this.showForm(key, "wf_hiconditionalrule", params);
    }

    private boolean isPluginCondition() {
        Object conditionType = this.getModel().getValue(CONDITIONTYPE);
        return conditionType != null && "plugin".equals(conditionType.toString());
    }

    private String validateRequiredField() {
        Object showText = this.getModel().getValue(SHOWTEXT);
        if (showText == null || WfUtils.isEmpty((String)showText.toString())) {
            return ResManager.loadKDString((String)"\u663e\u793a\u6587\u5b57\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConditionalRulePlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private String getExpressionFromWfCondition(List<Map<String, Object>> itemsValue) {
        return ConditionalRuleHelper.getConditionExpression(itemsValue);
    }

    private void initConditionalRule(Map<String, Object> rule, BpmnModel bpmnModel) {
        IDataModel model = this.getModel();
        Object showText = this.getCompatibleShowText(rule.get(SHOWTEXT));
        model.setValue(SHOWTEXT, showText);
        model.setValue("type", rule.get("type"));
        model.setValue(DESCRIPTION, rule.get(DESCRIPTION));
        Object vTime = rule.get(VALIDTIME);
        if (vTime instanceof Long) {
            model.setValue(VALIDTIME, (Object)new Timestamp((Long)vTime));
        } else {
            model.setValue(VALIDTIME, vTime);
        }
        model.setValue(ELEMENTID, rule.get(ELEMENTID));
        String expression = null;
        if (WfUtils.isNotEmptyString((Object)rule.get(EXPRESSION))) {
            expression = rule.get(EXPRESSION).toString();
            expression = expression.replaceAll("(\\.id)?\\s+BR", ".mc_wfRole CL").replaceAll("(\\.id)?\\s+BO", ".mc_org CL").replaceAll("(\\.id)?\\s+BS", ".mc_bsOrg CL").replaceAll("(\\.id)?\\s+CS", ".mc_csOrg CL");
            expression = expression.replaceAll(NOTEMPTY, "notempty");
            model.setValue(EXPRESSION, (Object)expression);
        } else {
            model.setValue(EXPRESSION, rule.get(EXPRESSION));
        }
        model.setValue("plugin", rule.get("plugin"));
        this.init((String)rule.get("type"), bpmnModel, (String)rule.get(ELEMENTID));
        List conditionals = (List)rule.get(ENTRY);
        if (conditionals == null || conditionals.isEmpty()) {
            return;
        }
        if (expression != null && expression.matches("\\$\\{\\s*!\\(.+\\)\\s*\\}") && (WfUtils.isEmptyString(((Map)conditionals.get(0)).get(LEFTBRACKET)) || !((Map)conditionals.get(0)).get(LEFTBRACKET).toString().contains("!"))) {
            if (WfUtils.isEmptyString(((Map)conditionals.get(0)).get(LEFTBRACKET))) {
                ((Map)conditionals.get(0)).put(LEFTBRACKET, "!(");
            } else {
                ((Map)conditionals.get(0)).put(LEFTBRACKET, "!(" + ((Map)conditionals.get(0)).get(LEFTBRACKET).toString().trim());
            }
            if (WfUtils.isEmptyString(((Map)conditionals.get(conditionals.size() - 1)).get(RIGHTBRACKET))) {
                ((Map)conditionals.get(conditionals.size() - 1)).put(RIGHTBRACKET, ")");
            } else {
                String lastRight = ((Map)conditionals.get(conditionals.size() - 1)).get(RIGHTBRACKET).toString().trim();
                ((Map)conditionals.get(conditionals.size() - 1)).put(RIGHTBRACKET, lastRight + ")");
            }
        }
        try {
            this.getWfConditionUpd().setValue(ConditionalRuleHelper.getConditionItems((List)conditionals));
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(e.getLocalizedMessage());
        }
    }

    private List<Map<String, Object>> getConditionItemsFromEntity(List<ConditionalEntity> conditionals) {
        ArrayList<Map<String, Object>> conditionItems = new ArrayList<Map<String, Object>>(conditionals.size());
        for (ConditionalEntity conditional : conditionals) {
            String valueStr;
            HashMap<String, Object> item = new HashMap<String, Object>(7);
            item.put(LEFTBRACKET, conditional.getLeftbracket());
            String compareType = conditional.getOperation();
            if (WfUtils.isNotEmptyString((Object)compareType)) {
                String expression;
                if (NOTEMPTY.equals(compareType)) {
                    item.put("comparetype", "notempty");
                    item.put(EXPRESSION, conditional.getParamnumber());
                } else if ("BR".equals(compareType)) {
                    if (WfUtils.isNotEmptyString((Object)conditional.getParamnumber())) {
                        expression = conditional.getParamnumber();
                        expression = expression.endsWith(".id") ? expression.replace(".id", ".mc_wfRole") : expression + ".mc_wfRole";
                        item.put(EXPRESSION, expression);
                        item.put("comparetype", "CL");
                    }
                } else if ("BO".equals(compareType)) {
                    if (WfUtils.isNotEmptyString((Object)conditional.getParamnumber())) {
                        expression = conditional.getParamnumber();
                        expression = expression.endsWith(".id") ? expression.replace(".id", ".mc_org") : expression + ".mc_org";
                        item.put(EXPRESSION, expression);
                        item.put("comparetype", "CL");
                    }
                } else if ("BS".equals(compareType)) {
                    if (WfUtils.isNotEmptyString((Object)conditional.getParamnumber())) {
                        expression = conditional.getParamnumber();
                        expression = expression.endsWith(".id") ? expression.replace(".id", ".mc_bsOrg") : expression + ".mc_bsOrg";
                        item.put(EXPRESSION, expression);
                        item.put("comparetype", "CL");
                    }
                } else if ("CS".equals(compareType)) {
                    if (WfUtils.isNotEmptyString((Object)conditional.getParamnumber())) {
                        expression = conditional.getParamnumber();
                        expression = expression.endsWith(".id") ? expression.replace(".id", ".mc_csOrg") : expression + ".mc_csOrg";
                        item.put(EXPRESSION, expression);
                        item.put("comparetype", "CL");
                    }
                } else {
                    item.put(EXPRESSION, conditional.getParamnumber());
                    item.put("comparetype", compareType);
                }
            } else {
                item.put(EXPRESSION, conditional.getParamnumber());
                item.put("comparetype", compareType);
            }
            item.put("id", conditional.getId());
            item.put("logaic", conditional.getLogic());
            item.put(RIGHTBRACKET, conditional.getRightbracket());
            item.put(VALUETYPE, conditional.getValuetype());
            String value = conditional.getValue();
            if (value != null && WfUtils.isNotEmpty((String)(valueStr = value.toString()))) {
                item.put(VALUE, conditional.getValue());
                if (valueStr.startsWith("[")) {
                    item.put(VALUE, SerializationUtils.fromJsonString((String)valueStr, List.class));
                } else if (valueStr.startsWith("{")) {
                    item.put(VALUE, SerializationUtils.fromJsonString((String)valueStr, Map.class));
                } else {
                    item.put(VALUE, value);
                }
            }
            conditionItems.add(item);
        }
        return conditionItems;
    }

    private void initConditionalRule(ConditionalRuleEntity rule, BpmnModel bpmnModel) {
        if (rule == null) {
            return;
        }
        IDataModel model = this.getModel();
        ILocaleString showText = rule.getShowtext();
        if (showText != null && WfUtils.isEmpty((String)showText.getLocaleValue())) {
            showText.setLocaleValue(showText.toString());
        }
        model.setValue(SHOWTEXT, (Object)showText);
        model.setValue("type", (Object)rule.getType());
        ILocaleString description = rule.getDescription();
        if (description != null && WfUtils.isEmpty((String)description.getLocaleValue())) {
            description.setLocaleValue(description.toString());
        }
        model.setValue(DESCRIPTION, (Object)description);
        model.setValue(VALIDTIME, (Object)rule.getValidtime());
        model.setValue(ELEMENTID, (Object)rule.getElementid());
        String expression = rule.getExpression();
        if (WfUtils.isNotEmpty((String)expression)) {
            expression = expression.replaceAll("(\\.id)?\\s+BR", ".mc_wfRole CL").replaceAll("(\\.id)?\\s+BO", ".mc_org CL").replaceAll("(\\.id)?\\s+BS", ".mc_bsOrg CL").replaceAll("(\\.id)?\\s+CS", ".mc_csOrg CL");
            expression = expression.replaceAll(NOTEMPTY, "notempty");
            model.setValue(EXPRESSION, (Object)expression);
        }
        model.setValue("plugin", (Object)rule.getPlugin());
        model.setValue(VERSION, (Object)rule.getVersion());
        this.cacheEntityId(bpmnModel.getMainProcess().getEntraBillId());
        this.init(rule.getType(), bpmnModel, rule.getElementid());
        List conditionals = rule.getEntryentity();
        if (conditionals == null || conditionals.isEmpty()) {
            return;
        }
        this.getWfConditionUpd().setValue(this.getConditionItemsFromEntity(conditionals));
    }

    private Map<String, Object> getConditionalRule() {
        IDataModel model = this.getModel();
        HashMap<String, Object> ruleData = new HashMap<String, Object>();
        ILocaleString showText = (ILocaleString)model.getValue(SHOWTEXT);
        for (Lang lang : WfUtils.getSupportLangs()) {
            if (showText == null || !WfUtils.isEmpty((String)((String)showText.get((Object)lang.toString())))) continue;
            showText.setItem(lang.toString(), (Object)showText.toString());
        }
        ruleData.put(SHOWTEXT, showText);
        ruleData.put("type", model.getValue("type"));
        ruleData.put(DESCRIPTION, model.getValue(DESCRIPTION));
        ruleData.put(VALIDTIME, model.getValue(VALIDTIME));
        ruleData.put(ELEMENTID, model.getValue(ELEMENTID));
        if (!CONDITIONTYPE_CONDITION.equals(model.getValue(CONDITIONTYPE).toString())) {
            ruleData.put("plugin", model.getValue("plugin"));
            return ruleData;
        }
        ruleData.put(EXPRESSION, model.getValue(EXPRESSION));
        ruleData.put(ENTRY, this.getConditionalItemsValue());
        return ruleData;
    }

    private List<Map<String, Object>> getConditionItemsValueForConfirm() {
        String[] idArr;
        String idStr;
        ArrayList<String> ids;
        List<Map<String, Object>> itemValues = this.getWfConditionUpd().getValue();
        if (!itemValues.isEmpty()) {
            ArrayList<Map<String, Object>> noIdItems = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> item : itemValues) {
                if (!StringUtils.isBlank((Object)item.get("id"))) continue;
                noIdItems.add(item);
            }
            if (!noIdItems.isEmpty()) {
                int size = noIdItems.size();
                ids = BpmnDiffUtil.getOrderedConditionEntityIds((int)size);
                for (int i = 0; i < size; ++i) {
                    ((Map)noIdItems.get(i)).put("id", ids.get(i));
                }
            }
        }
        if (WfUtils.isNotEmpty((String)(idStr = this.getPageCache().get(NEED_UPDATED_COND_IDS))) && (idArr = idStr.split(",")).length > 0) {
            ids = new ArrayList<String>(idArr.length);
            for (String id : idArr) {
                ids.add(id);
            }
            block3: for (Map map : itemValues) {
                if (ids.isEmpty()) break;
                for (int i = ids.size() - 1; i >= 0; --i) {
                    String id;
                    id = (String)ids.get(i);
                    if (!WfUtils.isNotEmpty((String)id) || !id.equals(map.get("id"))) continue;
                    map.put("id", BpmnDiffUtil.getListElementId((String)ENTRY));
                    ids.remove(i);
                    continue block3;
                }
            }
        }
        return itemValues;
    }

    private List<Map<String, Object>> getConditionalItemsValue() {
        List<Map<String, Object>> itemValues = this.getConditionItemsValueForConfirm();
        ArrayList<Map<String, Object>> conditionals = new ArrayList<Map<String, Object>>();
        if (itemValues != null && !itemValues.isEmpty()) {
            HashMap<String, Object> conditional = null;
            int i = 0;
            for (Map<String, Object> itemValue : itemValues) {
                Object expressionObj = itemValue.get(EXPRESSION);
                String expression = "";
                if (expressionObj instanceof String) {
                    expression = expressionObj.toString();
                    Pattern pattern = Pattern.compile("value=([\\w\\.]+)");
                    Matcher matcher = pattern.matcher(expression);
                    if (matcher.find()) {
                        expression = matcher.group(1);
                    }
                } else if (expressionObj instanceof Map) {
                    Map expressionMap = (Map)expressionObj;
                    expression = (String)expressionMap.get(VALUE);
                }
                conditional = new HashMap<String, Object>();
                if (itemValue.get("id") != null) {
                    conditional.put("id", itemValue.get("id"));
                }
                conditional.put(LEFTBRACKET, itemValue.get(LEFTBRACKET));
                conditional.put(PARAMNUMBER, expression);
                conditional.put(OPERATION, itemValue.get("comparetype"));
                Object value = itemValue.get(VALUE);
                if (value != null) {
                    if (!(value instanceof String)) {
                        conditional.put(VALUE, SerializationUtils.toJsonString((Object)value));
                    } else {
                        conditional.put(VALUE, value);
                    }
                }
                conditional.put(SEQ, i);
                conditional.put(RIGHTBRACKET, itemValue.get(RIGHTBRACKET));
                conditional.put(VALUETYPE, itemValue.get(VALUETYPE));
                conditional.put(LOGIC, itemValue.get("logaic"));
                conditional.put(ISHIDEEXP, itemValue.get(ISHIDEEXP) == null ? Boolean.valueOf(false) : itemValue.get(ISHIDEEXP));
                conditionals.add(conditional);
                ++i;
            }
        }
        return conditionals;
    }

    private Object getCompatibleShowText(Object showText) {
        String st = null;
        String regex = "\\{(\"\\w+\":(false|true),?){1,}\\}";
        if (showText instanceof JSONObject && (st = showText.toString()).matches(regex)) {
            try {
                showText = JSONUtils.cast((String)st.replaceAll("(false|true)", "\"$1\""), JSONObject.class);
            }
            catch (IOException e) {
                this.log.error(String.format("\u6761\u4ef6\u89c4\u5219\u663e\u793a\u6587\u5b57\u517c\u5bb9\u5904\u7406\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
            }
        }
        return showText;
    }

    private ConditionalRuleEntity getCondRuleModel(Long condRuleId) {
        ILocaleString description;
        IDataModel model = this.getModel();
        Object condRule = null;
        condRule = condRuleId != null && condRuleId != 0L ? (ConditionalRuleEntity)this.getRepositoryService().findEntityById(condRuleId, "wf_conditionalrule") : new ConditionalRuleEntityImpl();
        ILocaleString showText = (ILocaleString)model.getValue(SHOWTEXT);
        if (showText != null && !WfUtils.isEmpty((String)showText.toString())) {
            condRule.setShowtext(showText);
        }
        if (model.getValue("type") != null) {
            condRule.setType(model.getValue("type").toString());
        }
        if ((description = (ILocaleString)model.getValue(DESCRIPTION)) != null && !WfUtils.isEmpty((String)description.toString())) {
            condRule.setDescription(description);
        }
        if (model.getValue(ELEMENTID) != null) {
            condRule.setElementid(model.getValue(ELEMENTID).toString());
        }
        if (model.getValue(VERSION) != null) {
            condRule.setVersion(model.getValue(VERSION).toString());
        }
        if (CONDITIONTYPE_CONDITION.equals(model.getValue(CONDITIONTYPE).toString())) {
            if (model.getValue(EXPRESSION) != null) {
                condRule.setExpression(model.getValue(EXPRESSION).toString());
                condRule.setPlugin(null);
            }
        } else {
            if (model.getValue("plugin") != null) {
                condRule.setPlugin(model.getValue("plugin").toString());
                condRule.setExpression(null);
                condRule.setEntryentity(null);
            }
            return condRule;
        }
        List<Map<String, Object>> itemValues = this.getConditionItemsValueForConfirm();
        ArrayList<ConditionalEntityImpl> conditionals = new ArrayList<ConditionalEntityImpl>();
        if (itemValues != null && !itemValues.isEmpty()) {
            int i = 0;
            for (Map<String, Object> itemValue : itemValues) {
                Object val = itemValue.get(VALUE);
                if (val instanceof List) {
                    val = SerializationUtils.toJsonString((Object)val);
                } else if (val instanceof Map) {
                    val = SerializationUtils.toJsonString((Object)val);
                }
                conditionals.add(new ConditionalEntityImpl(condRule.getId(), ConditionalRulePlugin.getStrVal(itemValue.get(LEFTBRACKET)), ConditionalRulePlugin.getStrVal(itemValue.get(EXPRESSION)), ConditionalRulePlugin.getStrVal(itemValue.get("comparetype")), ConditionalRulePlugin.getStrVal(val), ConditionalRulePlugin.getStrVal(itemValue.get(RIGHTBRACKET)), ConditionalRulePlugin.getStrVal(itemValue.get("logaic")), ConditionalRulePlugin.getStrVal(itemValue.get(VALUETYPE)), ConditionalRulePlugin.getStrVal(itemValue.get("entitynumber")), i));
                ++i;
            }
        }
        condRule.setEntryentity(conditionals);
        return condRule;
    }

    public static String getStrVal(Object val) {
        if (WfUtils.isNotEmptyString((Object)val)) {
            return val.toString();
        }
        return "";
    }

    private WfConditionUpd getWfConditionUpd() {
        return (WfConditionUpd)this.getControl("wfconditionupdap");
    }

    private void cacheEntityId(String entityId) {
        this.getPageCache().put("entityId", entityId);
    }

    private void cacheEventNumber(String eventNumber) {
        this.getPageCache().put("eventnumber", eventNumber);
    }

    @Override
    public void confirmResult(IFormView validateView) {
        validateView.close();
        this.designerConfirm(this.getConditionalRule());
        validateView.sendFormAction(this.getView());
    }

    @Override
    public void initValidateResultPage(IFormView validateView) {
        validateView.setVisible(Boolean.TRUE, new String[]{"btncancel"});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("type");
        this.getPageCache().remove("pageId");
        this.getPageCache().remove("entityId");
        this.getPageCache().remove(NEED_UPDATED_COND_IDS);
    }

    public static boolean judgePreinsData(String entityName, Object id) {
        DynamicObject dyObj = QueryServiceHelper.queryOne((String)entityName, (String)"ispreinsdata,ismodified", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        return dyObj.getBoolean("ispreinsdata") && dyObj.getBoolean("ismodified");
    }

    private void showConditionRuleTips() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wf_conditionrule_tips");
        formShowParameter.setShowTitle(true);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6761\u4ef6\u8fd0\u7b97\u89c4\u5219", (String)"ConditionalRulePlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParam("wf_conditionruletips_content", (Object)"wf_conditionruletips_content");
        this.getView().showForm(formShowParameter);
    }
}

