/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.WfUtils;

public class DrawParameterListPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String PARAMNAME = "paramname";
    private static final String PARAMVALUE = "paramvalue";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (BTNOK.equals(key)) {
            this.returnData();
        }
    }

    public void afterCreateNewData(EventObject e) {
        JSONObject parameters;
        Object parametersObject = this.getView().getFormShowParameter().getCustomParams().get("drawParameter");
        if (WfUtils.isNotEmptyString(parametersObject) && (parameters = (JSONObject)SerializationUtils.fromJsonString((String)parametersObject.toString(), JSONObject.class)).size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, parameters.size());
            int index = 0;
            for (Map.Entry entrySet : parameters.entrySet()) {
                this.getModel().setValue(PARAMNAME, entrySet.getKey(), index);
                this.getModel().setValue(PARAMVALUE, entrySet.getValue(), index);
                ++index;
            }
        }
    }

    private void returnData() {
        DynamicObjectCollection dycs = this.getModel().getEntryEntity(ENTRYENTITY);
        JSONObject map = new JSONObject();
        for (DynamicObject dyc : dycs) {
            String key = dyc.getString(PARAMNAME).trim();
            String value = dyc.getString(PARAMVALUE).trim();
            if (WfUtils.isEmpty((String)key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570\u540d\u201d\u3002", (String)"DrawParameterListPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (WfUtils.isEmpty((String)value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570\u503c\u201d\u3002", (String)"DrawParameterListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            map.put(key, (Object)value);
        }
        this.getView().returnDataToParent((Object)map);
        this.getView().close();
    }
}

