/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.StartItem;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import org.apache.commons.io.FilenameUtils;

public class ExportModelSQLUtil {
    protected static Log logger = LogFactory.getLog(ExportModelSQLUtil.class);
    protected IFormView view;
    private RepositoryService repositoryService;
    private static final String SELECT = "SELECT ";
    private static final String DELETEFROM = "  DELETE FROM ";
    private static final String GEBYTEARRAY = "t_wf_gebytearray";
    private static final String GEBYTEARRAY_L = "t_wf_gebytearray_l";
    private static final String DOCUMENTLINE = "-- ----------------------------\n\r";
    private static final String ENDLINE = "';\n\r";
    private static final String CATEGORY_ID = "10000";
    private static final String STARTDIVIDINGLINE = "-- --------------------------------START-DIVIDING-LINE-----------------------------------\n\r";
    private static final String ENDDIVIDINGLINE = "-- --------------------------------END-DIVIDING-LINE-----------------------------------\n\n\r";
    private SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ExportModelSQLUtil() {
        logger.debug("Parameterless construction");
    }

    public ExportModelSQLUtil(IFormView formView, RepositoryService repositoryService) {
        this.view = formView;
        this.repositoryService = repositoryService;
    }

    public IFormView getView() {
        return this.view;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public boolean createSQL(String modelId) {
        StringBuilder sb = new StringBuilder();
        String filelds = "FID, FBUSINESSID, FVERSION, FMODIFYDATE, FPNGID, FTYPE, FOPERATION, FCREATEDATE, FNUMBER, FDEPLOYMENTID, FBPMNXMLID, FGRAPHID, FENTRABILL, FPARENTPROCID, FMODIFIERID, FORGUNITID, FCATEGORY, FCREATORID, FENTRABILLID, FPUBLISH";
        String sql = SELECT + filelds + " FROM t_wf_model WHERE fid='" + modelId + "'";
        List<Map<String, String>> list = this.getTableCloumnsInfo(sql);
        if (WfUtils.isEmptyForCollection(list) || WfUtils.isEmptyForMap(list.get(0))) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\u7684\u6d41\u7a0b\u5bfc\u51fa\u9519\u8bef\u3002", (String)"WorkflowModelManagePlugin_51", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"SQL\u5bfc\u51fa", (String)"WorkflowModelManagePlugin_36", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        String modelNumber = list.get(0).get("FNUMBER");
        String proccateId = list.get(0).get("FCATEGORY");
        String bpmnxmlId = list.get(0).get("FBPMNXMLID");
        if (WfUtils.isEmpty((String)proccateId)) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u6d41\u7a0b\u5bfc\u51fa\u9519\u8bef\uff0c\u65e0\u6cd5\u5206\u7c7b\u3002", (String)"WorkflowModelManagePlugin_35", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"SQL\u5bfc\u51fa", (String)"WorkflowModelManagePlugin_36", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (WfUtils.isEmpty((String)bpmnxmlId)) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u6d41\u7a0b\u5bfc\u51fa\u9519\u8bef\uff0c\u8bf7\u5148\u4fdd\u5b58\u8d44\u6e90\u8868\u3002", (String)"WorkflowModelManagePlugin_37", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"SQL\u5bfc\u51fa", (String)"WorkflowModelManagePlugin_36", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (list.get(0).containsKey("FPUBLISH")) {
            list.get(0).put("FPUBLISH", "0");
        }
        String returnSQL = this.createTableInsertSQL("t_wf_model", list);
        sb.append(returnSQL);
        filelds = "FID, FPKID, FLOCALEID, FDESCRIPTION, FNAME";
        sql = SELECT + filelds + " FROM t_wf_model_l WHERE fid='" + modelId + "'";
        list = this.getTableCloumnsInfo(sql);
        returnSQL = this.createTableInsertSQL("t_wf_model_l", list);
        sb.append(returnSQL);
        sb.append(DOCUMENTLINE).append("-- Records of t_wf_proccate\n\r").append(DOCUMENTLINE);
        sb.append("  update t_wf_model set fcategory = ").append(CATEGORY_ID).append(" where fid = ").append(modelId).append(";\n\r\n\r");
        filelds = "FID, FCONTENT, FGENERATED, FNAME, FDEPLOYMENTID, FCURRENTLANGUAGE";
        sql = SELECT + filelds + " FROM t_wf_gebytearray WHERE fid = '" + bpmnxmlId + "'";
        list = this.getTableCloumnsInfo(sql);
        returnSQL = this.createTableInsertSQL(GEBYTEARRAY, list);
        sb.append(returnSQL);
        filelds = "FID, FPKID, FLOCALEID, FCONTENT";
        sql = SELECT + filelds + " FROM t_wf_gebytearray_l WHERE fid = '" + bpmnxmlId + "'";
        list = this.getTableCloumnsInfo(sql);
        returnSQL = this.createTableInsertSQL(GEBYTEARRAY_L, list);
        sb.append(returnSQL);
        this.createMbillSumarySQL(modelId, sb);
        return this.packeZipAndExportSQLFile(sb.toString(), modelNumber, bpmnxmlId);
    }

    private void createMbillSumarySQL(String modelId, StringBuilder sb) {
        String returnSQL = null;
        String filelds = "FID, FNUMBER, FSTATUS, FENABLE, FMASTERID, FBILLTYPE, FSUMMARYTPL, FCREATORID, FMODIFIERID, FCREATETIME, FMODIFYTIME, FDEFAULTROWS, FDEFAULTDATAROWS, FTPLNAME, FNAME, FSCENE";
        String sql = null;
        BpmnModel bpmn = PluginUtil.getBpmnModelByModelId(Long.parseLong(modelId), this.repositoryService);
        if (bpmn != null && bpmn.getMainProcess() != null) {
            Process process = bpmn.getMainProcess();
            String entityNumber = process.getEntraBill();
            if (ModelType.BizFlow.name().equals(process.getProcessType())) {
                List startItems = process.getStartItems();
                if (startItems != null && !startItems.isEmpty()) {
                    StringBuilder entitys = new StringBuilder();
                    for (int i = 0; i < startItems.size(); ++i) {
                        entitys.append('\'').append(((StartItem)startItems.get(i)).getEntitynumber()).append('\'');
                        if (i >= startItems.size() - 1) continue;
                        entitys.append(",");
                    }
                    entityNumber = entitys.toString();
                }
                sql = SELECT + filelds + " FROM t_wf_mbillsummarycfg WHERE FBILLTYPE IN (" + entityNumber + ") AND FENABLE = '1' AND FSUMMARYTPL IN ('bpm_billrelation_cardtpl','bpm_billrelation_stkcard','bpm_floatlayertpl_default','bpm_billsummary_default') ORDER BY FMODIFYTIME DESC";
            } else {
                entityNumber = '\'' + entityNumber + '\'';
                sql = SELECT + filelds + " FROM t_wf_mbillsummarycfg WHERE FBILLTYPE IN (" + entityNumber + ") AND FENABLE = '1' AND FSUMMARYTPL IN ('wf_mbillsummary_common') ORDER BY FMODIFYTIME DESC";
            }
            List<Map<String, String>> list = this.getTableCloumnsInfo(sql);
            if (list != null && !list.isEmpty()) {
                ArrayList<Map<String, String>> tempList = new ArrayList<Map<String, String>>(8);
                HashSet<String> records = new HashSet<String>(list.size());
                for (Map<String, String> map : list) {
                    String key = String.format("%s%s", map.get("FBILLTYPE"), map.get("FSUMMARYTPL"));
                    if (records.contains(key)) continue;
                    records.add(key);
                    sb.append(STARTDIVIDINGLINE);
                    sb.append(this.createAnnotation("t_wf_mbillsummarycfg, FNUMBER = " + map.get("FNUMBER")));
                    tempList.clear();
                    tempList.add(map);
                    sb.append(this.createTableInsertSQL("t_wf_mbillsummarycfg", tempList));
                    String billSummaryId = map.get("FID");
                    sql = "SELECT FPKID, FID, FLOCALEID, FNAME FROM t_wf_mbillsummarycfg_l WHERE fid = " + billSummaryId;
                    List<Map<String, String>> multilanguageList = this.getTableCloumnsInfo(sql);
                    returnSQL = this.createTableInsertSQL("t_wf_mbillsummarycfg_l", multilanguageList);
                    sb.append(returnSQL);
                    filelds = "FID, FENTRYID, FSEQ, FENTRYLOCATION, FENTRYLOCATIONID, FFIELDKEY, FISHEADFIELD, FFIELDTYPE, FFIELDPERCEN, FFONTCOLOR, FFONTSIZE, FFIELDID, FISDEFAULTSHOW, FFIELDNAME, FENTRYLOCATIONNAME, FEDITABLE, FSHOWCONTENT, FCONTENT, FAGGREGATEFUNCTION";
                    sql = SELECT + filelds + " FROM t_wf_mbillsumarycfgentry WHERE fid = " + billSummaryId;
                    List<Map<String, String>> entryList = this.getTableCloumnsInfo(sql);
                    if (entryList != null && !entryList.isEmpty()) {
                        sb.append(DELETEFROM).append("t_wf_mbillsumarycfgentry WHERE fid = ").append(billSummaryId).append(";\n\r");
                        for (Map<String, String> entryMap : entryList) {
                            sb.append(this.createAnnotation("t_wf_mbillsumarycfgentry, FFIELDKEY = " + entryMap.get("FFIELDKEY")));
                            tempList.clear();
                            tempList.add(entryMap);
                            sb.append(this.createTableInsertSQL("t_wf_mbillsumarycfgentry", tempList));
                            String billSummaryEntryId = entryMap.get("FENTRYID");
                            sql = "SELECT FPKID, FENTRYID, FLOCALEID, FFIELDNAME, FENTRYLOCATIONNAME FROM t_wf_mbillsumarycfgentry_l WHERE fentryid = " + billSummaryEntryId;
                            multilanguageList = this.getTableCloumnsInfo(sql);
                            returnSQL = this.createTableInsertSQL("t_wf_mbillsumarycfgentry_l", multilanguageList);
                            sb.append(returnSQL);
                        }
                    }
                    sb.append(ENDDIVIDINGLINE);
                }
            }
        }
    }

    protected List<Map<String, String>> getTableCloumnsInfo(String sql) {
        return (List)DB.query((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List>(){

            public List<Map<String, String>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>(8);
                while (rs.next()) {
                    HashMap<String, String> items = new HashMap<String, String>(8);
                    int fieldCount = rs.getMetaData().getColumnCount();
                    for (int i = 1; i <= fieldCount; ++i) {
                        items.put(rs.getMetaData().getColumnName(i), rs.getString(i));
                    }
                    rows.add(items);
                }
                return rows;
            }
        });
    }

    protected String createTableInsertSQL(String tableName, List<Map<String, String>> list) {
        StringBuilder sb = new StringBuilder(DOCUMENTLINE);
        sb.append("-- Records of ").append(tableName).append("\n\r");
        sb.append(DOCUMENTLINE);
        for (Map<String, String> items : list) {
            if (tableName.endsWith("_l")) {
                sb.append(DELETEFROM).append(tableName).append(" WHERE fpkid='").append(items.get("FPKID")).append(ENDLINE);
            } else if (!tableName.endsWith("entry")) {
                sb.append(DELETEFROM).append(tableName).append(" WHERE fid='").append(items.get("FID")).append(ENDLINE);
            }
            StringBuilder insert = new StringBuilder();
            StringBuilder values = new StringBuilder();
            insert.append("  INSERT INTO ").append(tableName).append(" (");
            values.append(" VALUES (");
            Set<Map.Entry<String, String>> entrySet = items.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String key = entry.getKey();
                insert.append(key).append(", ");
                String value = entry.getValue();
                if (value == null) {
                    values.append(value).append(", ");
                    continue;
                }
                if ("".equals(value)) {
                    values.append("' ', ");
                    continue;
                }
                if ((GEBYTEARRAY_L.equals(tableName) || GEBYTEARRAY.equals(tableName)) && "FCONTENT".equals(key)) {
                    values.append("' ', ");
                    continue;
                }
                if ("FMODIFYDATE".equals(key) || "FCREATEDATE".equals(key) || "FCREATETIME".equals(key) || "FMODIFYTIME".equals(key)) {
                    try {
                        Date date = this.sf.parse(value);
                        values.append("{ts'").append(this.sf.format(date)).append("'}, ");
                    }
                    catch (ParseException e) {
                        logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                    }
                    continue;
                }
                values.append("'").append(value).append("', ");
            }
            insert.append(")");
            values.append(");\n\r\n\r");
            sb.append(insert.toString().replace(", )", ")")).append(values.append("\n\r").toString().replace(", )", ")"));
        }
        return sb.toString();
    }

    private String createAnnotation(String annotation) {
        StringBuilder sb = new StringBuilder(DOCUMENTLINE);
        sb.append("-- Records of ").append(annotation).append("\n\r");
        sb.append(DOCUMENTLINE);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean packeZipAndExportSQLFile(String sqlContent, String filename, String bpmnxmlId) {
        String path = System.getProperty("user.home") + File.separator + "ExportModelSQL";
        String localPath = path + File.separator + RequestContext.get().getTraceId();
        File localFile = new File(FilenameUtils.getName((String)localPath));
        if (!localFile.exists()) {
            localFile.mkdirs();
        }
        String zipFilename = filename + ".zip";
        String fullPath = WfUtils.checkPath((String)(localPath + File.separator + zipFilename));
        File zipFile = new File(FilenameUtils.getName((String)fullPath));
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            String fileDirectory = String.format("preinsdata%s%s.sql", File.separator, filename);
            this.putFilesToZipPackage(new ByteArrayInputStream(sqlContent.getBytes()), fileDirectory, out);
            String resourceSQL = String.format("%s_res", filename);
            this.putLongTextToZipPackage(resourceSQL, GEBYTEARRAY, "FID,FCONTENT", bpmnxmlId, out);
            String localeResourceSQL = String.format("%s_res_locale", filename);
            this.putLongTextToZipPackage(localeResourceSQL, GEBYTEARRAY_L, "FID,FCONTENT", bpmnxmlId, out);
            this.putWfConfigToZipPackage(filename, out);
        }
        catch (IOException e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"SQL\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a%s", (String)"WorkflowModelManagePlugin_46", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            if (localFile.exists()) {
                ExportModelSQLUtil.deleteFile(localFile);
            }
            return false;
        }
        String downloadFile = WfUtils.checkPath((String)(localPath + File.separator + zipFilename));
        try (FileInputStream in = new FileInputStream(FilenameUtils.getName((String)downloadFile));){
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipFilename, (InputStream)in, 5000);
            this.getView().openUrl(url);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            if (localFile.exists()) {
                ExportModelSQLUtil.deleteFile(localFile);
            }
        }
        return true;
    }

    protected void putFilesToZipPackage(InputStream inputStream, String fileDirectory, ZipOutputStream out) {
        try (BufferedInputStream in = new BufferedInputStream(inputStream);){
            ZipEntry entry = new ZipEntry(fileDirectory);
            entry.setMethod(8);
            out.putNextEntry(entry);
            int n = 0;
            byte[] buf = new byte[1024];
            while ((n = in.read(buf)) != -1) {
                out.write(buf, 0, n);
            }
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private void putLongTextToZipPackage(String sqlFileName, String tableName, String fields, String fid, ZipOutputStream out) {
        PreInsDataScriptBuilder builder;
        Map insertSQLScript;
        Object longTextData;
        if (WfUtils.isNotEmpty((String)fid) && (longTextData = (insertSQLScript = (builder = new PreInsDataScriptBuilder()).genInsertSQLScript(DBRoute.workflow, tableName, fields, "FID=" + fid, "", "")).get("xml")) != null) {
            int index = 1;
            HashMap longTextDataFile = (HashMap)longTextData;
            int size = longTextDataFile.size();
            for (Map.Entry entry : longTextDataFile.entrySet()) {
                String filename = String.format("%s.xml", sqlFileName);
                if (size > 1) {
                    filename = String.format("%s_%s.xml", sqlFileName, index++);
                }
                StringWriter stringWriter = (StringWriter)entry.getValue();
                byte[] barray = stringWriter.toString().getBytes();
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(barray);
                    Throwable throwable = null;
                    try {
                        String fileDirectory = String.format("preinsdata%sxml%s%s", File.separator, File.separator, filename);
                        this.putFilesToZipPackage(inputStream, fileDirectory, out);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)inputStream).close();
                    }
                }
                catch (Exception e) {
                    logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                }
            }
        }
    }

    protected void putWfConfigToZipPackage(String sqlFileName, ZipOutputStream out) {
        StringBuilder wfConfig = new StringBuilder();
        wfConfig.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
        wfConfig.append("<DataModel dympath=\"metadata\" xmlpath=\"preinsdata/xml\">").append("\n");
        wfConfig.append(String.format("    <SqlScript Type=\"KSQL\" Separator=\";\" dbkey=\"wf\">preinsdata/%s.sql</SqlScript>", sqlFileName)).append("\n");
        wfConfig.append("</DataModel>");
        this.putFilesToZipPackage(new ByteArrayInputStream(wfConfig.toString().getBytes()), "wf.xml", out);
    }

    public static void deleteFile(File file) {
        if (!file.isDirectory() && !file.delete()) {
            logger.debug(String.format("\u6587\u4ef6filename:[%s], \u5220\u9664\u5931\u8d25\u3002", file.getName()));
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory() && !delfile.delete()) {
                    logger.debug(String.format("\u6587\u4ef6\u5939directory:[%s], \u6587\u4ef6filename:[%s], \u5220\u9664\u5931\u8d25\u3002", file.getName(), delfile.getName()));
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                ExportModelSQLUtil.deleteFile(fileList[i]);
            }
            if (!file.delete()) {
                logger.debug(String.format("\u6587\u4ef6\u5939directory:[%s], \u5220\u9664\u5931\u8d25\u3002", file.getName()));
            }
        }
    }

    public static String genInsertSQLScript(String fromfield, String selectField, String wherefield, String orderfield) {
        return ExportModelSQLUtil.genInsertSQLScript(fromfield, selectField, wherefield, orderfield, null);
    }

    private static String genInsertSQLScript(String fromfield, String selectField, String wherefield, String orderfield, String textfield) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = null;
        try {
            if (WfUtils.isEmpty((String)fromfield) || WfUtils.isEmpty((String)selectField)) {
                return null;
            }
            map = builder.genInsertSQLScript(DBRoute.workflow, fromfield, selectField, wherefield, orderfield, textfield);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("genInsertSQLScript Error:%s.", e.getMessage())});
        }
        if (null == map || map.isEmpty()) {
            return null;
        }
        return (String)map.get("sql");
    }

    public static void exportFile(String sql, String sqlFileName, IFormView formView) {
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8));){
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, (InputStream)ins, 5000);
            formView.openUrl(url);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("exportFile error:%s.", e.getMessage())});
        }
    }
}

