/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.deploy.DeployModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.model.ImportDataInfo;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.DesignerEntity;
import kd.bos.workflow.engine.impl.util.ImportExportProcessUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class ImportModelPlugin
extends AbstractWorkflowPlugin
implements UploadListener,
IConfirmCallBack {
    private Set<String> existUrls = new HashSet<String>();
    private Set<String> existModelNumbers = new HashSet<String>();
    private static final String FILE_MAP = "_file_map_";
    private static final String FILE_LIST = "_file_list_";
    private static final String EXIST_FILE_LIST = "_exist_file_list_";
    private static final String EXIST_FILE_NAME = "_exist_file_name_";
    private static final String PROCESS_DIFFERENT_BILL = "process_different_bill";
    private boolean isCallBackOperation = false;
    private boolean isCallBackCoverSummary = false;
    protected Boolean isCoverSummaryCfg;
    private static final String COVER_IMPORT_MBSUMMARYCFG = "coverImportMBSummaryCfg";
    private DcxmlSerializer serializer;

    public ImportModelPlugin() {
        this.initSerializer();
    }

    private void initSerializer() {
        this.serializer = new DcxmlSerializer(this.getDCBinder());
        this.serializer.setColloctionIgnorePKValue(true);
    }

    protected DcBinder getDCBinder() {
        return DeployModel.getDCBinder();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(FILE_LIST);
        List<String> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        String mapStr = this.getPageCache().get(FILE_MAP);
        Map<String, String> fileMap = WfUtils.isEmpty((String)mapStr) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)mapStr, Map.class);
        for (Object url : evt.getUrls()) {
            Map map = (Map)url;
            String urlStr = (String)map.get("url");
            filelist.add(urlStr);
            fileMap.put(urlStr, (String)map.get("name"));
        }
        this.getPageCache().put(FILE_LIST, SerializationUtils.serializeToBase64(filelist));
        this.getPageCache().put(FILE_MAP, SerializationUtils.toJsonString(fileMap));
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(FILE_LIST);
        List filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        String mapStr = this.getPageCache().get(FILE_MAP);
        Map fileMap = WfUtils.isEmpty((String)mapStr) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)mapStr, Map.class);
        for (Object url : evt.getUrls()) {
            Map map = (Map)url;
            String urlStr = (String)map.get("url");
            filelist.remove(urlStr);
            fileMap.remove(urlStr);
        }
        this.getPageCache().put(FILE_LIST, SerializationUtils.serializeToBase64(filelist));
        this.getPageCache().put(FILE_MAP, SerializationUtils.toJsonString(fileMap));
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            this.importNoExistData();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        MessageBoxResult result = evt.getResult();
        if (MessageBoxResult.Cancel.equals((Object)result)) {
            return;
        }
        if (!MessageBoxResult.Yes.equals((Object)result) && !evt.getCallBackId().equals(COVER_IMPORT_MBSUMMARYCFG)) {
            this.emptyExistFileListCache();
            this.emptyExistFileNameCache();
            return;
        }
        switch (evt.getCallBackId()) {
            case "existData": {
                String diffBillProcs = this.getPageCache().get(PROCESS_DIFFERENT_BILL);
                if (WfUtils.isNotEmpty((String)diffBillProcs)) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6d41\u7a0b\u7ed1\u5b9a\u7684\u5355\u636e\u4e0e\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ImportModelPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), diffBillProcs), MessageBoxOptions.YesNo, new ConfirmCallBackListener("differentBill"));
                    break;
                }
                this.isCallBackOperation = true;
                this.importExistData();
                this.emptyExistFileListCache();
                this.emptyExistFileNameCache();
                break;
            }
            case "differentBill": {
                this.isCallBackOperation = true;
                this.importExistData();
                this.emptyExistFileListCache();
                this.emptyExistFileNameCache();
                break;
            }
            case "coverImportMBSummaryCfg": {
                this.isCallBackCoverSummary = true;
                this.isCoverSummaryCfg = Boolean.FALSE;
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.isCoverSummaryCfg = Boolean.TRUE;
                }
                this.importNoExistData();
                break;
            }
        }
    }

    private void importExistData() {
        String cacheExistUrls = this.getPageCache().get(EXIST_FILE_LIST);
        if (StringUtils.isBlank((CharSequence)cacheExistUrls)) {
            return;
        }
        Set filelist = (Set)SerializationUtils.deSerializeFromBase64((String)cacheExistUrls);
        if (filelist == null || filelist.isEmpty()) {
            return;
        }
        boolean hasException = false;
        List<String> processNumbers = null;
        try {
            processNumbers = this.importData(filelist);
        }
        catch (Exception e) {
            this.handleExceptionCondition(e);
            hasException = true;
        }
        if (!hasException) {
            this.getView().returnDataToParent(processNumbers);
            this.getView().close();
        }
    }

    private void importNoExistData() {
        String cacheUrls = this.getPageCache().get(FILE_LIST);
        if (StringUtils.isBlank((CharSequence)cacheUrls)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\uff0c\u6216\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"ImportModelPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        List filelist = (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        if (filelist == null || filelist.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\uff0c\u6216\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"ImportModelPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean hasException = false;
        List<String> processNumbers = null;
        try {
            processNumbers = this.importData(filelist);
        }
        catch (Exception e) {
            this.handleExceptionCondition(e);
            hasException = true;
        }
        if (!hasException && this.existModelNumbers.isEmpty()) {
            this.getView().returnDataToParent(processNumbers);
            this.getView().close();
        }
    }

    private void handleExceptionCondition(Exception e) {
        if (e instanceof KDBizException) {
            ErrorCode errorCode;
            Object[] args;
            Throwable throwable = ((KDBizException)((Object)e)).getCause();
            String procNumber = "";
            if (throwable instanceof KDBizException && (args = ((KDBizException)throwable).getArgs()) != null && args.length > 0) {
                procNumber = args[0].toString();
            }
            if ((errorCode = ((KDBizException)((Object)e)).getErrorCode()) != null && "bos.wf.sameEntityMobileBillSummaryCfgExist".equals(errorCode.getCode())) {
                String message = String.format(ResManager.loadKDString((String)"\u662f\u5426\u8986\u76d6\u6d41\u7a0b%1s\u4e2d\u7684\u201c\u5355\u636e\u6458\u8981%2s\u201d\uff1f\u8986\u76d6\u540e\u5176\u4ed6\u5f15\u7528\u8be5\u5355\u636e\u6458\u8981\u7684\u6d41\u7a0b\u5c06\u4f7f\u7528\u5bfc\u51fa\u540e\u7684\u65b0\u5355\u636e\u6458\u8981\u3002", (String)"ImportModelPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), procNumber, errorCode.getMessage());
                this.getView().showConfirm(message, MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener(COVER_IMPORT_MBSUMMARYCFG));
            } else if (errorCode != null && "bos.wf.notSameEntityMobileBillSummaryCfgExist".equals(errorCode.getCode())) {
                String errorNotification = String.format(ResManager.loadKDString((String)"\u6d41\u7a0b%1s\u4e2d\u7684%2s\uff0c\u4e0d\u80fd\u5bfc\u5165\uff0c\u8bf7\u4fee\u6539\u7f16\u7801\u540e\u518d\u5c1d\u8bd5\u5bfc\u5165\u3002", (String)"ImportModelPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), procNumber, errorCode.getMessage());
                this.getView().showErrorNotification(errorNotification);
            } else {
                this.getView().showErrorNotification(e.getMessage());
                this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        } else {
            this.getView().showErrorNotification(e.getMessage());
            this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> importData(Collection<String> filelist) {
        boolean isZipEntryEmpty = true;
        String zipFileName = "";
        ArrayList<ImportDataInfo> importDatas = new ArrayList<ImportDataInfo>(filelist.size());
        Map fileMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(FILE_MAP), Map.class);
        ArrayList<String> processNumbers = new ArrayList<String>(10);
        try {
            for (String url : filelist) {
                zipFileName = (String)fileMap.get(url);
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                InputStream inputStream = null;
                try {
                    inputStream = cache.getInputStream(url);
                    ZipInputStream zipIn = new ZipInputStream((InputStream)new BufferedInputStream(inputStream), Charset.forName("GBK"));
                    Throwable throwable = null;
                    try {
                        ZipEntry zipEntry = null;
                        while ((zipEntry = zipIn.getNextEntry()) != null) {
                            isZipEntryEmpty = false;
                            String fileName = zipEntry.getName();
                            if (!this.isValidFileSuffix(fileName)) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1s\u4e2d\u7684\u6587\u4ef6%2s\u4e0d\u5408\u6cd5\u3002", (String)"ImportModelPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFileName, fileName));
                            }
                            String content = this.getModelFileContent(zipIn);
                            if (WfUtils.isEmpty((String)content)) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1s\u7684%2s\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportModelPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFileName, fileName));
                            }
                            DeployModel deployModel = (DeployModel)this.serializer.deserializeFromString(content, null);
                            if (deployModel == null) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6\u201c%s\u201d\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u662f\u5426\u4e3a\u6709\u6548\u7684process\u6587\u4ef6\u3002", (String)"ImportModelPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), fileName));
                            }
                            importDatas.add(new ImportDataInfo(url, zipFileName, fileName, deployModel));
                        }
                        if (!isZipEntryEmpty) continue;
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e2d\u7684\u6d41\u7a0b\u6587\u4ef6\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ImportModelPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFileName));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (zipIn == null) continue;
                        if (throwable != null) {
                            try {
                                zipIn.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        zipIn.close();
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
                    }
                }
            }
            this.checkAndDeployModels(importDatas, processNumbers);
        }
        catch (KDBizException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            throw new KDBizException((Throwable)e, e.getErrorCode(), new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ImportNodetTemplatePlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        return processNumbers;
    }

    protected boolean isValidFileSuffix(String fileName) {
        return fileName.endsWith(".process");
    }

    protected List<DynamicObject> getMainModels(DeployModel deployModel) {
        return deployModel.getModels();
    }

    protected String getEntityFormId() {
        return "wf_model";
    }

    protected String getNumberField() {
        return "key";
    }

    protected String getEntityNumberField() {
        return "entrabill";
    }

    protected String getEntityIdField() {
        return "entrabillid_id";
    }

    protected String getProcessTypeField() {
        return "type";
    }

    protected String getEntraBill(DynamicObject mainModel) {
        return mainModel.getString(this.getEntityNumberField());
    }

    protected String getEntraBillId(DynamicObject mainModel) {
        return mainModel.getString(this.getEntityIdField());
    }

    private Map<String, String> getEntityNumberByModelNumber(List<String> numbers) {
        QFilter[] filters = new QFilter[]{new QFilter(this.getNumberField(), "in", numbers)};
        List entities = this.getRepositoryService().findEntitiesByFilters(this.getEntityFormId(), filters, String.format("%s,%s", this.getNumberField(), this.getEntityNumberField()), null);
        if (entities.isEmpty()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(entities.size());
        for (DesignerEntity entity : entities) {
            map.put(entity.getNumber(), entity.getEntityNumber());
        }
        return map;
    }

    private String getModelFileContent(ZipInputStream zipIn) throws IOException {
        StringBuilder content = new StringBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int len = 0;
        while ((len = zipIn.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        byte[] buff = out.toByteArray();
        content.append(new String(buff, 0, buff.length, "UTF-8"));
        return content.toString();
    }

    protected void checkAndDeployModels(List<ImportDataInfo> importDatas, List<String> processNumbers) {
        Map<String, String> map;
        String entrabill;
        String processNumber;
        HashMap<String, String> procFileMap = new HashMap<String, String>(importDatas.size());
        HashMap listZipData = new HashMap(importDatas.size());
        ArrayList<String> processNumbersZip = new ArrayList<String>(importDatas.size());
        for (ImportDataInfo importDataInfo : importDatas) {
            DeployModel deployModel = importDataInfo.getDeployModel();
            List<DynamicObject> list = this.getMainModels(deployModel);
            DynamicObject mainModel = list.get(0);
            HashMap<String, String> zipData = new HashMap<String, String>(3);
            processNumber = mainModel.getString(this.getNumberField());
            processNumbersZip.add(processNumber);
            zipData.put("url", importDataInfo.getZipFileUrl());
            entrabill = this.getEntraBill(mainModel);
            String entrabillId = this.getEntraBillId(mainModel);
            zipData.put("entrabill", entrabill);
            listZipData.put(processNumber, zipData);
            String zipFileName = importDataInfo.getZipFileName();
            String fileName = importDataInfo.getFileName();
            String procFile = (String)procFileMap.get(processNumber);
            if (procFile != null) {
                String tip = String.format(ResManager.loadKDString((String)"%1s \u4e0e  %2s\u4e2d\u7684%3s\u6587\u4ef6\u4e2d\u7684\u6d41\u7a0b\u91cd\u590d\u3002", (String)"ImportModelPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), procFile, zipFileName, fileName);
                throw new KDBizException(tip);
            }
            procFileMap.put(processNumber, String.format(ResManager.loadKDString((String)"%1s\u4e2d\u7684%2s\u6587\u4ef6", (String)"ImportModelPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFileName, fileName));
            QFilter[] qFilters = new QFilter[2];
            qFilters[0] = new QFilter("number", "=", (Object)entrabill);
            if (WfUtils.isNotEmpty((String)entrabillId)) {
                qFilters[1] = new QFilter("id", "=", (Object)entrabillId);
            }
            if (!QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])qFilters)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e \u201c%s\u201d \u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ImportModelPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), entrabill));
            }
            QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)processNumber), new QFilter("entrabill", "!=", (Object)entrabill)};
            if (QueryServiceHelper.exists((String)"wf_model", (QFilter[])filters)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u201c\u6d41\u7a0b\u7f16\u7801\u201d\u4e3a\u201c%s\u201d\u7684\u5176\u4ed6\u5355\u636e\u6d41\u7a0b\uff0c\u5355\u636e\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ImportModelPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), processNumber));
            }
            ImportExportProcessUtil.checkProcessTypeConsistent((String)processNumber, (String)mainModel.getString(this.getProcessTypeField()), (boolean)false);
        }
        HashMap<String, Boolean> deployModelFlag = new HashMap<String, Boolean>(processNumbersZip.size());
        for (String string : processNumbersZip) {
            deployModelFlag.put(string, Boolean.FALSE);
        }
        if (!this.isCallBackCoverSummary && !this.isCallBackDeploy() && (map = this.getEntityNumberByModelNumber(processNumbersZip)) != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String processNumber3 = entry.getKey();
                String entityNumber = entry.getValue();
                if (entityNumber == null) continue;
                this.existModelNumbers.add(processNumber3);
                String url = (String)((Map)listZipData.get(processNumber3)).get("url");
                this.existUrls.add(url);
                entrabill = (String)((Map)listZipData.get(processNumber3)).get("entrabill");
                if (entrabill != null && !entrabill.equals(entityNumber)) {
                    String diffBillProcs = this.getPageCache().get(PROCESS_DIFFERENT_BILL);
                    diffBillProcs = WfUtils.isNotEmpty((String)diffBillProcs) ? String.format("%s\u3001%s", diffBillProcs, processNumber3) : processNumber3;
                    this.getPageCache().put(PROCESS_DIFFERENT_BILL, diffBillProcs);
                }
                deployModelFlag.put(processNumber3, Boolean.TRUE);
            }
        }
        if (this.existUrls != null && !this.existUrls.isEmpty()) {
            this.getPageCache().put(EXIST_FILE_LIST, SerializationUtils.serializeToBase64(this.existUrls));
        }
        if (this.existModelNumbers != null && !this.existModelNumbers.isEmpty()) {
            this.getPageCache().put(EXIST_FILE_NAME, SerializationUtils.serializeToBase64(this.existModelNumbers));
            if (!this.isCallBackCoverSummary) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8981\u8986\u76d6\u7cfb\u7edf\u5df2\u5b58\u5728\u7684\u7f16\u7801\uff1f", (String)"ImportModelPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("existData"));
            }
        }
        for (ImportDataInfo importDataInfo : importDatas) {
            DeployModel deployModel = importDataInfo.getDeployModel();
            List<DynamicObject> models = this.getMainModels(deployModel);
            DynamicObject mainModel = models.get(0);
            processNumber = mainModel.getString(this.getNumberField());
            if (!this.isCallBackCoverSummary) {
                this.checkMobileBillSummaryCfg(importDataInfo.getDeployModel().getMobileBillSummaryCfg(), processNumber);
            }
            if (((Boolean)deployModelFlag.get(processNumber)).booleanValue()) continue;
            this.deployModel(importDataInfo, processNumbers);
        }
    }

    private void deployModel(ImportDataInfo importData, List<String> processNumbers) {
        DeployModel deployModel = importData.getDeployModel();
        List<DynamicObject> models = this.getMainModels(deployModel);
        DynamicObject mainModel = models.get(0);
        String processNumber = mainModel.getString(this.getNumberField());
        if (!this.isCallBackCoverSummary && this.isCallBackDeploy()) {
            String file = this.getPageCache().get(EXIST_FILE_NAME);
            if (WfUtils.isEmpty((String)file)) {
                return;
            }
            Set fileNames = (Set)SerializationUtils.deSerializeFromBase64((String)file);
            if (fileNames == null || fileNames.isEmpty()) {
                return;
            }
            if (!fileNames.contains(processNumber)) {
                return;
            }
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(this.getNumberField(), "=", (Object)processNumber)};
        boolean isCover = QueryServiceHelper.exists((String)this.getEntityFormId(), (QFilter[])qFilters);
        this.importModel(deployModel, isCover);
        processNumbers.add(processNumber);
        this.recordImportLog(mainModel);
    }

    protected void recordImportLog(DynamicObject model) {
        WfUtils.addOpLogByAppId((String)this.getView().getFormShowParameter().getAppId(), (String)"wf_model", (String)"barimportmodel", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u5165\u6d41\u7a0b", "ImportModelPlugin_11", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0bID: %1$s \u7f16\u7801: %2$s", "ImportModelPlugin_12", "bos-wf-formplugin"), (Object[])new Object[]{String.valueOf(model.getPkValue()), model.getString(this.getNumberField())});
    }

    protected void importModel(DeployModel deployModel, boolean isCover) {
        this.getRepositoryService().deployModel(deployModel, isCover, this.isCoverSummaryCfg);
    }

    private void checkMobileBillSummaryCfg(List<DynamicObject> mobileBillSummarys, String processNumber) {
        StringBuilder sameEntityMBSummaryNumbers = new StringBuilder();
        StringBuilder notSameEntityMBSummaryNumbers = new StringBuilder();
        for (DynamicObject mobileBillSummary : mobileBillSummarys) {
            String number = mobileBillSummary.getString("number");
            String billType = mobileBillSummary.getString("billtype_id");
            String summaryTplNum = mobileBillSummary.getString("summarytplnum");
            QFilter filter1 = new QFilter("number", "=", (Object)number);
            QFilter filter2 = new QFilter("billtype", "=", (Object)billType);
            QFilter filter4 = new QFilter("summarytplnum", "=", (Object)summaryTplNum);
            boolean existsSameEntityMBSummary = QueryServiceHelper.exists((String)"wf_mbillsummary_cfg", (QFilter[])new QFilter[]{filter1, filter2, filter4});
            if (existsSameEntityMBSummary) {
                sameEntityMBSummaryNumbers.append(number).append("\uff0c");
            }
            QFilter filter3 = new QFilter("billtype", "!=", (Object)billType);
            QFilter filter5 = new QFilter("summarytplnum", "!=", (Object)summaryTplNum);
            boolean existsNotSameEntityMBSummary = QueryServiceHelper.exists((String)"wf_mbillsummary_cfg", (QFilter[])new QFilter[]{filter1, filter3.or(filter5)});
            if (!existsNotSameEntityMBSummary) continue;
            notSameEntityMBSummaryNumbers.append(number).append("\uff0c");
        }
        if (notSameEntityMBSummaryNumbers.length() > 1) {
            String notSamemBillSummaryCfgNumbers = notSameEntityMBSummaryNumbers.substring(0, notSameEntityMBSummaryNumbers.length() - 1);
            throw new KDBizException(WFErrorCode.existsNotSameEntityMBSummaryError((String)notSamemBillSummaryCfgNumbers), new Object[]{processNumber});
        }
        if (sameEntityMBSummaryNumbers.length() > 1) {
            String mBillSummaryCfgNumbers = sameEntityMBSummaryNumbers.substring(0, sameEntityMBSummaryNumbers.length() - 1);
            throw new KDBizException(WFErrorCode.existsSameEntityMBSummaryError((String)mBillSummaryCfgNumbers), new Object[]{processNumber});
        }
    }

    private void emptyExistFileListCache() {
        this.getPageCache().put(EXIST_FILE_LIST, null);
    }

    private void emptyExistFileNameCache() {
        this.getPageCache().put(EXIST_FILE_NAME, null);
        this.getPageCache().put(PROCESS_DIFFERENT_BILL, null);
    }

    private boolean isCallBackDeploy() {
        return this.isCallBackOperation;
    }
}

