/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;

public class MessageTplTitleContentPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    protected Log log = LogFactory.getLog(MessageTplTitleContentPlugin.class);
    private static final String TITLE = "title";
    private static final String MSGTITLE = "msgtitle";
    private static final String CONTENT = "content";
    private static final String MSGCONTENT = "msgcontent";
    private static final String MSGTAB = "msgtab";
    private static final String SHOWTITLE = "showTitle";
    private static final String MSGTABKEY = "msgtabkey";
    private static final String VALUE = "value";
    public static final String INSERTEXPRESSION = "insertexpression";
    public static final String INSERTFIELD = "insertfield";
    public static final String CONFIRM = "confirm";
    public static final String CANCEL = "cancel";
    public static final String FROM = "FROM";
    public static final String NUMBERMAPNAME = "numberMapName";
    private static final String DELEGATIONSTATE = "delegationstate";
    public static final String PAGECACHE_SAMPLEMAP = "sampleMap";
    public static final String COSMIC = "cosmic";
    public static final String CUSTOM = "custom";
    public static final String SAMPLE = "sample";
    public static final String EXPRESSION = "expression";
    public static final String ENTITYNUMBERBIG = "entityNumber";
    public static final String INSERTERRORMSG = "inserterrormsg";
    public static final String EVT_AUTOMSG = "evt_automsg";
    private static final String LOCALE = "locale";
    private static final String MSGCONTENTCACHE = "msgContentCache";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONFIRM, CANCEL, INSERTEXPRESSION, INSERTERRORMSG});
        Tab apptabs = (Tab)this.getView().getControl(MSGTAB);
        apptabs.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initLocale();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Boolean showTitle = (Boolean)parameter.getCustomParam(SHOWTITLE);
        if (showTitle != null && showTitle.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MSGTITLE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{MSGTITLE});
        }
        Boolean flag = (Boolean)parameter.getCustomParam("notify");
        if (flag == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{INSERTERRORMSG});
        } else {
            this.getView().setVisible(flag, new String[]{INSERTERRORMSG});
        }
        String entityNumber = (String)parameter.getCustomParam(ENTITYNUMBERBIG);
        if (EVT_AUTOMSG.equals(parameter.getParentFormId()) && WfUtils.isEmpty((String)entityNumber)) {
            String type = (String)parameter.getCustomParam("type");
            if (CUSTOM.equals(type)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{INSERTFIELD});
            }
        } else if (!EVT_AUTOMSG.equals(parameter.getParentFormId()) && WfUtils.isEmpty((String)entityNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9875\u9762\u53c2\u6570\u201d\u7f3a\u5c11\u5355\u636e\u4fe1\u606f\u3002", (String)"MessageTplTitleContentPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (WfUtils.isNotEmptyString((Object)parameter.getCustomParam(FROM))) {
            this.getPageCache().put(FROM, (String)parameter.getCustomParam(FROM));
        }
        if (WfUtils.isEmptyString((Object)parameter.getCustomParam("type"))) {
            if (WfUtils.isEmptyString((Object)entityNumber)) {
                this.log.warn(String.format("\u5355\u636e\u4e3b\u9898\u53c2\u6570\u51fa\u9519--\u53c2\u6570\u4e3a\u7a7a\uff01 %s %s", "WfLightBillSubjectPlugin", ENTITYNUMBERBIG));
            }
            this.setFieldComboItems(entityNumber);
        } else if (WfUtils.isNotEmptyString((Object)entityNumber)) {
            this.setFieldComboItems(entityNumber);
        }
        JSONObject msgInfoObj = JSONObject.parseObject((String)((String)parameter.getCustomParam(VALUE)));
        String lang = Lang.get().toString();
        this.getModel().setValue(LOCALE, (Object)lang);
        if (null != msgInfoObj && msgInfoObj.size() > 0) {
            Object title = msgInfoObj.get((Object)TITLE);
            Object content = msgInfoObj.get((Object)CONTENT);
            if (title instanceof JSONObject || content instanceof JSONObject) {
                JSONObject contentObj;
                JSONObject titleObj = JSONObject.parseObject((String)(msgInfoObj.get((Object)TITLE) != null ? msgInfoObj.get((Object)TITLE).toString() : ""));
                if (null != titleObj && titleObj.size() > 0) {
                    this.getModel().setValue(TITLE, (Object)titleObj.getString(lang));
                }
                if (null != (contentObj = JSONObject.parseObject((String)(msgInfoObj.get((Object)CONTENT) != null ? msgInfoObj.get((Object)CONTENT).toString() : ""))) && contentObj.size() > 0) {
                    this.getModel().setValue(CONTENT, (Object)contentObj.getString(lang));
                }
                this.getPageCache().put(MSGCONTENTCACHE, msgInfoObj.toString());
            } else {
                this.getModel().setValue(TITLE, (Object)msgInfoObj.getString(TITLE));
                this.getModel().setValue(CONTENT, (Object)msgInfoObj.getString(CONTENT));
                JSONObject obj = this.msgHandle(lang, null, msgInfoObj.getString(TITLE), msgInfoObj.getString(CONTENT));
                this.getPageCache().put(MSGCONTENTCACHE, obj.toString());
            }
        }
        Tab msgtab = (Tab)this.getView().getControl(MSGTAB);
        msgtab.activeTab(MSGCONTENT);
        this.getPageCache().put(MSGTABKEY, MSGCONTENT);
    }

    private void initLocale() {
        List langList = InteServiceHelper.getMultiLangEnabledLang();
        LinkedHashMap<String, Object> items = new LinkedHashMap<String, Object>(langList.size());
        for (EnabledLang enabledLang : langList) {
            items.put(enabledLang.getName(), enabledLang.getNumber());
        }
        PluginUtil.setComboForControl(items, (ComboEdit)this.getControl(LOCALE));
    }

    protected void setFieldComboItems(String entityNumber) {
        MainEntityType entityType;
        HashMap<String, String> numberMapName = new HashMap<String, String>();
        MainEntityType mainType = entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Iterator iter = mainType.getAllFields().values().iterator();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        while (iter.hasNext()) {
            ComboItem item = new ComboItem();
            IDataEntityProperty fieldProp = (IDataEntityProperty)iter.next();
            if (WfUtils.isEmpty((String)fieldProp.getAlias()) || entityNumber.equals("wf_hitaskinst") && DELEGATIONSTATE.equals(fieldProp.getName()) || TaskExtendFieldUtil.isSpecialPropNeedRemove((String)entityNumber, (IDataEntityProperty)fieldProp).booleanValue() || !(fieldProp instanceof IFieldHandle) || WfUtils.isNotEmpty((String)fieldProp.getParent().getName()) && !entityNumber.equals(fieldProp.getParent().getName()) || fieldProp instanceof MulBasedataProp) continue;
            if (!(fieldProp instanceof BasedataProp) && !(fieldProp instanceof AttachmentProp)) {
                item.setValue(fieldProp.getName());
                item.setCaption(((IFieldHandle)fieldProp).getDisplayName());
                numberMapName.put(item.getValue(), item.getCaption().toString());
            }
            items.add(item);
        }
        ComboEdit fieldCombo = (ComboEdit)this.getControl(INSERTFIELD);
        this.getPageCache().put(NUMBERMAPNAME, SerializationUtils.toJsonString(numberMapName));
        fieldCombo.setComboItems(items);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (key.equals(INSERTEXPRESSION)) {
            this.showExpressionForm();
        } else if (CONFIRM.equals(key)) {
            String channle;
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String operationSource = (String)showParameter.getCustomParam("operationSource");
            String locale = (String)this.getModel().getValue(LOCALE);
            if (locale.equalsIgnoreCase(RequestContext.get().getLang().toString())) {
                if (WfUtils.isEmptyString((Object)this.getModel().getValue(CONTENT))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6b63\u6587\u5185\u5bb9\u201d\u3002", (String)"MessageTplTitleContentPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                String tplMap = this.getPageCache().get(MSGCONTENTCACHE);
                if (tplMap == null || WfUtils.isEmptyForMap((Map)((Map)SerializationUtils.fromJsonString((String)tplMap, Map.class)))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6b63\u6587\u5185\u5bb9\u201d\u3002", (String)"MessageTplTitleContentPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map tpls = (Map)SerializationUtils.fromJsonString((String)tplMap, Map.class);
                Map contentMap = (Map)tpls.get(CONTENT);
                if (WfUtils.isEmptyString(contentMap.get(RequestContext.get().getLang().toString()))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6b63\u6587\u5185\u5bb9\u201d\u3002", (String)"MessageTplTitleContentPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (WfUtils.isNotEmpty((String)(channle = (String)showParameter.getCustomParam("channel"))) && "sms".equals(channle)) {
                String message = ResManager.loadKDString((String)"\u6b63\u6587\u5185\u5bb9\u957f\u5ea6\u5982\u679c\u8d85\u8fc7450\u5b57\u7b26\uff0c\u77ed\u4fe1\u6e20\u9053\u5c06\u65e0\u6cd5\u63a8\u9001\u6d88\u606f\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u7ee7\u7eed\uff1f\uff08\u6ce8\u610f\uff1a\u5931\u8d25\u4fe1\u606f\u53ef\u5728\u6d88\u606f\u65e5\u5fd7\u4e2d\u67e5\u770b\u3002\uff09", (String)"MessageTplTitleContentPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("smsContentSizeCallBack"));
            } else {
                this.returnData();
            }
            this.getPageCache().remove(FROM);
        } else if (CANCEL.equals(key)) {
            this.getPageCache().remove(FROM);
            this.getView().close();
        } else if (INSERTERRORMSG.equals(key)) {
            String msgTabKey = this.getPageCache().get(MSGTABKEY);
            Object content = this.getModel().getValue(CONTENT);
            if (msgTabKey == null || MSGTITLE.equalsIgnoreCase(msgTabKey)) {
                content = this.getModel().getValue(TITLE);
            }
            content = WfUtils.isNotEmptyString((Object)content) ? content : "";
            content = content + "{errmsg}";
            if (msgTabKey == null || MSGTITLE.equalsIgnoreCase(msgTabKey)) {
                this.getModel().setValue(TITLE, content);
            } else {
                this.getModel().setValue(CONTENT, content);
            }
        }
    }

    private void returnData() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Boolean showTitle = (Boolean)showParameter.getCustomParam(SHOWTITLE);
        if (showTitle != null && showTitle.booleanValue()) {
            String locale = (String)this.getModel().getValue(LOCALE);
            String title = (String)this.getModel().getValue(TITLE);
            String content = (String)this.getModel().getValue(CONTENT);
            if ((StringUtils.isNotBlank((CharSequence)title) || StringUtils.isNotBlank((CharSequence)content)) && StringUtils.isBlank((CharSequence)locale)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bed\u79cd", (String)"MessageEmailContentPlugin_2", (String)"bos-message-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject obj = this.msgHandle(locale, "", title, content);
            JSONObject packageData = obj.getJSONObject("packageData");
            if (null != packageData) {
                JSONObject emailTitle = packageData.getJSONObject(TITLE);
                JSONObject emailContent = packageData.getJSONObject(CONTENT);
                if (StringUtils.isNotBlank((Object)emailTitle)) {
                    returnData.put(TITLE, emailTitle);
                }
                if (StringUtils.isNotBlank((Object)emailContent)) {
                    returnData.put(CONTENT, emailContent);
                }
            }
        } else {
            returnData.put("customSubject", this.getModel().getValue(CONTENT));
            returnData.put(SAMPLE, this.getPageCache().get(PAGECACHE_SAMPLEMAP));
        }
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    protected void showExpressionForm() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String modelJson = (String)showParameter.getCustomParam("modelJson");
        String entityNumber = (String)showParameter.getCustomParam(ENTITYNUMBERBIG);
        String comeFrom = (String)showParameter.getCustomParam(FROM);
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("bpmnModel", modelJson);
        content.put(ENTITYNUMBERBIG, entityNumber);
        content.put("ruleType", ConditionalRuleType.skip);
        content.put("fromSubjectModelAndApp", "fromSubjectModelAndApp");
        if (WfUtils.isNotEmpty((String)comeFrom) && "MSG".equals(comeFrom)) {
            String type = (String)showParameter.getCustomParam("type");
            if (COSMIC.equals(type) || CUSTOM.equals(type)) {
                content.put("ruleType", "EventConfig");
                content.put("eventnumber", showParameter.getCustomParam("eventnumber"));
            } else if ("expiresendmsg".equals(type)) {
                content.put("ruleType", "expiresendmsg");
            } else {
                content.put("ruleType", ConditionalRuleType.sequenceFlow);
            }
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, INSERTEXPRESSION));
        parameter.setFormId("wf_valueexpression");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(content);
        parameter.setHasRight(true);
        parameter.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnObj;
        Map m;
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (INSERTEXPRESSION.equals(key) && (m = (Map)(returnObj = closedCallBackEvent.getReturnData())) != null && !WfUtils.isNullObject(m.get(EXPRESSION)) && WfUtils.isNotEmptyString(m.get("prop"))) {
            Map propMap = (Map)SerializationUtils.fromJsonString((String)m.get("prop").toString(), Map.class);
            Object content = this.getModel().getValue(CONTENT);
            String msgTabKey = this.getPageCache().get(MSGTABKEY);
            if (msgTabKey == null || MSGTITLE.equalsIgnoreCase(msgTabKey)) {
                content = this.getModel().getValue(TITLE);
            }
            content = WfUtils.isNotEmptyString((Object)content) ? content : "";
            String expression = "{" + m.get(EXPRESSION) + "}";
            if (WfUtils.isEmpty((String)this.getPageCache().get(FROM)) && WfUtils.isNotEmpty((String)((String)propMap.get("name")))) {
                String propName = WfUtils.isEmpty((String)((String)propMap.get("fullName"))) ? (String)propMap.get("name") : (String)propMap.get("fullName");
                expression = propName + "\uff1a" + expression;
                if (WfUtils.isNotEmptyString(propMap.get(SAMPLE))) {
                    HashMap sampleMap = WfUtils.isNotEmpty((String)this.getPageCache().get(PAGECACHE_SAMPLEMAP)) ? (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PAGECACHE_SAMPLEMAP), Map.class) : new HashMap();
                    sampleMap.put(m.get(EXPRESSION).toString(), propMap.get(SAMPLE));
                    this.getPageCache().put(PAGECACHE_SAMPLEMAP, SerializationUtils.toJsonString(sampleMap));
                }
                if (WfUtils.isNotEmptyString((Object)content)) {
                    expression = "/" + expression;
                }
            }
            content = content + expression;
            if ("wf_autocoordinatemsg".equals(this.getView().getEntityId()) && content.toString().length() > 255) {
                content = content.toString().subSequence(0, 255);
            }
            if (msgTabKey == null || MSGTITLE.equalsIgnoreCase(msgTabKey)) {
                this.getModel().setValue(TITLE, content);
            } else {
                this.getModel().setValue(CONTENT, content);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) && "smsContentSizeCallBack".equals(messageBoxClosedEvent.getCallBackId())) {
            this.returnData();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object fieldObj;
        String propertyName = e.getProperty().getName().toLowerCase();
        if (INSERTFIELD.endsWith(propertyName) && WfUtils.isNotEmptyString((Object)(fieldObj = this.getModel().getValue(INSERTFIELD)))) {
            Object content = this.getModel().getValue(CONTENT);
            String msgTabKey = this.getPageCache().get(MSGTABKEY);
            if (msgTabKey == null || MSGTITLE.equalsIgnoreCase(msgTabKey)) {
                content = this.getModel().getValue(TITLE);
            }
            content = WfUtils.isNotEmptyString((Object)content) ? content : "";
            String fieldValue = "{" + fieldObj + "}";
            if (WfUtils.isEmpty((String)this.getPageCache().get(FROM))) {
                String numberMapNameStr = this.getPageCache().get(NUMBERMAPNAME);
                if (WfUtils.isNotEmpty((String)numberMapNameStr)) {
                    Map numberMapName = (Map)SerializationUtils.fromJsonString((String)numberMapNameStr, Map.class);
                    String name = (String)numberMapName.get(fieldObj);
                    fieldValue = name + "\uff1a" + fieldValue;
                }
                if (WfUtils.isNotEmptyString((Object)content)) {
                    fieldValue = "/" + fieldValue;
                }
            }
            content = content + fieldValue;
            if ("wf_autocoordinatemsg".equals(this.getView().getEntityId()) && content.toString().length() > 255) {
                content = content.toString().subSequence(0, 255);
            }
            if (msgTabKey == null || MSGTITLE.equalsIgnoreCase(msgTabKey)) {
                this.getModel().setValue(TITLE, content);
            } else {
                this.getModel().setValue(CONTENT, content);
            }
        }
        if (LOCALE.equalsIgnoreCase(propertyName)) {
            String newLocale = (String)e.getChangeSet()[0].getNewValue();
            String oldLocale = (String)e.getChangeSet()[0].getOldValue();
            if (StringUtils.isNotBlank((CharSequence)oldLocale) && StringUtils.isNotBlank((CharSequence)newLocale) && !newLocale.equals(oldLocale)) {
                this.log.debug("msgContent \u5207\u6362\u8bed\u79cd oldLocale=" + oldLocale + " newLocale=" + newLocale);
                this.getModel().setValue(INSERTFIELD, null);
                String oldTitle = (String)this.getModel().getValue(TITLE);
                String oldContent = (String)this.getModel().getValue(CONTENT);
                JSONObject obj = this.msgHandle(oldLocale, newLocale, oldTitle, oldContent);
                this.getPageCache().put(MSGCONTENTCACHE, String.valueOf(obj.get((Object)"packageData")));
                String title = obj.getString("newTitle");
                String content = obj.getString("newContent");
                this.getModel().setValue(CONTENT, (Object)content);
                this.getModel().setValue(TITLE, (Object)title);
            }
        }
    }

    public void tabSelected(TabSelectEvent arg0) {
        String msgTabKey = arg0.getTabKey();
        this.getPageCache().put(MSGTABKEY, msgTabKey);
        this.getModel().setValue(INSERTFIELD, null);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove(MSGTABKEY);
        this.getPageCache().remove(MSGCONTENTCACHE);
    }

    private JSONObject msgHandle(String oldLocale, String newLocale, String oldTitle, String oldContent) {
        JSONObject obj = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)oldLocale)) {
            String msgInfoCache = this.getPageCache().get(MSGCONTENTCACHE);
            JSONObject dataObj = new JSONObject();
            if (StringUtils.isNotBlank((CharSequence)msgInfoCache)) {
                dataObj = JSONObject.parseObject((String)msgInfoCache);
            }
            LocaleString title = new LocaleString();
            LocaleString content = new LocaleString();
            String emailTitle = dataObj.getString(TITLE);
            if (StringUtils.isNotBlank((CharSequence)emailTitle)) {
                JSONObject titleObj = JSONObject.parseObject((String)emailTitle);
                for (Map.Entry entry : titleObj.entrySet()) {
                    title.setItem((String)entry.getKey(), (Object)((String)entry.getValue()));
                }
            }
            title.setItem(oldLocale, (Object)oldTitle);
            String emailContent = dataObj.getString(CONTENT);
            if (StringUtils.isNotBlank((CharSequence)emailContent)) {
                JSONObject contentObj = JSONObject.parseObject((String)emailContent);
                for (Map.Entry entry : contentObj.entrySet()) {
                    content.setItem((String)entry.getKey(), (Object)((String)entry.getValue()));
                }
            }
            content.setItem(oldLocale, (Object)oldContent);
            JSONObject packageData = new JSONObject();
            packageData.put(TITLE, (Object)title);
            packageData.put(CONTENT, (Object)content);
            obj.put("packageData", (Object)packageData);
            if (StringUtils.isNotBlank((CharSequence)newLocale)) {
                obj.put("newTitle", title.getItem(newLocale));
                obj.put("newContent", content.getItem(newLocale));
            }
        }
        return obj;
    }
}

