/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.AbstractTreeListView;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityImpl;
import kd.bos.workflow.management.plugin.ProcessCategoryTreeListView;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ModelTreeListPlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
ClickListener,
IConfirmCallBack,
AfterSearchClickListener {
    protected static Log logger = LogFactory.getLog(ModelTreeListPlugin.class);
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String MESSAGE = "message";
    private static final String NUMBER = "number";
    private static final String EDIT_TREE_NODE_CALL_BACK = "edittreenodecallback";
    private static final String ADD_TREE_NODE_CALL_BACK = "addtreenodecallback";
    private static final String CLOUD_IDS_KEY = "cloudIdsKey";
    private static final String CLOUD_COVER_CALL_BACK = "cloudCoverCallBack";
    private static final String TREE_REFRESH = "treerefresh";
    private static final String DELETE_TREE_NODE = "deletetreenode";
    private static final String EDIT_TREE_NODE = "edittreenode";
    private static final String ADD_TREE_NODE = "addtreenode";
    private static final String BUTTON_IMPORT = "buttonimport";
    private static final String BUTTON_SYNCHRONIZATION = "synchronization";
    private static final String MULBASEDATA_CLOUD = "mulbasedatacloud";
    private static final String TREEVIEW = "treeview";
    private static final String BILLFORMID = "billFormId";
    private AbstractTreeListView treelistView = new ProcessCategoryTreeListView();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_SYNCHRONIZATION, BUTTON_IMPORT, ADD_TREE_NODE, EDIT_TREE_NODE, DELETE_TREE_NODE, TREE_REFRESH});
        FilterContainer search = (FilterContainer)this.getControl("FilterContainerap");
        search.addAfterSearchClickListener((AfterSearchClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.refreshTreeListView();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (MULBASEDATA_CLOUD.equals(name)) {
            this.importCloud(e);
            this.refreshTreeListView();
        }
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        e.setView(this.treelistView);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        switch (e.getActionId()) {
            case "addtreenodecallback": 
            case "edittreenodecallback": {
                this.closeCallBackForAddEditTreeNode(e);
                break;
            }
        }
    }

    private void closeCallBackForAddEditTreeNode(ClosedCallBackEvent e) {
        Map returnData = (Map)e.getReturnData();
        if (returnData != null && returnData.size() > 0) {
            String newNodeId = String.valueOf(returnData.get(ID));
            String parentId = String.valueOf(returnData.get("parentid"));
            String name = (String)returnData.get(NAME);
            TreeNode newNode = new TreeNode(parentId, newNodeId, name);
            ProcessCategoryEntity categoryEntity = this.getRepositoryService().getProcateById(Long.valueOf(parentId));
            Long entityId = categoryEntity.getId();
            String entityName = categoryEntity.getName();
            Long entityParentId = categoryEntity.getParentId();
            TreeNode root = new TreeNode(String.valueOf(entityParentId), String.valueOf(entityId), entityName);
            List<TreeNode> treeNodes = this.getTreeNodes(entityId);
            root.addChildren(treeNodes);
            TreeView tree = (TreeView)this.getView().getControl(TREEVIEW);
            root.setIsOpened(true);
            tree.updateNode(root);
            if (ADD_TREE_NODE_CALL_BACK.equals(e.getActionId())) {
                tree.focusNode(root);
            } else if (EDIT_TREE_NODE_CALL_BACK.equals(e.getActionId())) {
                tree.focusNode(newNode);
            }
            TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)parentId, (Object)newNodeId);
            this.treeNodeClick(event);
            tree.showNode(parentId);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ModelTreeListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private List<TreeNode> getTreeNodes(Long entityId) {
        List processCategoryEntities = this.getRepositoryService().getProcateByParentId(entityId);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(processCategoryEntities.size());
        for (ProcessCategoryEntity processCategoryEntity : processCategoryEntities) {
            String parentId = String.valueOf(entityId);
            Long id = processCategoryEntity.getId();
            String text = processCategoryEntity.getName();
            TreeNode treeNode = new TreeNode(parentId, String.valueOf(id), text);
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "deletetreenode": {
                this.deleteTreeNode();
                break;
            }
            case "cloudCoverCallBack": {
                this.coverCloud();
                this.refreshTreeListView();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        super.click(evt);
        Button button = (Button)evt.getSource();
        switch (key = button.getKey()) {
            case "buttonimport": {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getBillFormId(), (String)"47156aff000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"ModelTreeListPlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                MulBasedataEdit mulBaseDataCloud = (MulBasedataEdit)this.getControl(MULBASEDATA_CLOUD);
                mulBaseDataCloud.click();
                break;
            }
            case "addtreenode": {
                this.addTreeNode();
                break;
            }
            case "edittreenode": {
                this.editTreeNode();
                break;
            }
            case "deletetreenode": {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getBillFormId(), (String)"4715e1f1000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u5206\u7c7b\u201d\u7684\u5220\u9664\u6743\u9650\u3002", (String)"ModelTreeListPlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.checkDeleteOperationIsPermitted()) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u5417?", (String)"ModelTreeListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETE_TREE_NODE));
                break;
            }
            case "treerefresh": {
                this.refreshTreeListView();
                break;
            }
            case "synchronization": {
                this.updateProcessCagetory();
                this.refreshTreeListView();
                break;
            }
        }
    }

    private void updateProcessCagetory() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Boolean result = wfService.getRepositoryService().processCagetoryNameUpdate();
        if (result.booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"ModelTreeListPlugin_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void deleteTreeNode() {
        ProcessCategoryEntity processCategoryEntity = this.getFocusProcessCategoryEntity();
        if (processCategoryEntity != null) {
            try {
                Long id = processCategoryEntity.getId();
                Long parentId = processCategoryEntity.getParentId();
                this.getRepositoryService().deleteProcessCategory(processCategoryEntity);
                if (!processCategoryEntity.isLeaf().booleanValue()) {
                    this.refreshTreeListView();
                } else {
                    ProcessCategoryEntity categoryEntity = this.getRepositoryService().getProcateById(parentId);
                    Long entityId = categoryEntity.getId();
                    String entityName = categoryEntity.getName();
                    Long entityParentId = categoryEntity.getParentId();
                    TreeNode root = new TreeNode(String.valueOf(entityParentId), String.valueOf(entityId), entityName);
                    List<TreeNode> treeNodes = this.getTreeNodes(entityId);
                    root.addChildren(treeNodes);
                    TreeView tree = (TreeView)this.getView().getControl(TREEVIEW);
                    root.setIsOpened(true);
                    tree.updateNode(root);
                    tree.focusNode(root);
                    TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)parentId, (Object)id);
                    this.treeNodeClick(event);
                    tree.showNode(String.valueOf(parentId));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ModelTreeListPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.warn(String.format("%s:%s", "\u6d41\u7a0b\u7c7b\u522b\u5220\u9664\u5931\u8d25\uff1a", e.getMessage()));
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6d41\u7a0b\u7c7b\u522b\u201d\u5220\u9664\u5931\u8d25\u3002", (String)"ModelTreeListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7c7b\u522b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModelTreeListPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void editTreeNode() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getBillFormId(), (String)"4715a0df000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u5206\u7c7b\u201d\u4fee\u6539\u6743\u9650\u3002", (String)"ModelTreeListPlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = this.checkEditOperationIsPermitted();
        if (id == null) {
            return;
        }
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_processcagetory");
        parameter.setPkId((Object)id);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDIT_TREE_NODE_CALL_BACK));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void addTreeNode() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getBillFormId(), (String)"47156aff000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u5206\u7c7b\u201d\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"ModelTreeListPlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = this.checkAddOperationIsPermitted();
        if (id == null) {
            return;
        }
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_processcagetory");
        parameter.setCustomParam(MESSAGE, (Object)id);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_TREE_NODE_CALL_BACK));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void importCloud(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length <= 0) {
            return;
        }
        DynamicObjectCollection clouds = (DynamicObjectCollection)changeData[0].getNewValue();
        if (clouds == null || clouds.isEmpty()) {
            return;
        }
        ArrayList<String> cloudIds = new ArrayList<String>();
        StringBuilder cloudNames = new StringBuilder();
        RepositoryService repositoryService = this.getRepositoryService();
        for (DynamicObject cloud : clouds) {
            Object baseData = cloud.get("fbasedataid");
            if (!(baseData instanceof DynamicObject)) continue;
            DynamicObject baseDataDOB = (DynamicObject)baseData;
            String id = baseDataDOB.getString(ID);
            List processCategoryEntities = repositoryService.getProcateByApplicationId(id);
            if (processCategoryEntities == null || processCategoryEntities.isEmpty()) {
                DynamicObjectCollection apps;
                ProcessCategoryEntityImpl processCategoryEntity = new ProcessCategoryEntityImpl();
                this.packageProcessCategoryEntity((ProcessCategoryEntity)processCategoryEntity, baseDataDOB, null, false);
                Entity newEntity = this.getRepositoryService().saveOrUpdateEntity((Entity)processCategoryEntity);
                if (newEntity == null || (apps = BizAppServiceHelp.getAllBizAppsByCloudID((String)id)) == null || apps.isEmpty()) continue;
                Long parentId = newEntity.getId();
                for (DynamicObject app : apps) {
                    if (!"0".equals(app.get("type"))) continue;
                    processCategoryEntity = new ProcessCategoryEntityImpl();
                    this.packageProcessCategoryEntity((ProcessCategoryEntity)processCategoryEntity, app, parentId, true);
                    this.getRepositoryService().saveOrUpdateEntity((Entity)processCategoryEntity);
                }
                continue;
            }
            cloudIds.add(id);
            this.getPageCache().put(CLOUD_IDS_KEY, SerializationUtils.toJsonString(cloudIds));
            cloudNames.append(baseDataDOB.get(NAME)).append(',');
        }
        if (cloudIds.isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210", (String)"ModelTreeListPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            String message = "";
            if (cloudNames.length() > 0) {
                message = cloudNames.substring(0, cloudNames.length() - 1);
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u7ecf\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6?", (String)"ModelTreeListPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), message), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CLOUD_COVER_CALL_BACK));
        }
    }

    private void coverCloud() {
        String cloudIdsString = this.getPageCache().get(CLOUD_IDS_KEY);
        if (WfUtils.isEmpty((String)cloudIdsString)) {
            return;
        }
        List cloudIds = SerializationUtils.fromJsonStringToList((String)cloudIdsString, String.class);
        if (cloudIds == null) {
            return;
        }
        for (String id : cloudIds) {
            List cloudProcessCategoryEntities;
            DynamicObjectCollection apps = BizAppServiceHelp.getAllBizAppsByCloudID((String)id);
            if (apps == null || apps.isEmpty() || (cloudProcessCategoryEntities = this.getRepositoryService().getProcateByApplicationId(id)) == null || cloudProcessCategoryEntities.isEmpty()) continue;
            Long parentId = ((ProcessCategoryEntity)cloudProcessCategoryEntities.get(0)).getId();
            for (DynamicObject app : apps) {
                Object processCategoryEntity = null;
                List appProcessCategoryEntities = this.getRepositoryService().getProcateByApplicationId(app.getString(ID));
                processCategoryEntity = appProcessCategoryEntities == null || appProcessCategoryEntities.isEmpty() ? new ProcessCategoryEntityImpl() : (ProcessCategoryEntity)appProcessCategoryEntities.get(0);
                this.packageProcessCategoryEntity((ProcessCategoryEntity)processCategoryEntity, app, parentId, true);
                this.getRepositoryService().saveOrUpdateEntity((Entity)processCategoryEntity);
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8986\u76d6\u5bfc\u5165\u5b8c\u6210\u3002", (String)"ModelTreeListPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
    }

    private void packageProcessCategoryEntity(ProcessCategoryEntity processCategoryEntity, DynamicObject dynamicObject, Long parentId, boolean isLeaf) {
        processCategoryEntity.setApplicationId(dynamicObject.getString(ID));
        processCategoryEntity.setDescription(dynamicObject.getString(DESCRIPTION));
        processCategoryEntity.setLeaf(Boolean.valueOf(isLeaf));
        processCategoryEntity.setName(dynamicObject.getString(NAME));
        processCategoryEntity.setNumber(dynamicObject.getString(NUMBER));
        processCategoryEntity.setParentId(parentId);
    }

    private String getTreeFocusId() {
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (WfUtils.isEmpty((String)nodeId) || "0".equals(nodeId)) {
            return null;
        }
        return nodeId;
    }

    private Long checkAddOperationIsPermitted() {
        String message = ResManager.loadKDString((String)"\u8bf7\u5728\u4e1a\u52a1\u4e91\u4e0b\u6dfb\u52a0\u65b0\u5e94\u7528\u3002", (String)"ModelTreeListPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        ProcessCategoryEntity processCategoryEntity = this.getFocusProcessCategoryEntity();
        if (processCategoryEntity == null || WfUtils.isEmpty((Long)processCategoryEntity.getParentId()) || processCategoryEntity.isLeaf().booleanValue()) {
            this.getView().showTipNotification(message);
            return null;
        }
        return processCategoryEntity.getId();
    }

    private Long checkEditOperationIsPermitted() {
        String message = ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u81ea\u5b9a\u4e49\u7684\u201c\u6d41\u7a0b\u5206\u7c7b\u201d\u3002", (String)"ModelTreeListPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        ProcessCategoryEntity processCategoryEntity = this.getFocusProcessCategoryEntity();
        if (processCategoryEntity == null || !processCategoryEntity.isLeaf().booleanValue() || WfUtils.isNotEmpty((String)processCategoryEntity.getApplicationId())) {
            this.getView().showTipNotification(message);
            return null;
        }
        return processCategoryEntity.getId();
    }

    private boolean checkDeleteOperationIsPermitted() {
        boolean isDeletePermitted = true;
        ProcessCategoryEntity processCategoryEntity = this.getFocusProcessCategoryEntity();
        if (processCategoryEntity != null) {
            if (!processCategoryEntity.isLeaf().booleanValue()) {
                Long parentId = processCategoryEntity.getId();
                List processCategoryEnties = this.getRepositoryService().getProcateByParentId(parentId);
                for (ProcessCategoryEntity entity : processCategoryEnties) {
                    Long categoryId = entity.getId();
                    DynamicObject[] models = this.getRepositoryService().getModelByProcessCategoryId(categoryId);
                    if (models == null || models.length <= 0) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u4e91\u4e0b\u5b58\u5728\u6d41\u7a0b\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ModelTreeListPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    isDeletePermitted = false;
                    break;
                }
            } else {
                Long categoryId = processCategoryEntity.getId();
                DynamicObject[] models = this.getRepositoryService().getModelByProcessCategoryId(categoryId);
                if (models != null && models.length > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6d41\u7a0b\u5206\u7c7b\u4e0b\u5b58\u5728\u5ba1\u6279\u6d41\u6216\u4e1a\u52a1\u6d41\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ModelTreeListPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    isDeletePermitted = false;
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4e91\u6216\u5e94\u7528\u3002", (String)"ModelTreeListPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            isDeletePermitted = false;
        }
        return isDeletePermitted;
    }

    private ProcessCategoryEntity getFocusProcessCategoryEntity() {
        String nodeId = this.getTreeFocusId();
        if (nodeId == null) {
            return null;
        }
        RepositoryService repositoryService = this.getRepositoryService();
        ProcessCategoryEntity processCategoryEntity = repositoryService.getProcateById(Long.valueOf(nodeId));
        if (processCategoryEntity == null) {
            logger.debug("processCategoryEntity is null! nodeId: " + nodeId);
        }
        return processCategoryEntity;
    }

    private void refreshTreeListView() {
        ListView listView = (ListView)this.getView();
        listView.getTreeListView().refreshTreeView();
    }

    private RepositoryService getRepositoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRepositoryService();
    }

    public void click(SearchClickEvent evt) {
        List treeNodeId = this.treelistView.getTreeView().getTreeState().getSelectedNodeId();
        BillList list = (BillList)this.getView().getControl("billlistap");
        if (treeNodeId != null && treeNodeId.size() == 1 && !"10000".equals(treeNodeId.get(0))) {
            String nodeId = (String)treeNodeId.get(0);
            RepositoryService repositoryService = this.getRepositoryService();
            List processCategoryEntities = repositoryService.getProcateByParentId(Long.valueOf(nodeId));
            QFilter qFilter = null;
            if (processCategoryEntities != null && !processCategoryEntities.isEmpty()) {
                ArrayList<Long> ids = new ArrayList<Long>(processCategoryEntities.size() + 1);
                ids.add(Long.valueOf(nodeId));
                for (ProcessCategoryEntity processCategoryEntity : processCategoryEntities) {
                    ids.add(processCategoryEntity.getId());
                }
                qFilter = new QFilter("categoryid", "in", ids);
            } else {
                qFilter = new QFilter("categoryid", "=", (Object)Long.valueOf(nodeId));
            }
            if (evt.getFilterModel().getFilterObject().getFilterResult().getQFilter() != null) {
                evt.getFilterModel().getFilterObject().getFilterResult().getQFilter().and(qFilter);
            } else {
                evt.getFilterModel().getFilterObject().setQFilter(qFilter);
                list.setFilter(evt.getFilterModel().getFilterObject().getQFilter());
                return;
            }
        }
        list.setFilter(evt.getFilterModel().getFilterObject().getFilterResult().getQFilter());
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }

    private String getBillFormId() {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID);
        return WfUtils.isEmpty((String)billFormId) ? "wf_model" : billFormId;
    }
}

