/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class NextAssignNodesPlugin
extends AbstractWorkflowPlugin {
    private static final String SELECTROWS = "selectrows";
    private static final String FIDCONSTANT = "fid";
    private static final String NAMECONSTANT = "name";
    private static final String ENTRYENTITY = "entryentity";
    private static final String CONFIRM = "confirm";
    private static final String ITEMID = "itemId";
    private static final String MODELJSON = "modelJson";
    private static final String SELECTNODEIDS = "selectnodeids";
    private static final String NODENUM = "nodenum";
    private static final String DESCRIPTION = "description";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONFIRM});
    }

    public void afterCreateNewData(EventObject evt) {
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam(ITEMID);
        String modelJson = (String)this.getView().getFormShowParameter().getCustomParam(MODELJSON);
        String selectNodeIds = (String)this.getView().getFormShowParameter().getCustomParam(SELECTNODEIDS);
        List keyList = Collections.emptyList();
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        if (StringUtils.isNotBlank((CharSequence)selectNodeIds)) {
            keyList = (List)SerializationUtils.fromJsonString((String)selectNodeIds, List.class);
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((String)modelJson);
        List afterNodes = BpmnModelUtil.getFollowNodes((BpmnModel)bpmnModel, (String)itemId);
        ArrayList<FlowElement> afterElement = new ArrayList<FlowElement>();
        if (afterNodes.size() > 0) {
            for (FlowElement flowElement : afterNodes) {
                String elementType = flowElement.getType();
                if (!WfUtils.isAuditTypeNode((String)elementType)) continue;
                afterElement.add(flowElement);
            }
            IDataModel model = this.getModel();
            if (afterElement.size() > 0) {
                model.batchCreateNewEntryRow(ENTRYENTITY, afterElement.size() == 0 ? 1 : afterElement.size());
                int i = 0;
                for (FlowElement flowElement : afterElement) {
                    String elementNum = flowElement.getNumber();
                    if (keyList.contains(elementNum)) {
                        selectRows.add(i);
                    }
                    String elementId = flowElement.getId();
                    model.setValue(FIDCONSTANT, (Object)elementId, i);
                    String elementName = flowElement.getName();
                    model.setValue(NAMECONSTANT, (Object)elementName, i);
                    model.setValue(NODENUM, (Object)elementNum, i);
                    String description = flowElement.getDocumentation();
                    model.setValue(DESCRIPTION, (Object)description, i);
                    ++i;
                }
            }
        }
        this.getPageCache().put(SELECTROWS, SerializationUtils.toJsonString(selectRows));
    }

    public void afterBindData(EventObject e) {
        String selectRows = this.getPageCache().get(SELECTROWS);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        List selectRowList = (List)SerializationUtils.fromJsonString((String)selectRows, List.class);
        int[] rowIndex = new int[selectRowList.size()];
        for (int i = 0; i < selectRowList.size(); ++i) {
            rowIndex[i] = (Integer)selectRowList.get(i);
        }
        grid.selectRows(rowIndex, 0);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "confirm": {
                this.confirm();
                break;
            }
        }
    }

    private void confirm() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        LinkedHashMap<String, String> nodeInfo = new LinkedHashMap<String, String>(4);
        for (int i = 0; i < selectIndex.length; ++i) {
            String fid = this.getModel().getValue(FIDCONSTANT, selectIndex[i]).toString();
            String fName = this.getModel().getValue(NAMECONSTANT, selectIndex[i]).toString();
            nodeInfo.put(fid, fName);
        }
        this.getPageCache().remove(SELECTROWS);
        this.getView().returnDataToParent(nodeInfo);
        this.getView().close();
    }
}

