/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.ConditionalRulePlugin;
import kd.bos.workflow.design.plugin.PartTypePlugin;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfRoleDimensionUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.calculator.RoleDimension;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.management.util.ConditionalRuleConvertUtil;
import org.apache.commons.beanutils.MethodUtils;

public class PartAssistPlugin
extends AbstractWorkflowPlugin {
    private static Log log = LogFactory.getLog(PartAssistPlugin.class);
    private static final String CURRENT_PANEL = "currentPanel";
    private static final String BTN_PREV = "btnprev";
    private static final String BTN_NEXT = "btnnext";
    private static final String BTN_OK = "btnok";
    private static final String CONTAINER_TYPE = "container_type";
    private static final String CONTAINER_ROLE = "container_role";
    private static final String CONTAINER_RELATION = "container_relation";
    private static final String CONTAINER_PERSON = "container_person";
    private static final String CONTAINER_PLUGIN = "container_plugin";
    private static final String CONTAINER_POSITION = "container_position";
    private static final String CONTAINER_PLUGIN_BODY = "container_plugin_body";
    private static final String CONTAINER_CONDITION_RULE = "container_condition_rule";
    private static final String CONTAINER_CONDRULE_BODY = "container_condrule_body";
    private static final String CONTAINER_EXTEND = "container_extend";
    public static final String KEY_ID = "ID";
    public static final String OPENPAGEBYFORMID = "openpagebyformid";
    private static final String OPERATION_EDIT = "operation_edit";
    private static final String MODIFYPAGETYPE = "modifyPageType";
    public static final String SELECTEDTYPE = "selectedType";
    public static final char PERSONSPLITCHAR = ',';
    private static final String[] fromIds = new String[]{"wf_part_type", "wf_part_role", "wf_part_relation_new", "bos_usertreelistf7_part", "wf_participant_plugin", "wf_part_relation"};
    private static final String CONDRULE = "condrule";
    private static final String PROCDEFID = "procDefId";
    private static final String PARAMNAME = "paramname";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_PREV, BTN_NEXT, BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String type = (String)parameter.getCustomParam("type");
        if (WfUtils.isEmpty((String)type)) {
            this.switchPanel("wf_part_type", null, null);
        } else {
            String openFormId = this.getFormIdByType(type, type, (String)parameter.getCustomParam(OPENPAGEBYFORMID));
            this.showModifyPage(openFormId, this.getPageCache().get(MODIFYPAGETYPE));
            this.getPageCache().put("required", (String)parameter.getCustomParam("required"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_PREV.equals(key)) {
            this.prev();
        } else if (BTN_NEXT.equals(key)) {
            this.next();
        } else if (BTN_OK.equals(key)) {
            this.confirm();
        }
    }

    private void prev() {
        String currentPanel = this.getPageCache().get(CURRENT_PANEL);
        if ("wf_conditionrule_update".equals(currentPanel)) {
            String type;
            IPageCache pageCache = this.getChildPageCache("wf_part_type");
            if (pageCache != null && WfUtils.isNotEmpty((String)(type = pageCache.get(PartTypePlugin.getSelectedKey(pageCache))))) {
                String formId = this.getFormIdByType(type, pageCache.get("type_extend_number"), null);
                this.switchPanel(formId, null, null);
            }
        } else {
            this.switchPanel("wf_part_type", null, null);
        }
    }

    private void next() {
        String currentPanel = this.getPageCache().get(CURRENT_PANEL);
        this.logger.debug("kd.bos.workflow.design.plugin.PartAssistPlugin.next currentPanel:" + currentPanel);
        if ("wf_part_type".equals(currentPanel)) {
            IPageCache pageCache = this.getChildPageCache("wf_part_type");
            if (pageCache != null) {
                String type = pageCache.get(PartTypePlugin.getSelectedKey(pageCache));
                if (WfUtils.isNotEmpty((String)type)) {
                    String formId = this.getFormIdByType(type, pageCache.get("type_extend_number"), null);
                    this.logger.debug("kd.bos.workflow.design.plugin.PartAssistPlugin.next formId:" + formId + ";type:" + type);
                    this.switchPanel(formId, type, null);
                } else {
                    this.getView().showTipNotification("Please choose one data.");
                }
            }
        } else {
            this.switchPanel("wf_conditionrule_update", null, null);
        }
    }

    private void showModifyPage(String formId, String type) {
        this.getPageCache().put(OPENPAGEBYFORMID, formId);
        this.getPageCache().put(SELECTEDTYPE, type);
        this.switchPanel(formId, type, OPERATION_EDIT);
    }

    private String getFormIdByType(String type, String formNumber, String formId) {
        this.logger.debug("kd.bos.workflow.design.plugin.PartAssistPlugin.getFormIdByType type: " + type + ";formNumber: " + formNumber + ";formId: " + formId);
        switch (type) {
            case "relation": {
                formId = WfUtils.isEmpty((String)formId) ? this.getRelationFormId() : formId;
                break;
            }
            case "person": {
                formId = WfUtils.isEmpty((String)formId) ? "bos_usertreelistf7_part" : formId;
                break;
            }
            case "plugin": {
                formId = WfUtils.isEmpty((String)formId) ? "wf_participant_plugin" : formId;
                break;
            }
            case "role": {
                formId = WfUtils.isEmpty((String)formId) ? "wf_part_role" : formId;
                break;
            }
            case "position": {
                formId = WfUtils.isEmpty((String)formId) ? "wf_positiontreef7_part" : formId;
                break;
            }
            default: {
                type = "extend";
                formId = WfUtils.isEmpty((String)formId) ? this.getExtendFormIdByCfgNumber(formNumber) : formId;
            }
        }
        this.getPageCache().put(MODIFYPAGETYPE, type);
        return formId;
    }

    private void switchPanel(String newPanel, String type, String operation) {
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTAINER_TYPE, CONTAINER_ROLE, CONTAINER_RELATION, CONTAINER_PERSON, CONTAINER_PLUGIN, CONTAINER_CONDITION_RULE, CONTAINER_EXTEND, CONTAINER_POSITION});
        this.getView().setVisible(Boolean.TRUE, new String[]{this.getContainer(newPanel)});
        String pageId = this.getPageCache().get(newPanel);
        if (pageId == null) {
            FormShowParameter parameter = this.buildFormShowParameter(newPanel, type);
            parameter.setCustomParam("openType", this.getView().getFormShowParameter().getCustomParam("openType"));
            this.showForm(parameter);
            this.getPageCache().put(newPanel, parameter.getPageId());
        }
        this.getPageCache().put(CURRENT_PANEL, newPanel);
        this.refreshButtons(newPanel, type, operation);
    }

    private void refreshButtons(String newPanel, String type, String operation) {
        boolean isOk = true;
        if ("wf_part_type".equals(newPanel)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_PREV});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_NEXT});
            isOk = false;
        } else if ("wf_conditionrule_update".equals(newPanel)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_PREV});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEXT});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_PREV});
            if (this.needCondition().booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_NEXT});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEXT});
            }
        }
        if ("extend".equals(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_PREV});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEXT});
        }
        if (null != operation && OPERATION_EDIT.equals(operation)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_PREV});
        }
        this.getView().setVisible(Boolean.valueOf(isOk), new String[]{BTN_OK});
    }

    private String getContainer(String formId) {
        switch (formId) {
            case "wf_part_relation_new": 
            case "wf_part_relation": {
                return CONTAINER_RELATION;
            }
            case "wf_part_role": {
                return CONTAINER_ROLE;
            }
            case "bos_usertreelistf7_part": {
                return CONTAINER_PERSON;
            }
            case "wf_positiontreef7_part": {
                return CONTAINER_POSITION;
            }
            case "wf_participant_plugin": 
            case "wf_external_interface": {
                return CONTAINER_PLUGIN;
            }
            case "wf_conditionrule_update": {
                return CONTAINER_CONDITION_RULE;
            }
            case "wf_part_type": {
                return CONTAINER_TYPE;
            }
        }
        return CONTAINER_EXTEND;
    }

    private FormShowParameter buildFormShowParameter(String panel, String type) {
        FormShowParameter selfFormShowParameter = this.getView().getFormShowParameter();
        Map context = (Map)selfFormShowParameter.getCustomParam("context");
        Map part = (Map)selfFormShowParameter.getCustomParam("part");
        this.logger.debug("kd.bos.workflow.design.plugin.PartAssistPlugin.buildFormShowParameter type: " + type + ";panel: " + panel + ";part: " + part);
        if (!WfUtils.isEmpty((String)type) && "extend".equals(type)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(panel);
            parameter.setCustomParam("value", selfFormShowParameter.getCustomParam("value"));
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(this.getContainer(panel));
            parameter.setShowTitle(false);
            parameter.setCustomParam("context", (Object)context);
            parameter.setCustomParam("part", (Object)part);
            return parameter;
        }
        if ("wf_conditionrule_update".equals(panel)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setShowTitle(false);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.setFormId("wf_conditionrule_update");
            parameter.getOpenStyle().setTargetKey(CONTAINER_CONDRULE_BODY);
            Boolean canBeDefault = (Boolean)selfFormShowParameter.getCustomParam("canBeDefault");
            parameter.setCustomParam("canBeDefault", (Object)canBeDefault);
            StyleCss sc = new StyleCss();
            sc.setHeight("475px;");
            parameter.getOpenStyle().setInlineStyleCss(sc);
            parameter.setCustomParam("hideBtns", (Object)Boolean.TRUE);
            String validateTime = null;
            if (part != null) {
                parameter.setCustomParam("part", (Object)part);
                if (part != null && part.get(CONDRULE) != null) {
                    String condRegex = ".+,\"validtime\":\"([\\d-]+ [\\d:]+)\",.+";
                    String condrule = part.get(CONDRULE).toString();
                    parameter.setCustomParam("value", (Object)condrule);
                    String string = validateTime = condrule.matches(condRegex) ? condrule.replaceFirst(condRegex, "$1") : null;
                }
            }
            if (this.isOpenFromManagermentCenter()) {
                parameter.setCustomParam("openType", (Object)"managermentCenter");
                parameter.setCustomParam(PROCDEFID, context.get(PROCDEFID));
                parameter.setCustomParam("nodeid", context.get("taskactivityid"));
                parameter.setCustomParam("type", (Object)ConditionalRuleType.participant.toString());
                if (part != null) {
                    Object condRuleId = part.get("condRuleId");
                    parameter.setCustomParam("condruleid", (Object)(condRuleId == null ? null : condRuleId.toString()));
                }
                if (validateTime != null) {
                    this.getModel().setValue("subtitle", (Object)String.format(ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\uff1a%s", (String)"PartAssistPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), validateTime));
                    this.getView().setVisible(Boolean.TRUE, new String[]{"subtitle"});
                }
            } else {
                context.put("type", "participant");
                parameter.setCustomParam("context", (Object)context);
            }
            return parameter;
        }
        if ("bos_usertreelistf7_part".equals(panel)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setCaption(ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba-\u4eba\u5458", (String)"PartAssistPlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            if ("evt_participantplugin".equals(selfFormShowParameter.getParentFormId())) {
                parameter.setCaption(ResManager.loadKDString((String)"\u63a5\u6536\u4eba-\u4eba\u5458", (String)"PartAssistPlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            parameter.setShowTitle(false);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.setFormId(panel);
            parameter.getOpenStyle().setTargetKey(this.getContainer(panel));
            parameter.setCustomParam("context", (Object)context);
            parameter.setCustomParam("externalUserType", (Object)"all");
            parameter.setShowQuickFilter(false);
            parameter.setBillFormId("bos_user");
            if (part != null && !part.isEmpty()) {
                parameter.setCustomParam("part", (Object)part);
                if ("person".equals(part.get("type"))) {
                    String value = part.get("value").toString();
                    String[] pks = value.split(",");
                    Object[] pkIds = new Long[pks.length];
                    for (int i = 0; i < pks.length; ++i) {
                        pkIds[i] = Long.valueOf(pks[i].trim());
                    }
                    parameter.setSelectedRows(pkIds);
                }
            }
            parameter.setLookUp(true);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            listFilterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(listFilterParameter);
            return parameter;
        }
        if ("wf_participant_plugin".equals(panel) || "wf_external_interface".equals(panel)) {
            FormShowParameter parameter = this.getShowParameter("externalInterface", panel);
            parameter.setShowTitle(false);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(CONTAINER_PLUGIN_BODY);
            parameter.setCustomParam("entityId", (Object)this.getEntryBill(context));
            parameter.setCustomParam("data", (Object)part);
            parameter.setCustomParam("types", (Object)ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"}));
            return parameter;
        }
        if ("wf_positiontreef7_part".equals(panel)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setCaption(ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba-\u5c97\u4f4d", (String)"PartAssistPlugin_22", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            parameter.setShowTitle(false);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.setFormId(panel);
            parameter.getOpenStyle().setTargetKey(this.getContainer(panel));
            parameter.setCustomParam("context", (Object)context);
            parameter.setShowQuickFilter(false);
            parameter.setBillFormId("bos_position");
            if (part != null && !part.isEmpty()) {
                parameter.setCustomParam("part", (Object)part);
                if ("position".equals(part.get("type"))) {
                    String value = part.get("value").toString();
                    String[] pks = value.split(",");
                    Object[] pkIds = new Long[pks.length];
                    for (int i = 0; i < pks.length; ++i) {
                        pkIds[i] = Long.valueOf(pks[i].trim());
                    }
                    parameter.setSelectedRows(pkIds);
                }
            }
            parameter.setLookUp(true);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            listFilterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(listFilterParameter);
            return parameter;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setShowTitle(false);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setFormId(panel);
        parameter.getOpenStyle().setTargetKey(this.getContainer(panel));
        parameter.setCustomParam("context", (Object)context);
        parameter.setCustomParam("part", (Object)part);
        parameter.setCustomParam("needSourceElement", this.getView().getFormShowParameter().getCustomParam("needSourceElement"));
        Object scene = this.getView().getFormShowParameter().getCustomParam("referencePersonScene");
        if (scene != null) {
            parameter.setCustomParam("referencePersonScene", scene);
        }
        return parameter;
    }

    private String getEntryBill(Map<String, Object> context) {
        String number = null;
        if (context.get(PROCDEFID) != null) {
            ProcessDefinitionEntity procdef = this.getRepositoryService().getProcessdefineById(Long.valueOf(context.get(PROCDEFID).toString()));
            number = procdef.getEntraBillId();
        } else if (context.get("model") != null) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((String)context.get("model").toString());
            number = bpmnModel.getMainProcess().getEntraBillId();
        }
        return number;
    }

    private void confirm() {
        HashMap<String, Object> part = new HashMap<String, Object>();
        String selectedType = this.getPageCache().get(SELECTEDTYPE);
        if (!WfUtils.isEmpty((String)selectedType)) {
            part.put("type", selectedType);
        } else if (!this.storeType(part)) {
            return;
        }
        selectedType = (String)part.get("type");
        boolean specificPartDataStored = false;
        String formId = null;
        switch (selectedType) {
            case "role": {
                formId = "wf_part_role";
                specificPartDataStored = this.storeRoleData(formId, part);
                break;
            }
            case "relation": {
                formId = this.getRelationFormId();
                specificPartDataStored = this.storeRelationData(formId, part);
                break;
            }
            case "person": {
                formId = "bos_usertreelistf7_part";
                specificPartDataStored = this.storePersonData(formId, part);
                break;
            }
            case "plugin": {
                formId = "wf_participant_plugin";
                specificPartDataStored = this.storePluginData(formId, part);
                break;
            }
            case "position": {
                formId = "wf_positiontreef7_part";
                specificPartDataStored = this.storePositionData(formId, part);
                break;
            }
            case "extend": {
                formId = this.getPageCache().get(OPENPAGEBYFORMID);
                String extendNumber = (String)this.getView().getFormShowParameter().getCustomParam("type");
                if (WfUtils.isEmpty((String)formId)) {
                    IPageCache pageCache = this.getChildPageCache("wf_part_type");
                    if (pageCache != null) {
                        extendNumber = pageCache.get("type_extend_number");
                        formId = this.getExtendFormIdByCfgNumber(extendNumber);
                    } else {
                        this.logger.debug("PageCache is null!");
                    }
                }
                specificPartDataStored = this.storeExtendData(formId, extendNumber, part);
                break;
            }
        }
        if (!specificPartDataStored) {
            return;
        }
        if (!this.storeConditionRule("wf_conditionrule_update", part)) {
            return;
        }
        String id = (String)this.getView().getFormShowParameter().getCustomParam(KEY_ID);
        if (WfUtils.isNotEmpty((String)id)) {
            part.put("id", id);
        } else {
            part.put("id", BpmnDiffUtil.getListElementId((String)"participant"));
        }
        part.put(OPENPAGEBYFORMID, formId);
        part.put(SELECTEDTYPE, selectedType);
        part.put("required", Boolean.valueOf(this.getPageCache().get("required")));
        this.getView().returnDataToParent(part);
        this.closeRelatedViews();
        this.getView().close();
    }

    private boolean storePositionData(String formId, Map<String, Object> map) {
        IDataModel model = this.getChildModel(formId);
        if (model == null) {
            Map part = (Map)this.getView().getFormShowParameter().getCustomParam("part");
            if (part == null || part.isEmpty() || !"position".equals(part.get("type"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53c2\u4e0e\u4eba\u7c7b\u578b\u4e3a\u5c97\u4f4d\uff0c\u672a\u8bbe\u7f6e\u5177\u4f53\u7684\u5c97\u4f4d\u3002", (String)"PartAssistPlugin_24", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return false;
            }
            this.putIfCheck(map, "value", part.get("value"));
            this.putIfCheck(map, "valueshowtext", part.get("valueshowtext"));
            return true;
        }
        String pageId = this.getPageCache().get("wf_positiontreef7_part");
        BillList billList = (BillList)this.getView().getView(pageId).getControl("billlistap");
        ListSelectedRowCollection collectionRep = billList.getSelectedRows();
        if (collectionRep.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53c2\u4e0e\u4eba\u7c7b\u578b\u4e3a\u5c97\u4f4d\uff0c\u672a\u8bbe\u7f6e\u5177\u4f53\u7684\u5c97\u4f4d\u3002", (String)"PartAssistPlugin_24", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return false;
        }
        StringJoiner value = new StringJoiner(",");
        collectionRep.forEach(row -> value.add(row.getPrimaryKeyValue().toString()));
        if (collectionRep.size() > 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u201c\u5c97\u4f4d\u201d\u8fc7\u591a\uff0c\u6700\u591a\u53ef\u8bbe\u7f6e90\u4e2a\u3002", (String)"PartAssistPlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        map.put("value", value.toString());
        return true;
    }

    private boolean storeExtendData(String formId, String extendNumber, Map<String, Object> map) {
        map.put("type", extendNumber);
        IFormView childView = this.getChildView(formId);
        if (null == childView) {
            this.logger.warn("childView is null! " + formId);
            return true;
        }
        IDataModel model = childView.getModel();
        if (model == null) {
            this.logger.warn("ChildModel is null! " + formId);
            return true;
        }
        IPageCache childPacache = (IPageCache)childView.getService(IPageCache.class);
        CustomEventArgs args = new CustomEventArgs((Object)this.getView(), "validate", "validate", null);
        FormViewPluginProxy proxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        if (null != childPacache) {
            childPacache.remove("validateResult");
        }
        proxy.fireCustomEvent(args);
        if (childPacache != null && childPacache.get("validateResult") != null) {
            this.getView().showTipNotification(childPacache.get("validateResult"));
            return false;
        }
        map.put("value", SerializationUtils.toJsonString((Object)model.getDataEntity()));
        String showValueNumber = "showvalue";
        if (null != childView.getControl(showValueNumber) && WfUtils.isNotEmptyString((Object)model.getValue(showValueNumber))) {
            map.put("valueshowtext", model.getValue(showValueNumber));
        }
        return true;
    }

    private void closeRelatedViews() {
        for (String formId : fromIds) {
            IFormView view;
            String pageId = this.getPageCache().get(formId);
            if (pageId == null || (view = this.getView().getView(pageId)) == null) continue;
            view.close();
        }
    }

    private boolean storeType(Map<String, Object> map) {
        String selectedType;
        IPageCache pageCache = this.getChildPageCache("wf_part_type");
        if (pageCache != null && WfUtils.isNotEmpty((String)(selectedType = pageCache.get(PartTypePlugin.getSelectedKey(pageCache))))) {
            map.put("type", selectedType);
            return true;
        }
        return false;
    }

    private void putIfCheck(Map<String, Object> map, String key, Object value) {
        if (WfUtils.isEmpty((String)key) || WfUtils.isEmptyString((Object)value)) {
            return;
        }
        map.put(key, value.toString());
    }

    private boolean storeRelationData(String formId, Map<String, Object> map) {
        boolean enableNewPartRelationForm = WfConfigurationUtil.isEnableNewPartRelationForm();
        IDataModel model = this.getChildModel(formId);
        if (model == null) {
            Map part = (Map)this.getView().getFormShowParameter().getCustomParam("part");
            if (part == null || part.isEmpty() || !"relation".equals(part.get("type"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53c2\u4e0e\u4eba\u7c7b\u578b\u4e3a\u201c\u5173\u7cfb\u201d\uff0c\u8bf7\u8bbe\u7f6e\u5177\u4f53\u7684\u53c2\u4e0e\u4eba\u3002", (String)"PartAssistPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return false;
            }
            if (enableNewPartRelationForm) {
                this.putIfCheck(map, "referencePersonShowValue", part.get("referencePersonShowValue"));
                this.putIfCheck(map, "referenceOrgShowValue", part.get("referenceOrgShowValue"));
            }
            this.putIfCheck(map, "referencePerson", part.get("referencePerson"));
            this.putIfCheck(map, "reportType", part.get("reportType"));
            this.putIfCheck(map, "personRelation", part.get("personRelation"));
            this.putIfCheck(map, "referenceOrg", part.get("referenceOrg"));
            this.putIfCheck(map, "orgRelation", part.get("orgRelation"));
            this.putIfCheck(map, "value", part.get("value"));
            this.putIfCheck(map, "valueshowtext", part.get("valueshowtext"));
            if ("position".equals(part.get("reportType"))) {
                this.putIfCheck(map, "reportTo", part.get("reportTo"));
            }
            return true;
        }
        Object relationType = model.getValue("relation_type");
        Boolean person = "person".equals(relationType);
        Object reportType = model.getValue("report_type");
        HashMap<String, String> fields = new HashMap<String, String>();
        if (person.booleanValue()) {
            boolean passCheck;
            fields.put(enableNewPartRelationForm ? "ref_person_display" : "ref_person", ResManager.loadKDString((String)"\u53c2\u7167\u4eba", (String)"PartAssistPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            fields.put("report_type", ResManager.loadKDString((String)"\u534f\u4f5c\u7c7b\u578b", (String)"PartAssistPlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            fields.put("person_relation", ResManager.loadKDString((String)"\u5173\u7cfb", (String)"PartAssistPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            if ("position".equals(reportType)) {
                fields.put("report_to", ResManager.loadKDString((String)"\u6c47\u62a5\u7c7b\u578b", (String)"PartAssistPlugin_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            if (!(passCheck = this.checkNull(model, fields))) {
                return false;
            }
            IPageCache pageCache = this.getChildPageCache(formId);
            map.put("referencePerson", model.getValue("ref_person"));
            if (enableNewPartRelationForm) {
                map.put("referencePersonShowValue", model.getValue("ref_person_display"));
            }
            map.put("reportType", model.getValue("report_type"));
            map.put("personRelation", model.getValue("person_relation"));
            String valueShowText = "";
            if (pageCache != null) {
                valueShowText = this.getValueShowTextForRelation(model, pageCache, "person");
            } else {
                this.logger.debug("ChildPageCache is null! " + formId);
            }
            map.put("valueshowtext", valueShowText);
            map.put("value", valueShowText);
            map.put("referenceOrg", model.getValue("ref_org_person"));
            if (enableNewPartRelationForm) {
                map.put("referenceOrgShowValue", model.getValue("ref_org_person_display"));
            }
            if ("position".equals(reportType)) {
                map.put("reportTo", model.getValue("report_to"));
                map.put("referenceOrgShowValue", model.getValue("ref_org_position_display"));
            }
            DynamicObjectCollection paramsColl = model.getEntryEntity("paramsentry");
            ArrayList collaborationParams = new ArrayList();
            StringBuilder mustInputField = new StringBuilder();
            for (DynamicObject d : paramsColl) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("number", d.getString(PARAMNAME));
                m.put("param", d.getString(PARAMNAME));
                m.put("paramType", d.getString("paramtype"));
                Boolean paramMustInput = d.getBoolean("paramustinput");
                String mappingField = d.getString("parammappingfield");
                if (paramMustInput.booleanValue() && WfUtils.isEmpty((String)mappingField)) {
                    mustInputField.append(d.getString(PARAMNAME)).append(',');
                }
                m.put("valueExpression", mappingField);
                m.put("valueFormat", d.getString("paramvalueformat"));
                m.put("description", d.getString("paramdesc"));
                m.put("entityObjectType", d.getString("entityobject"));
                collaborationParams.add(m);
            }
            if (mustInputField.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"PartAssistPlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]), mustInputField.substring(0, mustInputField.lastIndexOf(","))));
                return false;
            }
            map.put("collaborationParams", collaborationParams);
        } else {
            fields.put(enableNewPartRelationForm ? "ref_org_org_display" : "ref_org_org", ResManager.loadKDString((String)"\u53c2\u7167\u7ec4\u7ec7", (String)"PartAssistPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            fields.put("org_relation", ResManager.loadKDString((String)"\u5173\u7cfb", (String)"PartAssistPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            boolean passCheck = this.checkNull(model, fields);
            if (!passCheck) {
                return false;
            }
            map.put("orgRelation", model.getValue("org_relation"));
            IPageCache pageCache = this.getChildPageCache(formId);
            String valueShowText = "";
            if (pageCache != null) {
                valueShowText = this.getValueShowTextForRelation(model, pageCache, "org");
            } else {
                this.logger.debug("ChildPageCache is null! " + formId);
            }
            map.put("valueshowtext", valueShowText);
            map.put("value", valueShowText);
            map.put("referenceOrg", model.getValue("ref_org_org"));
            if (enableNewPartRelationForm) {
                map.put("referenceOrgShowValue", model.getValue("ref_org_org_display"));
            }
        }
        map.put("relationType", relationType);
        return true;
    }

    private String getValueShowTextForRelation(IDataModel model, IPageCache pageCache, String relationType) {
        StringBuilder description;
        block7: {
            List comboItems;
            LocaleString nameLocal;
            String middleWord;
            String personRelationValue;
            block8: {
                String reference;
                String relation;
                description = new StringBuilder();
                String string = relation = "org".equals(relationType) ? "org_relation" : "person_relation";
                if (WfConfigurationUtil.isEnableNewPartRelationForm()) {
                    reference = "org".equals(relationType) ? "ref_org_org_display" : "ref_person_display";
                    description.append((String)model.getValue(reference));
                } else {
                    reference = "org".equals(relationType) ? "ref_org_org" : "ref_person";
                    String referencePersonValue = (String)model.getValue(reference);
                    List personItems = SerializationUtils.fromJsonStringToList((String)pageCache.get(reference), ComboItem.class);
                    for (ComboItem item : personItems) {
                        if (!WfUtils.isNotEmpty((String)referencePersonValue) || !referencePersonValue.equals(item.getValue())) continue;
                        description.append(item.getCaption().getLocaleValue());
                        break;
                    }
                }
                personRelationValue = (String)model.getValue(relation);
                middleWord = ResManager.loadKDString((String)"\u7684", (String)"PartAssistPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                nameLocal = null;
                if (!"org".equals(relationType)) break block8;
                List comboVItems = SerializationUtils.fromJsonStringToList((String)pageCache.get("org_relation"), ValueMapItem.class);
                if (!WfUtils.isNotEmptyForCollection((Collection)comboVItems)) break block7;
                for (ValueMapItem c : comboVItems) {
                    if (null == c || !personRelationValue.equals(c.getValue()) || null == (nameLocal = c.getName())) continue;
                    description.append(middleWord).append(nameLocal.getLocaleValue());
                    break block7;
                }
                break block7;
            }
            String reprotType = (String)model.getValue("report_type");
            String cacheKey = reprotType + ".person_relation";
            if (WfUtils.isNotEmpty((String)pageCache.get(cacheKey)) && WfUtils.isNotEmptyForCollection((Collection)(comboItems = SerializationUtils.fromJsonStringToList((String)pageCache.get(cacheKey), ComboItem.class)))) {
                for (ComboItem c : comboItems) {
                    if (null == c || !personRelationValue.equals(c.getValue())) continue;
                    if ("self".equals(c.getValue())) {
                        middleWord = "";
                    }
                    if (null == (nameLocal = c.getCaption())) continue;
                    description.append(middleWord).append(nameLocal.getLocaleValue());
                    break;
                }
            }
        }
        return description.toString();
    }

    private boolean storeRoleData(String formId, Map<String, Object> map) {
        String dimensions;
        Map dimensionInfos;
        Boolean isOrgFieldEnable;
        IDataModel model = this.getChildModel(formId);
        if (model == null) {
            Map part = (Map)this.getView().getFormShowParameter().getCustomParam("part");
            if (part == null || part.isEmpty() || !"role".equals(part.get("type"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53c2\u4e0e\u4eba\u7c7b\u578b\u4e3a\u201c\u89d2\u8272\u201d\uff0c\u8bf7\u8bbe\u7f6e\u5177\u4f53\u7684\u53c2\u4e0e\u4eba\u3002", (String)"PartAssistPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return false;
            }
            this.putIfCheck(map, "orgUnitId", part.get("orgUnitId"));
            this.putIfCheck(map, "roleId", part.get("roleId"));
            this.putIfCheck(map, "businessOrgField", part.get("businessOrgField"));
            this.putIfCheck(map, "value", part.get("value"));
            this.putIfCheck(map, "valueshowtext", part.get("valueshowtext"));
            return true;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("role", ResManager.loadKDString((String)"\u89d2\u8272", (String)"PartAssistPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        boolean passCheck = this.checkNull(model, fields);
        if (!passCheck) {
            return false;
        }
        DynamicObject role = (DynamicObject)model.getValue("role");
        map.put("roleId", this.getBaseDataId(role));
        map.put("value", WfUtils.getLocaleValue((ILocaleString)role.getLocaleString("name")));
        Object businessOrgField = model.getValue("bos_org");
        IPageCache childPageCache = this.getChildPageCache(formId);
        if (childPageCache != null) {
            businessOrgField = childPageCache.get("bos_org");
            map.put("businessOrgField", businessOrgField);
            map.put("dimensionField", childPageCache.get("selectinfomap"));
        }
        if ((!(isOrgFieldEnable = (Boolean)Optional.ofNullable((dimensionInfos = WfRoleDimensionUtil.getDimensionInfos((String)(dimensions = (String)role.get("roledimension")))).get("isOrgFieldEnable")).orElseGet(() -> Boolean.TRUE)).booleanValue() || WfUtils.isEmptyString((Object)map.get("businessOrgField"))) && (WfUtils.isEmptyString((Object)map.get("dimensionField")) || "{}".equals(map.get("dimensionField")))) {
            StringJoiner sj = new StringJoiner("\u3001");
            if (isOrgFieldEnable.booleanValue()) {
                sj.add(ResManager.loadKDString((String)"\u53c2\u7167\u7ec4\u7ec7", (String)"PartAssistPlugin_26", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            List roledimensions = new ArrayList(4);
            if (WfUtils.isNotEmptyString((Object)this.getPageCache().get("partRoleDimension"))) {
                roledimensions = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("partRoleDimension"), RoleDimension.class);
                roledimensions.forEach(roledimension -> sj.add(roledimension.getName().toString()));
            }
            if (isOrgFieldEnable.booleanValue() && WfUtils.isNotEmptyForCollection(roledimensions)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u9009\u9879\u4e3a%s\uff0c\u8bf7\u81f3\u5c11\u8bbe\u7f6e\u4e00\u9879\u3002", (String)"PartAssistPlugin_27", (String)"bos-wf-formplugin", (Object[])new Object[0]), sj.toString()));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PartAssistPlugin_28", (String)"bos-wf-formplugin", (Object[])new Object[]{sj.toString()}));
            }
            return false;
        }
        return true;
    }

    private String getBaseDataId(Object bd) {
        String baseDataId = null;
        Long dataId = null;
        dataId = bd instanceof DynamicObject ? Long.valueOf(((DynamicObject)bd).getLong("id")) : (Long)bd;
        if (WfUtils.isNotEmpty((Long)dataId)) {
            baseDataId = dataId.toString();
        }
        return baseDataId;
    }

    private boolean storePersonData(String formId, Map<String, Object> map) {
        IDataModel model = this.getChildModel(formId);
        if (model == null) {
            Map part = (Map)this.getView().getFormShowParameter().getCustomParam("part");
            if (part == null || part.isEmpty() || !"person".equals(part.get("type"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53c2\u4e0e\u4eba\u7c7b\u578b\u4e3a\u4eba\u5458\uff0c\u672a\u8bbe\u7f6e\u5177\u4f53\u7684\u53c2\u4e0e\u4eba\u3002", (String)"PartAssistPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return false;
            }
            this.putIfCheck(map, "value", part.get("value"));
            this.putIfCheck(map, "valueshowtext", part.get("valueshowtext"));
            return true;
        }
        String pageId = this.getPageCache().get("bos_usertreelistf7_part");
        BillList billList = (BillList)this.getView().getView(pageId).getControl("billlistap");
        ListSelectedRowCollection collectionRep = billList.getSelectedRows();
        ListSelectedRowCollection collection = new ListSelectedRowCollection();
        if (collectionRep != null && !collectionRep.isEmpty()) {
            HashSet<Long> pkSet = new HashSet<Long>(collectionRep.size());
            for (ListSelectedRow listSelectedRow : collectionRep) {
                if (pkSet.contains(listSelectedRow.getPrimaryKeyValue())) continue;
                pkSet.add((Long)listSelectedRow.getPrimaryKeyValue());
                collection.add((Object)listSelectedRow);
            }
        }
        if (collection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53c2\u4e0e\u4eba\u7c7b\u578b\u4e3a\u4eba\u5458\uff0c\u672a\u8bbe\u7f6e\u5177\u4f53\u7684\u53c2\u4e0e\u4eba\u3002", (String)"PartAssistPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return false;
        }
        StringBuilder value = new StringBuilder();
        for (ListSelectedRow row : collection) {
            value.append(row.getPrimaryKeyValue()).append(',');
        }
        int valueLength = value.length();
        if (valueLength > 0) {
            if (valueLength > 2000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u201c\u53c2\u4e0e\u4eba\u201d\u8fc7\u591a\uff0c\u6700\u591a\u53ef\u8bbe\u7f6e90\u4eba\u3002", (String)"PartAssistPlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return false;
            }
            value.deleteCharAt(value.length() - 1);
        }
        map.put("value", value.toString());
        return true;
    }

    private boolean storePluginData(String formId, Map<String, Object> map) {
        IDataModel model = this.getChildModel(formId);
        if (model == null) {
            Map part = (Map)this.getView().getFormShowParameter().getCustomParam("part");
            if (part == null || part.isEmpty() || !"plugin".equals(part.get("type"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53c2\u4e0e\u4eba\u7c7b\u578b\u4e3a\u201c\u4e1a\u52a1\u63d2\u4ef6\u201d\uff0c\u8bf7\u8bbe\u7f6e\u5177\u4f53\u7684\u53c2\u4e0e\u4eba\u3002", (String)"PartAssistPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return false;
            }
            this.putIfCheck(map, "value", part.get("value"));
            this.putIfCheck(map, "valueshowtext", part.get("valueshowtext"));
            return true;
        }
        String pageId = this.getPageCache().get(formId);
        IFormView subView = this.getView().getView(pageId);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)subView.getService(FormViewPluginProxy.class);
        IFormPlugin plugin = pluginProxy.getPlugin("kd.bos.workflow.design.plugin.WorkflowParticantForExternalInterfacePlugin");
        Map result = null;
        try {
            result = (Map)MethodUtils.invokeMethod((Object)plugin, (String)"confirm", (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error(String.format("invoke WorkflowParticantForExternalInterfacePlugin confirm method error! %s", e.getMessage()));
            return false;
        }
        String value = (String)result.get("value");
        if (WfUtils.isEmpty((String)value)) {
            this.getView().showTipNotification((String)result.get("msg"));
            return false;
        }
        String desc = (String)result.get("desc");
        map.put("value", value);
        if (WfUtils.isNotEmpty((String)desc)) {
            map.put("valueshowtext", desc);
        } else {
            map.put("valueshowtext", ExternalInterfaceUtil.getFormattedShowValue((String)value));
        }
        map.put("description", map.get("valueshowtext"));
        return true;
    }

    private boolean storeConditionRule(String formId, Map<String, Object> map) {
        if (!this.needCondition().booleanValue()) {
            return true;
        }
        IDataModel model = this.getChildModel(formId);
        if (model == null) {
            Map part = (Map)this.getView().getFormShowParameter().getCustomParam("part");
            if (part == null || part.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219\u5b58\u5728\u9519\u8bef\uff0c\u539f\u56e0\u662f\u672a\u8bbe\u7f6e\u5177\u4f53\u7684\u6761\u4ef6\u89c4\u5219\u3002", (String)"PartAssistPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return false;
            }
            if (!this.containsCondition(part)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219\u5b58\u5728\u9519\u8bef\uff0c\u539f\u56e0\u662f\u672a\u8bbe\u7f6e\u5177\u4f53\u7684\u6761\u4ef6\u89c4\u5219\u3002", (String)"PartAssistPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return false;
            }
            this.putIfCheck(map, "conditionExpression", part.get("conditionExpression"));
            this.putIfCheck(map, CONDRULE, part.get(CONDRULE));
            this.putIfCheck(map, "condRuleId", part.get("condRuleId"));
            this.putIfCheck(map, "defaultCondition", part.get("defaultCondition"));
            this.putIfCheck(map, "condruleshowtext", part.get("condruleshowtext"));
            this.putIfCheck(map, "value", part.get("value"));
            this.putIfCheck(map, "valueshowtext", part.get("valueshowtext"));
            return true;
        }
        Boolean defaultCondition = (Boolean)model.getValue("defaultcondition");
        map.put("defaultCondition", defaultCondition);
        ConditionalRulePlugin condRulePlugin = new ConditionalRulePlugin();
        String pageId = this.getPageCache().get(formId);
        condRulePlugin.setView(this.getView().getView(pageId));
        Object condRuleValue = condRulePlugin.confirm();
        if (condRuleValue instanceof String) {
            String tips = ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219\u5b58\u5728\u9519\u8bef\uff0c\u539f\u56e0\u662f\u672a\u8bbe\u7f6e\u5177\u4f53\u7684\u6761\u4ef6\u89c4\u5219\u3002", (String)"PartAssistPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return false;
        }
        if (condRuleValue instanceof Map) {
            Map condRule = (Map)condRuleValue;
            map.put("condruleshowtext", condRule.get("showtext"));
            map.put("conditionExpression", condRule.get("expression"));
            map.put(CONDRULE, condRule);
            return true;
        }
        if (condRuleValue instanceof ConditionalRuleEntityImpl) {
            ConditionalRuleEntityImpl entity = (ConditionalRuleEntityImpl)condRuleValue;
            map.put("condruleshowtext", entity.getShowtext().toString());
            map.put("conditionExpression", entity.getExpression());
            map.put(CONDRULE, ConditionalRuleConvertUtil.conditionalRuleToJson((ConditionalRuleEntity)entity));
            map.put("condRuleId", entity.getId());
            return true;
        }
        return false;
    }

    private boolean containsCondition(Map<String, Object> part) {
        Boolean defaultCondition = (Boolean)part.get("defaultCondition");
        if (defaultCondition.booleanValue()) {
            return true;
        }
        Object condRuleId = part.get("condRuleId");
        Object condRule = part.get(CONDRULE);
        Object expression = part.get("conditionExpression");
        return condRuleId != null || condRule != null || expression != null;
    }

    private boolean checkNull(IDataModel model, Map<String, String> fields) {
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String field = entry.getKey();
            if (!WfUtils.isEmptyString((Object)model.getValue(field))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"PartAssistPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), entry.getValue()), Integer.valueOf(1500));
            return false;
        }
        return true;
    }

    protected boolean isOpenFromManagermentCenter() {
        String openTye = (String)this.getView().getFormShowParameter().getCustomParam("openType");
        return "managermentCenter".equals(openTye);
    }

    private IDataModel getChildModel(String childFormId) {
        IFormView view = this.getChildView(childFormId);
        return view == null ? null : view.getModel();
    }

    protected IFormView getChildView(String childFormId) {
        String pageId = this.getPageCache().get(childFormId);
        if (pageId == null) {
            return null;
        }
        return this.getView().getView(pageId);
    }

    private IPageCache getChildPageCache(String childFormId) {
        String pageId = this.getPageCache().get(childFormId);
        if (pageId == null) {
            return null;
        }
        return (IPageCache)this.getView().getView(pageId).getService(IPageCache.class);
    }

    private Boolean needCondition() {
        IDataModel model = this.getChildModel("wf_part_type");
        if (model == null) {
            return Boolean.FALSE;
        }
        Boolean needCondition = (Boolean)model.getValue("checkbox_condition");
        return needCondition;
    }

    private String getExtendFormIdByCfgNumber(String number) {
        String formId = null;
        if (WfUtils.isNotEmpty((String)number)) {
            formId = super.getRepositoryService().getParticipantModelCfgEntityByCfgNumber(number).getFormId();
        }
        return formId;
    }

    private String getRelationFormId() {
        return WfConfigurationUtil.isEnableNewPartRelationForm() ? "wf_part_relation_new" : "wf_part_relation";
    }
}

