/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.design.plugin.AbstractPartPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.rule.expression.property.ExpressionProperty;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;
import kd.bos.workflow.management.plugin.WfCustomReportRelationUtil;
import kd.bos.workflow.management.plugin.basedatafiltertools.FilterDimemsionParam;
import kd.bos.workflow.relservice.WorkflowUserRelQueryHelper;

public class PartRelationPluginNew
extends AbstractPartPlugin {
    public static final String FORMID = "wf_part_relation_new";
    protected static final String RELATION_TYPE = "relation_type";
    protected static final String RELATION_TYPE_PERSON = "person";
    protected static final String RELATION_TYPE_ORG = "org";
    protected static final String PANEL_PERSON = "relation_panel_2";
    protected static final String REF_PERSON = "ref_person";
    protected static final String REF_PERSON_REAL = "ref_person_real";
    protected static final String REF_PERSON_DISPLAY = "ref_person_display";
    protected static final String REPORT_TYPE = "report_type";
    protected static final String PERSON_RELATION = "person_relation";
    protected static final String REF_ORG_PERSON = "ref_org_person";
    protected static final String REF_ORG_PERSON_REAL = "ref_org_person_real";
    protected static final String REF_ORG_PERSON_DISPLAY = "ref_org_person_display";
    protected static final String PERSON_RELATION_SELF = "self";
    protected static final String REPORT_TO = "report_to";
    protected static final String REF_ORG_POSITION_DISPLAY = "ref_org_position_display";
    protected static final String PANEL_ORG = "relation_panel_3";
    protected static final String REF_ORG_ORG = "ref_org_org";
    protected static final String REF_ORG_ORG_REAL = "ref_org_org_real";
    protected static final String REF_ORG_ORG_DISPLAY = "ref_org_org_display";
    protected static final String ORG_RELATION = "org_relation";
    protected static final String PANEL_REL_PARAM = "relparam_panel";
    protected static final String PARAMS_ENTRY = "paramsentry";
    protected static final String PARAMS_NAME = "paramname";
    protected static final String PARAMS_DESC = "paramdesc";
    protected static final String PARAMS_MUSTINPUT = "paramustinput";
    protected static final String PARAMS_TYPE = "paramtype";
    protected static final String PARAMS_TYPENAME = "paramtypename";
    protected static final String PARAMS_ENTITYOBJECT = "entityobject";
    protected static final String PARAMS_MAPPINGFIELD = "parammappingfield";
    protected static final String PARAMS_VALUEFORMAT = "paramvalueformat";
    protected static final String CLOSECALLBACK_EXPR = "closecallbackexpr";
    protected static final String CLOSECALLBACK_EXPPERSON = "closecallbackexpperson";
    protected static final String CLOSECALLBACK_F7 = "closecallbackf7";
    protected static final String NUMBERVARIABLE = "number";
    protected static final String BOOLEANVARIABLE = "boolean";
    protected static final String STRINGVARIABLE = "String";
    private static final String PROC_POINT = "proc.";
    private static final String MODEL_POINT = "model.";
    private static final String JSON_PATTERN = "^\\{.*\\}$";
    private static final String REPORT_TO_DEFAULTVALUE = "1690596074244322304";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PARAMS_MAPPINGFIELD, REF_PERSON_DISPLAY, REF_ORG_PERSON_DISPLAY, REF_ORG_ORG_DISPLAY, REF_ORG_POSITION_DISPLAY});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadReportType();
        this.init();
        this.load();
        this.setControl();
        this.updateReportTypes();
        this.updateRelations();
        this.updateExtraParams();
    }

    private void setControl() {
        if (RELATION_TYPE_PERSON.equals(this.getModel().getValue(RELATION_TYPE)) && PERSON_RELATION_SELF.equals(this.getModel().getValue(PERSON_RELATION)) && "admin_org".equals(this.getModel().getValue(REPORT_TYPE))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{REF_ORG_PERSON_DISPLAY});
        }
    }

    private void init() {
        ComboProp comboProp;
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(ORG_RELATION);
        if (null != comboEdit && null != (comboProp = (ComboProp)comboEdit.getProperty())) {
            this.getPageCache().put(ORG_RELATION, SerializationUtils.toJsonString((Object)comboProp.getComboItems()));
        }
    }

    private void updateReportTypes() {
        Map<String, ComboItem> reportTypeItems = this.extractReportTypesByType(RELATION_TYPE_PERSON);
        if (!reportTypeItems.isEmpty()) {
            ((ComboEdit)this.getControl(REPORT_TYPE)).setComboItems(new ArrayList<ComboItem>(reportTypeItems.values()));
            Object reportTypeVal = this.getModel().getValue(REPORT_TYPE);
            if (reportTypeItems.size() > 0 && (StringUtils.isBlank((Object)reportTypeVal) || reportTypeItems.get(reportTypeVal.toString()) == null)) {
                Set<String> keys = reportTypeItems.keySet();
                Iterator<String> it = keys.iterator();
                this.getModel().setValue(REPORT_TYPE, (Object)it.next());
            }
        }
    }

    private void updateRelations() {
        String reprotType = (String)this.getModel().getValue(REPORT_TYPE);
        Map<String, ComboItem> relationItems = this.extractRelationsByReportType(reprotType);
        if (!relationItems.isEmpty()) {
            ArrayList<ComboItem> relations = new ArrayList<ComboItem>(relationItems.values());
            String cacheKey = reprotType + "." + PERSON_RELATION;
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(relations));
            ((ComboEdit)this.getControl(PERSON_RELATION)).setComboItems(relations);
            Object relationVal = this.getModel().getValue(PERSON_RELATION);
            if (relationItems.size() > 0 && (StringUtils.isBlank((Object)relationVal) || relationItems.get(relationVal.toString()) == null)) {
                Set<String> keys = relationItems.keySet();
                Iterator<String> it = keys.iterator();
                this.getModel().setValue(PERSON_RELATION, (Object)it.next());
                relationVal = this.getModel().getValue(PERSON_RELATION);
            }
            this.showVisibleForRefOrgPerson(relationVal);
        }
        if ("position".equals(reprotType)) {
            List<ComboItem> items = this.getPositionReportToComboxItems();
            ComboEdit comboEdit = (ComboEdit)this.getControl(REPORT_TO);
            comboEdit.setComboItems(items);
            this.getModel().setValue(REPORT_TO, StringUtils.isNotBlank((Object)this.getModel().getValue(REPORT_TO)) ? this.getModel().getValue(REPORT_TO) : REPORT_TO_DEFAULTVALUE);
        }
    }

    private List<ComboItem> getPositionReportToComboxItems() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        String positionReportTo = this.getPageCache().get("positionReportTo");
        if (WfUtils.isNotEmpty((String)positionReportTo)) {
            return SerializationUtils.fromJsonStringToList((String)positionReportTo, ComboItem.class);
        }
        try {
            LinkedHashMap reportTypes = WorkflowUserRelQueryHelper.getPositionQueryProvider().getReportTypes(new HashSet());
            reportTypes.forEach((id, name) -> items.add(new ComboItem(LocaleString.fromMap((Map)name), String.valueOf(id))));
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u8f7d\u5c97\u4f4d\u6c47\u62a5\u7c7b\u578b\u5931\u8d25", (String)"PartRelationPluginNew_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        return items;
    }

    private void updateExtraParams() {
        DynamicObjectCollection params = this.extractParamsByRelId((String)this.getModel().getValue(REPORT_TYPE), (String)this.getModel().getValue(PERSON_RELATION));
        this.getModel().deleteEntryData(PARAMS_ENTRY);
        if (params != null && params.size() > 0) {
            this.getModel().deleteEntryData(PARAMS_ENTRY);
            this.getModel().batchCreateNewEntryRow(PARAMS_ENTRY, params.size());
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map part = (Map)parameter.getCustomParam("part");
            List paramsInfo = new ArrayList();
            HashMap numberKeyParams = new HashMap();
            if (part != null && "relation".equals(part.get("type")) && (paramsInfo = (List)part.get("collaborationParams")) != null) {
                for (Map i : paramsInfo) {
                    if (!WfUtils.isNotEmpty((String)((String)i.get(NUMBERVARIABLE)))) continue;
                    numberKeyParams.put(i.get(NUMBERVARIABLE), i);
                }
            }
            for (int i = 0; i < params.size(); ++i) {
                DynamicObject entityObject;
                DynamicObject para = (DynamicObject)params.get(i);
                String paramName = para.getString(PARAMS_NAME);
                String paramDesc = para.getString(PARAMS_DESC);
                Boolean paramMustInput = para.getBoolean(PARAMS_MUSTINPUT);
                String paramType = para.getString(PARAMS_TYPE);
                String paramTypeName = ParamTypeEnum.get(paramType).getDesc();
                if (ParamTypeEnum.ENTITYOBJECT.getName().equals(paramType) && (entityObject = para.getDynamicObject(PARAMS_ENTITYOBJECT)) != null) {
                    this.getModel().setValue(PARAMS_ENTITYOBJECT, (Object)entityObject.getString(NUMBERVARIABLE), i);
                    paramTypeName = paramTypeName + "(" + entityObject.getLocaleString("name").getLocaleValue() + ")";
                }
                this.getModel().setValue(PARAMS_NAME, (Object)paramName, i);
                this.getModel().setValue(PARAMS_DESC, (Object)paramDesc, i);
                this.getModel().setValue(PARAMS_TYPE, (Object)paramType, i);
                this.getModel().setValue(PARAMS_MUSTINPUT, (Object)paramMustInput, i);
                this.getModel().setValue(PARAMS_TYPENAME, (Object)paramTypeName, i);
                if (numberKeyParams.get(paramName) == null) continue;
                String valueFormat = (String)((Map)numberKeyParams.get(paramName)).get("valueFormat");
                String paramMappingField = (String)((Map)numberKeyParams.get(paramName)).get("valueExpression");
                if (paramMappingField != null) {
                    this.getModel().setValue(PARAMS_MAPPINGFIELD, (Object)paramMappingField, i);
                }
                if (valueFormat == null) continue;
                this.getModel().setValue(PARAMS_VALUEFORMAT, (Object)valueFormat, i);
            }
        }
        String value = (String)this.getModel().getValue(RELATION_TYPE);
        this.showSubPanel(value);
    }

    private void loadReportType() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map part = (Map)parameter.getCustomParam("part");
        if (part != null && "relation".equals(part.get("type"))) {
            IDataModel model = this.getModel();
            Object reportType = part.get("reportType");
            this.setIfCheck(model, REPORT_TYPE, reportType);
            model.setValue("refpersontype", (Object)this.extractRefPersonTypeByReportType((String)reportType));
        }
    }

    private void load() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map part = (Map)parameter.getCustomParam("part");
        if (part != null && "relation".equals(part.get("type"))) {
            boolean person;
            IDataModel model = this.getModel();
            if ("position".equals(model.getValue(REPORT_TYPE))) {
                Object reportTo = part.get("reportTo");
                model.setValue(REPORT_TO, StringUtils.isNotBlank(reportTo) ? reportTo : REPORT_TO_DEFAULTVALUE);
            }
            this.setRefPersonRealValue(part);
            Object personRelation = part.get("personRelation");
            this.setIfCheck(model, PERSON_RELATION, personRelation);
            Object referenceOrg = part.get("referenceOrg");
            this.setRefOrgRealValue(part);
            Object orgRelation = part.get("orgRelation");
            this.setIfCheck(model, ORG_RELATION, orgRelation);
            Object relationType = part.get("relationType");
            if (WfUtils.isEmptyString(relationType)) {
                if (referenceOrg != null) {
                    this.setIfCheck(model, RELATION_TYPE, RELATION_TYPE_ORG);
                    person = false;
                } else {
                    this.setIfCheck(model, RELATION_TYPE, RELATION_TYPE_PERSON);
                    person = true;
                }
            } else {
                this.setIfCheck(model, RELATION_TYPE, relationType);
                person = RELATION_TYPE_PERSON.equals(relationType);
            }
            if (person) {
                this.showSubPanel(RELATION_TYPE_PERSON);
            } else {
                this.showSubPanel(RELATION_TYPE_ORG);
            }
        } else {
            this.showSubPanel(RELATION_TYPE_PERSON);
        }
    }

    private void setRefOrgRealValue(Map<String, Object> part) {
        Object referenceOrg = part.get("referenceOrg");
        if (StringUtils.isBlank((Object)referenceOrg)) {
            return;
        }
        Object referenceOrgDisplay = part.get("referenceOrgShowValue");
        if (StringUtils.isNotBlank((Object)(referenceOrgDisplay = Optional.ofNullable(referenceOrgDisplay).orElseGet(() -> {
            if (referenceOrg.toString().matches(JSON_PATTERN)) {
                try {
                    JSONObject json = (JSONObject)JSONObject.parse((String)referenceOrg.toString());
                    return json.get((Object)"showName");
                }
                catch (Exception e) {
                    this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
                }
            }
            return null;
        })))) {
            this.getModel().setValue(REF_ORG_ORG, referenceOrg);
            this.getModel().setValue(REF_ORG_PERSON, referenceOrg);
            this.getModel().setValue(REF_ORG_ORG_REAL, referenceOrg);
            this.getModel().setValue(REF_ORG_PERSON_REAL, referenceOrg);
            this.getModel().setValue(REF_ORG_ORG_DISPLAY, referenceOrgDisplay);
            this.getModel().setValue(REF_ORG_PERSON_DISPLAY, referenceOrgDisplay);
            this.getModel().setValue(REF_ORG_POSITION_DISPLAY, referenceOrgDisplay);
        } else {
            String displayName = this.findExpressionNameByNumber(this.formatExpression((String)referenceOrg));
            JSONObject json = new JSONObject();
            json.put("selectType", (Object)"2");
            json.put("showName", (Object)displayName);
            json.put("parseInfo", referenceOrg);
            String orgExp = json.toString();
            this.getModel().setValue(REF_ORG_ORG, (Object)orgExp);
            this.getModel().setValue(REF_ORG_PERSON, (Object)orgExp);
            this.getModel().setValue(REF_ORG_ORG_REAL, (Object)orgExp);
            this.getModel().setValue(REF_ORG_PERSON_REAL, (Object)orgExp);
            this.getModel().setValue(REF_ORG_ORG_DISPLAY, (Object)displayName);
            this.getModel().setValue(REF_ORG_PERSON_DISPLAY, (Object)displayName);
            this.getModel().setValue(REF_ORG_POSITION_DISPLAY, (Object)displayName);
        }
    }

    private void setRefPersonRealValue(Map<String, Object> param) {
        Object referencePerson = param.get("referencePerson");
        if (StringUtils.isBlank((Object)referencePerson)) {
            return;
        }
        if (StringUtils.isNotBlank((Object)param.get("referencePersonShowValue"))) {
            this.getModel().setValue(REF_PERSON, referencePerson);
            this.getModel().setValue(REF_PERSON_REAL, referencePerson);
            this.getModel().setValue(REF_PERSON_DISPLAY, param.get("referencePersonShowValue"));
        } else {
            String afterFormatExp = this.formatExpression((String)referencePerson);
            String referencePersonDisplay = this.findExpressionNameByNumber(afterFormatExp);
            this.getModel().setValue(REF_PERSON, (Object)afterFormatExp);
            this.getModel().setValue(REF_PERSON_REAL, (Object)afterFormatExp);
            this.getModel().setValue(REF_PERSON_DISPLAY, (Object)referencePersonDisplay);
        }
    }

    private String formatExpression(String exp) {
        if (exp.startsWith("ENTI_")) {
            return exp.replace("ENTI_", MODEL_POINT);
        }
        if (exp.startsWith("ENTRY_")) {
            return exp.replace("ENTRY_", MODEL_POINT);
        }
        if (exp.startsWith("PROC_")) {
            return exp.replace("PROC_", PROC_POINT);
        }
        return exp;
    }

    private String findExpressionNameByNumber(String exp) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Process process = this.extractProcessFromParameter(parameter);
        String displayName = "";
        if (process == null) {
            return exp;
        }
        if (exp.startsWith(PROC_POINT)) {
            if ("proc.currentParticipant".equals(exp)) {
                String sendEvt = (String)this.getView().getFormShowParameter().getCustomParam("referencePersonScene");
                if ("taskReceived".equals(sendEvt)) {
                    return ResManager.loadKDString((String)"\u4efb\u52a1\u63a5\u6536\u4eba", (String)"PartRelationPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                }
                return ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u4eba", (String)"PartRelationPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("ruleType", ConditionalRuleType.participant.toString());
            ExpressionProperty expressionObj = ExpressionPropUtils.getPropByExpression((String)exp, null, (Process)process, params);
            if (expressionObj == null) {
                return exp;
            }
            displayName = Optional.ofNullable(expressionObj.getFullName()).orElseGet(() -> ((ExpressionProperty)expressionObj).getName());
        } else if (exp.startsWith(MODEL_POINT)) {
            String entraBill = this.getEntraBill(parameter, process);
            if (WfUtils.isEmpty((String)entraBill)) {
                return exp;
            }
            EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)entraBill, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("entityNumber", entraBill);
            ExpressionProperty expressionObj = ExpressionPropUtils.getPropByExpression((String)exp, (EntityMetadata)metadata, null, params);
            if (expressionObj == null) {
                return exp;
            }
            displayName = Optional.ofNullable(expressionObj.getFullName()).orElseGet(() -> ((ExpressionProperty)expressionObj).getName());
        }
        return Optional.ofNullable(displayName).orElseGet(() -> exp);
    }

    private void showSubPanel(String relationType) {
        if (RELATION_TYPE_ORG.equals(relationType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_PERSON});
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_ORG});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_REL_PARAM});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_PERSON});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_ORG});
            int entryRowCount = this.getModel().getEntryRowCount(PARAMS_ENTRY);
            this.getView().setVisible(Boolean.valueOf(entryRowCount > 0), new String[]{PANEL_REL_PARAM});
        }
    }

    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "parammappingfield": {
                this.showExpressionForm();
                break;
            }
            case "ref_person_display": {
                this.showRefPersonExpressionForm();
                break;
            }
            case "ref_org_person_display": 
            case "ref_org_org_display": 
            case "ref_org_position_display": {
                this.showFilterDimensionsForm(key);
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void showFilterDimensionsForm(String type) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        JSONObject context = (JSONObject)showParameter.getCustomParam("context");
        if (context == null || context.getJSONObject("nodeProperties") == null) {
            return;
        }
        String nodeKey = context.getJSONObject("nodeProperties").getString("itemId");
        if (StringUtils.isNotBlank((CharSequence)nodeKey)) {
            String modelJson = context.getString("model");
            Process process = ProcessDefinitionUtil.getBpmnModel((String)modelJson).getMainProcess();
            String name = ResManager.loadKDString((String)"\u53c2\u7167\u7ec4\u7ec7", (String)"PartRelationPluginNew_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            String entityNumber = this.getEntraBill(showParameter, process);
            FilterDimemsionParam params = new FilterDimemsionParam();
            params.setFilterDimension("bos_org");
            params.setControlName(name);
            params.setEntityNumber(entityNumber);
            String executorJson = (String)this.getModel().getValue(REF_ORG_PERSON_REAL);
            if (REF_ORG_ORG_DISPLAY.equals(type)) {
                executorJson = (String)this.getModel().getValue(REF_ORG_ORG_REAL);
                this.getView().getPageCache().put("isAddMacro", "true");
            }
            if (WfUtils.isNotEmpty((String)executorJson)) {
                JSONObject exeObject = JSONObject.parseObject((String)executorJson);
                String radioOption = exeObject.getString("selectType");
                String field = exeObject.getString("showName");
                String info = exeObject.getString("parseInfo");
                if (WfUtils.isNotEmpty((String)field) && WfUtils.isNotEmpty((String)info)) {
                    params.setSelectInfo(radioOption, field, info);
                }
            }
            WfCustomReportRelationUtil.openWindow((IFormPlugin)this, params, type);
        }
    }

    private void showRefPersonExpressionForm() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        JSONObject context = (JSONObject)showParameter.getCustomParam("context");
        if (context == null || context.getJSONObject("nodeProperties") == null) {
            return;
        }
        String nodeKey = context.getJSONObject("nodeProperties").getString("itemId");
        if (StringUtils.isNotBlank((CharSequence)nodeKey)) {
            String modelJson = context.getString("model");
            Process process = ProcessDefinitionUtil.getBpmnModel((String)modelJson).getMainProcess();
            String entityNumber = this.getEntraBill(showParameter, process);
            HashMap<String, Object> content = new HashMap<String, Object>(4);
            content.put("bpmnModel", modelJson);
            content.put("entityNumber", entityNumber);
            content.put("ruleType", ConditionalRuleType.participant);
            content.put("filter", "F7");
            FormShowParameter parameter = this.getShowParameter(CLOSECALLBACK_EXPPERSON, "wf_valueexpression", content);
            parameter.setCustomParam("filter", (Object)"filterF7");
            parameter.setCustomParam("expression", this.getModel().getValue(REF_PERSON_REAL));
            String sendEvt = (String)this.getView().getFormShowParameter().getCustomParam("referencePersonScene");
            parameter.setCustomParam("participantExpScene", (Object)(WfUtils.isNotEmpty((String)sendEvt) ? sendEvt : "partRelation"));
            parameter.setCaption(ResManager.loadKDString((String)"\u53c2\u7167\u4eba", (String)"PartAssistPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            this.showForm(parameter);
        }
    }

    private void showExpressionForm() {
        String valueFormat = (String)this.getModel().getValue(PARAMS_VALUEFORMAT);
        if ("1".equals(valueFormat)) {
            String paramType = (String)this.getModel().getValue(PARAMS_TYPE);
            if (ParamTypeEnum.ENTITYOBJECT.getName().equals(paramType)) {
                String formId = (String)this.getModel().getValue(PARAMS_ENTITYOBJECT);
                if (WfUtils.isEmpty((String)formId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5de5\u4f5c\u6d41\u534f\u4f5c\u5173\u7cfb\u3002", (String)"PartRelationPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean isMultiSelect = false;
                ListShowParameter para = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
                if (para != null) {
                    para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_F7));
                    this.getView().showForm((FormShowParameter)para);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u53c2\u6570\u503c\u201d\u3002", (String)"PartRelationPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        } else {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            JSONObject context = (JSONObject)showParameter.getCustomParam("context");
            if (context == null || context.getJSONObject("nodeProperties") == null) {
                return;
            }
            String nodeKey = context.getJSONObject("nodeProperties").getString("itemId");
            if (StringUtils.isNotBlank((CharSequence)nodeKey)) {
                String expression;
                String modelJson = context.getString("model");
                Process process = ProcessDefinitionUtil.getBpmnModel((String)modelJson).getMainProcess();
                String entityNumber = this.getEntraBill(showParameter, process);
                HashMap<String, Object> content = new HashMap<String, Object>();
                content.put("bpmnModel", modelJson);
                content.put("entityNumber", entityNumber);
                content.put("ruleType", ConditionalRuleType.skip);
                if (WfUtils.isNotEmptyString((Object)this.getModel().getValue(PARAMS_MAPPINGFIELD)) && (expression = this.getModel().getValue(PARAMS_MAPPINGFIELD).toString()).startsWith("${") && expression.endsWith("}")) {
                    expression = expression.substring(2, expression.length() - 1);
                    content.put("expression", expression);
                }
                this.showForm(CLOSECALLBACK_EXPR, "wf_valueexpression", content);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "closecallbackexpr": {
                this.setCloseDataForParamField((Map)returnData);
                break;
            }
            case "closecallbackf7": {
                this.setCloseDataForF7(returnData);
                break;
            }
            case "closecallbackexpperson": {
                this.setColseForRefPerson((Map)returnData);
                break;
            }
            case "ref_org_person_display": 
            case "ref_org_org_display": 
            case "ref_org_position_display": {
                this.setColseForRefOrg(actionId, (String)returnData);
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setColseForRefOrg(String type, String returnData) {
        if (WfUtils.isEmpty((String)returnData)) {
            return;
        }
        JSONObject data = JSONObject.parseObject((String)returnData);
        if (REF_ORG_PERSON_DISPLAY.equals(type)) {
            this.getModel().setValue(REF_ORG_PERSON, (Object)returnData);
            this.getModel().setValue(REF_ORG_PERSON_REAL, (Object)returnData);
            this.getModel().setValue(REF_ORG_PERSON_DISPLAY, data.get((Object)"showName"));
        } else if (REF_ORG_POSITION_DISPLAY.equals(type)) {
            this.getModel().setValue(REF_ORG_PERSON, (Object)returnData);
            this.getModel().setValue(REF_ORG_PERSON_REAL, (Object)returnData);
            this.getModel().setValue(REF_ORG_POSITION_DISPLAY, data.get((Object)"showName"));
        } else {
            this.getModel().setValue(REF_ORG_ORG, (Object)returnData);
            this.getModel().setValue(REF_ORG_ORG_REAL, (Object)returnData);
            this.getModel().setValue(REF_ORG_ORG_DISPLAY, data.get((Object)"showName"));
        }
    }

    private void setColseForRefPerson(Map<String, Object> returnData) {
        Object expression = returnData.get("expression");
        if (StringUtils.isNotBlank((Object)expression)) {
            Object value = returnData.get("prop");
            Map props = (Map)Optional.ofNullable(SerializationUtils.fromJsonString((String)((String)value), Map.class)).orElseGet(() -> new HashMap());
            String name = (String)Optional.ofNullable(props.get("fullName")).orElseGet(() -> props.get("name"));
            this.getModel().setValue(REF_PERSON_DISPLAY, (Object)name);
            this.getModel().setValue(REF_PERSON_REAL, expression);
            this.getModel().setValue(REF_PERSON, expression);
        }
    }

    private boolean validateVariableType(String valueType, String paramType) {
        boolean typeValidation = false;
        switch (valueType) {
            case "date": {
                if (!ParamTypeEnum.DATETIME.getName().equals(paramType)) break;
                typeValidation = true;
                break;
            }
            case "boolean": {
                if (!ParamTypeEnum.BOOLEAN.getName().equals(paramType)) break;
                typeValidation = true;
                break;
            }
            case "String": {
                if (!ParamTypeEnum.TEXT.getName().equals(paramType)) break;
                typeValidation = true;
                break;
            }
            case "number": 
            case "Long": {
                if (!ParamTypeEnum.DECIMAL.getName().equals(paramType)) break;
                typeValidation = true;
                break;
            }
            case "F7": {
                if (!ParamTypeEnum.ENTITYOBJECT.getName().equals(paramType)) break;
                typeValidation = true;
                break;
            }
        }
        return typeValidation;
    }

    private void setCloseDataForF7(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRow rowData = ((ListSelectedRowCollection)returnData).get(0);
            HashMap<String, Object> valObj = new HashMap<String, Object>();
            valObj.put("id", rowData.getPrimaryKeyValue());
            String number = rowData.getNumber();
            valObj.put(NUMBERVARIABLE, number);
            String name = rowData.getName();
            valObj.put("name", name);
            this.getModel().setValue(PARAMS_MAPPINGFIELD, (Object)SerializationUtils.toJsonString(valObj));
        } else {
            this.getModel().setValue(PARAMS_MAPPINGFIELD, (Object)SerializationUtils.toJsonString((Object)returnData));
        }
    }

    private void setCloseDataForParamField(Map<String, Object> data) {
        String prop = (String)data.get("prop");
        JSONObject propObj = (JSONObject)SerializationUtils.fromJsonString((String)prop, JSONObject.class);
        String valueType = propObj.getString("valuetype");
        String expression = propObj.getString("expression");
        EntryGrid grid = (EntryGrid)this.getControl(PARAMS_ENTRY);
        int focusRow = grid.getEntryState().getFocusRow();
        String currentParamType = (String)this.getModel().getValue(PARAMS_TYPE, focusRow);
        boolean typeValidation = true;
        if ("F7".equals(valueType)) {
            String currentParamEntityObject = (String)this.getModel().getValue(PARAMS_ENTITYOBJECT, focusRow);
            String entityNumber = propObj.getString("entityNumber");
            if (StringUtils.isBlank((CharSequence)entityNumber) || !entityNumber.equalsIgnoreCase(currentParamEntityObject)) {
                typeValidation = false;
            }
        } else if (this.isPersonMacroAndVariable(expression)) {
            valueType = STRINGVARIABLE;
        }
        if (typeValidation) {
            typeValidation = this.validateVariableType(valueType, currentParamType);
        }
        if (typeValidation) {
            this.getModel().setValue(PARAMS_MAPPINGFIELD, (Object)("${" + expression + "}"), focusRow);
        } else {
            String paraTypeName = (String)this.getModel().getValue(PARAMS_TYPENAME, focusRow);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u53ea\u80fd\u9009\u62e9\u201c%s\u201d\u7c7b\u578b\u7684\u5b57\u6bb5\u3002", (String)"PartRelationPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), paraTypeName));
        }
    }

    public boolean isPersonMacroAndVariable(String expression) {
        if (expression != null) {
            if (expression.startsWith("proc") && expression.endsWith("Assignee")) {
                return true;
            }
            if (expression.startsWith("proc") && expression.endsWith("initiator")) {
                return true;
            }
            return expression.equalsIgnoreCase("currentParticipant");
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        String valFormmat;
        IDataModel model = this.getModel();
        String prop = pca.getProperty().getName();
        Object newValue = pca.getChangeSet()[0].getNewValue();
        String value = (String)model.getValue(RELATION_TYPE);
        if (RELATION_TYPE.equals(prop)) {
            this.showSubPanel(value);
            this.updateReportTypes();
        } else if (REPORT_TYPE.equals(prop)) {
            this.getModel().setValue("refpersontype", (Object)this.extractRefPersonTypeByReportType((String)newValue));
            this.updateRelations();
            this.updateExtraParams();
        } else if (PERSON_RELATION.equals(prop)) {
            this.showVisibleForRefOrgPerson(newValue);
            this.updateExtraParams();
        } else if (REF_PERSON_DISPLAY.equals(prop)) {
            this.loadRefOrgPerson((String)newValue);
        } else if ((REF_ORG_PERSON_DISPLAY.equals(prop) || REF_ORG_POSITION_DISPLAY.equals(prop)) && StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(REF_ORG_PERSON, null);
            this.getModel().setValue(REF_ORG_PERSON_REAL, null);
            this.getModel().setValue(REF_ORG_PERSON_DISPLAY, null);
            this.getModel().setValue(REF_ORG_POSITION_DISPLAY, null);
        } else if (REF_ORG_ORG_DISPLAY.equals(prop) && StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(REF_ORG_ORG_REAL, null);
            this.getModel().setValue(REF_ORG_ORG, null);
            this.getModel().setValue(REF_ORG_ORG_DISPLAY, null);
        } else if ("refpersontype".equals(prop)) {
            this.init();
        } else if (PARAMS_VALUEFORMAT.equals(prop)) {
            this.getModel().beginInit();
            this.getModel().setValue(PARAMS_MAPPINGFIELD, (Object)"", pca.getChangeSet()[0].getRowIndex());
            this.getModel().endInit();
        } else if (PARAMS_MAPPINGFIELD.equals(prop) && !"1".equals(valFormmat = pca.getChangeSet()[0].getDataEntity().getString(PARAMS_VALUEFORMAT))) {
            String newVal = (String)newValue;
            if (StringUtils.isNotBlank((CharSequence)newVal) && !newVal.contains("${")) {
                String msg = pca.getChangeSet()[0].getDataEntity().getString(PARAMS_TYPENAME);
                String paramType = pca.getChangeSet()[0].getDataEntity().getString(PARAMS_TYPE);
                boolean typeValidation = true;
                if (ParamTypeEnum.ENTITYOBJECT.getName().equals(paramType)) {
                    typeValidation = false;
                } else if (ParamTypeEnum.BOOLEAN.getName().equals(paramType)) {
                    if (!newVal.equalsIgnoreCase("true") && !newVal.equalsIgnoreCase("false")) {
                        typeValidation = false;
                    }
                } else if (ParamTypeEnum.DATETIME.getName().equals(paramType)) {
                    try {
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        LocalDateTime.parse(newVal, formatter);
                    }
                    catch (Exception e) {
                        typeValidation = false;
                        msg = String.format(ResManager.loadKDString((String)"%s\u8bf7\u6c42\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd HH:mm:ss\u3002", (String)"PartRelationPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), msg);
                    }
                } else if (ParamTypeEnum.DECIMAL.getName().equals(paramType)) {
                    try {
                        new BigDecimal(newVal);
                    }
                    catch (Exception e) {
                        typeValidation = false;
                    }
                }
                if (!typeValidation) {
                    this.getModel().beginInit();
                    this.getModel().setValue(prop, pca.getChangeSet()[0].getOldValue(), pca.getChangeSet()[0].getRowIndex());
                    this.getModel().endInit();
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u53ea\u80fd\u9009\u62e9\u201c%s\u201d\u7c7b\u578b\u7684\u5b57\u6bb5\u3002", (String)"PartRelationPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), msg));
                }
            }
            this.getView().updateView(PARAMS_ENTRY);
        }
    }

    private void loadRefOrgPerson(String newValue) {
        if (StringUtils.isBlank((CharSequence)newValue)) {
            this.getModel().setValue(REF_PERSON, null);
            this.getModel().setValue(REF_PERSON_REAL, null);
        }
        this.getModel().setValue(REF_ORG_PERSON, null);
        this.getModel().setValue(REF_ORG_PERSON_REAL, null);
        this.getModel().setValue(REF_ORG_PERSON_DISPLAY, null);
        this.getModel().setValue(REF_ORG_POSITION_DISPLAY, null);
    }

    private void showVisibleForRefOrgPerson(Object newValue) {
        Boolean isEnable = Boolean.FALSE;
        String reportType = (String)this.getModel().getValue(REPORT_TYPE);
        if (!PERSON_RELATION_SELF.equals(newValue) && "admin_org".equals(reportType)) {
            isEnable = Boolean.TRUE;
        }
        this.getView().setVisible(isEnable, new String[]{REF_ORG_PERSON_DISPLAY});
    }

    static enum ParamTypeEnum {
        DATETIME("datetime", "date", ResManager.loadKDString((String)"\u65e5\u671f\u578b", (String)"PartRelationPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0])),
        BOOLEAN("boolean", "boolean", ResManager.loadKDString((String)"\u5e03\u5c14\u578b", (String)"PartRelationPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0])),
        TEXT("text", "String", ResManager.loadKDString((String)"\u6587\u672c\u578b", (String)"PartRelationPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0])),
        DECIMAL("decimal", "number", ResManager.loadKDString((String)"\u6570\u503c\u578b", (String)"PartRelationPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0])),
        ENTITYOBJECT("entityobject", "F7", ResManager.loadKDString((String)"\u5bf9\u8c61\u578b", (String)"PartRelationPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));

        private String name;
        private String number;
        private String desc;

        private ParamTypeEnum(String name, String number, String desc) {
            this.name = name;
            this.number = number;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getNumber() {
            return this.number;
        }

        public String getDesc() {
            return this.desc;
        }

        public static ParamTypeEnum get(String name) {
            if (ParamTypeEnum.DATETIME.name.equals(name)) {
                return DATETIME;
            }
            if (ParamTypeEnum.BOOLEAN.name.equals(name)) {
                return BOOLEAN;
            }
            if (ParamTypeEnum.TEXT.name.equals(name)) {
                return TEXT;
            }
            if (ParamTypeEnum.DECIMAL.name.equals(name)) {
                return DECIMAL;
            }
            return ENTITYOBJECT;
        }
    }
}

