/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.EventSupportTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.plugin.AbstractPartPlugin;
import kd.bos.workflow.engine.WfRoleDimensionUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.RoleDimension;
import kd.bos.workflow.management.plugin.WfCustomReportRelationUtil;
import kd.bos.workflow.management.plugin.basedatafiltertools.FilterDimemsionParam;

public class PartRolePlugin
extends AbstractPartPlugin
implements Consumer<BeforeF7ViewDetailEvent> {
    public static final String FORMID = "wf_part_role";
    protected static final String ROLE = "role";
    protected static final String BOS_ORG = "bos_org";
    protected static final String DIMENSION1 = "dimension1";
    protected static final String DIMENSION2 = "dimension2";
    protected static final String DIMENSION3 = "dimension3";
    protected static final String DIMENSION4 = "dimension4";
    protected static final String ROLEDIMENSION = "roledimension";
    protected static final String SELECTINFOMAP = "selectinfomap";
    Map<String, LocaleString> fieldMap = new HashMap<String, LocaleString>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.showRoles();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BOS_ORG, DIMENSION1, DIMENSION2, DIMENSION3, DIMENSION4});
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        FilterDimemsionParam params = new FilterDimemsionParam();
        String executorJson = "";
        block7 : switch (key) {
            case "bos_org": {
                params.setFilterDimension(BOS_ORG);
                executorJson = this.getPageCache().get(BOS_ORG);
                params.setControlName(ResManager.loadKDString((String)"\u53c2\u7167\u7ec4\u7ec7", (String)"PartRelationPluginNew_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                break;
            }
            case "dimension1": 
            case "dimension2": 
            case "dimension3": 
            case "dimension4": {
                String roleDimension = this.getPageCache().get(ROLEDIMENSION);
                if (!WfUtils.isNotEmpty((String)roleDimension)) break;
                List rdList = SerializationUtils.fromJsonStringToList((String)roleDimension, RoleDimension.class);
                for (RoleDimension rd : rdList) {
                    Map infoMap;
                    String io;
                    if (!key.equals(rd.getIndex())) continue;
                    DynamicObject dynObject = WfRoleDimensionUtil.getObjectType((String)rd.getEntityNumber());
                    if (WfUtils.isNullObject((Object)dynObject)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"number\u4e3a\u201c%s\u201d\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574\u7ef4\u5ea6\u8bbe\u7f6e\u3002", (String)"PartRolePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), rd.getEntityNumber()));
                        return;
                    }
                    params.setFilterDimension(rd.getEntityNumber());
                    params.setControlName(dynObject.getDataEntityType().getDisplayName().getLocaleValue());
                    String info = this.getPageCache().get(SELECTINFOMAP);
                    if (!WfUtils.isNotEmpty((String)info) || (io = (String)(infoMap = (Map)SerializationUtils.fromJsonString((String)info, Map.class)).get(rd.getEntityNumber())) == null) break block7;
                    executorJson = io;
                    break block7;
                }
                break;
            }
        }
        params.setEntityNumber(this.getPageCache().get("entraBill"));
        this.putSelectExecutorParams(params, executorJson);
        WfCustomReportRelationUtil.openWindow((IFormPlugin)this, params, key);
    }

    public void closedCallBack(ClosedCallBackEvent arg) {
        super.closedCallBack(arg);
        String actionId = arg.getActionId();
        Object data = arg.getReturnData();
        if (WfUtils.isNotEmptyString((Object)data)) {
            FilterDimemsionParam.SelectInfo info = (FilterDimemsionParam.SelectInfo)SerializationUtils.fromJsonString((String)data.toString(), FilterDimemsionParam.SelectInfo.class);
            if (BOS_ORG.equals(info.getEntityNumber()) && actionId.equals(BOS_ORG)) {
                this.setIfCheck(this.getModel(), BOS_ORG, info.getShowName());
                this.getPageCache().put(BOS_ORG, info.toString());
            } else {
                Map<String, String> infoMap = new HashMap<String, String>();
                if (WfUtils.isNotEmpty((String)this.getPageCache().get(SELECTINFOMAP))) {
                    infoMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(SELECTINFOMAP), Map.class);
                }
                infoMap.put(info.getEntityNumber(), info.toString());
                String roleDimension = this.getPageCache().get(ROLEDIMENSION);
                if (WfUtils.isNotEmpty((String)roleDimension)) {
                    List list = SerializationUtils.fromJsonStringToList((String)roleDimension, RoleDimension.class);
                    for (RoleDimension rd : list) {
                        if (!rd.getEntityNumber().equals(info.getEntityNumber())) continue;
                        this.setIfCheck(this.getModel(), rd.getIndex(), info.getShowName());
                        break;
                    }
                }
                this.getPageCache().put(SELECTINFOMAP, SerializationUtils.toJsonString(infoMap));
            }
        }
    }

    private void putSelectExecutorParams(FilterDimemsionParam params, String executorJson) {
        if (WfUtils.isEmpty((String)executorJson)) {
            return;
        }
        JSONObject exeObject = JSONObject.parseObject((String)executorJson);
        String radioOption = exeObject.getString("selectType");
        String field = exeObject.getString("showName");
        String info = exeObject.getString("parseInfo");
        if (WfUtils.isNotEmpty((String)field) && WfUtils.isNotEmpty((String)info)) {
            params.setSelectInfo(radioOption, field, info);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
        this.load();
    }

    private void init() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Process process = this.extractProcessFromParameter(parameter);
        String entraBill = null;
        String errorInfo = null;
        if (ProcessType.AuditFlow.name().equals(process.getProcessType())) {
            entraBill = process.getEntraBill();
            List flowElementList = process.getFlowElementList();
            if (WfUtils.isEmpty((String)entraBill) && flowElementList != null && !flowElementList.isEmpty()) {
                entraBill = (String)((FlowElement)flowElementList.get(0)).getPropertyValue("entityNumber");
            }
            errorInfo = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"PartRolePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        } else {
            JSONObject nodeProperties;
            Map customParams = parameter.getCustomParams();
            JSONObject context = (JSONObject)customParams.get("context");
            if (context != null && (nodeProperties = context.getJSONObject("nodeProperties")) != null) {
                String itemId = nodeProperties.getString("itemId");
                FlowElement flowElement = process.getFlowElement(itemId);
                if (flowElement instanceof BillTask) {
                    entraBill = ((BillTask)flowElement).getEntityNumber();
                    errorInfo = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5f53\u524d\u5355\u636e\u201d\u3002", (String)"PartRolePlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                } else if (flowElement instanceof UserTask) {
                    entraBill = ((UserTask)flowElement).getEntityNumber();
                    errorInfo = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"PartRolePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                } else if (flowElement instanceof AutoTask) {
                    entraBill = MetadataDao.getNumberById((String)((AutoTask)flowElement).getEntityId());
                    errorInfo = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"PartRolePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                } else if (flowElement instanceof NotifyTask) {
                    entraBill = ((NotifyTask)flowElement).getEntityNumber();
                    errorInfo = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"PartRolePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                } else if (flowElement instanceof EventSupportTask) {
                    entraBill = MetadataDao.getNumberById((String)((EventSupportTask)flowElement).getEntityId());
                    errorInfo = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"PartRolePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                } else if (flowElement instanceof CallActivity) {
                    entraBill = ((CallActivity)flowElement).getEntityNumber();
                    errorInfo = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"PartRolePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                }
            }
        }
        if (WfUtils.isEmpty((String)entraBill)) {
            if (WfUtils.isNotEmpty(errorInfo)) {
                this.getView().showTipNotification(errorInfo);
            }
        } else {
            this.getPageCache().put("entraBill", entraBill);
            MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)entraBill);
            List<ComboItem> fieldItems = this.extractOrgItemsFromEntityCacheForPartRole((DynamicObjectType)mainEntity, ResManager.loadKDString((String)"\u5355\u636e-", (String)"PartRolePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            for (IDataEntityProperty prop : mainEntity.getProperties()) {
                if (!(prop instanceof EntryProp)) continue;
                fieldItems.addAll(this.extractOrgItemsFromEntityCacheForPartRole(((EntryProp)prop).getDynamicCollectionItemPropertyType(), null));
            }
            for (ComboItem item : fieldItems) {
                this.fieldMap.put(item.getValue(), item.getCaption());
            }
        }
    }

    private void load() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map part = (Map)parameter.getCustomParam("part");
        if (part != null && ROLE.equals(part.get("type"))) {
            JSONObject obj;
            IDataModel model = this.getModel();
            Object roleId = part.get("roleId");
            this.setIfCheck(model, ROLE, roleId);
            Object businessOrgField = part.get("businessOrgField");
            if (WfUtils.isJSONObject(businessOrgField)) {
                obj = JSONObject.parseObject((String)businessOrgField.toString());
                this.setIfCheck(model, BOS_ORG, obj.get((Object)"showName"));
            } else if (WfUtils.isNotEmptyString(businessOrgField) && !WfUtils.isJSONObject(businessOrgField)) {
                obj = new JSONObject();
                obj.put("parseInfo", businessOrgField);
                obj.put("selectType", (Object)"2");
                LocaleString field = this.fieldMap.get(businessOrgField);
                if (field != null) {
                    obj.put("showName", (Object)field.getLocaleValue());
                    this.setIfCheck(model, BOS_ORG, field.getLocaleValue());
                }
                businessOrgField = obj.toJSONString();
            }
            this.getPageCache().put(BOS_ORG, (String)businessOrgField);
            this.showDimension();
            Object dimensionField = part.get("dimensionField");
            if (WfUtils.isNotEmptyString(dimensionField)) {
                Map dimensionFieldMap = (Map)SerializationUtils.fromJsonString((String)dimensionField.toString(), Map.class);
                for (String executorJson : dimensionFieldMap.values()) {
                    if (WfUtils.isEmpty((String)executorJson)) continue;
                    JSONObject exeObject = JSONObject.parseObject((String)executorJson);
                    String radioOption = exeObject.getString("selectType");
                    String field = exeObject.getString("showName");
                    String info = exeObject.getString("parseInfo");
                    String entityNumber = exeObject.getString("entityNumber");
                    if (WfUtils.isNullObject((Object)WfRoleDimensionUtil.getObjectType((String)entityNumber))) continue;
                    this.setDimension(new FilterDimemsionParam.SelectInfo(entityNumber, radioOption, field, info));
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{DIMENSION1, DIMENSION2, DIMENSION3, DIMENSION4, BOS_ORG});
        }
    }

    private void showRoles() {
        BasedataEdit roleF7 = (BasedataEdit)this.getControl(ROLE);
        roleF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getListFilterParameter();
        });
        roleF7.addBeforeF7ViewDetailListener((Consumer)this);
    }

    private void showDimension() {
        ArrayList fieldList = Lists.newArrayList((Object[])new String[]{DIMENSION1, DIMENSION2, DIMENSION3, DIMENSION4});
        DynamicObject role = (DynamicObject)this.getModel().getValue(ROLE);
        if (role != null) {
            String roleDimension = role.getString(ROLEDIMENSION);
            if (WfUtils.isNotEmpty((String)roleDimension)) {
                StringBuilder delNumber = new StringBuilder();
                Map dimensionInfos = WfRoleDimensionUtil.getDimensionInfos((String)roleDimension);
                Boolean isOrgFieldEnable = (Boolean)Optional.ofNullable(dimensionInfos.get("isOrgFieldEnable")).orElseGet(() -> Boolean.TRUE);
                this.getView().setVisible(isOrgFieldEnable, new String[]{BOS_ORG});
                List list = (List)dimensionInfos.get("dimensions");
                for (RoleDimension dimension : list) {
                    String entityNumber = dimension.getEntityNumber();
                    DynamicObject dynObject = WfRoleDimensionUtil.getObjectType((String)entityNumber);
                    if (WfUtils.isNullObject((Object)dynObject)) {
                        delNumber = delNumber.append(entityNumber).append("\u3001");
                    } else {
                        DynamicObjectType type = dynObject.getDynamicObjectType();
                        TextEdit field = (TextEdit)this.getControl(dimension.getIndex());
                        field.setCaption(type.getDisplayName());
                        dimension.setName(type.getDisplayName());
                        this.getView().setVisible(Boolean.TRUE, new String[]{dimension.getIndex()});
                        this.setIfCheck(this.getModel(), dimension.getIndex(), null);
                    }
                    fieldList.remove(dimension.getIndex());
                }
                if (delNumber.length() != 0) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"number\u4e3a\u201c%s\u201d\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574\u7ef4\u5ea6\u8bbe\u7f6e\u3002", (String)"PartRolePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), delNumber.substring(0, delNumber.length() - 1)));
                }
                this.getPageCache().put(ROLEDIMENSION, SerializationUtils.toJsonString((Object)list));
                if (this.getView().getParentView() != null) {
                    this.getView().getParentView().getPageCache().put("partRoleDimension", SerializationUtils.toJsonString((Object)list));
                }
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{BOS_ORG});
                if (this.getView().getParentView() != null) {
                    this.getView().getParentView().getPageCache().remove("partRoleDimension");
                }
            }
        }
        if (!fieldList.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, fieldList.toArray(new String[fieldList.size()]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        switch (propName = property.getName()) {
            case "role": {
                this.getPageCache().remove(SELECTINFOMAP);
                this.getPageCache().remove(BOS_ORG);
                this.getModel().setValue(BOS_ORG, null);
                this.getModel().setValue(DIMENSION1, null);
                this.getModel().setValue(DIMENSION2, null);
                this.getModel().setValue(DIMENSION3, null);
                this.getModel().setValue(DIMENSION4, null);
                this.showDimension();
                break;
            }
            case "bos_org": {
                this.getPageCache().remove(BOS_ORG);
                break;
            }
            case "dimension1": 
            case "dimension2": 
            case "dimension3": 
            case "dimension4": {
                this.cleanDimension(propName);
                break;
            }
        }
    }

    private void setDimension(FilterDimemsionParam.SelectInfo info) {
        String roleDimension = this.getPageCache().get(ROLEDIMENSION);
        String entityNumber = info.getEntityNumber();
        if (WfUtils.isNotEmpty((String)roleDimension)) {
            List list = SerializationUtils.fromJsonStringToList((String)roleDimension, RoleDimension.class);
            for (RoleDimension rd : list) {
                if (!rd.getEntityNumber().equals(entityNumber)) continue;
                this.setIfCheck(this.getModel(), rd.getIndex(), info.getShowName());
                this.putSelectInfoMap(entityNumber, info.toString());
                break;
            }
        }
    }

    private void putSelectInfoMap(String entityNumber, String info) {
        String selectinfoString = this.getPageCache().get(SELECTINFOMAP);
        Map<String, String> infoMap = new HashMap<String, String>(4);
        if (WfUtils.isNotEmpty((String)selectinfoString)) {
            infoMap = (Map)SerializationUtils.fromJsonString((String)selectinfoString, Map.class);
        }
        infoMap.put(entityNumber, info);
        this.getPageCache().put(SELECTINFOMAP, SerializationUtils.toJsonString(infoMap));
    }

    private void cleanDimension(String propName) {
        String roleDimension = this.getPageCache().get(ROLEDIMENSION);
        if (WfUtils.isNotEmpty((String)roleDimension)) {
            List list = SerializationUtils.fromJsonStringToList((String)roleDimension, RoleDimension.class);
            for (RoleDimension rd : list) {
                if (!propName.equals(rd.getIndex())) continue;
                this.removeSelectInfoMap(rd.getEntityNumber());
                break;
            }
        }
    }

    private void removeSelectInfoMap(String entityNumber) {
        String selectinfoString = this.getPageCache().get(SELECTINFOMAP);
        if (WfUtils.isNotEmpty((String)selectinfoString)) {
            Map infoMap = (Map)SerializationUtils.fromJsonString((String)selectinfoString, Map.class);
            infoMap.remove(entityNumber);
            this.getPageCache().put(SELECTINFOMAP, SerializationUtils.toJsonString((Object)infoMap));
        }
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent beforeF7ViewDetailEvent) {
        if (StringUtils.isBlank((Object)beforeF7ViewDetailEvent.getPkId())) {
            return;
        }
        Long pkId = (Long)beforeF7ViewDetailEvent.getPkId();
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"wf_role", (String)"roletype");
        if (!"approvalposition".equals(dynObj.getString("roletype"))) {
            return;
        }
        beforeF7ViewDetailEvent.setCancel(true);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("wf_positionrole");
        Optional.ofNullable(pkId).ifPresent(x -> parameter.setPkId((Object)pkId));
        parameter.getCustomParams().put("roletype", "approvalposition");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

