/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.workflow.design.plugin.AbstractPartPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.config.ParticipantModelCfgEntity;
import kd.bos.workflow.taskcenter.plugin.util.PictureResourceEnum;

public class PartTypePlugin
extends AbstractPartPlugin
implements RowClickEventListener,
TabSelectListener {
    public static final String FORMID = "wf_part_type";
    public static final String SELECTED_TYPE = "selectedType";
    public static final String TYPE_EXTEND_NUMBER = "type_extend_number";
    private static final String ENTRY_ENTITY = "entryentity";
    protected static final String CHECKBOX_CONDITION = "checkbox_condition";
    protected static final String PARTICIPATEPIC = "pic";
    protected static final String PARTICIPATENAME = "participatename";
    private static String[] types = new String[]{"relation", "role", "position", "person", "plugin"};
    public static final String SPLITCHAR = "_wf_";
    private static final String ENTRYENTITY_EXT = "entryentity_ext";
    private static final String PICTUREFIELD_EXT = "picturefield_ext";
    private static final String TEXTFIELD_NAME_EXT = "textfield_name_ext";
    private static final String TEXTFIELD_NUMBER_EXT = "textfield_number_ext";
    private static final String CURRENTTABID = "currentTabId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        EntryGrid gridExt = (EntryGrid)this.getControl(ENTRYENTITY_EXT);
        gridExt.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
        HashMap<String, List<ParticipantModelCfgEntity>> extendMap = new HashMap<String, List<ParticipantModelCfgEntity>>();
        Boolean isExtend = this.initExtendData(extendMap, false);
        if (!isExtend.booleanValue()) {
            HashMap<String, Boolean> prop = new HashMap<String, Boolean>(1);
            prop.put("hideNav", Boolean.TRUE);
            this.getView().updateControlMetadata("tabap", prop);
        } else {
            this.getPageCache().put(CURRENTTABID, "tabpageap_default");
            this.setEntryEntityForExt(extendMap);
        }
    }

    public void afterBindData(EventObject e) {
        this.load();
    }

    private void init() {
        IDataModel model = this.getModel();
        DynamicObjectCollection collection = model.getEntryEntity(ENTRY_ENTITY);
        if (collection.size() != 5) {
            collection.clear();
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, 5);
        model.setValue(PARTICIPATEPIC, (Object)PictureResourceEnum.PC_RELATION.getValue(), 0);
        model.setValue(PARTICIPATENAME, (Object)ResManager.loadKDString((String)"\u5173\u7cfb", (String)"PartTypePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), 0);
        model.setValue(PARTICIPATEPIC, (Object)PictureResourceEnum.PC_ROLE.getValue(), 1);
        model.setValue(PARTICIPATENAME, (Object)ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272", (String)"PartTypePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), 1);
        model.setValue(PARTICIPATEPIC, (Object)PictureResourceEnum.PC_POSITION.getValue(), 2);
        model.setValue(PARTICIPATENAME, (Object)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"PartTypePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), 2);
        model.setValue(PARTICIPATEPIC, (Object)PictureResourceEnum.PC_PERSON.getValue(), 3);
        model.setValue(PARTICIPATENAME, (Object)ResManager.loadKDString((String)"\u4eba\u5458", (String)"PartTypePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), 3);
        model.setValue(PARTICIPATEPIC, (Object)PictureResourceEnum.PC_PLUGIN.getValue(), 4);
        model.setValue(PARTICIPATENAME, (Object)ResManager.loadKDString((String)"\u4e1a\u52a1\u63d2\u4ef6", (String)"PartTypePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), 4);
    }

    private void load() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map part = (Map)parameter.getCustomParam("part");
        if (part == null || part.isEmpty()) {
            this.setSelection("relation");
            this.getModel().setValue(CHECKBOX_CONDITION, (Object)Boolean.FALSE);
        } else {
            String type = part.get("type").toString();
            this.setSelection(type);
            Boolean hasCondition = WfUtils.isNotEmptyString(part.get("condrule")) || WfUtils.isNotEmptyString(part.get("condRuleId"));
            this.getModel().setValue(CHECKBOX_CONDITION, (Object)hasCondition);
        }
        this.setConditionFlexVisible(parameter.getCustomParam("openType"));
    }

    private void setConditionFlexVisible(Object openType) {
        boolean fromManagermentCenter = "managermentCenter".equals(openType);
        this.getView().setVisible(Boolean.valueOf(fromManagermentCenter), new String[]{"type_panel_3"});
        this.getView().setVisible(Boolean.valueOf(fromManagermentCenter), new String[]{"type_panel_4"});
    }

    private void setSelection(String type) {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        switch (type) {
            case "relation": {
                grid.selectRows(0);
                this.cacheSelection("relation");
                break;
            }
            case "role": {
                grid.selectRows(1);
                this.cacheSelection("role");
                break;
            }
            case "person": {
                grid.selectRows(2);
                this.cacheSelection("person");
                break;
            }
            case "plugin": {
                grid.selectRows(3);
                this.cacheSelection("plugin");
                break;
            }
            default: {
                grid.selectRows(0);
                this.cacheSelection("relation");
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry cardEntry;
        super.entryRowClick(evt);
        Object source = evt.getSource();
        if (source instanceof CardEntry && ENTRYENTITY_EXT.equals((cardEntry = (CardEntry)source).getKey())) {
            int index = cardEntry.getEntryState().getFocusRow();
            Object extNumber = this.getModel().getValue(TEXTFIELD_NUMBER_EXT, index);
            if (WfUtils.isNotEmptyString((Object)extNumber)) {
                this.cacheSelection("extend");
                String number = extNumber.toString();
                this.getPageCache().put(TYPE_EXTEND_NUMBER, super.getRepositoryService().getParticipantModelCfgEntityByCfgNumber(number).getNumber());
                return;
            }
        }
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int focusRow = grid.getEntryState().getFocusRow();
        this.cacheSelection(types[focusRow]);
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        IDataModel model = this.getModel();
        String prop = pca.getProperty().getName();
        if (CHECKBOX_CONDITION.equals(prop)) {
            Boolean condition = (Boolean)model.getValue(CHECKBOX_CONDITION);
            this.getPageCache().put(CHECKBOX_CONDITION, condition.toString());
        }
    }

    private void cacheSelection(String type) {
        this.logger.debug("kd.bos.workflow.design.plugin.PartTypePlugin.cacheSelection type: " + type);
        String cacheKey = PartTypePlugin.getSelectedKey(this.getPageCache());
        this.logger.debug("kd.bos.workflow.design.plugin.PartTypePlugin.cacheSelection cacheKey: " + cacheKey);
        this.getPageCache().put(cacheKey, type);
    }

    protected static String getSelectedKey(IPageCache pageCache) {
        String cacheKey = SELECTED_TYPE;
        String currentTabId = pageCache.get(CURRENTTABID);
        if (WfUtils.isNotEmpty((String)currentTabId)) {
            cacheKey = cacheKey + currentTabId;
        }
        return cacheKey;
    }

    private Boolean initExtendData(Map<String, List<ParticipantModelCfgEntity>> extendMap, boolean onlyForQuery) {
        Boolean isExtendVisible = Boolean.FALSE;
        List extendCfgs = super.getRepositoryService().getExtendParticipantModelCfgs();
        if (0 != extendCfgs.size()) {
            isExtendVisible = Boolean.TRUE;
            if (!onlyForQuery) {
                String key = null;
                List<ParticipantModelCfgEntity> entities = null;
                Long noCodeParticipantCfgId = 1731293124317199360L;
                Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
                for (ParticipantModelCfgEntity entity : extendCfgs) {
                    if (noCodeParticipantCfgId.equals(entity.getId()) || disabledAppIds.contains(entity.getApplicationId())) continue;
                    key = entity.getApplicationId();
                    entities = extendMap.get(key);
                    if (entities == null) {
                        entities = new ArrayList<ParticipantModelCfgEntity>();
                    }
                    entities.add(entity);
                    extendMap.put(key, entities);
                }
            }
        }
        return isExtendVisible;
    }

    public void tabSelected(TabSelectEvent evt) {
        EntryGrid grid;
        int focusRow;
        String key = evt.getTabKey();
        if (WfUtils.isNotEmpty((String)key)) {
            this.getPageCache().put(CURRENTTABID, key);
        }
        if ("tabpageap_ext".equals(key) && (focusRow = (grid = (EntryGrid)this.getControl(ENTRYENTITY_EXT)).getEntryState().getFocusRow()) < 0) {
            grid.selectRows(0);
        }
    }

    private void setEntryEntityForExt(Map<String, List<ParticipantModelCfgEntity>> extendMap) {
        Collection<List<ParticipantModelCfgEntity>> values;
        IDataModel model = this.getModel();
        String entryName = ENTRYENTITY_EXT;
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entrys = (DynamicObjectCollection)dataEntity.get(entryName);
        if (entrys.size() > 0) {
            entrys.clear();
            this.getView().updateView(entryName);
        }
        if (WfUtils.isNotEmptyForMap(extendMap) && WfUtils.isNotEmptyForCollection(values = extendMap.values())) {
            int rowCount = 0;
            for (List<ParticipantModelCfgEntity> cfgList : values) {
                if (!WfUtils.isNotEmptyForCollection(cfgList)) continue;
                rowCount += cfgList.size();
            }
            model.batchCreateNewEntryRow(entryName, rowCount);
            int i = 0;
            String avatar = null;
            for (List<ParticipantModelCfgEntity> cfgList : values) {
                if (!WfUtils.isNotEmptyForCollection(cfgList)) continue;
                for (ParticipantModelCfgEntity cfg : cfgList) {
                    avatar = cfg.getAvatar();
                    avatar = WfUtils.isNotEmpty((String)avatar) ? WfUtils.getFullPachForStaticResource((String)avatar) : PictureResourceEnum.PC_EXTEND_SMALL.getValue();
                    model.setValue(PICTUREFIELD_EXT, (Object)avatar, i);
                    model.setValue(TEXTFIELD_NAME_EXT, (Object)cfg.getName(), i);
                    model.setValue(TEXTFIELD_NUMBER_EXT, (Object)cfg.getNumber(), i);
                    ++i;
                }
            }
        }
    }
}

