/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityImpl;

public class ProcessCagetoryPlugin
extends AbstractWorkflowPlugin {
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String BIGINT_ID = "bigintid";
    private static final String PARENT_ID = "parentid";
    private static final String DESCRIPTION = "description";
    private static final String BUTTON_SAVE = "buttonsave";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ILocaleString name = (ILocaleString)this.getModel().getValue(NAME);
        this.getPageCache().put(NUMBER, (String)this.getModel().getValue(NUMBER));
        if (name != null) {
            this.getPageCache().put(NAME, name.getLocaleValue());
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_SAVE});
    }

    public void afterCreateNewData(EventObject e) {
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object parentId = baseShowParameter.getCustomParam("message");
        this.getModel().setValue(PARENT_ID, parentId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        if (BUTTON_SAVE.equals(key)) {
            String number = this.getModel().getValue(NUMBER).toString();
            String name = this.getModel().getValue(NAME).toString();
            BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
            boolean ret = false;
            if (OperationStatus.ADDNEW.equals((Object)parameter.getStatus())) {
                ret = this.isEmptyOrSpecialCharacter(number, name) && this.isCodeUniqueness(number) && this.isNameUniqueness(name);
            } else if (OperationStatus.EDIT.equals((Object)parameter.getStatus())) {
                ret = this.isEmptyOrSpecialCharacter(number, name);
                if (!ret) {
                    return;
                }
                if (WfUtils.isNotEmpty((String)number) && !number.equals(this.getPageCache().get(NUMBER))) {
                    ret = this.isCodeUniqueness(number);
                } else if (WfUtils.isNotEmpty((String)name) && !name.equals(this.getPageCache().get(NAME))) {
                    ret = this.isNameUniqueness(name);
                }
            }
            if (!ret) {
                return;
            }
            Object processCategoryEntity = null;
            Object id = parameter.getPkId();
            processCategoryEntity = WfUtils.isNotEmptyString((Object)id) ? this.getRepositoryService().getProcateById((Long)id) : new ProcessCategoryEntityImpl();
            try {
                processCategoryEntity.setDescription(this.getModel().getValue(DESCRIPTION).toString());
                processCategoryEntity.setLeaf(Boolean.TRUE);
                processCategoryEntity.setILocaleStringName((ILocaleString)this.getModel().getValue(NAME));
                processCategoryEntity.setNumber(this.getModel().getValue(NUMBER).toString());
                processCategoryEntity.setParentId((Long)this.getModel().getValue(PARENT_ID));
                Entity entity = this.getRepositoryService().saveOrUpdateEntity((Entity)processCategoryEntity);
                this.getModel().setValue(BIGINT_ID, (Object)entity.getId());
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                returnData.put(NAME, name);
                returnData.put("id", processCategoryEntity.getId());
                returnData.put(PARENT_ID, processCategoryEntity.getParentId());
                this.getView().returnDataToParent(returnData);
                this.getModel().setDataChanged(false);
                this.getView().close();
            }
            catch (Exception e) {
                this.logger.error(String.format("%s:%s", "\u4fdd\u5b58\u5931\u8d25", e));
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"ProcessCagetoryPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isEmptyOrSpecialCharacter(String number, String name) {
        StringBuilder sb = new StringBuilder();
        if (WfUtils.isEmpty((String)number)) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7f16\u7801\u201d\u3002", (String)"ProcessCagetoryPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else if (!PluginUtil.matchPattern("^[A-Za-z0-9_]+$", number)) {
            sb.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5e94\u4f7f\u7528\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f\uff0c\u907f\u514d\u4f7f\u7528\u7279\u6b8a\u5b57\u7b26\u3002", (String)"ProcessCagetoryPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            this.getView().showErrorNotification(sb.toString());
            return false;
        }
        if (WfUtils.isEmpty((String)name)) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"ProcessCagetoryPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else if (!PluginUtil.matchPattern("^([\\w\\u4e00-\\u9fa5\\-\\(\\)\\uFF08\\uFF09]+[\\w\\u4e00-\\u9fa5\\-\\(\\)\\s]*)$", name)) {
            sb.append(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u8bf7\u4f7f\u7528\u5b57\u6bcd\u3001\u4e2d\u6587\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u62ec\u53f7\u6216\u6a2a\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f \u3002", (String)"ProcessCagetoryPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            this.getView().showErrorNotification(sb.toString());
            return false;
        }
        return true;
    }

    private boolean isCodeUniqueness(String number) {
        long numberCount = this.getRepositoryService().getProcessCategoryCountByNumber((Long)this.getModel().getValue(PARENT_ID), number);
        if (numberCount > 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5df2\u5b58\u5728", (String)"ProcessCagetoryPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isNameUniqueness(String name) {
        long nameCount = this.getRepositoryService().getProcessCategoryCountByName((Long)this.getModel().getValue(PARENT_ID), name);
        if (nameCount > 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728", (String)"ProcessCagetoryPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(NUMBER);
        this.getPageCache().remove(NAME);
    }
}

