/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.WfUtils;

public class ProcessEventPlugin
extends AbstractFormPlugin {
    protected static final String ENTRYENTITY = "entryentity";
    protected static final String ENTRYNAME = "entryname";
    protected static final String ENTRYNUMBER = "entrynumber";
    protected static final String NUMBER_REGULAR_EXPRESSION = "^[A-Za-z][A-Za-z0-9_]*$";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRYENTITY);
            JSONArray jsonArray = new JSONArray();
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(ENTRYNUMBER, dynamicObject.get(ENTRYNUMBER));
                jsonObject.put(ENTRYNAME, (Object)dynamicObject.get(ENTRYNAME).toString());
                jsonArray.add((Object)jsonObject);
            }
            String validateMsg = this.validate(jsonArray);
            if (validateMsg != null) {
                args.setCancel(true);
                this.getView().showTipNotification(validateMsg);
            }
        }
    }

    protected String validate(JSONArray params) {
        if (params != null) {
            int size = params.size();
            ArrayList<String> numbers = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                JSONObject param = params.getJSONObject(i);
                String number = param.getString(ENTRYNUMBER);
                int row = i + 1;
                if (WfUtils.isEmpty((String)number) || !number.matches(NUMBER_REGULAR_EXPRESSION)) {
                    return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u201c\u53c2\u6570\u7f16\u7801\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"AbstractWorkflowNodeParamsPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), row);
                }
                int index = numbers.indexOf(number);
                if (index > -1) {
                    return String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u4e0e\u7b2c\u201c%2$s\u201d\u884c\u7684\u201c\u53c2\u6570\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"AbstractWorkflowNodeParamsPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), index + 1, row);
                }
                numbers.add(number);
                String name = param.getString(ENTRYNAME);
                if (!WfUtils.isEmpty((String)name)) continue;
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u201c\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractWorkflowNodeParamsPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), row);
            }
        }
        return null;
    }
}

