/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ProcessSelectPlugin
extends AbstractFormPlugin {
    public static final String VERSION = "version";

    public void initialize() {
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
        Button btncel = (Button)this.getView().getControl("btncancel");
        btncel.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.confirm();
        } else if (key.equalsIgnoreCase("btncancel")) {
            this.getView().close();
        }
    }

    private void confirm() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows != null && rows.length > 0) {
            FormShowParameter para = this.getView().getFormShowParameter();
            WorkflowService workflowService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            String busKey = (String)para.getCustomParam("busKey");
            IDataModel model = this.getModel();
            for (int row : rows) {
                String id = (String)model.getValue("key", row);
                String version = (String)model.getValue(VERSION, row);
                workflowService.startProcessInstanceByKeyAndVersion(busKey, id, version, null);
                this.getView().showMessage(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u63d0\u4ea4\u6210\u529f\u3002", (String)"ProcessSelectPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            this.getView().close();
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }

    public void afterCreateNewData(EventObject e) {
        String entryKey = "entryentity";
        FormShowParameter para = this.getView().getFormShowParameter();
        List cols = (List)para.getCustomParam("process");
        if (cols == null || cols.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(entryKey);
        if (cols.size() > count) {
            model.batchCreateNewEntryRow(entryKey, cols.size() - count);
        }
        int i = 0;
        for (Map op : cols) {
            model.setValue("id", op.get("id"), i);
            model.setValue("key", op.get("number"), i);
            model.setValue("name", op.get("name"), i);
            model.setValue(VERSION, op.get(VERSION), i);
            model.setValue("description", op.get("description"), i);
            ++i;
        }
        this.getView().updateView();
    }
}

