/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.util.TohandleGroupUtil;
import kd.bos.workflow.engine.WfUtils;

public class TohandleGroupListPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ToHandleGroupListDataProvider());
        super.beforeCreateListDataProvider(args);
    }

    static class ToHandleGroupListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;

        ToHandleGroupListDataProvider() {
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String userId = RequestContext.get().getUserId();
            this.queryResult = new QueryResult();
            String filterStr = this.buildFilter();
            this.queryResult.setDataCount(this.getRealCount());
            String orderBy = this.getOrderByExpr();
            DynamicObjectCollection c = TohandleGroupUtil.getTohandleGroupByUserId(start, limit, userId, filterStr, orderBy);
            this.queryResult.setCollection(c);
            return c;
        }

        private String buildFilter() {
            List filters = this.getQFilters();
            StringBuilder sb = new StringBuilder();
            if (filters.isEmpty()) {
                return sb.toString();
            }
            int len = filters.size();
            for (int j = 0; j < len; ++j) {
                QFilter f = (QFilter)filters.get(j);
                if (f.getCP().equals("ftlike") && WfUtils.isNotEmptyString((Object)f.getValue())) {
                    String value;
                    if (j != 0) {
                        sb.append(" or ");
                    }
                    if ((value = f.getValue().toString()).contains("#")) {
                        String like = value.split("#")[1];
                        if (like.contains("\b")) {
                            String[] items = like.split("\b");
                            for (int i = 0; i < items.length; ++i) {
                                sb.append(" e.FNAME like ");
                                sb.append("'%").append(items[i]).append("%' ");
                                if (i == items.length - 1) continue;
                                sb.append(" or ");
                            }
                            continue;
                        }
                        sb.append(" e.FNAME like ");
                        sb.append("'%").append(like).append("%' ");
                        continue;
                    }
                    sb.append(" e.FNAME like ");
                    sb.append("'").append(value).append("' ");
                    continue;
                }
                if (f == null || f.toString() == null || f.getProperty() == null || f.getProperty().equalsIgnoreCase("id")) continue;
                if (j != 0) {
                    sb.append(" AND ");
                }
                if (f.getCP().contains("is null") || f.getCP().contains("is not null")) {
                    String sqlFiter = f.toString().replaceAll(f.getProperty(), "e.FNAME");
                    sb.append(sqlFiter).append(" ");
                    continue;
                }
                sb.append("( ").append("e.FNAME ").append(f.getCP()).append(" '").append(f.getValue()).append("' ) ");
            }
            return sb.toString();
        }

        public int getRealCount() {
            String userId = RequestContext.get().getUserId();
            String filterStr = this.buildFilter();
            return TohandleGroupUtil.getTohandleGroupCountByUserId(userId, filterStr);
        }
    }
}

