/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class TohandleGrouppByPlugin
extends AbstractWorkflowPlugin {
    private static final String BILLNAME = "billname";
    private static final String SETTINGINFO = "settinginfo";
    private static final String SHOWINFO = "showinfo";
    private static final String GROUPBYNODE = "groupbynode";
    private static final String BTNOK = "btnok";
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, SETTINGINFO, SHOWINFO});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue(BILLNAME, params.get(BILLNAME));
        Object defValue = params.get("expression");
        if (StringUtils.isNotBlank(defValue)) {
            try {
                Map groupByInfos = (Map)SerializationUtils.fromJsonString((String)defValue.toString(), Map.class);
                this.getModel().setValue(SETTINGINFO, groupByInfos.get(SETTINGINFO));
                this.getModel().setValue(SHOWINFO, groupByInfos.get(SHOWINFO));
                this.getModel().setValue(GROUPBYNODE, (Object)((Boolean)groupByInfos.get(GROUPBYNODE)));
            }
            catch (Exception error) {
                this.logger.info("load groupInfos is fail: " + error.getMessage());
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BTNOK.equals(ctrl.getKey())) {
            this.saveGroupInfo();
        } else if (SETTINGINFO.equals(ctrl.getKey())) {
            this.showGroupSetting(SETTINGINFO);
        } else if (SHOWINFO.equals(ctrl.getKey())) {
            this.showGroupSetting(SHOWINFO);
        }
    }

    private void showGroupSetting(String key) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entityNumber", (String)customParams.get("entityNumber"));
        params.put("FROM", "MSG");
        String value = (String)this.getModel().getValue(key);
        if (WfUtils.isNotEmpty((String)value)) {
            params.put("value", value);
        }
        this.showForm(key, "wf_billsubject_light", ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1\u5206\u7ec4\u4fe1\u606f\u8bbe\u7f6e", (String)"TohandleGrouppByPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), params);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        if (event.getReturnData() == null) {
            return;
        }
        switch (actionId = event.getActionId()) {
            case "settinginfo": 
            case "showinfo": {
                this.updateGroupInfo(actionId, event.getReturnData());
                break;
            }
        }
    }

    private void updateGroupInfo(String actionId, Object returnData) {
        Map data;
        Object value;
        if (returnData instanceof Map && (value = (data = (Map)returnData).get("customSubject")) != null) {
            this.getModel().setValue(actionId, value);
        }
    }

    private void saveGroupInfo() {
        String settingInfo = (String)this.getModel().getValue(SETTINGINFO);
        if (WfUtils.isEmpty((String)settingInfo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5f85\u529e\u4efb\u52a1\u5206\u7ec4\u4fe1\u606f\u8bbe\u7f6e\u201d\u3002", (String)"TohandleGrouppByPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String showInfo = (String)this.getModel().getValue(SHOWINFO);
        if (WfUtils.isEmpty((String)showInfo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5f85\u529e\u4efb\u52a1\u5206\u7ec4\u4fe1\u606f\u663e\u793a\u8bbe\u7f6e\u201d\u3002", (String)"TohandleGrouppByPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        Object groupByNode = this.getModel().getValue(GROUPBYNODE);
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put(SETTINGINFO, settingInfo);
        obj.put(SHOWINFO, showInfo);
        obj.put(GROUPBYNODE, groupByNode);
        this.getView().returnDataToParent(obj);
        this.getView().close();
    }
}

