/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.ProcessInstanceMainOrgView;
import kd.bos.workflow.api.ViewFlowChartPermParam;
import kd.bos.workflow.design.plugin.record.ViewFlowChartPermResult;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.history.HistoricProcessInstance;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityImpl;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ViewFlowChartPermComponent {
    public static final Log log = LogFactory.getLog(ViewFlowChartPermComponent.class);
    private IFormView view;

    public ViewFlowChartPermComponent() {
    }

    public ViewFlowChartPermComponent(IFormView view) {
        this.view = view;
    }

    public ViewFlowChartPermComponent setView(IFormView view) {
        this.view = view;
        return this;
    }

    private List<Long> acquireHasPermProcessInstance() {
        String ids = (String)this.view.getFormShowParameter().getCustomParam("hasPermProcessInstanceList");
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return new ArrayList<Long>(0);
        }
        return Splitter.on((String)",").splitToList((CharSequence)ids).stream().map(Long::valueOf).collect(Collectors.toList());
    }

    public boolean processInstanceHasPerm(Long processInstanceId) {
        if (!this.needPerm()) {
            return true;
        }
        return this.acquireHasPermProcessInstance().contains(processInstanceId);
    }

    public ViewFlowChartPermResult initHasPermInstanceList(Long processInstanceId) {
        HistoricProcessInstanceEntity currentInstance = this.getHistoryService().getHistoricProcessInstance(processInstanceId);
        Long rootProcessInstanceId = currentInstance.getRootProcessInstanceId();
        if (rootProcessInstanceId == null || rootProcessInstanceId == 0L) {
            return new ViewFlowChartPermResult().setTargetId(processInstanceId);
        }
        String entityNumber = currentInstance.getEntitynumber();
        String viewFlowChatPermPlugin = this.fetchPermPlugin(entityNumber);
        if (StringUtils.isEmpty((CharSequence)viewFlowChatPermPlugin)) {
            return new ViewFlowChartPermResult().setTargetId(processInstanceId);
        }
        ViewFlowChartPermResult result = new ViewFlowChartPermResult();
        result.setPlugin(viewFlowChatPermPlugin);
        List sameRootInstanceList = this.getHistoryService().getSameRootHistoricProcessInstance(rootProcessInstanceId);
        List collect = sameRootInstanceList.stream().map(item -> {
            ProcessInstanceMainOrgView instanceOrgView = new ProcessInstanceMainOrgView();
            instanceOrgView.setProcessInstanceId(item.getProcessInstanceId());
            instanceOrgView.setProcessDefinitionId(item.getProcessDefinitionId());
            instanceOrgView.setCreateDate(item.getCreateDate());
            instanceOrgView.setMainOrgId(item.getMainOrgId());
            if (item.getSuperProcessInstanceId() == null || item.getSuperProcessInstanceId() == 0L) {
                instanceOrgView.setRootStatus(true);
            }
            return instanceOrgView;
        }).collect(Collectors.toList());
        ViewFlowChartPermParam param = new ViewFlowChartPermParam();
        param.setBillPK(currentInstance.getBusinessKey());
        param.setEntityNumber(currentInstance.getEntitynumber());
        param.setCurrentUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        param.setProcessInstanceOrgViewList(collect);
        Object o = ExternalInterfaceUtil.executeExtItf((ExtItfCallerType)ExtItfCallerType.CALALLOWVIEWCHATPROCESS, (String)viewFlowChatPermPlugin, (Object[])new Object[]{param});
        if (o == null) {
            return result.setTargetId(rootProcessInstanceId);
        }
        List processInstanceMainOrgViews = (List)new ObjectMapper().convertValue(o, (TypeReference)new TypeReference<List<ProcessInstanceMainOrgView>>(){});
        processInstanceMainOrgViews = Optional.ofNullable(processInstanceMainOrgViews).orElseGet(ArrayList::new);
        List<Long> hasPermInstanceList = processInstanceMainOrgViews.stream().map(ProcessInstanceMainOrgView::getProcessInstanceId).filter(item -> item != null && item != 0L).distinct().collect(Collectors.toList());
        Long target = this.getTarget(sameRootInstanceList, hasPermInstanceList, processInstanceId);
        return result.setHasPermInstanceList(hasPermInstanceList).setTargetId(target);
    }

    private Long getTarget(List<HistoricProcessInstanceEntity> sameRootInstanceList, List<Long> hasPermInstanceList, Long processInstanceId) {
        HashSet<Long> hasPermSet = new HashSet<Long>(hasPermInstanceList);
        HistoricProcessInstanceEntity rootInstance = this.calRootInstance(sameRootInstanceList);
        if (sameRootInstanceList.isEmpty()) {
            return rootInstance.getId();
        }
        if (hasPermSet.contains(processInstanceId)) {
            return processInstanceId;
        }
        Map<Long, HistoricProcessInstanceEntity> map = sameRootInstanceList.stream().collect(Collectors.toMap(HistoricProcessInstance::getId, item -> item));
        HistoricProcessInstanceEntity target = map.get(processInstanceId);
        int loopTime = 0;
        while (target.getSuperProcessInstanceId() != null && target.getProcessInstanceId() != 0L) {
            if (loopTime > 100) {
                throw new KDException("There may be a loop in the process, please fix the relevant data");
            }
            ++loopTime;
            Long superProcessInstanceId = target.getSuperProcessInstanceId();
            if (hasPermSet.contains(superProcessInstanceId)) {
                return superProcessInstanceId;
            }
            target = map.get(superProcessInstanceId);
        }
        return target.getId();
    }

    public boolean cellHasPerm(String cellId, Long currentInstance) {
        if (!this.needPerm()) {
            return true;
        }
        HistoricActivityInstanceEntity cell = this.getHistoryService().findHisActInstanceBy(cellId, currentInstance);
        if (cell == null) {
            return false;
        }
        Long calledProcessInstanceId = cell.getCalledProcessInstanceId();
        if (calledProcessInstanceId == null || calledProcessInstanceId == 0L) {
            return true;
        }
        return this.processInstanceHasPerm(calledProcessInstanceId);
    }

    private HistoricProcessInstanceEntity calRootInstance(List<HistoricProcessInstanceEntity> source) {
        for (HistoricProcessInstanceEntity item : source) {
            if (!Objects.equals(item.getRootProcessInstanceId(), item.getId())) continue;
            return item;
        }
        return new HistoricProcessInstanceEntityImpl();
    }

    private HistoryService getHistoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getHistoryService();
    }

    private String fetchPermPlugin(String entityNumber) {
        QFilter qFilter = new QFilter("entitynumber", "=", (Object)entityNumber);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"wf_billsubjectmodel", (String)"id,viewchatflowpermplugin", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            return "";
        }
        String permissionPlugin = dynamicObject.getString("viewchatflowpermplugin");
        if (StringUtils.isEmpty((CharSequence)permissionPlugin)) {
            return "";
        }
        return permissionPlugin;
    }

    public boolean needPerm() {
        Object plugin = this.view.getFormShowParameter().getCustomParam("permPlugin");
        if (plugin instanceof String) {
            return StringUtils.isNotEmpty((CharSequence)((String)plugin));
        }
        return false;
    }
}

