/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WfBackNodeSelectPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private String ENTRYENTITY = "entryentity";

    public void initialize() {
        Button btnok = (Button)this.getView().getControl("btnok");
        btnok.addClickListener((ClickListener)this);
        Button btncancel = (Button)this.getView().getControl("btncancel");
        btncancel.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject eo) {
        String nodesStr = (String)this.getView().getFormShowParameter().getCustomParam("nodes");
        if (WfUtils.isNotEmpty((String)nodesStr)) {
            List nodes = SerializationUtils.fromJsonStringToList((String)nodesStr, Map.class);
            IDataModel model = this.getModel();
            if (!nodes.isEmpty()) {
                model.batchCreateNewEntryRow(this.ENTRYENTITY, nodes.size());
                Iterator iter = nodes.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    Map node = (Map)iter.next();
                    this.getModel().setValue("nodeid", node.get("number"), i);
                    this.getModel().setValue("nodename", node.get("name"), i);
                    ++i;
                }
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        AbstractGrid grid = (AbstractGrid)this.getControl(this.ENTRYENTITY);
        int[] rowIndexs = grid.getEntryState().getSelectedRows();
        if (rowIndexs.length > 0) {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put("id", (String)this.getModel().getValue("nodeid", rowIndexs[0]));
            ret.put("name", (String)this.getModel().getValue("nodename", rowIndexs[0]));
            this.getView().returnDataToParent(ret);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8282\u70b9\u3002", (String)"WfBackNodeSelectPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }
}

