/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;

public class WfCallActivityConfigPlugin
extends AbstractWorkflowConfigurePlugin
implements TabSelectListener {
    public static final String TAB_BASE = "tabpageap";
    public static final String TAB_MSG = "msgtab";
    public static final String TAB_CONTROL = "controltag";
    public static final String TAB_PLUGIN = "plugintab";
    public static final String ENTITYNAMEBIG = "entityName";
    public static final String ENTITYNUMBER = "entityNumber";
    public static final String ENTITYID = "entityId";
    public static final String ADDRESSKEYNAMEBIG = "addressKeyName";
    public static final String CALLPROCESSNAMEBIG = "callProcessName";
    public static final String CALLPROCESSNUMBERBIG = "callProcessNumber";
    public static final String CALLPROCESSIDBIG = "callProcessId";
    public static final String NUMBER = "number";
    public static final String CALLPROCESSNAME = "callprocessname";
    public static final String ENTITYNAME = "entityname";
    public static final String CALLEDWAY = "calledway";
    public static final String ADDRESSKEYNAME = "addresskeyname";
    public static final String ADDRESSKEY = "addresskey";
    public static final String PLUGINS_PANEL = "task_plugins_panel";
    public static final String MESSAGE_PANEL = "task_msg_panel";
    public static final String CONTROL_PANEL = "task_control_panel";
    public static final String SHOWTEXT = "showtext";
    public static final String INPARAMETERS_PARAMVALUE = "inparameters_paramvalue";
    public static final String INPARAMETERS = "inparameters";
    public static final String INPARAMETERS_ID = "inparameters_id";
    public static final String INPARAMETERS_INDEX = "inparameters_selected_rowIndex";
    public static final String ADDRESSPROPSPANEL = "addresspropspanel";
    public static final String KEY_PLUGINS_PAGEID = "plugins_pageId";
    public static final String KEY_MESSAGE_PAGEID = "message_pageId";
    public static final String KEY_CONTROL_PAGEID = "control_pageId";
    public static final String KEY_TASKINFOFORBILLSUMMARY = "taskinfoforbillsummary";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(ADDRESSKEYNAME);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADDRESSKEYNAME, CALLPROCESSNAME, ENTITYNAME, INPARAMETERS_PARAMVALUE});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.stencilType == null) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getFormShowParameter() != null && "wf_nodeconfigview".equals(parentView.getFormShowParameter().getFormId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
        try {
            String callProcessNumber;
            this.beginInit();
            super.afterCreateNewData(e);
            JSONObject properties = this.getCellProperties();
            Object entityName = properties.get((Object)ENTITYNAMEBIG);
            this.initBizFlowProperties(properties);
            this.getModel().setValue(ENTITYNAME, entityName);
            this.repairTimerControlId(properties);
            this.visibleCalledWay();
            this.getModel().setValue(ADDRESSKEYNAME, properties.get((Object)ADDRESSKEYNAMEBIG));
            String callProcessName = properties.get((Object)CALLPROCESSNAMEBIG) == null ? "" : properties.get((Object)CALLPROCESSNAMEBIG);
            String string = callProcessNumber = properties.get((Object)CALLPROCESSNUMBERBIG) == null ? "" : properties.get((Object)CALLPROCESSNUMBERBIG);
            if (WfUtils.isNotEmptyString((Object)callProcessName)) {
                this.getModel().setValue(CALLPROCESSNAME, (Object)String.format("%s(%s)", callProcessName, callProcessNumber));
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TAB_CONTROL});
            BizFlowPluginUtil.addOrUpdateStartItemEntity(this.getModelType(), this.getIdeFormView(), properties);
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WfCallActivityConfigPlugin.class);
        }
    }

    private void initBizFlowProperties(JSONObject properties) {
        String entityNumber;
        boolean isBizFlowModel = "BizFlowModel".equals(this.modelType);
        this.getView().setVisible(Boolean.valueOf(isBizFlowModel), new String[]{ENTITYNAME});
        this.getView().setVisible(Boolean.valueOf(isBizFlowModel), new String[]{KEY_TASKINFOFORBILLSUMMARY});
        if (isBizFlowModel && WfUtils.isNotEmpty((String)(entityNumber = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, ENTITYNUMBER)))) {
            this.initBizFlowProperties(entityNumber, properties);
        }
    }

    private void repairTimerControlId(JSONObject properties) {
        JSONArray inParams = (JSONArray)DesignerModelUtil.getProperty((Map<String, Object>)properties, INPARAMETERS);
        if (inParams != null) {
            for (int i = 0; i < inParams.size(); ++i) {
                JSONObject item = inParams.getJSONObject(i);
                if (!WfUtils.isEmpty((String)item.getString("id"))) continue;
                String id = BpmnDiffUtil.getListElementId((String)"inParameters");
                this.getModel().setValue(INPARAMETERS_ID, (Object)id, i);
                this.setGridProperty(INPARAMETERS_ID, id, i);
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "callprocessname": {
                this.showCallProcess();
                break;
            }
            case "addresskeyname": {
                this.showOperation();
                break;
            }
            case "entityname": {
                DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, ENTITYNAME);
                break;
            }
            case "inparameters_paramvalue": {
                this.openExpressionProps();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void openExpressionProps() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(INPARAMETERS);
        int rowIndex = grid.getEntryState().getFocusRow();
        this.getPageCache().put(INPARAMETERS_INDEX, String.valueOf(rowIndex));
        JSONObject properties = this.getCellProperties();
        FormShowParameter parameter = this.getShowParameter(INPARAMETERS_PARAMVALUE, "wf_valueexpression");
        Object defaultVal = this.getModel().getValue(INPARAMETERS_PARAMVALUE, rowIndex);
        parameter.setCustomParam(ENTITYNUMBER, DesignerModelUtil.getProperty((Map<String, Object>)properties, "entitynumber"));
        parameter.setCustomParam("bpmnModel", (Object)this.getModelJsonString());
        parameter.setCustomParam("isVal", (Object)Boolean.TRUE);
        parameter.setCustomParam("ruleType", (Object)ConditionalRuleType.sequenceFlow);
        String expression = null;
        if (WfUtils.isNotEmptyString((Object)defaultVal)) {
            expression = defaultVal.toString();
            if (expression.startsWith("${") && expression.matches("\\$\\{.+\\}")) {
                expression = expression.replaceAll("\\$|\\{|\\}", "");
                parameter.setCustomParam("expression", (Object)expression);
            } else {
                parameter.setCustomParam("tip", (Object)WFMultiLangConstants.getValueIsNotExpressionTip());
            }
        }
        this.getView().showForm(parameter);
    }

    private void showCallProcess() {
        try {
            QFilter[] entityFilters;
            DynamicObject entity;
            String entraBillNum;
            JSONObject processProps = this.getProcessProperties();
            HashMap<String, Object> processProperties = new HashMap<String, Object>();
            processProperties.put("process_id", processProps.getString("process_id"));
            String entraBillId = processProps.getString("entraBillId");
            if (WfUtils.isEmpty((String)entraBillId) && WfUtils.isNotEmpty((String)(entraBillNum = (String)this.getView().getParentView().getFormShowParameter().getCustomParam(ENTITYID))) && (entity = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"dentityid", (QFilter[])(entityFilters = new QFilter[]{new QFilter(NUMBER, "=", (Object)entraBillNum)}))) != null) {
                entraBillId = (String)entity.get("dentityid");
            }
            if (WfUtils.isEmpty((String)entraBillId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5355\u636e\u540e\u518d\u9009\u62e9\u3002", (String)"WfCallActivityConfigPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            processProperties.put("entraBillId", entraBillId);
            processProperties.put("selected", this.getCellProperties().get((Object)CALLPROCESSIDBIG));
            if ("BizFlowModel".equals(this.modelType)) {
                processProperties.put("entraBillId", this.getCellProperties().get((Object)ENTITYID));
            }
            HashMap<String, HashMap<String, Object>> context = new HashMap<String, HashMap<String, Object>>();
            context.put("processProperties", processProperties);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("context", context);
            params.put("processType", processProps.getString("processType"));
            FormShowParameter showParameter = this.getShowParameter(CALLPROCESSNAME, "wf_selectsubprocess");
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        }
        catch (Exception e) {
            this.log.error(String.format("\u521d\u59cb\u5316\u5b50\u6d41\u7a0b\u76f8\u5173\u4fe1\u606f\u51fa\u9519--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
        }
    }

    private void showOperation() {
        try {
            JSONObject properties = this.getCellProperties();
            HashMap<String, String> processProperties = new HashMap<String, String>();
            processProperties.put("entraBill", properties.getString(ENTITYNUMBER));
            HashMap<String, HashMap<String, String>> context = new HashMap<String, HashMap<String, String>>();
            context.put("processProperties", processProperties);
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("context", context);
            params.put("selchexkbox", Boolean.FALSE);
            FormShowParameter showParameter = this.getShowParameter(ADDRESSKEYNAME, "wf_formoperation");
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        }
        catch (Exception e) {
            this.log.error(String.format("\u521d\u59cb\u5316\u64cd\u4f5c\u76f8\u5173\u4fe1\u606f\u51fa\u9519--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "callprocessname": {
                this.setCloseDataForSubProcess(returnData);
                break;
            }
            case "entityname": {
                this.setCloseDataForEntryBill(returnData);
                break;
            }
            case "addresskeyname": {
                this.setCloseDataForOperation(returnData);
                break;
            }
            case "inparameters_paramvalue": {
                this.setInParametersValue(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setInParametersValue(Object returnData) {
        if (returnData instanceof Map) {
            Map m = (Map)returnData;
            int focus = Integer.parseInt(this.getPageCache().get(INPARAMETERS_INDEX));
            String expression = (String)m.get("expression");
            if (WfUtils.isNotEmpty((String)expression)) {
                expression = String.format("${%s}", expression);
            }
            this.getModel().setValue(INPARAMETERS_PARAMVALUE, (Object)expression, focus);
        }
        this.getPageCache().remove(INPARAMETERS_INDEX);
    }

    public void setCloseDataForSubProcess(Object returnData) {
        Map evtData = (Map)returnData;
        this.getModel().setValue(CALLPROCESSNAME, (Object)String.format("%s(%s)", evtData.get("name"), evtData.get(NUMBER)));
        this.setProperty(CALLPROCESSIDBIG, evtData.get("id"));
        this.setProperty(CALLPROCESSNAMEBIG, evtData.get("name"));
        this.setProperty(CALLPROCESSNUMBERBIG, evtData.get(NUMBER));
    }

    protected void setCloseDataForEntryBill(Object returnData) {
        if (returnData instanceof Map) {
            String oriEntityNumber = (String)this.getProperty(ENTITYNUMBER);
            Map data = (Map)returnData;
            this.getModel().setValue(ENTITYNAME, data.get("name"));
            String entityId = (String)data.get("id");
            String entityName = (String)data.get("name");
            String entityNumber = (String)data.get(NUMBER);
            this.setProperties(ENTITYID, entityId, ENTITYNUMBER, entityNumber, ENTITYNAMEBIG, entityName);
            if ("BizFlowModel".equals(this.getModelType())) {
                JSONObject props = this.getCellProperties();
                this.initBizFlowProperties(entityNumber, props);
                String procEntityNumber = BizFlowPluginUtil.getProcessEntityNumber((Map<String, Object>)this.getProcessProperties());
                BizFlowPluginUtil.updateStartItemWhenEntityNumberChanged(this.getIdeFormView(), props, oriEntityNumber, procEntityNumber);
            }
        }
    }

    public void setCloseDataForOperation(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            Object name = data.get("name");
            Object number = data.get(NUMBER);
            this.setProperty(ADDRESSKEYNAMEBIG, name);
            this.setProperty("addressKey", number);
            this.getModel().setValue(ADDRESSKEYNAME, name);
            String entityNumber = (String)this.getCellProperties().get((Object)ENTITYNUMBER);
            BizFlowPluginUtil.updateStartItemOperation(this.getModelType(), entityNumber, this.getIdeFormView(), data);
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
        if (CALLEDWAY.equals(propName)) {
            this.visibleCalledWay();
        } else if (ADDRESSKEYNAME.equals(propName)) {
            if (newValue == null || "".equals(newValue.toString().trim())) {
                this.setProperty(ADDRESSKEYNAMEBIG, null);
                this.setProperty("addressKey", null);
            }
        } else if (CALLPROCESSNAME.equals(propName) && (newValue == null || "".equals(newValue.toString().trim()))) {
            this.setProperty(CALLPROCESSIDBIG, null);
            this.setProperty(CALLPROCESSNAMEBIG, null);
            this.setProperty(CALLPROCESSNUMBERBIG, null);
        }
    }

    public void visibleCalledWay() {
        String value = (String)this.getModel().getValue(CALLEDWAY);
        if ("bindByProdefId".equals(value)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap5"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap6"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap6"});
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key;
        switch (key = evt.getTabKey()) {
            case "msgtab": {
                this.loadMessagePage();
                break;
            }
            case "plugintab": {
                this.loadTaskPluginsPage();
                break;
            }
            case "controltag": {
                this.loadNodeControlPage();
                break;
            }
        }
    }

    protected void loadMessagePage() {
        String pageId = this.getPageCache().get(KEY_MESSAGE_PAGEID);
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_msgnotify_configure", MESSAGE_PANEL);
            this.getPageCache().put(KEY_MESSAGE_PAGEID, pageId);
        }
    }

    protected void loadTaskPluginsPage() {
        String pageId = this.getPageCache().get(KEY_PLUGINS_PAGEID);
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_task_plugins", PLUGINS_PANEL);
            this.getPageCache().put(KEY_PLUGINS_PAGEID, pageId);
        }
    }

    protected void loadNodeControlPage() {
        String pageId = this.getPageCache().get(KEY_CONTROL_PAGEID);
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_callactivity_control", CONTROL_PANEL);
            this.getPageCache().put(KEY_CONTROL_PAGEID, pageId);
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        if (INPARAMETERS.equals(e.getEntryProp().getName())) {
            RowDataEntity data = e.getRowDataEntities()[0];
            data.getDataEntity().set(INPARAMETERS_ID, (Object)BpmnDiffUtil.getListElementId((String)"inParameters"));
        }
        super.afterAddRow(e);
    }
}

