/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;
import org.apache.commons.collections4.map.HashedMap;

public class WfCompensateEventConfigPlugin
extends AbstractWorkflowConfigurePlugin {
    public static final String CLICK_BACKNODE = "backset_backnodename";
    public static final String CACHE_PREBILLTASK = "prebillTask";
    public static final String ENTRY_BACKSET = "backset";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CLICK_BACKNODE});
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.stencilType == null) {
            return;
        }
        try {
            this.beginInit();
            super.afterCreateNewData(e);
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WfCompensateEventConfigPlugin.class);
        }
    }

    @Override
    protected Object getInitPropValue(JSONObject properties, String propName) {
        if ("backSet".equals(propName)) {
            Object value = DesignerModelUtil.getProperty((Map<String, Object>)properties, propName);
            if (value instanceof String && WfUtils.isNotEmptyString((Object)value)) {
                value = JSON.parseArray((String)((String)value));
            }
            return value;
        }
        return super.getInitPropValue(properties, propName);
    }

    @Override
    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (CLICK_BACKNODE.equals(key)) {
            String cachePreBilltaskStr = this.getPageCache().get(CACHE_PREBILLTASK);
            if (WfUtils.isEmpty((String)cachePreBilltaskStr)) {
                ArrayList<HashedMap> backNodes = new ArrayList<HashedMap>(16);
                String modelJson = this.getModelJsonString();
                try {
                    BpmnModel bpmnModel = DesignerModelUtil.getBpmnModel(modelJson);
                    String nodeId = this.getCellProperties().getString("attachedToRefId");
                    List<FlowElement> preNodes = DesignerModelUtil.getRejectNodes(bpmnModel, nodeId);
                    FlowElement cNode = bpmnModel.getFlowElement(nodeId);
                    if (cNode instanceof BillTask) {
                        HashedMap cnode = new HashedMap(2);
                        cnode.put("name", bpmnModel.getFlowElement(nodeId).getName());
                        cnode.put("number", nodeId);
                        backNodes.add(cnode);
                    }
                    if (!preNodes.isEmpty()) {
                        for (FlowElement ele : preNodes) {
                            if (!(ele instanceof BillTask)) continue;
                            HashedMap node = new HashedMap(2);
                            node.put("name", ele.getName());
                            node.put("number", ele.getId());
                            backNodes.add(node);
                        }
                    }
                    cachePreBilltaskStr = SerializationUtils.toJsonString(backNodes);
                    this.getPageCache().put(CACHE_PREBILLTASK, cachePreBilltaskStr);
                }
                catch (Exception e) {
                    this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
                }
            }
            if ("empty".equals(cachePreBilltaskStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u524d\u5e8f\u5355\u636e\u8282\u70b9\uff0c\u53ef\u4ee5\u4e0d\u9009\u62e9\u3002", (String)"WfCompensateEventConfigPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else {
                HashedMap params = new HashedMap(1);
                params.put("nodes", cachePreBilltaskStr);
                this.showForm(key, "wf_bactnode", (Map<String, Object>)params);
            }
        } else {
            super.click(evt);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_BACKSET);
        int rowKey = grid.getEntryState().getFocusRow();
        if (CLICK_BACKNODE.equalsIgnoreCase(actionId)) {
            Map data = (Map)evt.getReturnData();
            this.getModel().setValue(CLICK_BACKNODE, data.get("name"), rowKey);
            this.getModel().setValue("backset_backnode", data.get("id"), rowKey);
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (CLICK_BACKNODE.equals(propName) && WfUtils.isEmptyString((Object)newValue)) {
            this.getModel().setValue("backset_backnode", (Object)"", rowIndex);
        }
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        if (ENTRY_BACKSET.equals(e.getEntryProp().getName())) {
            RowDataEntity data = e.getRowDataEntities()[0];
            data.getDataEntity().set("backset_id", (Object)BpmnDiffUtil.getListElementId((String)"backSet"));
        }
        super.afterAddRow(e);
    }
}

