/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.model.ServiceInfo;
import kd.bos.workflow.engine.impl.util.AutoTaskUtil;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.management.plugin.WfCustomReportRelationUtil;
import kd.bos.workflow.management.plugin.basedatafiltertools.FilterDimemsionParam;

public class WfCompensateTaskConfigPlugin
extends AbstractWorkflowConfigurePlugin
implements TabSelectListener {
    private static final String SERVICEPANELTOOLBAR = "advcontoolbarap1";
    private static final String ENTRYBILLNAME = "entityname";
    private static final String ENTRYBILLID = "entityId";
    private static final String EXECUTOR = "serviceexecutor";
    private static final String KEY_MESSAGE_PAGEID = "message_pageId";
    private static final String TAB_MESSAGE = "msgtab";
    private static final String MESSAGE_PANEL = "task_msg_panel";
    private static final String ENTRY_OPERATIONS = "operations";
    private static final String SV_OPERATIONS_OPERATION = "sv_operations_operation";
    private static final String OPERATIONS_OPERATION = "operations_operation";
    private static final String OPERATIONS_ERRORCODE = "operations_errorcode";
    private static final String REFERFILTER = "referfilter";
    private static final String BTN_ADVBTNADD = "advbtnadd";
    private static final String BTN_ADVBTNREMOVE = "advbtnremove";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ENTRYBILLNAME, EXECUTOR, SV_OPERATIONS_OPERATION});
        this.addClickListeners(new String[]{BTN_ADVBTNADD, BTN_ADVBTNREMOVE});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCreateNewData(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getFormShowParameter() != null && "wf_nodeconfigview".equals(parentView.getFormShowParameter().getFormId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
        try {
            this.beginInit();
            super.afterCreateNewData(e);
            this.initControlFieldValue();
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WfCompensateTaskConfigPlugin.class);
        }
    }

    @Override
    protected void initEntryGridValue(EntryGrid grid, JSONArray array) {
        super.initEntryGridValue(grid, array);
    }

    @Override
    protected Object getEntryFieldShowValue(String property, JSONObject data, EntryGrid grid) {
        if ("operation".equals(property)) {
            Object op = data.get((Object)property);
            ServiceInfo info = AutoTaskUtil.getServiceInfoFromString((String)((String)op));
            if (info == null) {
                return "";
            }
            String extItf = info.getExtItf();
            if ("operation".equals(info.getType())) {
                HashMap m = ExternalInterfaceUtil.castJSONToMap((Object)ExternalInterfaceUtil.getExtItfValue((String)extItf));
                Object number = m.get("forward");
                Object name = m.get("forward_name");
                return String.format("%s(%s)", name, number);
            }
            return ExternalInterfaceUtil.getFormattedShowValue((String)extItf);
        }
        return super.getEntryFieldShowValue(property, data, grid);
    }

    private void initControlFieldValue() {
        JSONObject executor;
        JSONObject properties = this.getCellProperties();
        String executorStr = (String)this.getInitPropValue(properties, EXECUTOR);
        if (WfUtils.isNotEmpty((String)executorStr) && (executor = JSONObject.parseObject((String)executorStr)) != null && !executor.isEmpty()) {
            this.getModel().setValue(EXECUTOR, executor.get((Object)"showName"));
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (ENTRYBILLNAME.equals(propName) && (WfUtils.isEmptyString((Object)newValue) || !newValue.equals(oldValue))) {
            if (WfUtils.isEmptyString((Object)newValue)) {
                this.setProperty(ENTRYBILLID, null);
            }
            this.setProperty(EXECUTOR, null);
            this.getModel().setValue(EXECUTOR, (Object)"");
            int count = this.getModel().getEntryRowCount(ENTRY_OPERATIONS);
            if (count > 0) {
                ArrayList<Integer> rows = new ArrayList<Integer>(16);
                for (int i = 0; i < count; ++i) {
                    String val = (String)this.getModel().getValue(OPERATIONS_OPERATION, i);
                    String type = ExternalInterfaceUtil.getExtItfType((String)val);
                    if (!"operation".equals(type)) continue;
                    rows.add(i);
                }
                if (!rows.isEmpty()) {
                    int[] indexes = new int[rows.size()];
                    for (int i = 0; i < rows.size(); ++i) {
                        indexes[i] = (Integer)rows.get(i);
                    }
                    this.getModel().deleteEntryRows(ENTRY_OPERATIONS, indexes);
                }
            }
        } else if (SV_OPERATIONS_OPERATION.equals(propName) && WfUtils.isEmptyString((Object)newValue)) {
            this.getModel().setValue(OPERATIONS_OPERATION, newValue, rowIndex);
        }
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "entityname": {
                DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, ENTRYBILLNAME);
                break;
            }
            case "serviceexecutor": {
                this.showSelectExecutorWindow();
                break;
            }
            case "sv_operations_operation": {
                String entityId = (String)this.getModel().getValue(ENTRYBILLID);
                if (WfUtils.isEmpty((String)entityId)) {
                    return;
                }
                EntryGrid grid = (EntryGrid)this.getControl(ENTRY_OPERATIONS);
                int focusRow = grid.getEntryState().getFocusRow();
                String extitf = (String)this.getModel().getValue(OPERATIONS_OPERATION, focusRow);
                String value = null;
                if (WfUtils.isNotEmpty((String)extitf)) {
                    ServiceInfo info = AutoTaskUtil.getServiceInfoFromString((String)extitf);
                    value = info.getExtItf();
                }
                String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script", "operation"});
                DesignerPluginUtil.openExternalInterface(this.getView(), (IFormPlugin)this, types, entityId, value, true);
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void showSelectExecutorWindow() {
        String name = ResManager.loadKDString((String)"\u670d\u52a1\u6267\u884c\u4eba", (String)"WorkflowAutoTaskConfigurePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        String modelJson = this.getModelJsonString();
        JSONObject properties = this.getCellProperties();
        String entityId = (String)BpmnModelUtil.getProperty((Map)properties, (String)"service.entityId");
        if (WfUtils.isEmpty((String)entityId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"WfCompensateTaskConfigPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String entityNumber = MetadataDao.getEntityNumberById((String)entityId);
        FilterDimemsionParam params = new FilterDimemsionParam();
        params.setFilterDimension("bos_user");
        params.setControlName(name);
        params.setModelJson(modelJson);
        params.setEntityNumber(entityNumber);
        String executorJson = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "serviceExecutor");
        this.putSelectExecutorParams(params, executorJson);
        WfCustomReportRelationUtil.openWindow((IFormPlugin)this, params);
    }

    private void putSelectExecutorParams(FilterDimemsionParam params, String executorJson) {
        if (WfUtils.isEmpty((String)executorJson)) {
            return;
        }
        JSONObject exeObject = JSONObject.parseObject((String)executorJson);
        String radioOption = exeObject.getString("selectType");
        String field = exeObject.getString("showName");
        String info = exeObject.getString("parseInfo");
        if (WfUtils.isNotEmpty((String)field) && WfUtils.isNotEmpty((String)info)) {
            params.setSelectInfo(radioOption, field, info);
        }
    }

    private void setCloseDataForExecutor(Object returnData) {
        String selectInfoStr = (String)returnData;
        if (selectInfoStr != null) {
            JSONObject selectInfoObject = JSONObject.parseObject((String)selectInfoStr);
            String showName = selectInfoObject.getString("showName");
            this.getModel().setValue(EXECUTOR, (Object)showName);
            this.setProperty(EXECUTOR, selectInfoStr);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        if (TAB_MESSAGE.equals(key)) {
            this.loadMessagePage();
        }
    }

    protected void loadMessagePage() {
        String pageId = this.getPageCache().get(KEY_MESSAGE_PAGEID);
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_msgnotify_configure", MESSAGE_PANEL);
            this.getPageCache().put(KEY_MESSAGE_PAGEID, pageId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "entityname": {
                this.setCloseDataForEntryBill(returnData);
                break;
            }
            case "referfilter": {
                this.setCloseDataForExecutor(returnData);
                break;
            }
            case "externalInterface": {
                if (!WfUtils.isNotEmptyString((Object)returnData)) break;
                ServiceInfo info = AutoTaskUtil.getServiceInfoFromString((String)((String)returnData));
                EntryGrid grid = (EntryGrid)this.getControl(ENTRY_OPERATIONS);
                int focusRow = grid.getEntryState().getFocusRow();
                this.getModel().setValue(OPERATIONS_OPERATION, (Object)info.getExtItf(), focusRow);
                if ("operation".equals(info.getType())) {
                    HashMap m = ExternalInterfaceUtil.castJSONToMap((Object)ExternalInterfaceUtil.getExtItfValue((String)info.getExtItf()));
                    Object number = m.get("forward");
                    Object name = m.get("forward_name");
                    this.getModel().setValue(SV_OPERATIONS_OPERATION, (Object)String.format("%s(%s)", name, number), focusRow);
                    break;
                }
                this.getModel().setValue(SV_OPERATIONS_OPERATION, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)info.getExtItf()), focusRow);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setCloseDataForEntryBill(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.getModel().setValue(ENTRYBILLNAME, data.get("name"));
            String entityId = (String)data.get("id");
            this.setProperties(ENTRYBILLID, entityId, ENTRYBILLNAME, data.get("name"));
            this.getModel().setValue(ENTRYBILLID, (Object)entityId);
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        if (ENTRY_OPERATIONS.equals(e.getEntryProp().getName())) {
            RowDataEntity data = e.getRowDataEntities()[0];
            data.getDataEntity().set("operations_id", (Object)BpmnDiffUtil.getListElementId((String)ENTRY_OPERATIONS));
        }
        super.afterAddRow(e);
    }
}

