/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;

public class WfLightBillSubjectMulLangPlugin
extends AbstractWorkflowPlugin {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String INSERTEXPRESSION = "insertexpression";
    public static final String INSERTFIELD = "insertfield";
    public static final String CONFIRM = "btnok";
    public static final String CANCEL = "btncancel";
    public static final String FROM = "FROM";
    public static final String NUMBERMAPNAME = "numberMapName";
    private static final String CONTENT = "content";
    private static final String CONTENT_MUL = "content_mul";
    public static final String PAGECACHE_SAMPLEMAP = "sampleMap";
    public static final String COSMIC = "cosmic";
    public static final String CUSTOM = "custom";
    public static final String SAMPLE = "sample";
    public static final String EXPRESSION = "expression";
    public static final String ENTITYNUMBERBIG = "entityNumber";
    private static final String DELEGATIONSTATE = "delegationstate";
    private static final String LOCALE = "locale";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM, CANCEL, INSERTEXPRESSION});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (key.equals(INSERTEXPRESSION)) {
            this.showExpressionForm();
        } else if (CONFIRM.equals(key)) {
            this.getPageCache().remove(FROM);
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            ILocaleString content = this.fetchContent();
            content.put((Object)((String)this.getModel().getValue(LOCALE)), (Object)((String)this.getModel().getValue(CONTENT)));
            if (content.containsKey((Object)"GLang")) {
                Lang lang = RequestContext.get().getLang();
                content.put((Object)"GLang", content.get((Object)lang.name()));
            }
            returnData.put("customSubject", content);
            returnData.put(SAMPLE, this.getPageCache().get(PAGECACHE_SAMPLEMAP));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if (CANCEL.equals(key)) {
            this.getPageCache().remove(FROM);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnObj;
        Map m;
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (INSERTEXPRESSION.equals(key) && (m = (Map)(returnObj = closedCallBackEvent.getReturnData())) != null && !WfUtils.isNullObject(m.get(EXPRESSION)) && WfUtils.isNotEmptyString(m.get("prop"))) {
            Map propMap = (Map)SerializationUtils.fromJsonString((String)m.get("prop").toString(), Map.class);
            Object content = this.getModel().getValue(CONTENT);
            content = WfUtils.isNotEmptyString((Object)content) ? content : "";
            String expression = "{" + m.get(EXPRESSION) + "}";
            if (WfUtils.isEmpty((String)this.getPageCache().get(FROM)) && WfUtils.isNotEmpty((String)((String)propMap.get("name")))) {
                String propName = WfUtils.isEmpty((String)((String)propMap.get("fullName"))) ? (String)propMap.get("name") : (String)propMap.get("fullName");
                expression = propName + "\uff1a" + expression;
                if (WfUtils.isNotEmptyString(propMap.get(SAMPLE))) {
                    HashMap sampleMap = WfUtils.isNotEmpty((String)this.getPageCache().get(PAGECACHE_SAMPLEMAP)) ? (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PAGECACHE_SAMPLEMAP), Map.class) : new HashMap();
                    sampleMap.put(m.get(EXPRESSION).toString(), propMap.get(SAMPLE));
                    this.getPageCache().put(PAGECACHE_SAMPLEMAP, SerializationUtils.toJsonString(sampleMap));
                }
                if (WfUtils.isNotEmptyString((Object)content)) {
                    expression = "/" + expression;
                }
            }
            content = content + expression;
            if ("wf_autocoordinatemsg".equals(this.getView().getEntityId()) && content.toString().length() > 255) {
                content = content.toString().subSequence(0, 255);
            }
            this.getModel().setValue(CONTENT, content);
        }
    }

    private void showExpressionForm() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String modelJson = (String)showParameter.getCustomParam("modelJson");
        String entityNumber = (String)showParameter.getCustomParam(ENTITYNUMBERBIG);
        String comeFrom = (String)showParameter.getCustomParam(FROM);
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("bpmnModel", modelJson);
        content.put(ENTITYNUMBERBIG, entityNumber);
        content.put("ruleType", ConditionalRuleType.skip);
        content.put("fromSubjectModelAndApp", "fromSubjectModelAndApp");
        if (WfUtils.isNotEmpty((String)comeFrom) && "MSG".equals(comeFrom)) {
            String type = (String)showParameter.getCustomParam("type");
            if (COSMIC.equals(type) || CUSTOM.equals(type)) {
                content.put("ruleType", "EventConfig");
                content.put("eventnumber", showParameter.getCustomParam("eventnumber"));
            } else {
                content.put("ruleType", ConditionalRuleType.sequenceFlow);
            }
        }
        this.showForm(INSERTEXPRESSION, "wf_valueexpression", content);
    }

    public void afterCreateNewData(EventObject e) {
        List<EnabledLang> enabledLangs = this.initLocale();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityNumber = (String)parameter.getCustomParam(ENTITYNUMBERBIG);
        if (WfUtils.isNotEmptyString((Object)parameter.getCustomParam(FROM))) {
            this.getPageCache().put(FROM, (String)parameter.getCustomParam(FROM));
        }
        if (WfUtils.isEmptyString((Object)parameter.getCustomParam("type"))) {
            if (WfUtils.isEmptyString((Object)entityNumber)) {
                this.log.debug(String.format("\u5355\u636e\u4e3b\u9898\u53c2\u6570\u51fa\u9519--\u53c2\u6570\u4e3a\u7a7a\uff01 %s %s", "WfLightBillSubjectPlugin", ENTITYNUMBERBIG));
            }
            this.setFieldComboItems(entityNumber);
        } else if (WfUtils.isNotEmptyString((Object)entityNumber)) {
            this.setFieldComboItems(entityNumber);
        }
        String valueStr = (String)parameter.getCustomParam("value");
        if (valueStr == null) {
            return;
        }
        LocaleString value = LocaleString.fromMap((Map)((Map)SerializationUtils.fromJsonString((String)valueStr, Map.class)));
        this.getPageCache().put(CONTENT_MUL, valueStr);
        String lang = (String)this.getModel().getValue(LOCALE);
        String content = (String)value.getItem(lang);
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            this.getModel().setValue(CONTENT, (Object)content);
        } else if (this.oldContent((ILocaleString)value)) {
            String gLang = (String)value.getItem("GLang");
            this.getModel().setValue(CONTENT, (Object)gLang);
            for (EnabledLang item : enabledLangs) {
                value.put(item.getNumber(), (Object)gLang);
            }
            this.putContent((ILocaleString)value);
        }
    }

    private boolean oldContent(ILocaleString content) {
        for (Map.Entry item : content.entrySet()) {
            if ("GLang".equals(item.getKey()) || !StringUtils.isNotEmpty((CharSequence)((CharSequence)item.getValue()))) continue;
            return false;
        }
        return true;
    }

    private void setFieldComboItems(String entityNumber) {
        MainEntityType entityType;
        if (WfUtils.isEmpty((String)entityNumber)) {
            this.log.debug("NodeTemplate,There is't entityId");
            return;
        }
        HashMap<String, String> numberMapName = new HashMap<String, String>();
        MainEntityType mainType = entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Iterator iter = mainType.getAllFields().values().iterator();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        while (iter.hasNext()) {
            ComboItem item = new ComboItem();
            IDataEntityProperty fieldProp = (IDataEntityProperty)iter.next();
            if (WfUtils.isEmpty((String)fieldProp.getAlias()) || entityNumber.equals("wf_hitaskinst") && DELEGATIONSTATE.equals(fieldProp.getName()) || TaskExtendFieldUtil.isSpecialPropNeedRemove((String)entityNumber, (IDataEntityProperty)fieldProp).booleanValue() || !(fieldProp instanceof IFieldHandle) || WfUtils.isNotEmpty((String)fieldProp.getParent().getName()) && !entityNumber.equals(fieldProp.getParent().getName()) || fieldProp instanceof MulBasedataProp) continue;
            if (!(fieldProp instanceof BasedataProp) && !(fieldProp instanceof AttachmentProp)) {
                item.setValue(fieldProp.getName());
                item.setCaption(((IFieldHandle)fieldProp).getDisplayName());
                numberMapName.put(item.getValue(), item.getCaption().toString());
            }
            items.add(item);
        }
        ComboEdit fieldCombo = (ComboEdit)this.getControl(INSERTFIELD);
        this.getPageCache().put(NUMBERMAPNAME, SerializationUtils.toJsonString(numberMapName));
        fieldCombo.setComboItems(items);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName().toLowerCase();
        if (INSERTFIELD.endsWith(propertyName)) {
            Object fieldObj = this.getModel().getValue(INSERTFIELD);
            if (WfUtils.isNotEmptyString((Object)fieldObj)) {
                Object content = this.getModel().getValue(CONTENT);
                content = WfUtils.isNotEmptyString((Object)content) ? content : "";
                String fieldValue = "{" + fieldObj + "}";
                if (WfUtils.isEmpty((String)this.getPageCache().get(FROM))) {
                    String numberMapNameStr = this.getPageCache().get(NUMBERMAPNAME);
                    if (WfUtils.isNotEmpty((String)numberMapNameStr)) {
                        Map numberMapName = (Map)SerializationUtils.fromJsonString((String)numberMapNameStr, Map.class);
                        String name = (String)numberMapName.get(fieldObj);
                        fieldValue = name + "\uff1a" + fieldValue;
                    }
                    if (WfUtils.isNotEmptyString((Object)content)) {
                        fieldValue = "/" + fieldValue;
                    }
                }
                content = content + fieldValue;
                if ("wf_autocoordinatemsg".equals(this.getView().getEntityId()) && content.toString().length() > 255) {
                    content = content.toString().subSequence(0, 255);
                }
                this.getModel().setValue(CONTENT, content);
            }
        } else if (LOCALE.equals(propertyName)) {
            String currentValue;
            ChangeData changeData = e.getChangeSet()[0];
            String oldLang = (String)changeData.getOldValue();
            String newLang = (String)changeData.getNewValue();
            ILocaleString content = this.fetchContent();
            String oldValue = (String)content.get((Object)oldLang);
            if (!StringUtils.equals((CharSequence)oldValue, (CharSequence)(currentValue = (String)this.getModel().getValue(CONTENT)))) {
                content.put((Object)oldLang, (Object)currentValue);
                this.putContent(content);
            }
            String item = (String)content.getItem(newLang);
            this.getModel().setValue(CONTENT, (Object)item);
        }
    }

    public ILocaleString fetchContent() {
        String s = this.getPageCache().get(CONTENT_MUL);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return new LocaleString();
        }
        return LocaleString.fromMap((Map)((Map)SerializationUtils.fromJsonString((String)s, Map.class)));
    }

    public void putContent(ILocaleString content) {
        this.getPageCache().put(CONTENT_MUL, SerializationUtils.toJsonString((Object)content));
    }

    private List<EnabledLang> initLocale() {
        List langList = InteServiceHelper.getMultiLangEnabledLang();
        LinkedHashMap<String, Object> items = new LinkedHashMap<String, Object>(langList.size());
        for (EnabledLang enabledLang : langList) {
            items.put(enabledLang.getName(), enabledLang.getNumber());
        }
        PluginUtil.setComboForControl(items, (ComboEdit)this.getControl(LOCALE));
        String lang = Lang.get().toString();
        this.getModel().setValue(LOCALE, (Object)lang);
        return langList;
    }
}

