/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.operation.IWfOperationPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.task.center.operation.OperationsRegister;
import org.apache.commons.beanutils.MethodUtils;

public class WfOperationEditPlugin
extends AbstractWorkflowPlugin {
    private static Log log = LogFactory.getLog(WfOperationEditPlugin.class);
    public static final String RADIO_NAME = "name";
    public static final String RADIO_VALUE = "value";
    public static final String SELECTED = "selected";
    public static final String FORM_ID = "formId";
    public static final String OPEN_PARAMS = "openParams";
    public static final String RADIO_MAP_FORMID = "radioMapFormId";
    public static final String SUB_PAGEID = "subPageId";
    public static final String BTNCANCEL = "btncancel";
    public static final String BTNOK = "btnok";
    public static final String ORADIOGROUP = "oradiogroup";
    public static final String OPERATIONPANEL = "operationpanel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNCANCEL, BTNOK});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.formattAndReturnData();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private void formattAndReturnData() {
        String subPageId = this.getPageCache().get(SUB_PAGEID);
        if (WfUtils.isNotEmpty((String)subPageId)) {
            IFormView subView = this.getView().getView(subPageId);
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)subView.getService(FormViewPluginProxy.class);
            IWfOperationPlugin extItfPlugin = null;
            List plugins = pluginProxy.getPlugIns();
            Map result = null;
            for (IFormPlugin plugin : plugins) {
                if (!(plugin instanceof IWfOperationPlugin)) continue;
                extItfPlugin = (IWfOperationPlugin)plugin;
                try {
                    result = (Map)MethodUtils.invokeMethod((Object)extItfPlugin, (String)"returnData", null);
                }
                catch (Exception e) {
                    log.error(String.format("invoke WorkflowExternalInterfacePlugin's %s method error! %s", "returnData", e.getMessage()));
                }
                break;
            }
            if (result == null) {
                return;
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        } else if ("skipExpire".equals(this.getModel().getValue(ORADIOGROUP))) {
            HashMap<String, String> returnData = new HashMap<String, String>();
            returnData.put(RADIO_NAME, ResManager.loadKDString((String)"\u8df3\u8fc7", (String)"WfOperationEditPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            returnData.put("operationNumber", "skipExpire");
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ORADIOGROUP.equals(name)) {
            String operation = (String)this.getModel().getValue(ORADIOGROUP);
            Map radioMapFormId = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(RADIO_MAP_FORMID), Map.class);
            String formId = (String)radioMapFormId.get(operation.toLowerCase());
            this.openOperationForm(formId, null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map operationCfg = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        String numbers = (String)operationCfg.get("numbers");
        List operationMetas = OperationsRegister.getInstance().getExpireOperationMetasByNumbers(numbers);
        if (operationMetas != null && !operationMetas.isEmpty()) {
            String value = (String)((Map)operationMetas.get(0)).get(RADIO_VALUE);
            HashMap<String, String> radioMapFormId = new HashMap<String, String>(operationMetas.size());
            for (Map i : operationMetas) {
                String val = i.get(RADIO_VALUE).toString().toLowerCase();
                this.getView().setVisible(Boolean.TRUE, new String[]{val});
                radioMapFormId.put(val, (String)i.get(FORM_ID));
            }
            if (WfUtils.isNotEmptyString(operationCfg.get("number"))) {
                value = (String)operationCfg.get("number");
            }
            value = value.toLowerCase();
            this.getPageCache().put(RADIO_MAP_FORMID, SerializationUtils.toJsonString(radioMapFormId));
            this.getModel().setValue(ORADIOGROUP, (Object)value);
            Object hideAutoAudit = this.getView().getFormShowParameter().getCustomParam("hideAutoAudit");
            if (hideAutoAudit != null && ((Boolean)hideAutoAudit).booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"autoauditexpire"});
            }
            this.openOperationForm((String)radioMapFormId.get(value), operationCfg.get(OPEN_PARAMS));
        }
    }

    private void openOperationForm(String formId, Object openOperationParams) {
        String subPageId = this.getPageCache().get(SUB_PAGEID);
        if (WfUtils.isNotEmpty((String)subPageId)) {
            HashMap<String, String> pageIds = new HashMap<String, String>();
            pageIds.put("pageId", subPageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", pageIds);
            this.getPageCache().remove(SUB_PAGEID);
        }
        if (WfUtils.isNotEmpty((String)formId)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            String controlType = (String)this.getView().getFormShowParameter().getCustomParam("controlType");
            if ("wf_sendmsgoperation".equals(formId) && WfUtils.isNotEmpty((String)controlType)) {
                parameter.setCustomParam("controlType", (Object)controlType);
            }
            if (WfUtils.isNotEmptyString((Object)openOperationParams)) {
                parameter.setCustomParam(OPEN_PARAMS, openOperationParams);
            }
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPERATIONPANEL));
            parameter.setFormId(formId);
            parameter.setShowTitle(false);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(OPERATIONPANEL);
            this.showForm(parameter);
            subPageId = parameter.getPageId();
            this.getPageCache().put(SUB_PAGEID, subPageId);
        }
    }

    private Map<String, Object> createFlexPanel() {
        HashMap<String, Object> panel = new HashMap<String, Object>();
        HashMap s = new HashMap();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("r", "");
        m.put("b", "15px");
        m.put("t", "10px");
        m.put("l", "");
        s.put("m", m);
        panel.put("s", s);
        HashMap<String, String> w = new HashMap<String, String>();
        w.put("en_US", "100%");
        w.put("zh_CN", "100%");
        w.put("zh_TW", "100%");
        panel.put("w", w);
        panel.put("id", "operationitems");
        panel.put("gr", 1);
        HashMap<String, String> text = new HashMap<String, String>();
        text.put("en_US", ResManager.loadKDString((String)"Flex\u9762\u677f", (String)"WfOperationEditPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        text.put("zh_CN", ResManager.loadKDString((String)"Flex\u9762\u677f", (String)"WfOperationEditPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        text.put("zh_TW", ResManager.loadKDString((String)"Flex\u9762\u677f", (String)"WfOperationEditPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        panel.put("text", text);
        panel.put("wr", Boolean.TRUE);
        panel.put("type", "flexpanel");
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        Map<String, Object> labelMap = this.createLabel();
        items.add(labelMap);
        panel.put("items", items);
        return panel;
    }

    private Map<String, Object> createLabel() {
        HashMap<String, Object> labelMap = new HashMap<String, Object>();
        labelMap.put("showStyle", 0);
        HashMap s = new HashMap();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("r", "");
        m.put("b", "");
        m.put("t", "28px");
        m.put("l", "30px");
        s.put("m", m);
        labelMap.put("s", s);
        HashMap<String, String> w = new HashMap<String, String>();
        w.put("en_US", "100px");
        w.put("zh_CN", "100px");
        w.put("zh_TW", "100px");
        labelMap.put("w", w);
        HashMap<String, String> caption = new HashMap<String, String>();
        caption.put("en_US", ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\uff1a", (String)"WfOperationEditPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        caption.put("zh_CN", ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\uff1a", (String)"WfOperationEditPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        caption.put("zh_TW", ResManager.loadKDString((String)"\u64cd\u4f5c\u985e\u578b\uff1a", (String)"WfOperationEditPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        labelMap.put("caption", caption);
        labelMap.put("id", "labelap");
        HashMap<String, String> text = new HashMap<String, String>();
        text.put("en_US", ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\uff1a", (String)"WfOperationEditPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        text.put("zh_CN", ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\uff1a", (String)"WfOperationEditPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        text.put("zh_TW", ResManager.loadKDString((String)"\u64cd\u4f5c\u985e\u578b\uff1a", (String)"WfOperationEditPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        labelMap.put("text", text);
        labelMap.put("type", "label");
        return labelMap;
    }

    private Map<String, Object> createRadio(Object value, Object name) {
        HashMap<String, Object> radio = new HashMap<String, Object>();
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("v", value);
        item.put("mi", Boolean.FALSE);
        item.put("type", "radio");
        item.put("fu", Boolean.TRUE);
        item.put("group", ORADIOGROUP);
        radio.put("item", item);
        HashMap s = new HashMap();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("r", "0px");
        m.put("b", "0px");
        m.put("t", "");
        m.put("l", "0px");
        s.put("m", m);
        radio.put("s", s);
        HashMap<String, String> w = new HashMap<String, String>();
        w.put("en_US", "180px");
        w.put("zh_CN", "180px");
        w.put("zh_TW", "180px");
        radio.put("w", w);
        HashMap<String, Object> caption = new HashMap<String, Object>();
        caption.put("en_US", name);
        caption.put("zh_CN", name);
        caption.put("zh_TW", name);
        radio.put("caption", caption);
        radio.put("id", value);
        radio.put("l", 52);
        radio.put("type", "fieldcon");
        return radio;
    }
}

