/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WfParticipantSettingPlugin
extends AbstractWorkflowPlugin {
    private static final String CONTENT = "content";
    public static final String INSERTFIELD = "insertfield";
    public static final String CONFIRM = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (CONFIRM.equals(key)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("settingValue", this.getModel().getValue(CONTENT));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (WfUtils.isNotEmptyString((Object)parameter.getCustomParam("value"))) {
            this.getModel().setValue(CONTENT, parameter.getCustomParam("value"));
        }
        this.setFieldComboItems();
    }

    private void setFieldComboItems() {
        MainEntityType entityType;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        MainEntityType mainType = entityType = EntityMetadataCache.getDataEntityType((String)"bos_user");
        Iterator iter = mainType.getAllFields().values().iterator();
        while (iter.hasNext()) {
            ComboItem item = new ComboItem();
            IDataEntityProperty fieldProp = (IDataEntityProperty)iter.next();
            if (!this.isPermitShow(fieldProp)) continue;
            item.setValue(fieldProp.getName());
            item.setCaption(fieldProp.getDisplayName());
            items.add(item);
        }
        ComboItem itemNameWithoutNumber = new ComboItem();
        itemNameWithoutNumber.setCaption(new LocaleString(ResManager.loadKDString((String)"\u59d3\u540d\uff08\u91cd\u540d\u4e0d\u52a0\u6ce8\u5de5\u53f7\uff09", (String)"WfParticipantSettingPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        itemNameWithoutNumber.setValue("nameWithoutNumber");
        items.add(itemNameWithoutNumber);
        QFilter qfilter1 = new QFilter("entitynumber", "=", (Object)"bos_user");
        QFilter qfilter2 = new QFilter("valuetype", "=", (Object)"String");
        QFilter qfilter3 = new QFilter("controltype", "=", (Object)"text");
        QFilter[] filters = new QFilter[]{qfilter1, qfilter2, qfilter3};
        DynamicObjectCollection expressionexts = QueryServiceHelper.query((String)"wf_expressionext", (String)"number,name", (QFilter[])filters);
        String extNum = null;
        for (DynamicObject expressionext : expressionexts) {
            extNum = expressionext.getString("number");
            if ("mc_uPosition".equals(extNum) || "mc_procUserName".equals(extNum)) continue;
            ComboItem item = new ComboItem();
            item.setValue(extNum);
            item.setCaption(new LocaleString(expressionext.getString("name")));
            items.add(item);
        }
        ComboEdit fieldCombo = (ComboEdit)this.getControl(INSERTFIELD);
        fieldCombo.setComboItems(items);
    }

    private boolean isPermitShow(IDataEntityProperty fieldProp) {
        boolean result = false;
        result = "name".equals(fieldProp.getName()) || "position".equals(fieldProp.getName()) || "dpt".equals(fieldProp.getName()) || "simplepinyin".equals(fieldProp.getName()) || "fullpinyin".equals(fieldProp.getName()) || "number".equals(fieldProp.getName()) || "phone".equals(fieldProp.getName()) || "email".equals(fieldProp.getName());
        return result;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object fieldObj;
        String propertyName = e.getProperty().getName().toLowerCase();
        if (INSERTFIELD.endsWith(propertyName) && WfUtils.isNotEmptyString((Object)(fieldObj = this.getModel().getValue(INSERTFIELD)))) {
            Object content = this.getModel().getValue(CONTENT);
            content = WfUtils.isNotEmptyString((Object)content) ? content : "";
            content = content + String.format("{%s}", fieldObj);
            this.getModel().setValue(CONTENT, content);
        }
    }
}

