/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.deployer.VersionUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.DynamicSchemeUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.management.batchsetting.MutexResult;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class WorkFlowModelDepConPlugin
extends AbstractWorkflowPlugin
implements ClickListener {
    protected static Log logger = LogFactory.getLog(WorkFlowModelDepConPlugin.class);
    protected static final String BUTTON_CANCEL = "btncancel";
    protected static final String BUTTON_OK = "btnok";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String NUMBER = "number";
    protected static final String VERSION = "version";
    protected static final String CHECKBOX_DISABLE = "checkboxdisable";
    protected static final String CHECKBOX_UPGRADESTARTCON = "upgradstartcon";
    protected static final String CHECKBOX_OTHERPROCESSDISABLED = "otherprocessdisabled";
    protected static final String VERSION_DESCRIPTION = "versiondesc";
    protected static final String PUBLISH_SUB_PROCESS = "pubsubproc";
    protected static final String PUBLISH_SUB_PROCESS_RADIO = "pubsubprocradio";
    protected static final String IGNORE_VALIDATE_INFO = "ignorevalidateinfo";
    protected static final String SYNCHRONIZE_SCHEME = "syncscheme";
    protected static final String SYNCHRONIZE_RESOURCEWORDS = "syncreswords";
    public static final String DISABLE_PREVIOUS_KEY = "disablePrevious";
    public static final String VERSION_DESCRIPTION_KEY = "versionDescription";
    public static final String PUBLISH_SUBPROCESS_KEY = "publishSubProcess";
    public static final String UPGRADE_STARTCONDITION_KEY = "upgradeStartCondition";
    public static final String DISABLE_OTHERPROCESS_KEY = "disableOtherProcess";
    public static final String IGNORE_VALIDATE_INFO_KEY = "ignoreValidateInfo";
    public static final String PUBLISHTIPS = "publishtips";
    public static final String SYNCHRONIZE_SCHEME_KEY = "processDefinitionId";
    public static final String SYNCHRONIZE_RESOURCEWORDS_KEY = "synchronizeResourceWords";
    public static final String PROCESSNUMBER = "processNumber";
    public static final String PROCESSVERSION = "processVersion";
    public static final String KEY_HASEXCEPTION = "hasException";
    public static final String KEY_PROCESSNUMBER = "processNumber";

    @Override
    public void initialize() {
        super.initialize();
        Button btnok = (Button)this.getView().getControl(BUTTON_OK);
        btnok.addClickListener((ClickListener)this);
        Button btncancel = (Button)this.getView().getControl(BUTTON_CANCEL);
        btncancel.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.publishModel();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("message");
        if (map != null) {
            String number = (String)map.get(NUMBER);
            MutexResult result = BpmnModelUtil.requirePublishOrImportProcessMutexLock((String)"publish", (String)number);
            if (!result.isSuccess()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BUTTON_OK, CHECKBOX_OTHERPROCESSDISABLED, CHECKBOX_UPGRADESTARTCON, IGNORE_VALIDATE_INFO, SYNCHRONIZE_SCHEME, SYNCHRONIZE_RESOURCEWORDS});
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u53d1\u5e03\u6216\u5bfc\u5165\u6d41\u7a0b\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"WorkFlowModelDepConPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), result.getUserName()), Integer.valueOf(3000));
                return;
            }
            this.getPageCache().put("processNumber", number);
        }
        this.initPage(map);
    }

    private void initPage(Map<String, Object> map) {
        IDataModel model = this.getModel();
        if (map != null && map.size() > 0) {
            Map idMap;
            List deployedIds;
            model.setValue(ID, map.get(ID));
            Object showName = map.get(NAME);
            if (showName instanceof Map) {
                String lang = RequestContext.get().getLang().toString();
                showName = ((Map)showName).get(lang);
            }
            model.setValue(NAME, showName);
            String number = (String)map.get(NUMBER);
            model.setValue(NUMBER, (Object)number);
            String version = (String)map.get(VERSION);
            if (WfUtils.isEmpty((String)version)) {
                version = VersionUtils.getNextVersion((String)version);
                model.setValue(CHECKBOX_DISABLE, (Object)Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{CHECKBOX_DISABLE});
            }
            if (!(deployedIds = (List)(idMap = this.getRepositoryService().getSubProcIdsClassifiedByDeployState(Long.valueOf(map.get(ID).toString()))).get("deployed")).isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{PUBLISH_SUB_PROCESS});
            }
            model.setValue(VERSION, (Object)version);
            if (WfUtils.isNotEmpty((String)version) && "0001".equals(version)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{PUBLISHTIPS, SYNCHRONIZE_RESOURCEWORDS});
                this.getView().setEnable(Boolean.FALSE, new String[]{CHECKBOX_UPGRADESTARTCON});
            } else {
                this.initSyncScheme(number);
                this.initSyncResWords(number);
            }
            this.initOtherProcessDisabled();
        }
    }

    private void initSyncScheme(String number) {
        List items = DynamicSchemeUtil.getPreviousProcessItemsWithCustomScheme((String)number);
        if (!items.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SYNCHRONIZE_SCHEME});
            ComboEdit syncScheme = (ComboEdit)this.getView().getControl(SYNCHRONIZE_SCHEME);
            syncScheme.setComboItems(items);
        }
    }

    private void initSyncResWords(String number) {
        List<ComboItem> versions = DesignerModelUtil.getProcdefPreviousVersionItemsWithResourceWords(number);
        if (versions != null && !versions.isEmpty()) {
            ComboEdit syncResWords = (ComboEdit)this.getView().getControl(SYNCHRONIZE_RESOURCEWORDS);
            syncResWords.setComboItems(versions);
            if (versions.get(0) != null) {
                this.getView().getModel().setValue(SYNCHRONIZE_RESOURCEWORDS, (Object)versions.get(0).getValue());
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SYNCHRONIZE_RESOURCEWORDS});
        }
    }

    private void initOtherProcessDisabled() {
        String modelId = (String)this.getModel().getValue(ID);
        BpmnModel bpmnModel = PluginUtil.getBpmnModelByModelId(Long.valueOf(modelId), this.getRepositoryService());
        String name = bpmnModel.getMainProcess().getEntraBillName();
        String fullName = String.format(ResManager.loadKDString((String)"\u7981\u7528[%s]\u5176\u4ed6\u65e0\u542f\u52a8\u6761\u4ef6\u7684\u6d41\u7a0b", (String)"WorkFlowModelDepConPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), name);
        FieldEdit fieldEdit = (FieldEdit)this.getControl(CHECKBOX_OTHERPROCESSDISABLED);
        fieldEdit.setCaption(new LocaleString(fullName));
        boolean hasCondition = false;
        ConditionalRuleEntity startUpCondition = bpmnModel.getMainProcess().getStartupcondrule();
        if (BizFlowUtil.isBizFlow((BpmnModel)bpmnModel)) {
            hasCondition = true;
            this.getView().setVisible(Boolean.FALSE, new String[]{CHECKBOX_UPGRADESTARTCON, CHECKBOX_OTHERPROCESSDISABLED});
        } else {
            boolean bl = hasCondition = startUpCondition != null;
        }
        if (hasCondition) {
            this.getModel().setValue(CHECKBOX_OTHERPROCESSDISABLED, (Object)0);
            this.getView().setVisible(Boolean.FALSE, new String[]{CHECKBOX_OTHERPROCESSDISABLED, CHECKBOX_UPGRADESTARTCON});
        }
    }

    protected void publishModel() {
        IDataModel dataModel = this.getModel();
        String id = (String)dataModel.getValue(ID);
        HashMap<String, Map<String, Object>> deploymentProperties = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> deploymentProperty = new HashMap<String, Object>();
        deploymentProperty.put(VERSION_DESCRIPTION_KEY, dataModel.getValue(VERSION_DESCRIPTION));
        deploymentProperty.put(DISABLE_PREVIOUS_KEY, dataModel.getValue(CHECKBOX_DISABLE));
        deploymentProperty.put(PUBLISH_SUBPROCESS_KEY, dataModel.getValue(PUBLISH_SUB_PROCESS_RADIO));
        deploymentProperty.put(UPGRADE_STARTCONDITION_KEY, dataModel.getValue(CHECKBOX_UPGRADESTARTCON));
        deploymentProperty.put(DISABLE_OTHERPROCESS_KEY, dataModel.getValue(CHECKBOX_OTHERPROCESSDISABLED));
        deploymentProperty.put(IGNORE_VALIDATE_INFO_KEY, dataModel.getValue(IGNORE_VALIDATE_INFO));
        deploymentProperty.put(SYNCHRONIZE_SCHEME_KEY, dataModel.getValue(SYNCHRONIZE_SCHEME));
        deploymentProperty.put(SYNCHRONIZE_RESOURCEWORDS_KEY, dataModel.getValue(SYNCHRONIZE_RESOURCEWORDS));
        deploymentProperty.put("processNumber", dataModel.getValue(NUMBER));
        deploymentProperty.put(PROCESSVERSION, dataModel.getValue(VERSION));
        deploymentProperties.put(id, deploymentProperty);
        this.publish(new Long[]{Long.valueOf(id)}, deploymentProperties);
    }

    protected void publish(Long[] ids, Map<String, Map<String, Object>> deploymentProperties) {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        String error = "";
        String failedMsg = ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\u3002", (String)"WorkFlowModelDepConPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        try {
            RepositoryService wfService = this.getRepositoryService();
            Long id = ids[0];
            Map<String, Object> deploymentProperty = deploymentProperties.get(String.valueOf(id));
            boolean ignoreFlag = (Boolean)deploymentProperty.get(IGNORE_VALIDATE_INFO_KEY);
            List<ValidationError> validateInfos = this.validateModel(id, wfService);
            if (null != validateInfos && !validateInfos.isEmpty()) {
                if (ValidatorUtil.hasErrorInfo(validateInfos)) {
                    String status = this.hasBizFlowEntityValidError(validateInfos) ? "E+" : "E";
                    returnData.put("status", status);
                    returnData.put("validateResults", SerializationUtils.toJsonString(validateInfos));
                } else if (ignoreFlag) {
                    this.publish(ids, deploymentProperties, returnData, wfService);
                } else {
                    returnData.put("validateResults", SerializationUtils.toJsonString(validateInfos));
                    returnData.put("status", "E");
                }
            } else {
                String eflag = this.getPageCache().get(KEY_HASEXCEPTION);
                if (null == eflag) {
                    this.publish(ids, deploymentProperties, returnData, wfService);
                }
            }
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        catch (WFEngineException e) {
            error = WfUtils.getExceptionStacktrace((Throwable)e);
            logger.error(error);
            if (WFErrorCode.licenseVerifyException().equals((Object)e.getErrorCode()) || WFErrorCode.licenseExceedLimitException().equals((Object)e.getErrorCode())) {
                FormShowParameter param = LicenseServiceHelper.buildNoticeFormShowParameter((String)e.getMessage(), new ArrayList(0));
                this.showForm(param);
            } else {
                this.getView().showErrMessage(error, failedMsg);
            }
        }
        catch (KDException e) {
            error = WfUtils.getExceptionStacktrace((Throwable)e);
            logger.error(error);
            if (WFErrorCode.publishSubProcessError().toString().equals(e.getErrorCode().toString())) {
                this.getView().showErrorNotification(e.getMessage());
            } else {
                this.getView().showErrMessage(error, failedMsg);
            }
        }
        catch (Exception e) {
            error = WfUtils.getExceptionStacktrace((Throwable)e);
            logger.error(error);
            this.getView().showErrMessage(error, failedMsg);
        }
    }

    private void publish(Long[] ids, Map<String, Map<String, Object>> deploymentProperties, Map<String, Object> returnData, RepositoryService wfService) {
        Long deploymentId = wfService.publish(ids, deploymentProperties);
        returnData.put("status", "S");
        returnData.put("deploymentId", deploymentId);
        returnData.put("modelId", ids[0]);
        Map<String, Object> deploymentProperty = deploymentProperties.get(String.valueOf(ids[0]));
        returnData.put("processNumber", deploymentProperty.get("processNumber"));
        returnData.put(PROCESSVERSION, deploymentProperty.get(PROCESSVERSION));
    }

    private List<ValidationError> validateModel(Long id, RepositoryService wfService) {
        ArrayList<ValidationError> validateInfos = new ArrayList();
        try {
            ResourceEntity resourceEntity = wfService.getResourceByModelIdAndType(id, "graph_json");
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((String)resourceEntity.getData());
            validateInfos = wfService.validateProcesses(bpmnModel, null);
        }
        catch (Exception e) {
            logger.error(String.format("\u6821\u9a8c\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)"\u6821\u9a8c\u51fa\u9519\uff01", (String)"WorkFlowModelDepConPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(KEY_HASEXCEPTION, "E");
        }
        return validateInfos;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String processNumber = this.getPageCache().get("processNumber");
        if (WfUtils.isNotEmpty((String)processNumber)) {
            BpmnModelUtil.releasePublishOrImportProcessMutexLock((String)"publish", (String)processNumber);
            this.getPageCache().remove("processNumber");
        }
    }

    private boolean hasBizFlowEntityValidError(List<ValidationError> validateInfos) {
        for (ValidationError e : validateInfos) {
            if (!e.isBizFlowEntityValidError()) continue;
            return true;
        }
        return false;
    }
}

