/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.Modify;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;

public class WorkflowAdminsSettingListPlugin
extends AbstractListPlugin {
    private static final String QUERY = "query";
    private static final String ADMIN = "admin";
    private static final String ADDNEW = "addnew";
    private static final String DELETE = "delete";
    private static final String DISABLE = "disable";
    private static final String ENABLE = "enable";
    private static final String NUMBER = "number";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (args.getSource() instanceof Modify && rows == null) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            args.setCancel(true);
            return;
        }
        if (args.getSource() instanceof Delete || args.getSource() instanceof StatusConvert) {
            BaseChangeLogsUtil.putBaseArrayCache(this.getView(), "wf_administrator");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ((args.getSource() instanceof Delete || args.getSource() instanceof StatusConvert) && args.getOperationResult().isSuccess()) {
            String arr;
            JSONArray baseArray;
            BaseChangeLogsUtil.addChangeLog(this.getView(), args.getSource(), ADMIN);
            if (!(args.getSource() instanceof StatusConvert && ENABLE.equals(((StatusConvert)args.getSource()).getType()) || null == (baseArray = JSONArray.parseArray((String)(arr = this.getPageCache().get("arr")))) || baseArray.isEmpty())) {
                for (int i = 0; i < baseArray.size(); ++i) {
                    JSONObject object = baseArray.getJSONObject(i);
                    if (null == object || !WfUtils.isNotEmpty((String)object.getString(NUMBER))) continue;
                    WfAdminUtil.removeWfAdminCache((String)object.getString(NUMBER));
                }
            }
        }
        WfCacheHelper.removeWfAdminUserIdsCache();
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{QUERY});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (QUERY.equals(evt.getItemKey())) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_administrator", (String)"47150e89000000ac")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u53d8\u66f4\u65e5\u5fd7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"WorkflowAdminsSettingListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseChangeLogsUtil.queryLog(this.getView(), ADMIN);
        }
    }

    public void afterCreateNewData(EventObject e) {
        PluginUtil.setControlInvisible(this.getView(), "exit");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (WfAdminUtil.controlBtnByAdmin((Long)userId) && !WfAdminUtil.isWfManager((Long)userId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ADDNEW, DELETE, DISABLE, ENABLE});
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_administrator", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u7ba1\u7406\u5458\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"WorkflowAdminsSettingListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        super.billListHyperLinkClick(args);
    }
}

