/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowAdvAppSchemePlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String ADVAPPSCHEMEWHENMATCH = "advappschemewhenmatch";
    private static final String FP_ADVAPPSCHEME = "fp_advappscheme";
    private static final String ADVAPPSCHEME = "advappscheme_bas";
    private static final String ADVAPPSCHEMEFORMID = "idi_schema";
    private static final String ADVAPPSCHEMES = "advAppSchemes";
    private static final String ADVAPPSCHEME_ID = "id";
    private static final String SCHEME_ID = "schemeId";
    private static final String SCHEME_NUMBER = "schemeNumber";
    private static final String SCHEME_SHOWTEXT = "showtext";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(ADVAPPSCHEME);
        this.addHandleProperties("advAppSchemeWhenMatch", ADVAPPSCHEMES);
    }

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ADVAPPSCHEMEWHENMATCH, ADVAPPSCHEME});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.initAdvAppScheme(this.getCellProperties());
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "advappscheme_bas": {
                this.showAdvAppScheme();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "advappschemewhenmatch": {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                this.getView().setVisible((Boolean)newValue, new String[]{FP_ADVAPPSCHEME});
                break;
            }
            case "advappscheme_bas": {
                if (!WfUtils.isEmptyString((Object)newValue)) break;
                this.deleteProperty(ADVAPPSCHEMES);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "advappscheme_bas": {
                this.setCloseDataForAdvAppScheme(returnData);
                break;
            }
        }
    }

    private void initAdvAppScheme(JSONObject properties) {
        Boolean advAppSchemeWhenMatch = Boolean.FALSE;
        Object advAppSchemeWhenMatchObj = DesignerModelUtil.getProperty((Map<String, Object>)properties, "advAppSchemeModel.advAppSchemeWhenMatch");
        if (WfUtils.isNotEmptyString((Object)advAppSchemeWhenMatchObj)) {
            advAppSchemeWhenMatch = Boolean.valueOf(advAppSchemeWhenMatchObj.toString());
        }
        this.getModel().setValue(ADVAPPSCHEMEWHENMATCH, (Object)advAppSchemeWhenMatch);
        this.getView().setVisible(advAppSchemeWhenMatch, new String[]{FP_ADVAPPSCHEME});
        String showText = this.getSchemeTextsFromProperties();
        if (WfUtils.isNotEmptyString((Object)showText)) {
            this.getModel().setValue(ADVAPPSCHEME, (Object)showText);
        }
    }

    private void showAdvAppScheme() {
        Object[] pkIds;
        ListShowParameter para = ShowFormHelper.createShowListForm((String)ADVAPPSCHEMEFORMID, (boolean)false);
        JSONObject properties = this.getCellProperties();
        QFilter qFilterForEntityNumber = new QFilter("sourceentitynumber", "=", properties.get((Object)"entityNumber"));
        QFilter qFilterForEnable = new QFilter("enable", "=", (Object)"1");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilterForEntityNumber);
        qFilters.add(qFilterForEnable);
        if (null != properties) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setQFilters(qFilters);
            para.setListFilterParameter(listFilterParameter);
        }
        if (WfUtils.isNotEmptyForArrays((Object[])(pkIds = this.getSchemeIdsFromProperties()))) {
            QFilter qFilterForId = new QFilter(ADVAPPSCHEME_ID, "in", (Object)pkIds);
            boolean isExist = true;
            try {
                isExist = ORM.create().exists(ADVAPPSCHEMEFORMID, new QFilter[]{qFilterForId, qFilterForEnable});
            }
            catch (Exception e) {
                isExist = false;
                this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            }
            if (isExist) {
                para.setSelectedRows(pkIds);
            }
        }
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADVAPPSCHEME));
        para.setMultiSelect(true);
        this.getView().showForm((FormShowParameter)para);
    }

    private void setCloseDataForAdvAppScheme(Object returnData) {
        ListSelectedRowCollection datas;
        if (returnData instanceof ListSelectedRowCollection && WfUtils.isNotEmptyForCollection((Collection)(datas = (ListSelectedRowCollection)returnData))) {
            ArrayList advAppSchemeList = new ArrayList();
            HashMap<String, Object> advAppSchemeMap = null;
            Object id = null;
            String number = null;
            String name = null;
            StringBuilder nameSb = new StringBuilder();
            for (ListSelectedRow row : datas) {
                id = row.getPrimaryKeyValue();
                number = row.getNumber();
                name = row.getName();
                if (WfUtils.isEmpty((String)name) || "null".equals(name)) {
                    name = number;
                }
                nameSb.append(name).append("\uff0c");
                advAppSchemeMap = new HashMap<String, Object>();
                advAppSchemeMap.put(ADVAPPSCHEME_ID, String.valueOf(id));
                advAppSchemeMap.put(SCHEME_ID, WfUtils.getLongValueFromObj((Object)id));
                advAppSchemeMap.put(SCHEME_NUMBER, number);
                advAppSchemeMap.put(SCHEME_SHOWTEXT, name);
                advAppSchemeList.add(advAppSchemeMap);
            }
            if (WfUtils.isNotEmptyString((Object)nameSb)) {
                this.getModel().setValue(ADVAPPSCHEME, (Object)nameSb.substring(0, nameSb.length() - 1));
            }
            this.setProperty(ADVAPPSCHEMES, advAppSchemeList);
            this.deleteProperty("advAppSchemeModel.advAppScheme");
        }
    }

    private Object[] getSchemeIdsFromProperties() {
        ArrayList<Object> schemeInfos = new ArrayList<Object>();
        Object advAppSchemes = this.getAdvAppSchemes();
        if (advAppSchemes instanceof JSONArray) {
            JSONArray advAppSchemeArray = (JSONArray)advAppSchemes;
            Object schemeId = null;
            for (Object advAppSchemeObj : advAppSchemeArray) {
                if (!(advAppSchemeObj instanceof JSONObject) || null == (schemeId = ((JSONObject)advAppSchemeObj).get((Object)SCHEME_ID))) continue;
                schemeInfos.add(schemeId);
            }
        }
        if (WfUtils.isEmptyForCollection(schemeInfos)) {
            return new Object[0];
        }
        return schemeInfos.toArray(new Object[schemeInfos.size()]);
    }

    private String getSchemeTextsFromProperties() {
        Object advAppSchemes = this.getAdvAppSchemes();
        if (advAppSchemes instanceof JSONArray) {
            StringBuilder nameSb = new StringBuilder();
            JSONArray advAppSchemeArray = (JSONArray)advAppSchemes;
            Object nameObj = null;
            for (Object advAppSchemeObj : advAppSchemeArray) {
                if (!(advAppSchemeObj instanceof JSONObject)) continue;
                nameObj = DesignerPluginUtil.getLocaleValue(((JSONObject)advAppSchemeObj).get((Object)SCHEME_SHOWTEXT));
                if (WfUtils.isEmptyString((Object)nameObj) || "null".equals(nameObj)) {
                    nameObj = ((JSONObject)advAppSchemeObj).get((Object)SCHEME_NUMBER);
                }
                if (!WfUtils.isNotEmptyString((Object)nameObj)) continue;
                nameSb.append(nameObj).append("\uff0c");
            }
            if (WfUtils.isNotEmptyString((Object)nameSb)) {
                return nameSb.substring(0, nameSb.length() - 1);
            }
        }
        return null;
    }

    private Object getAdvAppSchemes() {
        Object advAppSchemeModelObj;
        JSONObject properties = this.getCellProperties();
        if (null != properties && (advAppSchemeModelObj = properties.get((Object)"advAppSchemeModel")) instanceof JSONObject) {
            JSONObject advAppSchemeModel = (JSONObject)advAppSchemeModelObj;
            Object advAppScheme = advAppSchemeModel.get((Object)"advAppScheme");
            if (advAppScheme instanceof JSONObject) {
                JSONArray advAppSchemes = new JSONArray();
                advAppSchemes.add(advAppScheme);
                return advAppSchemes;
            }
            return advAppSchemeModel.get((Object)ADVAPPSCHEMES);
        }
        return null;
    }
}

