/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.plugin.model.ParticipantEntryInfo;
import kd.bos.workflow.design.util.ParticipantConfigureHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class WorkflowAllowNextPersonPropConfPlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String FP_ALLOWNEXTPERSON = "fp_allownextperson";
    private static final String ALLOWANYONE = "allowanyone";
    private static final String BTN_ADD_ALLOWPERSON = "btn_add_allowperson";
    private static final String BUTTONAP_PARTICIPANT_SEL = "buttonap_participant_sel";
    public static final String BTN_EDIT_ALLOWPERSON = "btn_edit_allowperson";
    private static final String BTN_DEL_ALLOWPERSON = "btn_del_allowperson";
    public static final String ENTRYENTITY_ALLOWPERSON = "entryentity_allowperson";
    private static final String PICTURE_ALLOWPERSON = "picture_allowperson";
    private static final String SHOWVALUEPRE_ALLOWPERSON = "showvaluepre_allowperson";
    private static final String SHOWVALUE_ALLOWPERSON = "showvalue_allowperson";
    private static final String ISREQUIRED = "required";
    private static final String BTN_ADD_BLACKLIST = "btn_add_blacklist";
    private static final String BUTTONAP_PARTICIPANT_NO = "buttonap_participant_no";
    private static final String BTN_EDIT_BLACKLIST = "btn_edit_blacklist";
    private static final String BTN_DEL_BLACKLIST = "btn_del_blacklist";
    public static final String ENTRYENTITY_BLACKLIST = "entryentity_blacklist";
    private static final String PICTURE_BLACKLIST = "picture_blacklist";
    private static final String SHOWVALUEPRE_BLACKLIST = "showvaluepre_blacklist";
    private static final String SHOWVALUE_BLACKLIST = "showvalue_blacklist";
    private static final String PARTICIPANTRANGESETTING = "participantRangeSetting";
    private static final String PARTICIPANTALLOW = "participantAllow";
    private static final String PARTICIPANTBLACKLIST = "participantBlackList";
    private static final String PERSONRANGEBTN = "personrangeformanual";
    private static final String SIGNTYPE = "signtype";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(ENTRYENTITY_ALLOWPERSON, ENTRYENTITY_BLACKLIST);
    }

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_ADD_ALLOWPERSON, BTN_EDIT_ALLOWPERSON, BTN_DEL_ALLOWPERSON, BTN_ADD_BLACKLIST, BTN_EDIT_BLACKLIST, BTN_DEL_BLACKLIST, BUTTONAP_PARTICIPANT_SEL, BUTTONAP_PARTICIPANT_NO});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.stencilType == null) {
            return;
        }
        if (BpmnModelUtil.instanceofUserTask((String)this.stencilType) || BpmnModelUtil.instanceofAuditTask((String)this.stencilType)) {
            JSONObject properties = this.getCellProperties();
            this.initAllowNextPerson(properties);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "buttonap_participant_sel": 
            case "btn_add_allowperson": {
                ParticipantConfigureHelper.addParticipant(this, ENTRYENTITY_ALLOWPERSON, this.itemId, this.getModelJsonString(), key);
                break;
            }
            case "btn_edit_allowperson": {
                ParticipantConfigureHelper.modifyParticipant(this, ENTRYENTITY_ALLOWPERSON, this.itemId, this.getModelJsonString(), key);
                break;
            }
            case "btn_del_allowperson": {
                List<Map<String, Object>> allowPersonList = ParticipantConfigureHelper.deleteParticipant(this, ENTRYENTITY_ALLOWPERSON);
                this.setProperty(PARTICIPANTALLOW, allowPersonList);
                if (WfUtils.isEmptyForCollection(allowPersonList)) {
                    this.setVisibleForBtn(true);
                }
                boolean isEnable = null != allowPersonList && 0 != allowPersonList.size();
                this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{ALLOWANYONE});
                this.getModel().setValue(ALLOWANYONE, (Object)(isEnable && (Boolean)this.getModel().getValue(ALLOWANYONE) != false ? 1 : 0));
                break;
            }
            case "btn_add_blacklist": 
            case "buttonap_participant_no": {
                ParticipantConfigureHelper.addParticipant(this, ENTRYENTITY_BLACKLIST, this.itemId, this.getModelJsonString(), key);
                break;
            }
            case "btn_edit_blacklist": {
                ParticipantConfigureHelper.modifyParticipant(this, ENTRYENTITY_BLACKLIST, this.itemId, this.getModelJsonString(), key);
                break;
            }
            case "btn_del_blacklist": {
                List<Map<String, Object>> deleteParticipants = ParticipantConfigureHelper.deleteParticipant(this, ENTRYENTITY_BLACKLIST);
                this.setProperty(PARTICIPANTBLACKLIST, deleteParticipants);
                if (!WfUtils.isEmptyForCollection(deleteParticipants)) break;
                this.setVisibleForBlackBtn(true);
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId.toLowerCase(Locale.getDefault())) {
            case "btn_add_allowperson": 
            case "buttonap_participant_sel": {
                this.setCloseDataForParticipantRangeSetting("operation_add", returnData, PARTICIPANTALLOW);
                if (returnData == null) break;
                this.getView().setEnable(Boolean.TRUE, new String[]{ALLOWANYONE});
                if (!BUTTONAP_PARTICIPANT_SEL.equalsIgnoreCase(actionId)) break;
                this.setVisibleForBtn(false);
                break;
            }
            case "btn_edit_allowperson": {
                this.setCloseDataForParticipantRangeSetting("operation_modify", returnData, PARTICIPANTALLOW);
                break;
            }
            case "btn_add_blacklist": 
            case "buttonap_participant_no": {
                this.setCloseDataForParticipantRangeSetting("operation_add", returnData, PARTICIPANTBLACKLIST);
                if (returnData == null || !BUTTONAP_PARTICIPANT_NO.equalsIgnoreCase(actionId)) break;
                this.setVisibleForBlackBtn(false);
                break;
            }
            case "btn_edit_blacklist": {
                this.setCloseDataForParticipantRangeSetting("operation_modify", returnData, PARTICIPANTBLACKLIST);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "personrangeformanual": {
                this.getView().setVisible((Boolean)newValue, new String[]{FP_ALLOWNEXTPERSON});
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "required": {
                this.propertyChangedForAllowPerson(propName, newValue, rowIndex);
                break;
            }
            case "businessmodel": 
            case "signtype": {
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void propertyChangedForAllowPerson(String key, Object value, int index) {
        Object returnData;
        List returnDataList;
        String pageCache;
        String pageCacheKey = ParticipantConfigureHelper.getDatasCacheKey(ENTRYENTITY_ALLOWPERSON);
        if (WfUtils.isNotEmpty((String)pageCacheKey) && WfUtils.isNotEmpty((String)(pageCache = this.getPageCache().get(pageCacheKey))) && null != (returnDataList = (List)SerializationUtils.fromJsonString((String)pageCache, List.class)) && index < returnDataList.size() && null != (returnData = returnDataList.get(index)) && Map.class.isInstance(returnData)) {
            Map data = (Map)returnData;
            data.put(key, value);
            this.getPageCache().put(pageCacheKey, SerializationUtils.toJsonString((Object)returnDataList));
            this.setProperty(PARTICIPANTALLOW, returnDataList);
        }
    }

    private void setCloseDataForParticipantRangeSetting(String actionId, Object returnData, String modelId) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            ParticipantEntryInfo info = null;
            if (PARTICIPANTALLOW.equals(modelId)) {
                info = this.getParticipantEntryInfoForAllowPerson(data);
            } else if (PARTICIPANTBLACKLIST.equals(modelId)) {
                info = this.getParticipantEntryInfoForBlackList(data);
            }
            if (info != null) {
                List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.setParticipantEntryValue(this, info, actionId);
                this.setProperty(modelId, returnDataList);
            }
        }
    }

    private ParticipantEntryInfo getParticipantEntryInfoForAllowPerson(Map<String, Object> data) {
        return new ParticipantEntryInfo(ENTRYENTITY_ALLOWPERSON, PICTURE_ALLOWPERSON, SHOWVALUEPRE_ALLOWPERSON, SHOWVALUE_ALLOWPERSON, data, ISREQUIRED);
    }

    private ParticipantEntryInfo getParticipantEntryInfoForBlackList(Map<String, Object> data) {
        if (data != null) {
            return new ParticipantEntryInfo(ENTRYENTITY_BLACKLIST, PICTURE_BLACKLIST, SHOWVALUEPRE_BLACKLIST, SHOWVALUE_BLACKLIST, data);
        }
        return new ParticipantEntryInfo(ENTRYENTITY_BLACKLIST, PICTURE_BLACKLIST, SHOWVALUEPRE_BLACKLIST, SHOWVALUE_BLACKLIST);
    }

    private void initAllowNextPerson(JSONObject properties) {
        if (properties == null) {
            this.logger.debug("cell's properties is null!");
            return;
        }
        Object personRange = this.getProperty(PERSONRANGEBTN) == null ? this.getDefaultValueByName(properties, PERSONRANGEBTN) : this.getProperty(PERSONRANGEBTN);
        Boolean isAllowNextPersonPanle = personRange == null ? Boolean.FALSE : (Boolean)personRange;
        this.getView().setVisible(isAllowNextPersonPanle, new String[]{FP_ALLOWNEXTPERSON});
        boolean isAllowAnyone = false;
        JSONObject participant = properties.getJSONObject(PARTICIPANTRANGESETTING);
        if (participant == null) {
            participant = new JSONObject();
            Boolean allowAnyone = (Boolean)this.getDefaultValueByName(properties, ALLOWANYONE);
            JSONArray participantAllow = (JSONArray)this.getDefaultValueByName(properties, PARTICIPANTALLOW);
            JSONArray participantBlackList = (JSONArray)this.getDefaultValueByName(properties, PARTICIPANTBLACKLIST);
            participant.put(ALLOWANYONE, (Object)allowAnyone);
            participant.put(PARTICIPANTALLOW, (Object)participantAllow);
            participant.put(PARTICIPANTBLACKLIST, (Object)participantBlackList);
        }
        boolean isHavingData = ParticipantConfigureHelper.loadCardDataForParticipant(participant, ENTRYENTITY_ALLOWPERSON, PARTICIPANTALLOW, this, this.getParticipantEntryInfoForAllowPerson(null));
        if (null == participant || !isHavingData) {
            this.setVisibleForBtn(true);
        } else {
            this.setVisibleForBtn(false);
        }
        if (isHavingData && null != participant) {
            isAllowAnyone = participant.getBoolean(ALLOWANYONE) == null ? Boolean.FALSE : participant.getBoolean(ALLOWANYONE);
        }
        this.getView().setEnable(Boolean.valueOf(isHavingData), new String[]{ALLOWANYONE});
        this.getModel().setValue(ALLOWANYONE, (Object)isAllowAnyone);
        boolean isHavingBlackData = ParticipantConfigureHelper.loadCardDataForParticipant(participant, ENTRYENTITY_BLACKLIST, PARTICIPANTBLACKLIST, this, this.getParticipantEntryInfoForBlackList(null));
        if (null == participant || !isHavingBlackData) {
            this.setVisibleForBlackBtn(true);
        } else {
            this.setVisibleForBlackBtn(false);
        }
    }

    private void setVisibleForBlackBtn(Boolean isVisible) {
        this.getView().setVisible(isVisible, new String[]{BUTTONAP_PARTICIPANT_NO});
        this.getView().setVisible(Boolean.valueOf(isVisible == false), new String[]{BTN_ADD_BLACKLIST, "labelap219", BTN_EDIT_BLACKLIST, "labelap329", BTN_DEL_BLACKLIST});
    }

    private void setVisibleForBtn(Boolean isVisible) {
        this.getView().setVisible(isVisible, new String[]{BUTTONAP_PARTICIPANT_SEL});
        this.getView().setVisible(Boolean.valueOf(isVisible == false), new String[]{BTN_ADD_ALLOWPERSON, "labelap21", BTN_EDIT_ALLOWPERSON, "labelap32", BTN_DEL_ALLOWPERSON});
    }
}

