/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.task.auditpoint.AuditPointType;

public class WorkflowAuditPointNodeControlPlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String AUDITPOINTWHENMATCH = "auditpointwhenmatch";
    private static final String FLEXPANEL_AUDITPOINTS = "fp_auditpoints";
    protected static final String AUDITPOINTS = "auditpoints";
    private static final String BTN_AUDITPOINTSADD = "btn_auditpointsadd";
    private static final String BTN_AUDITPOINTSUPD = "btn_auditpointsupd";
    protected static final String AUDITPOINTS_ID = "auditpoints_id";
    private static final String AUDITPOINTS_TYPE = "auditpoints_type";
    private static final String SV_AUDITPOINTS_RULE = "sv_auditpoints_rule";
    protected static final String AUDITPOINTS_RULE = "auditpoints_rule";
    private static final String AUDITPOINTS_DISPLAYNAME = "auditpoints_displayname";
    private static final String AUDITPOINTS_INSTRUCTION = "auditpoints_instruction";
    private static final String SV_AUDITPOINTS_BIZRULE = "sv_auditpoints_bizrule";
    protected static final String AUDITPOINTS_BIZRULE = "auditpoints_bizrule";
    private static final String AUDITPOINTS_ERRORMESSAGE = "auditpoints_errormessage";
    private static final String AUDITPOINTS_NEEDREASON = "auditpoints_needreason";
    private static final String AUDITPOINTS_NEEDMARK = "auditpoints_needmark";
    private static final String AUDITPOINTS_IMMEDIATELY = "auditpoints_immediately";
    private static final String ENTITYNUMBER = "entityNumber";
    private static final String VALUE = "value";
    private static final String SHOWTEXT = "showtext";

    @Override
    public void initialize() {
        super.initialize();
        this.addHandleProperties("auditPoints", "auditPointWhenMatch", "auditPointTitle");
        this.addExclusiveProperty(SV_AUDITPOINTS_RULE, SV_AUDITPOINTS_BIZRULE);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_AUDITPOINTSADD, BTN_AUDITPOINTSUPD, SV_AUDITPOINTS_RULE, AUDITPOINTS_DISPLAYNAME, AUDITPOINTS_INSTRUCTION});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.initAuditPoints();
    }

    private void initAuditPoints() {
        Object auditPointWhenMatch = this.getProperty(AUDITPOINTWHENMATCH);
        boolean isShowAuditPoints = false;
        if (auditPointWhenMatch != null) {
            isShowAuditPoints = (Boolean)auditPointWhenMatch;
        }
        this.getView().getModel().setValue("auditpointtitle", (Object)ResManager.loadKDString((String)"\u5ba1\u6279\u8981\u70b9", (String)"ApprovalPagePluginNew_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        this.getModel().setValue(AUDITPOINTWHENMATCH, (Object)isShowAuditPoints);
        this.getView().setVisible(Boolean.valueOf(isShowAuditPoints), new String[]{FLEXPANEL_AUDITPOINTS});
        DynamicObjectCollection auditPoints = this.getModel().getEntryEntity(AUDITPOINTS);
        for (DynamicObject auditPoint : auditPoints) {
            String auditPointsType = auditPoint.getString(AUDITPOINTS_TYPE);
            String auditPointsInstruction = auditPoint.getString(AUDITPOINTS_INSTRUCTION);
            if (!WfUtils.isEmpty((String)auditPointsType) || !WfUtils.isNotEmpty((String)auditPointsInstruction)) continue;
            auditPoint.set(AUDITPOINTS_TYPE, (Object)AuditPointType.TEXTREMINDER.getNumber());
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_auditpointsup", "btn_auditpointsdown", "labelap3114", "labelap31121"});
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_auditpointsadd": {
                this.showAuditPointPage(BTN_AUDITPOINTSADD);
                break;
            }
            case "btn_auditpointsupd": {
                this.showAuditPointPage(BTN_AUDITPOINTSUPD);
                break;
            }
            case "sv_auditpoints_rule": {
                this.showAuditPointRule(SV_AUDITPOINTS_RULE);
                break;
            }
            case "auditpoints_displayname": {
                this.showDisplayNameOrInstruction(AUDITPOINTS_DISPLAYNAME, ResManager.loadKDString((String)"\u5ba1\u6279\u8981\u70b9\u663e\u793a\u540d\u79f0", (String)"WorkflowAudittaskNodeControlPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                break;
            }
            case "auditpoints_instruction": {
                this.showDisplayNameOrInstruction(AUDITPOINTS_INSTRUCTION, ResManager.loadKDString((String)"\u5ba1\u6279\u8981\u70b9\u8be6\u7ec6\u8bf4\u660e", (String)"WorkflowAudittaskNodeControlPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void showAuditPointPage(String key) {
        JSONObject properties = this.getCellProperties();
        String entityNumber = properties.getString(ENTITYNUMBER);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelJson", this.getModelJsonString());
        params.put("itemId", this.itemId);
        params.put(ENTITYNUMBER, entityNumber);
        if (BTN_AUDITPOINTSUPD.equals(key)) {
            int focusRow = this.getEntryEntityFocusRow(AUDITPOINTS);
            if (focusRow == -1) {
                StandardTips.view((IFormView)this.getView()).notSelectRow();
                return;
            }
            DynamicObject auditPointsEntryEntity = this.getModel().getEntryRowEntity(AUDITPOINTS, focusRow);
            params.put("auditPoints", auditPointsEntryEntity);
        }
        super.showForm(this.getShowParameter(key, "wf_auditpoint", params));
    }

    private void showAuditPointRule(String actionId) {
        int focusRow = this.getEntryEntityFocusRow(AUDITPOINTS);
        String conditionValue = null;
        String auditPointsRule = (String)this.getModel().getValue(AUDITPOINTS_RULE, focusRow);
        if (!WfUtils.isEmpty((String)auditPointsRule)) {
            conditionValue = auditPointsRule;
        }
        FormShowParameter parameter = DesignerPluginUtil.getConditionalRuleParameter(ConditionalRuleType.auditPointsRule, this.getView(), (IFormPlugin)this, conditionValue, this.getModelJsonString(), this.itemId, "rule", actionId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    private void showDisplayNameOrInstruction(String key, String caption) {
        int focusRow = this.getEntryEntityFocusRow(AUDITPOINTS);
        String value = (String)this.getModel().getValue(key, focusRow);
        String modelJson = this.getModelJsonString();
        JSONObject properties = this.getCellProperties();
        String entityNumber = properties.getString(ENTITYNUMBER);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelJson", modelJson);
        params.put(ENTITYNUMBER, entityNumber);
        params.put(VALUE, value);
        params.put("FROM", "MSG");
        super.showForm(this.getShowParameter(key, "wf_billsubject_light", caption, params));
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (AUDITPOINTWHENMATCH.equals(propName)) {
            this.getView().setVisible((Boolean)newValue, new String[]{FLEXPANEL_AUDITPOINTS});
        } else if (SV_AUDITPOINTS_RULE.equals(propName) && StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(AUDITPOINTS_RULE, newValue, rowIndex);
            this.getModel().endInit();
        }
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = evt.getActionId()) {
            case "btn_auditpointsadd": {
                this.setCloseForAuditPointsAddNewOrModify(BTN_AUDITPOINTSADD, returnData);
                break;
            }
            case "btn_auditpointsupd": {
                this.setCloseForAuditPointsAddNewOrModify(BTN_AUDITPOINTSUPD, returnData);
                break;
            }
            case "sv_auditpoints_rule": {
                this.setCloseForAuditPointsRule(returnData);
                break;
            }
            case "auditpoints_displayname": {
                this.setCloseForInstructionOrDisplayName(AUDITPOINTS_DISPLAYNAME, returnData);
                break;
            }
            case "auditpoints_instruction": {
                this.setCloseForInstructionOrDisplayName(AUDITPOINTS_INSTRUCTION, returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setCloseForAuditPointsAddNewOrModify(String actionId, Object returnData) {
        if (Map.class.isInstance(returnData)) {
            Map map = (Map)returnData;
            int index = 0;
            if (BTN_AUDITPOINTSADD.equals(actionId)) {
                index = this.getModel().createNewEntryRow(AUDITPOINTS);
            } else if (BTN_AUDITPOINTSUPD.equals(actionId)) {
                index = this.getEntryEntityFocusRow(AUDITPOINTS);
            }
            this.getModel().setValue(AUDITPOINTS_TYPE, map.get("type"), index);
            this.getModel().setValue(AUDITPOINTS_RULE, map.get("rule"), index);
            this.getModel().setValue(SV_AUDITPOINTS_RULE, map.get("sv_rule"), index);
            this.getModel().setValue(AUDITPOINTS_DISPLAYNAME, map.get("displayName"), index);
            this.getModel().setValue(AUDITPOINTS_BIZRULE, map.get("bizRule"), index);
            this.getModel().setValue(SV_AUDITPOINTS_BIZRULE, map.get("sv_bizRule"), index);
            this.getModel().setValue(AUDITPOINTS_ERRORMESSAGE, map.get("errorMessage"), index);
            this.getModel().setValue(AUDITPOINTS_NEEDREASON, map.get("needReason"), index);
            this.getModel().setValue(AUDITPOINTS_NEEDMARK, map.get("needMark"), index);
            this.getModel().setValue(AUDITPOINTS_INSTRUCTION, map.get("instruction"), index);
            this.getModel().setValue(AUDITPOINTS_IMMEDIATELY, map.get("immediately"), index);
        }
    }

    private void setCloseForAuditPointsRule(Object returnData) {
        int focusRow = this.getEntryEntityFocusRow(AUDITPOINTS);
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            if (data.isEmpty()) {
                this.getModel().setValue(SV_AUDITPOINTS_RULE, null, focusRow);
                this.getModel().setValue(AUDITPOINTS_RULE, null, focusRow);
                return;
            }
            if (focusRow > -1) {
                Object showTextObject = data.get(SHOWTEXT);
                if (showTextObject != null) {
                    String lang = RequestContext.get().getLang().toString();
                    String auditPointsRuleSV = (String)((Map)showTextObject).get(lang);
                    this.getModel().setValue(SV_AUDITPOINTS_RULE, (Object)auditPointsRuleSV, focusRow);
                }
                this.getModel().setValue(AUDITPOINTS_RULE, (Object)SerializationUtils.toJsonString((Object)data), focusRow);
                this.setProperty("rule", data);
            }
        }
    }

    private void setCloseForInstructionOrDisplayName(String actionId, Object returnData) {
        Map returnMap;
        Object auditPointValue;
        if (Map.class.isInstance(returnData) && (auditPointValue = (returnMap = (Map)returnData).get("customSubject")) != null) {
            int focusRow = this.getEntryEntityFocusRow(AUDITPOINTS);
            this.getModel().setValue(actionId, auditPointValue, focusRow);
        }
    }
}

