/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;

public class WorkflowAuditPointPlugin
extends AbstractWorkflowPlugin {
    private static final String TYPE = "auditpoints_type";
    private static final String RULE = "auditpoints_rule";
    private static final String SV_RULE = "sv_auditpoints_rule";
    private static final String DISPLAYNAME = "auditpoints_displayname";
    private static final String SV_BIZRULE = "sv_auditpoints_bizrule";
    private static final String BIZRULE = "auditpoints_bizrule";
    private static final String ERRORMESSAGE = "auditpoints_errormessage";
    private static final String FLEXPANELINSTRES = "flexpanelinstres";
    private static final String NEEDREASON = "auditpoints_needreason";
    private static final String NEEDMARK = "auditpoints_needmark";
    private static final String INSTRUCTION = "auditpoints_instruction";
    private static final String IMMEDIATELY = "auditpoints_immediately";
    private static final String BTNOK = "btnok";
    private static final String TEXTREMINDER = "textreminder";
    private static final String AUTOMATICCHECKS = "automaticchecks";
    private static final String MANUALCHECKS = "manualchecks";
    private static final String MODELJSON = "modelJson";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{DISPLAYNAME, SV_RULE, SV_BIZRULE, ERRORMESSAGE, INSTRUCTION, BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initValues();
        this.switchType();
    }

    private void initValues() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject auditPoints = (JSONObject)customParams.get("auditPoints");
        if (auditPoints != null) {
            this.getModel().setValue(TYPE, auditPoints.get((Object)TYPE));
            this.getModel().setValue(SV_RULE, auditPoints.get((Object)SV_RULE));
            this.getModel().setValue(RULE, auditPoints.get((Object)RULE));
            this.getModel().setValue(DISPLAYNAME, auditPoints.get((Object)DISPLAYNAME));
            this.getModel().setValue(SV_BIZRULE, auditPoints.get((Object)SV_BIZRULE));
            this.getModel().setValue(BIZRULE, auditPoints.get((Object)BIZRULE));
            this.getModel().setValue(ERRORMESSAGE, auditPoints.get((Object)ERRORMESSAGE));
            this.getModel().setValue(INSTRUCTION, auditPoints.get((Object)INSTRUCTION));
            this.getModel().setValue(NEEDREASON, auditPoints.get((Object)NEEDREASON));
            this.getModel().setValue(NEEDMARK, auditPoints.get((Object)NEEDMARK));
            this.getModel().setValue(IMMEDIATELY, auditPoints.get((Object)IMMEDIATELY));
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "sv_auditpoints_rule": {
                this.showRule(SV_RULE);
                break;
            }
            case "auditpoints_displayname": {
                this.showDisplayNameOrInstruction(DISPLAYNAME, ResManager.loadKDString((String)"\u5ba1\u6279\u8981\u70b9\u663e\u793a\u540d\u79f0", (String)"WorkflowAuditPointPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                break;
            }
            case "sv_auditpoints_bizrule": {
                this.showBizRule(SV_BIZRULE);
                break;
            }
            case "auditpoints_errormessage": {
                this.showDisplayNameOrInstruction(ERRORMESSAGE, ResManager.loadKDString((String)"\u672a\u901a\u8fc7\u65f6\u9519\u8bef\u4fe1\u606f\u63cf\u8ff0", (String)"WorkflowAuditPointPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                break;
            }
            case "auditpoints_instruction": {
                this.showDisplayNameOrInstruction(INSTRUCTION, ResManager.loadKDString((String)"\u5ba1\u6279\u8981\u70b9\u8be6\u7ec6\u8bf4\u660e", (String)"WorkflowAuditPointPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btnok": {
                this.confirm();
                break;
            }
        }
    }

    private void showRule(String key) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String modelJson = (String)customParams.get(MODELJSON);
        String itemId = (String)customParams.get("itemId");
        String rule = (String)this.getModel().getValue(RULE);
        String conditionValue = null;
        if (!WfUtils.isEmpty((String)rule)) {
            conditionValue = rule;
        }
        DesignerPluginUtil.openConditionalRule(ConditionalRuleType.auditPointsRule, this.getView(), (IFormPlugin)this, conditionValue, modelJson, itemId, "", key);
    }

    private void showBizRule(String key) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String modelJson = (String)customParams.get(MODELJSON);
        String itemId = (String)customParams.get("itemId");
        String bizRule = (String)this.getModel().getValue(BIZRULE);
        JSONObject value = null;
        if (!WfUtils.isEmpty((String)bizRule)) {
            value = (JSONObject)SerializationUtils.fromJsonString((String)bizRule, JSONObject.class);
        }
        String conditionValue = null;
        if (value != null) {
            conditionValue = value.toJSONString();
        }
        DesignerPluginUtil.openConditionalRule(ConditionalRuleType.auditPointsBizRule, this.getView(), (IFormPlugin)this, conditionValue, modelJson, itemId, "", key);
    }

    private void showDisplayNameOrInstruction(String key, String caption) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String modelJson = (String)customParams.get(MODELJSON);
        String entityNumber = (String)customParams.get("entityNumber");
        if (WfUtils.isEmpty((String)entityNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65f6\u4e0d\u652f\u6301\u589e\u52a0\u672a\u901a\u8fc7\u65f6\u9519\u8bef\u4fe1\u606f\u63cf\u8ff0\u3002", (String)"WorkflowAuditPointPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String value = (String)this.getModel().getValue(key);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(MODELJSON, modelJson);
        params.put("entityNumber", entityNumber);
        params.put("value", value);
        params.put("FROM", "MSG");
        super.showForm(this.getShowParameter(key, "wf_billsubject_light", caption, params));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        ChangeData[] changeSet;
        String propName = e.getProperty().getName();
        if (TYPE.equals(propName)) {
            this.switchType();
        } else if (SV_RULE.equals(propName) && (changeSet = e.getChangeSet()) != null && changeSet.length > 0 && StringUtils.isBlank((Object)(newValue = changeSet[0].getNewValue()))) {
            this.getModel().setValue(RULE, newValue);
            this.getModel().endInit();
        }
    }

    private void switchType() {
        String type;
        switch (type = (String)this.getModel().getValue(TYPE)) {
            case "textreminder": {
                this.getView().setVisible(Boolean.TRUE, new String[]{TYPE, DISPLAYNAME, INSTRUCTION});
                this.getView().setVisible(Boolean.FALSE, new String[]{RULE, BIZRULE, SV_BIZRULE, ERRORMESSAGE, FLEXPANELINSTRES, IMMEDIATELY});
                break;
            }
            case "automaticchecks": {
                this.getView().setVisible(Boolean.TRUE, new String[]{TYPE, DISPLAYNAME, SV_BIZRULE, ERRORMESSAGE, INSTRUCTION, IMMEDIATELY});
                this.getView().setVisible(Boolean.FALSE, new String[]{RULE, BIZRULE, FLEXPANELINSTRES});
                break;
            }
            case "manualchecks": {
                this.getView().setVisible(Boolean.TRUE, new String[]{TYPE, DISPLAYNAME, FLEXPANELINSTRES, INSTRUCTION});
                this.getView().setVisible(Boolean.FALSE, new String[]{RULE, BIZRULE, SV_BIZRULE, ERRORMESSAGE, IMMEDIATELY});
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "sv_auditpoints_rule": {
                this.setConditionalRule(returnData, SV_RULE, RULE);
                break;
            }
            case "auditpoints_displayname": {
                this.setInstructionOrDisplayName(DISPLAYNAME, returnData);
                break;
            }
            case "sv_auditpoints_bizrule": {
                this.setConditionalRule(returnData, SV_BIZRULE, BIZRULE);
                break;
            }
            case "auditpoints_errormessage": {
                this.setInstructionOrDisplayName(ERRORMESSAGE, returnData);
                break;
            }
            case "auditpoints_instruction": {
                this.setInstructionOrDisplayName(INSTRUCTION, returnData);
                break;
            }
        }
    }

    private void setConditionalRule(Object returnData, String showValueKey, String realValueKey) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            if (data.isEmpty()) {
                this.getModel().setValue(showValueKey, null);
                this.getModel().setValue(realValueKey, null);
            } else {
                this.getModel().setValue(showValueKey, (Object)DesignerPluginUtil.getLocaleValue(data.get("showtext")));
                this.getModel().setValue(realValueKey, (Object)SerializationUtils.toJsonString((Object)data));
            }
        }
    }

    private void setInstructionOrDisplayName(String actionId, Object returnData) {
        Map returnMap;
        if (Map.class.isInstance(returnData) && (returnMap = (Map)returnData).containsKey("customSubject")) {
            Object value = returnMap.get("customSubject");
            this.getModel().setValue(actionId, value);
        }
    }

    private void confirm() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("type", (String)this.getModel().getValue(TYPE));
        returnData.put("rule", (String)this.getModel().getValue(RULE));
        returnData.put("sv_rule", (String)this.getModel().getValue(SV_RULE));
        returnData.put("displayName", (String)this.getModel().getValue(DISPLAYNAME));
        returnData.put("bizRule", (String)this.getModel().getValue(BIZRULE));
        returnData.put("sv_bizRule", (String)this.getModel().getValue(SV_BIZRULE));
        returnData.put("errorMessage", (String)this.getModel().getValue(ERRORMESSAGE));
        returnData.put("needReason", (Boolean)this.getModel().getValue(NEEDREASON));
        returnData.put("needMark", (Boolean)this.getModel().getValue(NEEDMARK));
        returnData.put("instruction", (String)this.getModel().getValue(INSTRUCTION));
        returnData.put("immediately", (Boolean)this.getModel().getValue(IMMEDIATELY));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

