/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.design.plugin.WorkflowBasicInfoPlugin;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.design.property.alias.AliasConverterFactory;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class WorkflowAudittaskBasicinfoPlugin
extends WorkflowBasicInfoPlugin {
    private static final String OPTIONALDECISIONS = "optionaldecisions";
    private static final String MOBILE_PAGE_ATTR_CONFIG = "mobilePageAttrConfig";
    private static final String PAGE_ATTR_CONFIG = "pageAttrConfig";
    private static final String BILL_SETTING = "billSetting";
    private static final String FIELDMODIFIED = "fieldmodified";
    private static final String PAGEATTRCONFIG = "pageattrconfig";
    private static final String MOBILEPAGEATTRCONFIG = "mobilepageattrconfig";
    private static final String OPERATIONWHENSAVE = "operationwhensave";
    private static final String OPERATIONWHENSUBMIT = "operationwhensubmit";
    private static final String OPERATIONWHENREJECT = "operationwhenreject";
    private static final String DATASIGNEDVERIFY = "datasignedverify";
    private static final String DATASIGNEDADD = "datasignedadd";
    private static final String DATASIGNEDPANEL = "datasignedpanel";
    private static final String BILLATTRCONFIG_OPTIMIZEDATA = "optimizeData";
    private static final String BILLATTRCONFIG_ATTRCONFIGKEY = "attrConfigKey";
    private static final String BILLATTRCONFIG_ATTRCONFIGOBJ = "attrConfigObj";
    private static final String OPTIMIZESUFFIX_MODEL = "model";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(PAGEATTRCONFIG, MOBILEPAGEATTRCONFIG, "pageattrconfigmodel", "mobilepageattrconfigmodel", OPERATIONWHENSAVE, OPERATIONWHENSUBMIT, OPERATIONWHENREJECT);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PAGEATTRCONFIG, MOBILEPAGEATTRCONFIG, OPERATIONWHENSAVE, OPERATIONWHENSUBMIT, OPERATIONWHENREJECT});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject props = this.getCellProperties();
        this.initOptionalDecisionItems(props);
    }

    private void initOptionalDecisionItems(JSONObject props) {
        List<Map<String, Object>> items = ProcTemplatePluginUtil.getOptionalDecisionItems((Map<String, Object>)props);
        if (items != null) {
            this.getModel().setValue(OPTIONALDECISIONS, (Object)BillPagePluginUtil.getOperationInfosFromReturnValues(items, (String)"name"));
        }
    }

    @Override
    protected void initEntryBillInfo(JSONObject properties) {
        super.initEntryBillInfo(properties);
        this.setBillPanelInfo(properties);
    }

    @Override
    protected void showOrHidePCAndMobile(Object value) {
        Boolean showPC = value == null || "pc".equals(value) || "all".equals(value);
        Boolean showMobile = value == null || "mobile".equals(value) || "all".equals(value);
        this.getView().setVisible(showPC, new String[]{"formkey"});
        this.getView().setVisible(showMobile, new String[]{"mobilformkey"});
        if ("AuditTask".equals(this.stencilType)) {
            this.getView().setVisible(showPC, new String[]{PAGEATTRCONFIG});
            this.getView().setVisible(showMobile, new String[]{MOBILEPAGEATTRCONFIG});
        }
        if ("YunzhijiaTask".equals(this.stencilType) || "SSCApprove".equals(this.stencilType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DATASIGNEDPANEL});
        }
        if ("SSCApprove".equals(this.stencilType) || "SSCImageUpload".equals(this.stencilType) || "SSCImageUploadNew".equals(this.stencilType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"sensitivefield"});
        }
    }

    private void setBillPanelInfo(JSONObject properties) {
        Boolean isSSCApprove;
        Boolean isAuditTask = this.stencilType.equals("AuditTask") || this.stencilType.equals("YunzhijiaTask");
        Map billSetting = (Map)properties.get((Object)BILL_SETTING);
        Map map = billSetting = billSetting != null ? billSetting : new HashMap();
        if (isAuditTask.booleanValue()) {
            Boolean realFieldModified = Boolean.TRUE.equals(billSetting.get("fieldModified"));
            this.getModel().setValue(FIELDMODIFIED, (Object)realFieldModified);
            this.getView().setVisible(realFieldModified, new String[]{OPERATIONWHENSAVE});
            this.setOperationValues(billSetting, properties, false);
            this.setBillAttrConfigForPart(this.getBillAttrConfigMap(billSetting, PAGE_ATTR_CONFIG), PAGE_ATTR_CONFIG, false);
            this.setBillAttrConfigForPart(this.getBillAttrConfigMap(billSetting, MOBILE_PAGE_ATTR_CONFIG), MOBILE_PAGE_ATTR_CONFIG, false);
        }
        if ((isSSCApprove = Boolean.valueOf(GraphCodecUtils.isSSCApprove((String)this.stencilType))).booleanValue()) {
            this.setOperationValues(billSetting, properties, true);
        }
        if (!WfConfigurationUtil.needDataSigned()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DATASIGNEDPANEL});
        }
    }

    private void setOperationValues(Map billSetting, JSONObject properties, boolean isSSCApprove) {
        if (!isSSCApprove) {
            this.setOperationValue("operationWhenSave", OPERATIONWHENSAVE, billSetting, properties);
        }
        this.getModel().setValue(OPERATIONWHENSUBMIT, (Object)this.getValidationDisplayValue((String)billSetting.get("operationWhenSubmit")));
        this.getModel().setValue(OPERATIONWHENREJECT, (Object)this.getValidationDisplayValue((String)billSetting.get("operationWhenReject")));
    }

    private void setOperationValue(String operationNumberKey, String operationNumberField, Map billSetting, JSONObject properties) {
        Object value = billSetting.get(operationNumberKey);
        if (null != value) {
            String operationName = WfUtils.getOperationName((String)((String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "entityNumber")), (String)((String)value));
            this.getModel().setValue(operationNumberField, (Object)(WfUtils.isNotEmpty((String)operationName) ? operationName : value));
        }
    }

    private void setBillAttrConfigForPart(Map<String, Object> billAttrConfigMap, String attrConfigKey, boolean updateProperty) {
        if (null == billAttrConfigMap || billAttrConfigMap.isEmpty()) {
            return;
        }
        Object attrConfigObj = billAttrConfigMap.get(BILLATTRCONFIG_ATTRCONFIGOBJ);
        this.getModel().setValue(attrConfigKey.toLowerCase(Locale.ENGLISH), AliasConverterFactory.create("wf_billpageattrcfg").convert(attrConfigObj));
        if (!updateProperty) {
            return;
        }
        boolean optimizeData = (Boolean)billAttrConfigMap.get(BILLATTRCONFIG_OPTIMIZEDATA);
        if (!optimizeData) {
            this.setProperty(attrConfigKey.toLowerCase(Locale.ENGLISH), attrConfigObj);
            return;
        }
        String attrConfigKeyOptimize = (String)billAttrConfigMap.get(BILLATTRCONFIG_ATTRCONFIGKEY);
        this.setProperty(attrConfigKeyOptimize.toLowerCase(Locale.ENGLISH), attrConfigObj);
        this.deleteProperty(attrConfigKey.toLowerCase(Locale.ENGLISH));
    }

    private Map<String, Object> getBillAttrConfigMap(Map billSetting, String attrConfigKeyParam) {
        if (null == billSetting || billSetting.isEmpty()) {
            return null;
        }
        boolean optimizeData = true;
        String attrConfigKey = attrConfigKeyParam + "Model";
        Object attrConfigObj = billSetting.get(attrConfigKey);
        if (WfUtils.isEmptyString(attrConfigObj)) {
            attrConfigKey = attrConfigKeyParam;
            attrConfigObj = billSetting.get(attrConfigKey);
            optimizeData = false;
        }
        if (WfUtils.isEmptyString(attrConfigObj)) {
            return null;
        }
        HashMap<String, Object> billAttrConfigMap = new HashMap<String, Object>(3);
        billAttrConfigMap.put(BILLATTRCONFIG_OPTIMIZEDATA, optimizeData);
        billAttrConfigMap.put(BILLATTRCONFIG_ATTRCONFIGKEY, attrConfigKey);
        billAttrConfigMap.put(BILLATTRCONFIG_ATTRCONFIGOBJ, attrConfigObj);
        return billAttrConfigMap;
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "pageattrconfig": {
                this.showPageForBillAttrConfig(false, key);
                break;
            }
            case "mobilepageattrconfig": {
                this.showPageForBillAttrConfig(true, key);
                break;
            }
            case "operationwhensave": {
                this.showPageForOperation(OPERATIONWHENSAVE);
                break;
            }
            case "operationwhensubmit": 
            case "operationwhenreject": {
                this.showValidateExtItfPage(key);
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void showValidateExtItfPage(String property) {
        String value = (String)DesignerModelUtil.getProperty((Map<String, Object>)this.getCellProperties(), String.format("billSetting.%s", property));
        JSONObject cellProperties = this.getCellProperties();
        FormShowParameter parameter = this.getShowParameter(property, "wf_validationplugin");
        String entityId = (String)DesignerModelUtil.getProperty((Map<String, Object>)cellProperties, "entityId");
        String entityNumber = (String)DesignerModelUtil.getProperty((Map<String, Object>)cellProperties, "entityNumber");
        parameter.setCustomParam("value", (Object)value);
        parameter.setCustomParam("entityId", (Object)entityId);
        parameter.setCustomParam("entityNumber", (Object)entityNumber);
        parameter.setCustomParam("optionalActions", ProcTemplatePluginUtil.getOptionalOperationNumbers((Map<String, Object>)cellProperties));
        this.getView().showForm(parameter);
    }

    private void showPageForBillAttrConfig(boolean isMobile, String callBackId) {
        Object controlValue;
        JSONObject properties = this.getCellProperties();
        String entityNumber = properties.getString("entityNumber");
        if (WfUtils.isEmpty((String)entityNumber)) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"WorkflowAudittaskBasicinfoPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.showTips(tips);
            return;
        }
        Map billSetting = (Map)properties.get((Object)BILL_SETTING);
        billSetting = billSetting != null ? billSetting : new HashMap();
        Object selectedValues = null;
        String formKeyText = null;
        String controlName = null;
        String attrConfigKey = null;
        if (isMobile) {
            attrConfigKey = MOBILE_PAGE_ATTR_CONFIG;
            controlName = "mobilformkey";
        } else {
            attrConfigKey = PAGE_ATTR_CONFIG;
            controlName = "formkey";
        }
        Map<String, Object> billAttrConfigMap = this.getBillAttrConfigMap(billSetting, attrConfigKey);
        if (null != billAttrConfigMap) {
            selectedValues = billAttrConfigMap.get(BILLATTRCONFIG_ATTRCONFIGOBJ);
        }
        if (!WfUtils.isNotEmptyString((Object)(controlValue = this.getModel().getValue(controlName))) || null == controlValue || !controlValue.toString().contains("_combo_")) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5185\u5d4c\u5355\u636e\u3002", (String)"WorkflowBasicInfoPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.showTips(tips);
            return;
        }
        formKeyText = controlValue.toString().split("_combo_")[1];
        Boolean realFieldModified = Boolean.TRUE.equals(billSetting.get("fieldModified"));
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map params = BillPagePluginUtil.getParamstersForBillPageAttrCfg((Object)properties.getString("entityName"), (Object)properties.getString("entityNumber"), (Object)this.getProperty(controlName), (Object)formKeyText, (FormShowParameter)parameter, (Boolean)realFieldModified, (Boolean)isMobile, (Object)selectedValues);
        FormShowParameter parameters = this.getShowParameter(callBackId, "wf_billpageattrcfg", "", params);
        parameter.setShowTitle(true);
        this.showForm(parameters);
    }

    private void showPageForOperation(String type) {
        JSONObject properties = this.getCellProperties();
        Map params = BillPagePluginUtil.getParamstersOperation((Object)DesignerModelUtil.getProperty((Map<String, Object>)properties, "billSetting.formKey"), (Object)DesignerModelUtil.getProperty((Map<String, Object>)properties, "entityId"), (FormShowParameter)this.getView().getFormShowParameter(), (Boolean)Boolean.FALSE, null);
        FormShowParameter parameters = this.getShowParameter(type, "wf_formoperation", "", params);
        parameters.setCustomParam("optionalActions", ProcTemplatePluginUtil.getOptionalOperationNumbers((Map<String, Object>)properties));
        this.showForm(parameters);
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "fieldmodified": {
                this.fieldModifiedChanged(propName, (Boolean)newValue);
                break;
            }
            case "pageattrconfig": {
                this.pageAttrConfigChanged(PAGE_ATTR_CONFIG, newValue);
                break;
            }
            case "mobilepageattrconfig": {
                this.pageAttrConfigChanged(MOBILE_PAGE_ATTR_CONFIG, newValue);
                break;
            }
            case "operationwhensave": {
                this.pageAttrConfigChanged(OPERATIONWHENSAVE, newValue);
                break;
            }
            case "entrybill": {
                if (newValue == null || "".equals(newValue.toString().trim())) {
                    this.setProperties(PAGE_ATTR_CONFIG, null, "pageAttrConfigmodel", null, MOBILE_PAGE_ATTR_CONFIG, null, "mobilePageAttrConfigmodel", null);
                    this.getModel().setValue(PAGEATTRCONFIG, (Object)"");
                    this.getModel().setValue(MOBILEPAGEATTRCONFIG, (Object)"");
                }
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "operationwhensubmit": 
            case "operationwhenreject": {
                this.pageAttrConfigChanged(propName, newValue);
                break;
            }
            case "datasignedverify": 
            case "datasignedadd": {
                this.disEnableBatchBtn();
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void pageAttrConfigChanged(String propName, Object newValue) {
        if (newValue != null && !"".equals(newValue.toString().trim())) {
            return;
        }
        this.setProperty(propName, null);
        if (PAGE_ATTR_CONFIG.equals(propName) || MOBILE_PAGE_ATTR_CONFIG.equals(propName)) {
            this.setProperty(propName + OPTIMIZESUFFIX_MODEL, null);
        }
    }

    @Override
    protected void formKeyChanged(String propName, Object newValue, Object oldValue) {
        super.formKeyChanged(propName, newValue, oldValue);
        if (newValue.toString().contains("_combo_") && oldValue.toString().contains("_combo_")) {
            String controlName = "formkey".equals(propName) ? PAGEATTRCONFIG : MOBILEPAGEATTRCONFIG;
            this.getModel().setValue(controlName, (Object)"");
            this.setProperty(controlName, null);
            this.setProperty(controlName + OPTIMIZESUFFIX_MODEL, null);
        }
    }

    private void fieldModifiedChanged(String propName, Boolean newValue) {
        this.getView().setVisible(newValue, new String[]{OPERATIONWHENSAVE});
        if (!newValue.booleanValue()) {
            this.setBillAttrConfigByFieldModified();
            this.getModel().setValue(OPERATIONWHENSAVE, (Object)"");
            this.deleteProperty(OPERATIONWHENSAVE);
        }
        this.setProperty(propName, newValue);
    }

    private void setBillAttrConfigByFieldModified() {
        JSONObject properties = this.getCellProperties();
        Map billSetting = (Map)properties.get((Object)BILL_SETTING);
        if (null == billSetting || billSetting.isEmpty()) {
            return;
        }
        this.setBillAttrConfigByFieldModified(billSetting, PAGE_ATTR_CONFIG);
        this.setBillAttrConfigByFieldModified(billSetting, MOBILE_PAGE_ATTR_CONFIG);
    }

    private void setBillAttrConfigByFieldModified(Map billSetting, String attrConfigKeyParam) {
        if (null == billSetting || billSetting.isEmpty()) {
            return;
        }
        Map<String, Object> billAttrConfigMap = this.getBillAttrConfigMap(billSetting, attrConfigKeyParam);
        if (null == billAttrConfigMap) {
            return;
        }
        boolean optimizeData = (Boolean)billAttrConfigMap.get(BILLATTRCONFIG_OPTIMIZEDATA);
        Object attrConfigObj = billAttrConfigMap.get(BILLATTRCONFIG_ATTRCONFIGOBJ);
        if (null == (attrConfigObj = this.getBillAttrConfigByFieldModified(attrConfigObj, optimizeData))) {
            return;
        }
        billAttrConfigMap.put(BILLATTRCONFIG_ATTRCONFIGOBJ, attrConfigObj);
        this.setBillAttrConfigForPart(billAttrConfigMap, attrConfigKeyParam, true);
    }

    private Object getBillAttrConfigByFieldModified(Object attrConfig, boolean optimizeData) {
        if (WfUtils.isEmptyString((Object)attrConfig)) {
            return null;
        }
        if (optimizeData) {
            boolean fieldHideNotSettled;
            boolean fieldModifyNotSettled;
            Map attrConfigOptimize = (Map)attrConfig;
            if (null == attrConfigOptimize || attrConfigOptimize.isEmpty()) {
                return null;
            }
            Map fieldMap = (Map)attrConfigOptimize.get("field");
            if (null == fieldMap || fieldMap.isEmpty()) {
                return null;
            }
            Map fieldMapModify = (Map)fieldMap.get("modify");
            boolean bl = fieldModifyNotSettled = null == fieldMapModify || fieldMapModify.isEmpty();
            if (fieldModifyNotSettled) {
                return null;
            }
            Map fieldMapHide = (Map)fieldMap.get("hide");
            boolean bl2 = fieldHideNotSettled = null == fieldMapHide || fieldMapHide.isEmpty();
            if (fieldHideNotSettled) {
                attrConfigOptimize.remove("field");
            } else {
                fieldMap.remove("modify");
                fieldMap.remove("mustinput");
            }
            return attrConfigOptimize;
        }
        ArrayList<JSONObject> removeObjs = new ArrayList<JSONObject>();
        List pageAttrConfigs = (List)attrConfig;
        JSONObject pageAttrConfigsJson = null;
        for (int i = 0; i < pageAttrConfigs.size(); ++i) {
            pageAttrConfigsJson = (JSONObject)pageAttrConfigs.get(i);
            if (null == pageAttrConfigsJson || !DesignerModelUtil.getBooleanValue(pageAttrConfigsJson.get((Object)"modify")).booleanValue()) continue;
            if (!DesignerModelUtil.getBooleanValue(pageAttrConfigsJson.get((Object)"hide")).booleanValue()) {
                removeObjs.add(pageAttrConfigsJson);
                continue;
            }
            pageAttrConfigsJson.put("modify", (Object)Boolean.FALSE);
        }
        if (0 != removeObjs.size()) {
            pageAttrConfigs.removeAll(removeObjs);
        }
        return pageAttrConfigs;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "pageattrconfig": 
            case "mobilepageattrconfig": {
                this.setCloseDataForBillAttrConfig(returnData, actionId, actionId);
                break;
            }
            case "operationwhensave": {
                this.setCloseDataForOperation(returnData, OPERATIONWHENSAVE);
                break;
            }
            case "operationwhensubmit": 
            case "operationwhenreject": {
                this.setCloseDataForValidation(returnData, actionId);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setCloseDataForValidation(Object returnData, String key) {
        if (returnData instanceof String) {
            String value = returnData.toString();
            String displayValue = this.getValidationDisplayValue(value);
            this.getModel().setValue(key, (Object)displayValue);
            this.setProperty(key, value);
        }
    }

    private String getValidationDisplayValue(String value) {
        if (value == null) {
            return value;
        }
        String displayValue = null;
        boolean extItfVal = ExternalInterfaceUtil.isValidValue((String)value);
        if (extItfVal) {
            displayValue = ExternalInterfaceUtil.getFormattedShowValue((String)value);
        } else {
            String entityNumber = (String)DesignerModelUtil.getProperty((Map<String, Object>)this.getCellProperties(), "entityNumber");
            displayValue = WfUtils.getOperationName((String)entityNumber, (String)value);
            if (WfUtils.isEmpty((String)displayValue)) {
                displayValue = value;
            }
        }
        return displayValue;
    }

    private void setCloseDataForOperation(Object returnData, String type) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.getModel().setValue(type, (Object)BillPagePluginUtil.getOperationInfosFromReturnValues((Object)data, (String)"name"));
            this.setProperty(type, BillPagePluginUtil.getOperationInfosFromReturnValues((Object)data, (String)"number"));
        }
    }

    private void setCloseDataForBillAttrConfig(Object returnData, String actionId, String propertyName) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.getModel().setValue(actionId, data.get("name"));
            this.setProperty(propertyName + OPTIMIZESUFFIX_MODEL, data.get("id"));
            this.deleteProperty(propertyName);
        }
    }

    @Override
    protected void setCloseDataForEntryBill(Object returnData) {
        super.setCloseDataForEntryBill(returnData);
        if (returnData instanceof Map) {
            this.setBillAttrConfigForClear();
        }
    }

    private void setBillAttrConfigForClear() {
        this.getModel().setValue(PAGEATTRCONFIG, (Object)"");
        this.getModel().setValue(MOBILEPAGEATTRCONFIG, (Object)"");
        this.getModel().setValue(OPERATIONWHENSAVE, (Object)"");
        this.setProperties(PAGEATTRCONFIG, null, MOBILEPAGEATTRCONFIG, null, "pageattrconfigmodel", null, "mobilepageattrconfigmodel", null, OPERATIONWHENSAVE, null);
    }

    @Override
    protected Object getInitPropValue(JSONObject properties, String propName) {
        Object value = super.getInitPropValue(properties, propName);
        if ("processingPage".equals(propName) && "wf_approvalpage".equals(value)) {
            value = "wf_approvalpage_bac";
        }
        return value;
    }

    private void showTips(String tips) {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            parentView.showTipNotification(tips);
            this.getView().sendFormAction(parentView);
        } else {
            this.getView().showTipNotification(tips);
        }
    }

    private void disEnableBatchBtn() {
        Object dataSingnedVerify = this.getModel().getValue(DATASIGNEDVERIFY);
        Object dataSingnedAdd = this.getModel().getValue(DATASIGNEDADD);
        if (dataSingnedVerify != null && ((Boolean)dataSingnedVerify).booleanValue() || dataSingnedAdd != null && ((Boolean)dataSingnedAdd).booleanValue()) {
            this.setProperties("compositetasks", false);
        }
        String pageId = this.getView().getParentView().getPageCache().get("node_control_pageId");
        IFormView pluginView = null;
        if (WfUtils.isNotEmpty((String)pageId) && (pluginView = this.getView().getView(pageId)) != null) {
            this.getView().getParentView().getPageCache().remove("node_control_pageId");
            pluginView.close();
            this.getView().sendFormAction(pluginView);
        }
    }
}

