/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.design.plugin.WorkflowUsertaskPropConfPlugin;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.plugin.model.StencilProperty;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowAudittaskPropConfPlugin
extends WorkflowUsertaskPropConfPlugin {
    private static final String PROPERTY_REPEATERBTN = "repeaterbtn";
    private static final String DECISION_OPTIONS = "decisionOptions";
    private static final String DECISION = "decision";
    private static final String REJECTOPTIONS = "rejectOptions";
    private static final String ITEMID = "itemId";
    private static final String NUMBER = "number";

    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.stencilType == null) {
            return;
        }
        try {
            JSONObject properties = this.getCellProperties();
            this.initDecisionOptions(properties);
            super.afterCreateNewData(e);
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WorkflowAudittaskPropConfPlugin.class);
        }
    }

    @Override
    protected Object getInitPropValue(JSONObject properties, String propName) {
        if (PROPERTY_REPEATERBTN.equals(propName)) {
            Object repeaterbtn = DesignerModelUtil.getProperty((Map<String, Object>)properties, PROPERTY_REPEATERBTN);
            String repeaterModel = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "repeaterModel");
            if (repeaterbtn == null && repeaterModel != null && !"manual".equals(repeaterModel)) {
                this.setProperties(PROPERTY_REPEATERBTN, Boolean.TRUE);
                return Boolean.TRUE;
            }
        }
        return super.getInitPropValue(properties, propName);
    }

    @Override
    protected String getOperationOrDecision(JSONObject properties) {
        String decisionName = null;
        Object decisionOptions = DesignerModelUtil.getProperty((Map<String, Object>)properties, DECISION_OPTIONS);
        if (WfUtils.isNotEmptyString((Object)decisionOptions)) {
            decisionOptions = ProcTemplatePluginUtil.initDecisionOptionsScene((JSONArray)decisionOptions);
            this.getPageCache().put(DECISION_OPTIONS, SerializationUtils.toJsonString((Object)decisionOptions));
            decisionName = this.getDecisionNameFromReturnValues((List)decisionOptions);
        }
        return decisionName;
    }

    @Override
    protected void showOperationOrDecisionPage() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.showDecisionPage(parameter, this.getCellProperties(), null);
    }

    protected void showDecisionPage(FormShowParameter parameter, JSONObject properties, String business_model) {
        String modelJson = this.getModelJsonString();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("model", modelJson);
        context.put("nodeProperties", this.getDecisionParamProperties(properties));
        Map params = parameter.getCustomParams();
        params.put("context", context);
        params.put("optionalActions", ProcTemplatePluginUtil.getOptionalDecisionItemNumbers((Map<String, Object>)properties));
        String value = this.getPageCache().get(DECISION_OPTIONS);
        List values = null;
        values = WfUtils.isEmptyString((Object)value) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)value, List.class);
        params.put("value", values);
        FormShowParameter parameters = this.getShowParameter(DECISION, "wf_decisionitempage", "", params);
        params.put("business_model", business_model);
        parameters.setCustomParam("isDefaultScheme", (Object)this.getIdeViewPageCacheData("isDefaultScheme"));
        parameters.setCustomParam("schemeId", (Object)this.getIdeViewPageCacheData("schemeId"));
        parameter.setShowTitle(true);
        this.showForm(parameters);
    }

    protected Map<String, Object> getDecisionParamProperties(JSONObject properties) {
        HashMap<String, Object> nodeProperties = new HashMap<String, Object>();
        nodeProperties.put("entityId", DesignerModelUtil.getProperty((Map<String, Object>)properties, "entityId"));
        nodeProperties.put(ITEMID, this.itemId);
        nodeProperties.put("formKey", DesignerModelUtil.getProperty((Map<String, Object>)properties, "billSetting.formKey"));
        nodeProperties.put("variableGroup.variables", DesignerModelUtil.getProperty((Map<String, Object>)properties, "variableGroup.variables"));
        Object join = DesignerModelUtil.getProperty((Map<String, Object>)properties, "join");
        if (join == null) {
            join = Boolean.FALSE;
        }
        nodeProperties.put("join", join);
        return nodeProperties;
    }

    private String getDecisionNameFromReturnValues(List<Map<String, Object>> decisionItems) {
        String returnData = "";
        if (null != decisionItems && 0 != decisionItems.size()) {
            StringBuilder decisionsFormat = new StringBuilder("{");
            if (!decisionItems.isEmpty()) {
                for (Map<String, Object> item : decisionItems) {
                    decisionsFormat.append(item.get("name")).append(',');
                }
                returnData = decisionsFormat.substring(0, decisionsFormat.length() - 1);
            }
            returnData = "{".equals(returnData) ? "" : returnData + '}';
        }
        return returnData;
    }

    private void initDecisionOptions(JSONObject properties) {
        if (properties == null) {
            this.logger.debug("cell's properties is null!");
            return;
        }
        Object decisionOptions = DesignerModelUtil.getProperty((Map<String, Object>)properties, DECISION_OPTIONS);
        StencilConfig stencilConfig = this.getStencilConfig();
        StencilProperty decisionProperty = stencilConfig.getStencilProperty(DECISION_OPTIONS);
        if (decisionOptions == null && decisionProperty.getDefaultValue() == null) {
            JSONArray defaultItems = new JSONArray();
            JSONObject consent = new JSONObject();
            consent.put("auditType", (Object)"approve");
            consent.put("decisionScene", (Object)"approve");
            consent.put("defaultDecision", (Object)Boolean.TRUE);
            consent.put(NUMBER, (Object)"Consent");
            consent.put("name", (Object)ResManager.loadKDString((String)"\u540c\u610f", (String)"WorkflowAudittaskPropConfPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            consent.put("id", (Object)BpmnDiffUtil.getListElementId((String)DECISION_OPTIONS));
            defaultItems.add((Object)consent);
            JSONObject reject = new JSONObject();
            reject.put("auditType", (Object)"reject");
            reject.put("decisionScene", (Object)"rejectToAllAuditNode");
            reject.put(NUMBER, (Object)"Reject");
            reject.put("name", (Object)this.getDefaultRejectDecisionName());
            reject.put("id", (Object)BpmnDiffUtil.getListElementId((String)DECISION_OPTIONS));
            String modelJson = this.getModelJsonString();
            try {
                List<FlowElement> prevNodes = DesignerModelUtil.getPreviousNodes(modelJson, this.itemId);
                if (prevNodes != null && !prevNodes.isEmpty()) {
                    FlowElement prevNode = prevNodes.get(prevNodes.size() - 1);
                    JSONObject rejectNode = new JSONObject();
                    rejectNode.put(ITEMID, (Object)prevNode.getId());
                    rejectNode.put("name", (Object)prevNode.getName());
                    JSONArray rejectNodes = new JSONArray();
                    rejectNodes.add((Object)rejectNode);
                    reject.put(REJECTOPTIONS, (Object)rejectNodes);
                }
            }
            catch (Exception e) {
                this.log.info(String.format("\u521d\u59cb\u5316\u51b3\u7b56\u9879--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01%s %s", e.getMessage(), WfUtils.getExceptionStacktrace((Throwable)e)));
            }
            defaultItems.add((Object)reject);
            DesignerModelUtil.setProperty((Map<String, Object>)properties, DECISION_OPTIONS, defaultItems);
            this.setProperty(DECISION_OPTIONS, defaultItems);
        }
    }

    protected String getDefaultRejectDecisionName() {
        return ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u5df2\u9009\u8282\u70b9", (String)"WorkflowAudittaskPropConfPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected void operationOrDecisionChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
    }

    @Override
    protected String getBasicInfoFormId() {
        return "wf_audittask_basicinfo";
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (DECISION.equals(actionId)) {
            this.setCloseDataForDecision(returnData);
        } else {
            super.closedCallBack(evt);
        }
    }

    private void setCloseDataForDecision(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            List decisionOptions = (List)data.get(DECISION_OPTIONS);
            this.getModel().setValue("participant_operation", (Object)this.getDecisionNameFromReturnValues(decisionOptions));
            this.setProperties(DECISION_OPTIONS, decisionOptions, "autoDecisionWhenMatch", data.get("autoDecisionWhenMatch"), "variables", data.get("variables"));
            this.cleanInvalidRejectNode(decisionOptions);
            this.getPageCache().put(DECISION_OPTIONS, SerializationUtils.toJsonString((Object)decisionOptions));
            this.closePluginViewIfNecessary();
        }
    }

    @Override
    protected String getNodeControlFormId() {
        return "wf_audittask_nodecontrol";
    }

    private void cleanInvalidRejectNode(List<Map<String, Object>> decisionOptions) {
        if (WfUtils.isEmptyForCollection(decisionOptions)) {
            return;
        }
        JSONObject properties = this.getCellProperties();
        Object batchDecision = DesignerModelUtil.getProperty((Map<String, Object>)properties, "batchReject.batchRejectDec");
        Object rejectNodeId = DesignerModelUtil.getProperty((Map<String, Object>)properties, "batchReject.batchRejectNode");
        if (WfUtils.isEmptyString((Object)batchDecision) || WfUtils.isEmptyString((Object)rejectNodeId)) {
            return;
        }
        HashSet<String> validNodeIds = new HashSet<String>(0);
        boolean matchedDecision = false;
        for (Map<String, Object> m : decisionOptions) {
            if (null == m || !batchDecision.equals(m.get(NUMBER)) || null == m.get(REJECTOPTIONS)) continue;
            matchedDecision = true;
            List rejectOptions = (List)m.get(REJECTOPTIONS);
            if (!WfUtils.isNotEmptyForCollection((Collection)rejectOptions)) continue;
            for (Map d : rejectOptions) {
                if (null == d || null == d.get(ITEMID)) continue;
                validNodeIds.add((String)d.get(ITEMID));
            }
        }
        if (!matchedDecision) {
            this.setProperty(properties, "batchRejectDec", "");
        }
        if (!validNodeIds.contains(rejectNodeId)) {
            this.setProperty(properties, "batchRejectNode", "");
        }
    }
}

