/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.lang.Lang;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowAutoCoordinatePlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String ALLOWCOORDINATE = "allowcoordinate";
    private static final String FPCOORDINATESETTING = "fp_coordinatesetting";
    private static final String AUTOCOORDINATE = "autocoordinate";
    private static final String AUTOCOORDINATEFIELDMODIFY = "autocoordiantefieldmodify";
    private static final String SHOWTEXT = "showtext";

    @Override
    public void initialize() {
        super.initialize();
        this.addHandleProperties("allowCoordinate", "autoCoordinate", "autoCoordianteFieldModify");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{AUTOCOORDINATE});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        JSONObject properties = this.getCellProperties();
        this.initCoordinateSetting(properties);
    }

    private void initCoordinateSetting(JSONObject properties) {
        Object autocoordiantefieldmodifyValue;
        if (this.getView().getControl(ALLOWCOORDINATE) == null) {
            return;
        }
        Object allowCoordinateValue = DesignerModelUtil.getProperty((Map<String, Object>)properties, ALLOWCOORDINATE);
        boolean allowCoordinate = allowCoordinateValue == null ? false : Boolean.parseBoolean(allowCoordinateValue.toString());
        this.getModel().setValue(ALLOWCOORDINATE, (Object)allowCoordinate);
        this.getView().setVisible(Boolean.valueOf(allowCoordinate), new String[]{FPCOORDINATESETTING});
        Object autoCoordinateObject = DesignerModelUtil.getProperty((Map<String, Object>)properties, "autoCoordinateModel.autoCoordinate");
        if (!WfUtils.isEmptyString((Object)autoCoordinateObject)) {
            JSONObject circulate = (JSONObject)autoCoordinateObject;
            this.getModel().setValue(AUTOCOORDINATE, ((JSONObject)circulate.get((Object)SHOWTEXT)).get((Object)Lang.get().toString()));
        }
        boolean autoCoordinateFieldModify = (autocoordiantefieldmodifyValue = DesignerModelUtil.getProperty((Map<String, Object>)properties, "autoCoordinateModel.autocoordiantefieldmodify")) == null ? false : Boolean.parseBoolean(autocoordiantefieldmodifyValue.toString());
        this.getModel().setValue(AUTOCOORDINATEFIELDMODIFY, (Object)autoCoordinateFieldModify);
    }

    @Override
    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (AUTOCOORDINATE.equals(key)) {
            this.openCoordinateSettingPage();
        } else {
            super.click(evt);
        }
    }

    private void openCoordinateSettingPage() {
        JSONObject properties = this.getCellProperties();
        Object entityNumber = DesignerModelUtil.getProperty((Map<String, Object>)properties, "entityNumber");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelJson", this.getModelJsonString());
        params.put("properties", properties);
        params.put("itemId", this.itemId);
        params.put("entityNumber", entityNumber);
        params.put("isDefaultScheme", this.getIdeViewPageCacheData("isDefaultScheme"));
        params.put("schemeId", this.getIdeViewPageCacheData("schemeId"));
        this.showForm(AUTOCOORDINATE, "wf_coordinatesetting", params);
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (ALLOWCOORDINATE.equals(propName)) {
            this.switchCoordinatePanelState(newValue);
        } else if (AUTOCOORDINATE.equals(propName)) {
            this.coordinatePropertyChanged(newValue);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    private void coordinatePropertyChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty(AUTOCOORDINATE, null);
        }
    }

    private void switchCoordinatePanelState(Object newValue) {
        this.getView().setVisible((Boolean)newValue, new String[]{FPCOORDINATESETTING});
        this.setProperty(ALLOWCOORDINATE, newValue);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = evt.getActionId();
        if (actionId != null && actionId.equals(AUTOCOORDINATE)) {
            this.setCloseBackForAutoCoordinate(returnData);
        } else {
            super.closedCallBack(evt);
        }
    }

    private void setCloseBackForAutoCoordinate(Object returnData) {
        if (returnData instanceof Map) {
            Map autoCoordinateData = (Map)returnData;
            this.getModel().setValue(AUTOCOORDINATE, (Object)DesignerPluginUtil.getLocaleValue(autoCoordinateData.get(SHOWTEXT)));
            this.setProperty(AUTOCOORDINATE, autoCoordinateData);
        }
    }
}

